/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class HorizontalAlignment
extends AbstractEnumerator {
    public static final String copyright = "Copyright (c) 2005, 2007 Actuate Corporation";
    public static final int AUTOMATIC = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final HorizontalAlignment AUTOMATIC_LITERAL = new HorizontalAlignment(0, "Automatic", "Automatic");
    public static final HorizontalAlignment LEFT_LITERAL = new HorizontalAlignment(1, "Left", "Left");
    public static final HorizontalAlignment CENTER_LITERAL = new HorizontalAlignment(2, "Center", "Center");
    public static final HorizontalAlignment RIGHT_LITERAL = new HorizontalAlignment(3, "Right", "Right");
    private static final HorizontalAlignment[] VALUES_ARRAY = new HorizontalAlignment[]{AUTOMATIC_LITERAL, LEFT_LITERAL, CENTER_LITERAL, RIGHT_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static HorizontalAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HorizontalAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HorizontalAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HorizontalAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HorizontalAlignment get(int value) {
        switch (value) {
            case 0: {
                return AUTOMATIC_LITERAL;
            }
            case 1: {
                return LEFT_LITERAL;
            }
            case 2: {
                return CENTER_LITERAL;
            }
            case 3: {
                return RIGHT_LITERAL;
            }
        }
        return null;
    }

    private HorizontalAlignment(int value, String name, String literal) {
        super(value, name, literal);
    }
}

