/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.DateFormatDetail;
import org.eclipse.birt.chart.model.attribute.DateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.DateFormatType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.FractionNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.NumberFormatSpecifierImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierPreview;
import org.eclipse.birt.chart.ui.swt.composites.LocalizedNumberEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class FormatSpecifierComposite
extends Composite
implements SelectionListener {
    private transient Button btnUndefined = null;
    private transient Button btnStandard = null;
    private transient Button btnAdvanced = null;
    private transient Button btnFraction = null;
    private transient Combo cmbDataType = null;
    private transient Composite cmpStandardDetails = null;
    private transient StackLayout slStandardDetails = null;
    private transient Composite cmpStandardDateDetails = null;
    private transient Composite cmpStandardNumberDetails = null;
    private transient IFormatSpecifierUIComponent cpWrapStandardNumber = null;
    private transient IFormatSpecifierUIComponent cpWrapStandardDate = null;
    private transient IFormatSpecifierUIComponent cpWrapAdvancedNumber = null;
    private transient IFormatSpecifierUIComponent cpWrapAdvancedDate = null;
    private transient IFormatSpecifierUIComponent cpWrapFractionNumber = null;
    private transient Composite cmpAdvancedDetails = null;
    private transient StackLayout slAdvancedDetails = null;
    private transient Composite cmpAdvancedDateDetails = null;
    private transient Composite cmpAdvancedNumberDetails = null;
    private transient Composite cmpFractionNumberDetails = null;
    private transient FormatSpecifierPreview fsp = null;
    private transient FormatSpecifier formatspecifier = null;
    private transient boolean bEnableEvents = true;
    public static final String DATA_TYPE_NONE = Messages.getString("FormatSpecifierComposite.Lbl.None");
    public static final String DATA_TYPE_NUMBER = Messages.getString("FormatSpecifierComposite.Lbl.Number");
    public static final String DATA_TYPE_DATETIME = Messages.getString("FormatSpecifierComposite.Lbl.DateTime");
    private String[] supportedTypes = null;

    public FormatSpecifierComposite(Composite parent, int style, FormatSpecifier formatspecifier) {
        this(parent, style, formatspecifier, new String[]{DATA_TYPE_NUMBER, DATA_TYPE_DATETIME});
    }

    public FormatSpecifierComposite(Composite parent, int style, FormatSpecifier formatspecifier, String[] supportedTypes) {
        super(parent, style);
        this.formatspecifier = formatspecifier;
        this.supportedTypes = supportedTypes;
        this.init();
        this.placeComponents();
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 10;
        glContent.marginWidth = 10;
        glContent.verticalSpacing = 0;
        this.slStandardDetails = new StackLayout();
        this.slAdvancedDetails = new StackLayout();
        this.setLayout((Layout)glContent);
        Group grpPreview = new Group((Composite)this, 0);
        grpPreview.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        grpPreview.setLayoutData((Object)gd);
        grpPreview.setText(Messages.getString("FormatSpecifierComposite.Lbl.Preview"));
        this.fsp = new FormatSpecifierPreview((Composite)grpPreview, 0, true);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 0x1000000;
        this.fsp.setLayoutData(gd);
        this.createPlaceHolder(this, 2);
        Label lblDataType = new Label((Composite)this, 0);
        GridData gdLBLDataType = new GridData();
        lblDataType.setLayoutData((Object)gdLBLDataType);
        lblDataType.setText(Messages.getString("FormatSpecifierComposite.Lbl.DataType"));
        this.cmbDataType = new Combo((Composite)this, 12);
        GridData gdCMBDataType = new GridData(768);
        this.cmbDataType.setLayoutData((Object)gdCMBDataType);
        this.cmbDataType.addSelectionListener((SelectionListener)this);
        this.createPlaceHolder(this, 2);
        this.btnUndefined = new Button((Composite)this, 16);
        GridData gdBTNUndefined = new GridData(768);
        gdBTNUndefined.horizontalSpan = 2;
        this.btnUndefined.setLayoutData((Object)gdBTNUndefined);
        this.btnUndefined.setText(Messages.getString("FormatSpecifierComposite.Lbl.Undefined"));
        this.btnUndefined.addSelectionListener((SelectionListener)this);
        this.createPlaceHolder(this, 2);
        this.btnStandard = new Button((Composite)this, 16);
        GridData gdBTNStandard = new GridData(768);
        gdBTNStandard.horizontalSpan = 2;
        this.btnStandard.setLayoutData((Object)gdBTNStandard);
        this.btnStandard.setText(Messages.getString("FormatSpecifierComposite.Lbl.Standard"));
        this.btnStandard.addSelectionListener((SelectionListener)this);
        this.cmpStandardDetails = new Composite((Composite)this, 0);
        GridData gdCMPStandardDetails = new GridData(1808);
        gdCMPStandardDetails.horizontalIndent = 16;
        gdCMPStandardDetails.horizontalSpan = 2;
        this.cmpStandardDetails.setLayoutData((Object)gdCMPStandardDetails);
        this.cmpStandardDetails.setLayout((Layout)this.slStandardDetails);
        this.cmpStandardDateDetails = new Composite(this.cmpStandardDetails, 0);
        GridLayout glDate = new GridLayout();
        glDate.verticalSpacing = 5;
        glDate.marginHeight = 0;
        glDate.marginWidth = 0;
        this.cmpStandardDateDetails.setLayout((Layout)glDate);
        this.cpWrapStandardDate = new DateStandardComposite(this.cmpStandardDateDetails);
        this.cmpStandardNumberDetails = new Composite(this.cmpStandardDetails, 0);
        GridLayout glNumber = new GridLayout();
        glNumber.verticalSpacing = 5;
        glNumber.marginHeight = 0;
        glNumber.marginWidth = 0;
        this.cmpStandardNumberDetails.setLayout((Layout)glNumber);
        this.cpWrapStandardNumber = new NumberStandardComposite(this.cmpStandardNumberDetails);
        this.createPlaceHolder(this, 2);
        this.btnAdvanced = new Button((Composite)this, 16);
        GridData gdBTNAdvanced = new GridData(768);
        gdBTNAdvanced.horizontalSpan = 2;
        this.btnAdvanced.setLayoutData((Object)gdBTNAdvanced);
        this.btnAdvanced.setText(Messages.getString("FormatSpecifierComposite.Lbl.Advanced"));
        this.btnAdvanced.addSelectionListener((SelectionListener)this);
        this.cmpAdvancedDetails = new Composite((Composite)this, 0);
        GridData gdCMPAdvancedDetails = new GridData(1808);
        gdCMPAdvancedDetails.horizontalIndent = 16;
        gdCMPAdvancedDetails.horizontalSpan = 2;
        this.cmpAdvancedDetails.setLayoutData((Object)gdCMPAdvancedDetails);
        this.cmpAdvancedDetails.setLayout((Layout)this.slAdvancedDetails);
        this.cmpAdvancedDateDetails = new Composite(this.cmpAdvancedDetails, 0);
        GridLayout glAdvDate = new GridLayout();
        glAdvDate.verticalSpacing = 5;
        glAdvDate.marginHeight = 0;
        glAdvDate.marginWidth = 0;
        this.cmpAdvancedDateDetails.setLayout((Layout)glAdvDate);
        this.cpWrapAdvancedDate = new DateAdvancedComposite(this.cmpAdvancedDateDetails);
        this.cmpAdvancedNumberDetails = new Composite(this.cmpAdvancedDetails, 0);
        GridLayout glAdvNumber = new GridLayout();
        glAdvNumber.verticalSpacing = 5;
        glAdvNumber.marginHeight = 0;
        glAdvNumber.marginWidth = 0;
        this.cmpAdvancedNumberDetails.setLayout((Layout)glAdvNumber);
        this.cpWrapAdvancedNumber = new NumberAdvancedComposite(this.cmpAdvancedNumberDetails);
        this.createPlaceHolder(this, 2);
        this.btnFraction = new Button((Composite)this, 16);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        this.btnFraction.setLayoutData((Object)gd2);
        this.btnFraction.setText(Messages.getString("FormatSpecifierComposite.Lbl.Fraction"));
        this.btnFraction.addSelectionListener((SelectionListener)this);
        this.cmpFractionNumberDetails = new Composite((Composite)this, 0);
        gd2 = new GridData(1808);
        gd2.horizontalIndent = 16;
        gd2.horizontalSpan = 2;
        this.cmpFractionNumberDetails.setLayoutData((Object)gd2);
        this.cmpFractionNumberDetails.setLayout((Layout)new FormLayout());
        this.cpWrapFractionNumber = new NumberFractionComposite(this.cmpFractionNumberDetails);
        this.populateLists();
    }

    private void createPlaceHolder(Composite parent, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = 10;
        label.setLayoutData((Object)gd);
    }

    private void populateLists() {
        this.bEnableEvents = false;
        if (this.supportedTypes == null) {
            this.cmbDataType.add(DATA_TYPE_NONE);
        } else {
            this.cmbDataType.setItems(this.supportedTypes);
        }
        if (this.formatspecifier == null) {
            this.cmbDataType.select(0);
            this.btnUndefined.setSelection(true);
            if (this.cmbDataType.getText().equals(DATA_TYPE_NUMBER)) {
                this.slStandardDetails.topControl = this.cmpStandardNumberDetails;
                this.slAdvancedDetails.topControl = this.cmpAdvancedNumberDetails;
            } else if (this.cmbDataType.getText().equals(DATA_TYPE_DATETIME)) {
                this.slStandardDetails.topControl = this.cmpStandardDateDetails;
                this.slAdvancedDetails.topControl = this.cmpAdvancedDateDetails;
            } else if (this.cmbDataType.getText().equals(DATA_TYPE_NONE)) {
                this.cmpFractionNumberDetails.setVisible(false);
                this.btnFraction.setVisible(false);
                this.btnStandard.setVisible(false);
                this.btnAdvanced.setVisible(false);
            }
        } else if (this.formatspecifier instanceof DateFormatSpecifier || this.formatspecifier instanceof JavaDateFormatSpecifier) {
            this.cmbDataType.setText(DATA_TYPE_DATETIME);
            if (this.formatspecifier instanceof DateFormatSpecifier) {
                this.btnStandard.setSelection(true);
            } else if (this.formatspecifier instanceof JavaDateFormatSpecifier) {
                this.btnAdvanced.setSelection(true);
            } else {
                this.btnUndefined.setSelection(true);
            }
            this.slStandardDetails.topControl = this.cmpStandardDateDetails;
            this.slAdvancedDetails.topControl = this.cmpAdvancedDateDetails;
        } else if (this.formatspecifier instanceof NumberFormatSpecifier || this.formatspecifier instanceof JavaNumberFormatSpecifier) {
            this.cmbDataType.setText(DATA_TYPE_NUMBER);
            if (this.formatspecifier instanceof NumberFormatSpecifier) {
                this.btnStandard.setSelection(true);
            } else if (this.formatspecifier instanceof JavaNumberFormatSpecifier) {
                this.btnAdvanced.setSelection(true);
            } else {
                this.btnUndefined.setSelection(true);
            }
            this.slStandardDetails.topControl = this.cmpStandardNumberDetails;
            this.slAdvancedDetails.topControl = this.cmpAdvancedNumberDetails;
        } else if (this.formatspecifier instanceof FractionNumberFormatSpecifier) {
            this.cmbDataType.setText(DATA_TYPE_NUMBER);
            this.btnFraction.setSelection(true);
            this.slStandardDetails.topControl = this.cmpStandardNumberDetails;
            this.slAdvancedDetails.topControl = this.cmpAdvancedNumberDetails;
        }
        this.cpWrapStandardDate.populateLists();
        this.cpWrapStandardNumber.populateLists();
        this.cpWrapAdvancedNumber.populateLists();
        this.cpWrapAdvancedDate.populateLists();
        this.cpWrapFractionNumber.populateLists();
        this.updateUIState();
        this.layout();
        this.bEnableEvents = true;
    }

    public FormatSpecifier getFormatSpecifier() {
        if (this.btnUndefined.getSelection()) {
            return null;
        }
        this.formatspecifier = this.buildFormatSpecifier();
        return this.formatspecifier;
    }

    private FormatSpecifier buildFormatSpecifier() {
        FormatSpecifier fs = null;
        if (this.cmbDataType.getText().equals(DATA_TYPE_NUMBER)) {
            if (this.btnAdvanced.getSelection()) {
                fs = this.cpWrapAdvancedNumber.buildFormatSpecifier();
            } else if (this.btnStandard.getSelection()) {
                fs = this.cpWrapStandardNumber.buildFormatSpecifier();
            } else if (this.btnFraction.getSelection()) {
                fs = this.cpWrapFractionNumber.buildFormatSpecifier();
            }
        } else if (this.cmbDataType.getText().equals(DATA_TYPE_DATETIME)) {
            if (this.btnAdvanced.getSelection()) {
                fs = this.cpWrapAdvancedDate.buildFormatSpecifier();
            } else if (this.btnStandard.getSelection()) {
                fs = this.cpWrapStandardDate.buildFormatSpecifier();
            }
        }
        return fs;
    }

    private void updateUIState() {
        if (this.cmbDataType.getText().equals(DATA_TYPE_NUMBER)) {
            if (this.btnStandard.getSelection()) {
                this.cpWrapStandardNumber.setEnabled(true);
                this.cpWrapAdvancedNumber.setEnabled(false);
                this.cpWrapFractionNumber.setEnabled(false);
            } else if (this.btnAdvanced.getSelection()) {
                this.cpWrapStandardNumber.setEnabled(false);
                this.cpWrapAdvancedNumber.setEnabled(true);
                this.cpWrapFractionNumber.setEnabled(false);
            } else if (this.btnFraction.getSelection()) {
                this.cpWrapStandardNumber.setEnabled(false);
                this.cpWrapAdvancedNumber.setEnabled(false);
                this.cpWrapFractionNumber.setEnabled(true);
            } else {
                this.cpWrapStandardNumber.setEnabled(false);
                this.cpWrapAdvancedNumber.setEnabled(false);
                this.cpWrapFractionNumber.setEnabled(false);
            }
            this.cmpFractionNumberDetails.setVisible(true);
            this.btnFraction.setVisible(true);
        } else if (this.cmbDataType.getText().equals(DATA_TYPE_DATETIME)) {
            if (this.btnStandard.getSelection()) {
                this.cpWrapStandardDate.setEnabled(true);
                this.cpWrapAdvancedDate.setEnabled(false);
            } else if (this.btnAdvanced.getSelection()) {
                this.cpWrapStandardDate.setEnabled(false);
                this.cpWrapAdvancedDate.setEnabled(true);
            } else {
                this.cpWrapStandardDate.setEnabled(false);
                this.cpWrapAdvancedDate.setEnabled(false);
            }
            this.cmpFractionNumberDetails.setVisible(false);
            this.btnFraction.setVisible(false);
        }
        this.fsp.setDataType(this.cmbDataType.getText());
        this.updatePreview();
    }

    public Point getPreferredSize() {
        return new Point(200, 150);
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.bEnableEvents) {
            return;
        }
        if (e.getSource().equals(this.cmbDataType)) {
            if (this.cmbDataType.getText().equals(DATA_TYPE_NUMBER)) {
                this.slStandardDetails.topControl = this.cmpStandardNumberDetails;
                this.slAdvancedDetails.topControl = this.cmpAdvancedNumberDetails;
            } else if (this.cmbDataType.getText().equals(DATA_TYPE_DATETIME)) {
                this.slStandardDetails.topControl = this.cmpStandardDateDetails;
                this.slAdvancedDetails.topControl = this.cmpAdvancedDateDetails;
                if (this.btnFraction.getSelection()) {
                    this.btnUndefined.setSelection(true);
                    this.btnFraction.setSelection(false);
                }
            }
            this.updateUIState();
            this.cmpStandardDetails.layout();
            this.cmpAdvancedDetails.layout();
        } else if (e.getSource() instanceof Button) {
            this.updateUIState();
        }
    }

    private void updatePreview() {
        boolean hasException = false;
        try {
            this.fsp.updatePreview(this.getFormatSpecifier());
        }
        catch (IllegalArgumentException e) {
            ChartWizard.showException((String)e.getMessage());
            hasException = true;
        }
        if (!hasException) {
            ChartWizard.removeException();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class DateAdvancedComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    ModifyListener {
        private CCombo txtDatePattern;
        private Label lblDatePattern;

        private DateAdvancedComposite(Composite parent) {
            super(parent, 0);
            this.txtDatePattern = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glDateAdvanced = new GridLayout();
            glDateAdvanced.verticalSpacing = 5;
            glDateAdvanced.numColumns = 2;
            glDateAdvanced.marginHeight = 2;
            glDateAdvanced.marginWidth = 2;
            GridData gdGRPDateAdvanced = new GridData(1808);
            this.setLayoutData(gdGRPDateAdvanced);
            this.setLayout((Layout)glDateAdvanced);
            this.lblDatePattern = new Label((Composite)this, 0);
            GridData gdLBLDatePattern = new GridData();
            this.lblDatePattern.setLayoutData((Object)gdLBLDatePattern);
            this.lblDatePattern.setText(Messages.getString("FormatSpecifierComposite.Lbl.DatePattern"));
            this.txtDatePattern = new CCombo((Composite)this, 2052);
            GridData gdTXTDatePattern = new GridData(768);
            this.txtDatePattern.setLayoutData((Object)gdTXTDatePattern);
            this.txtDatePattern.addModifyListener((ModifyListener)this);
            this.txtDatePattern.setItems(new String[]{"EEEE,MMMM dd,yyyy", "MM/dd/yy", "dd-MMM-yy", "LLL,yyyy", "hh:mm:ss,a", "HH:mm:ss", "DDD,yyyy,QQQQ", "EEE, MMM d, yyyy", "yyyy.MMMM.dd GGG hh:mm aaa", "yyyy.MM.dd G 'at' HH:mm:ss zzz"});
            this.txtDatePattern.setVisibleItemCount(this.txtDatePattern.getItemCount());
            this.txtDatePattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormatSpecifierComposite.this.bEnableEvents = false;
                    if (!(FormatSpecifierComposite.this.formatspecifier instanceof JavaDateFormatSpecifier)) {
                        FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)"");
                    }
                    ((JavaDateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPattern(DateAdvancedComposite.this.txtDatePattern.getText());
                    FormatSpecifierComposite.this.bEnableEvents = true;
                    FormatSpecifierComposite.this.updatePreview();
                }
            });
        }

        public void populateLists() {
            if (FormatSpecifierComposite.this.formatspecifier instanceof JavaDateFormatSpecifier) {
                String str = ((JavaDateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getPattern();
                if (str == null) {
                    str = "";
                }
                this.txtDatePattern.setText(str);
            }
        }

        public FormatSpecifier buildFormatSpecifier() {
            JavaDateFormatSpecifier fs = JavaDateFormatSpecifierImpl.create((String)this.txtDatePattern.getText());
            return fs;
        }

        public void setEnabled(boolean enabled) {
            this.lblDatePattern.setEnabled(enabled);
            this.txtDatePattern.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void modifyText(ModifyEvent e) {
            Object oSource = e.getSource();
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (oSource.equals(this.txtDatePattern)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof JavaDateFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)"");
                }
                ((JavaDateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPattern(this.txtDatePattern.getText());
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
            FormatSpecifierComposite.this.updatePreview();
        }
    }

    private class DateStandardComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    Listener {
        private Combo cmbDateType;
        private Combo cmbDateForm;
        private Label lblDateType;
        private Label lblDateDetails;

        private DateStandardComposite(Composite parent) {
            super(parent, 0);
            this.cmbDateType = null;
            this.cmbDateForm = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glDateStandard = new GridLayout();
            glDateStandard.verticalSpacing = 5;
            glDateStandard.numColumns = 2;
            glDateStandard.marginHeight = 2;
            glDateStandard.marginWidth = 2;
            GridData gdGRPDateStandard = new GridData(1808);
            this.setLayoutData(gdGRPDateStandard);
            this.setLayout((Layout)glDateStandard);
            this.lblDateType = new Label((Composite)this, 0);
            GridData gdLBLDateType = new GridData();
            this.lblDateType.setLayoutData((Object)gdLBLDateType);
            this.lblDateType.setText(Messages.getString("FormatSpecifierComposite.Lbl.Type"));
            this.cmbDateType = new Combo((Composite)this, 12);
            GridData gdCMBDateType = new GridData(768);
            this.cmbDateType.setLayoutData((Object)gdCMBDateType);
            this.cmbDateType.addListener(13, (Listener)this);
            this.lblDateDetails = new Label((Composite)this, 0);
            GridData gdLBLDateDetails = new GridData();
            this.lblDateDetails.setLayoutData((Object)gdLBLDateDetails);
            this.lblDateDetails.setText(Messages.getString("FormatSpecifierComposite.Lbl.Details"));
            this.cmbDateForm = new Combo((Composite)this, 12);
            GridData gdCMBDateForm = new GridData(768);
            this.cmbDateForm.setLayoutData((Object)gdCMBDateForm);
            this.cmbDateForm.addListener(13, (Listener)this);
        }

        public void populateLists() {
            NameSet ns = LiteralHelper.dateFormatTypeSet;
            this.cmbDateType.setItems(ns.getDisplayNames());
            if (FormatSpecifierComposite.this.formatspecifier instanceof DateFormatSpecifier) {
                this.cmbDateType.select(ns.getSafeNameIndex(((DateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getType().getName()));
            }
            if (this.cmbDateType.getSelectionIndex() == -1) {
                this.cmbDateType.select(0);
            }
            ns = LiteralHelper.dateFormatDetailSet;
            this.cmbDateForm.setItems(ns.getDisplayNames());
            if (FormatSpecifierComposite.this.formatspecifier instanceof DateFormatSpecifier) {
                this.cmbDateForm.select(ns.getSafeNameIndex(((DateFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getDetail().getName()));
            }
            if (this.cmbDateForm.getSelectionIndex() == -1) {
                this.cmbDateForm.select(0);
            }
        }

        public FormatSpecifier buildFormatSpecifier() {
            DateFormatSpecifier fs = AttributeFactory.eINSTANCE.createDateFormatSpecifier();
            fs.setType(DateFormatType.getByName((String)LiteralHelper.dateFormatTypeSet.getNameByDisplayName(this.cmbDateType.getText())));
            fs.setDetail(DateFormatDetail.getByName((String)LiteralHelper.dateFormatDetailSet.getNameByDisplayName(this.cmbDateForm.getText())));
            return fs;
        }

        public void setEnabled(boolean enabled) {
            this.lblDateDetails.setEnabled(enabled);
            this.lblDateType.setEnabled(enabled);
            this.cmbDateForm.setEnabled(enabled);
            this.cmbDateType.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void handleEvent(Event event) {
            FormatSpecifierComposite.this.updatePreview();
        }
    }

    static interface IFormatSpecifierUIComponent {
        public void populateLists();

        public FormatSpecifier buildFormatSpecifier();

        public void setEnabled(boolean var1);
    }

    private class NumberAdvancedComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    ModifyListener {
        private CCombo txtNumberPattern;
        private LocalizedNumberEditorComposite txtAdvMultiplier;
        private Label lblAdvMultiplier;
        private Label lblNumberPattern;

        private NumberAdvancedComposite(Composite parent) {
            super(parent, 0);
            this.txtNumberPattern = null;
            this.txtAdvMultiplier = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glNumberAdvanced = new GridLayout();
            glNumberAdvanced.verticalSpacing = 5;
            glNumberAdvanced.numColumns = 2;
            glNumberAdvanced.marginHeight = 2;
            glNumberAdvanced.marginWidth = 2;
            GridData gdGRPNumberAdvanced = new GridData(1808);
            this.setLayoutData(gdGRPNumberAdvanced);
            this.setLayout((Layout)glNumberAdvanced);
            this.lblAdvMultiplier = new Label((Composite)this, 0);
            GridData gdLBLAdvMultiplier = new GridData();
            this.lblAdvMultiplier.setLayoutData((Object)gdLBLAdvMultiplier);
            this.lblAdvMultiplier.setText(Messages.getString("FormatSpecifierComposite.Lbl.Multiplier"));
            this.txtAdvMultiplier = new LocalizedNumberEditorComposite(this, 2052);
            GridData gdTXTAdvMultiplier = new GridData(768);
            this.txtAdvMultiplier.setLayoutData(gdTXTAdvMultiplier);
            this.txtAdvMultiplier.addModifyListener(this);
            this.lblNumberPattern = new Label((Composite)this, 0);
            GridData gdLBLNumberPattern = new GridData();
            this.lblNumberPattern.setLayoutData((Object)gdLBLNumberPattern);
            this.lblNumberPattern.setText(Messages.getString("FormatSpecifierComposite.Lbl.NumberPattern"));
            this.txtNumberPattern = new CCombo((Composite)this, 2052);
            GridData gdTXTNumberPattern = new GridData(768);
            this.txtNumberPattern.setLayoutData((Object)gdTXTNumberPattern);
            this.txtNumberPattern.addModifyListener((ModifyListener)this);
            this.txtNumberPattern.setItems(new String[]{"##.###", "00.###", "##,###.00", "0.00'K'", "##0.00 \u00a4", "###0.000\u2030"});
            this.txtNumberPattern.setVisibleItemCount(this.txtNumberPattern.getItemCount());
            this.txtNumberPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormatSpecifierComposite.this.bEnableEvents = false;
                    if (!(FormatSpecifierComposite.this.formatspecifier instanceof JavaNumberFormatSpecifier)) {
                        FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"");
                    }
                    ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPattern(NumberAdvancedComposite.this.txtNumberPattern.getText());
                    FormatSpecifierComposite.this.bEnableEvents = true;
                    FormatSpecifierComposite.this.updatePreview();
                }
            });
        }

        public void populateLists() {
            if (FormatSpecifierComposite.this.formatspecifier instanceof JavaNumberFormatSpecifier) {
                String str = ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getPattern();
                if (str == null) {
                    str = "";
                }
                if (((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eIsSet((EStructuralFeature)AttributePackage.eINSTANCE.getJavaNumberFormatSpecifier_Multiplier())) {
                    this.txtAdvMultiplier.setValue(((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getMultiplier());
                }
                this.txtNumberPattern.setText(str);
            }
        }

        public FormatSpecifier buildFormatSpecifier() {
            JavaNumberFormatSpecifier fs = JavaNumberFormatSpecifierImpl.create((String)this.txtNumberPattern.getText());
            if (this.txtAdvMultiplier.isSetValue()) {
                ((JavaNumberFormatSpecifierImpl)fs).setMultiplier(this.txtAdvMultiplier.getValue());
            }
            return fs;
        }

        public void setEnabled(boolean enabled) {
            this.lblAdvMultiplier.setEnabled(enabled);
            this.lblNumberPattern.setEnabled(enabled);
            this.txtAdvMultiplier.setEnabled(enabled);
            this.txtNumberPattern.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void modifyText(ModifyEvent e) {
            Object oSource = e.getSource();
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (oSource.equals((Object)this.txtAdvMultiplier)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof JavaNumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)this.txtNumberPattern.getText());
                }
                if (this.txtAdvMultiplier.isSetValue()) {
                    ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtAdvMultiplier.getValue());
                } else {
                    ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getJavaNumberFormatSpecifier_Multiplier());
                }
            } else if (oSource.equals(this.txtNumberPattern)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof JavaNumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"");
                }
                ((JavaNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPattern(this.txtNumberPattern.getText());
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
            FormatSpecifierComposite.this.updatePreview();
        }
    }

    private class NumberFractionComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    Listener {
        private transient FractionNumberFormatSpecifier dummyFs;
        private transient Button btnApproximate;
        private transient Button btnUseNumerator;
        private transient Button btnUseDenorminator;
        private transient Text txtPrefix;
        private transient Text txtSuffix;
        private transient Text txtDelimiter;
        private transient Spinner spnNumerator;
        private transient Spinner spnFractionDigits;
        private Label lblDelimiter;
        private Label lblPrefix;
        private Label lblSuffix;

        private NumberFractionComposite(Composite parent) {
            super(parent, 0);
            this.dummyFs = FractionNumberFormatSpecifierImpl.create();
            this.btnApproximate = null;
            this.btnUseNumerator = null;
            this.btnUseDenorminator = null;
            this.txtPrefix = null;
            this.txtSuffix = null;
            this.txtDelimiter = null;
            this.spnNumerator = null;
            this.spnFractionDigits = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glNumberStandard = new GridLayout();
            glNumberStandard.verticalSpacing = 5;
            glNumberStandard.numColumns = 4;
            glNumberStandard.marginHeight = 2;
            glNumberStandard.marginWidth = 2;
            this.setLayout((Layout)glNumberStandard);
            this.lblDelimiter = new Label((Composite)this, 0);
            this.lblDelimiter.setText(Messages.getString("FormatSpecifierComposite.Lbl.Delimiter"));
            this.txtDelimiter = new Text((Composite)this, 2052);
            GridData gd = new GridData(768);
            gd.widthHint = 60;
            this.txtDelimiter.setLayoutData((Object)gd);
            String str = this.getFormatSpecifier().getDelimiter();
            if (str == null) {
                str = "";
            }
            this.txtDelimiter.setText(str);
            this.txtDelimiter.addListener(24, (Listener)this);
            this.btnApproximate = new Button((Composite)this, 32);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.btnApproximate.setLayoutData((Object)gd);
            this.btnApproximate.setText(Messages.getString("FormatSpecifierComposite.Lbl.Approximate"));
            this.btnApproximate.addListener(13, (Listener)this);
            this.lblPrefix = new Label((Composite)this, 0);
            this.lblPrefix.setText(Messages.getString("FormatSpecifierComposite.Lbl.Prefix"));
            this.txtPrefix = new Text((Composite)this, 2052);
            GridData gdTXTPrefix = new GridData(768);
            gdTXTPrefix.widthHint = 60;
            this.txtPrefix.setLayoutData((Object)gdTXTPrefix);
            str = this.getFormatSpecifier().getPrefix();
            if (str == null) {
                str = "";
            }
            this.txtPrefix.setText(str);
            this.txtPrefix.addListener(24, (Listener)this);
            this.btnUseNumerator = new Button((Composite)this, 16);
            this.btnUseNumerator.setText(Messages.getString("FormatSpecifierComposite.Lbl.Numerator"));
            this.btnUseNumerator.addListener(13, (Listener)this);
            this.spnNumerator = new Spinner((Composite)this, 2048);
            GridData gdTXTMultiplier = new GridData(768);
            gdTXTMultiplier.widthHint = 60;
            this.spnNumerator.setLayoutData((Object)gdTXTMultiplier);
            this.spnNumerator.setMinimum(1);
            this.spnNumerator.setSelection((int)this.getFormatSpecifier().getNumerator());
            this.spnNumerator.setToolTipText(Messages.getString("FormatSpecifierComposite.Tooltip.InputAPositiveInteger"));
            this.spnNumerator.addListener(13, (Listener)this);
            this.lblSuffix = new Label((Composite)this, 0);
            this.lblSuffix.setText(Messages.getString("FormatSpecifierComposite.Lbl.Suffix"));
            this.txtSuffix = new Text((Composite)this, 2052);
            GridData gdTXTSuffix = new GridData(768);
            gdTXTSuffix.widthHint = 60;
            this.txtSuffix.setLayoutData((Object)gdTXTSuffix);
            str = this.getFormatSpecifier().getSuffix();
            if (str == null) {
                str = "";
            }
            this.txtSuffix.setText(str);
            this.txtSuffix.addListener(24, (Listener)this);
            this.btnUseDenorminator = new Button((Composite)this, 16);
            this.btnUseDenorminator.setText(Messages.getString("FormatSpecifierComposite.Lbl.MaxRecursionTimes"));
            this.btnUseDenorminator.addListener(13, (Listener)this);
            this.spnFractionDigits = new Spinner((Composite)this, 2048);
            this.spnFractionDigits.setMinimum(1);
            this.spnFractionDigits.setMaximum(8);
            GridData gdISCFractionDigits = new GridData(768);
            gdISCFractionDigits.widthHint = 60;
            this.spnFractionDigits.setLayoutData((Object)gdISCFractionDigits);
            this.spnFractionDigits.setSelection(this.getFormatSpecifier().getFractionDigits());
            this.spnFractionDigits.setToolTipText(Messages.getString("FormatSpecifierComposite.Tooltip.FractionDigits"));
            this.spnFractionDigits.addListener(13, (Listener)this);
        }

        void modifyText(ModifyEvent e) {
            Object oSource = e.getSource();
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (oSource.equals(this.txtPrefix)) {
                this.getFormatSpecifier().setPrefix(this.txtPrefix.getText());
            } else if (oSource.equals(this.txtSuffix)) {
                this.getFormatSpecifier().setSuffix(this.txtSuffix.getText());
            } else if (oSource.equals(this.txtDelimiter)) {
                this.getFormatSpecifier().setDelimiter(this.txtDelimiter.getText());
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
        }

        public void setEnabled(boolean enabled) {
            this.lblDelimiter.setEnabled(enabled);
            this.lblPrefix.setEnabled(enabled);
            this.lblSuffix.setEnabled(enabled);
            this.txtDelimiter.setEnabled(enabled);
            this.txtPrefix.setEnabled(enabled);
            this.txtSuffix.setEnabled(enabled);
            this.btnApproximate.setSelection(!this.getFormatSpecifier().isPrecise());
            this.btnApproximate.setEnabled(enabled);
            this.btnUseNumerator.setEnabled(enabled && this.btnApproximate.getSelection());
            this.btnUseDenorminator.setEnabled(enabled && this.btnApproximate.getSelection());
            if (this.getFormatSpecifier().getNumerator() > 0.0) {
                this.btnUseNumerator.setSelection(true);
                this.btnUseDenorminator.setSelection(false);
            } else {
                this.btnUseNumerator.setSelection(false);
                this.btnUseDenorminator.setSelection(true);
            }
            this.spnNumerator.setEnabled(enabled && this.btnApproximate.getSelection() && this.btnUseNumerator.getSelection());
            this.spnFractionDigits.setEnabled(enabled && this.btnApproximate.getSelection() && this.btnUseDenorminator.getSelection());
            super.setEnabled(enabled);
        }

        public void populateLists() {
            if (FormatSpecifierComposite.this.formatspecifier instanceof FractionNumberFormatSpecifier) {
                this.setEnabled(true);
            }
        }

        private FractionNumberFormatSpecifier getFormatSpecifier() {
            return FormatSpecifierComposite.this.formatspecifier instanceof FractionNumberFormatSpecifier ? (FractionNumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier : this.dummyFs;
        }

        public FormatSpecifier buildFormatSpecifier() {
            FractionNumberFormatSpecifier fs = FractionNumberFormatSpecifierImpl.create();
            fs.setPrecise(!this.btnApproximate.getSelection());
            fs.setDelimiter(this.txtDelimiter.getText());
            fs.setPrefix(this.txtPrefix.getText());
            fs.setSuffix(this.txtSuffix.getText());
            fs.setFractionDigits(this.spnFractionDigits.getSelection());
            if (this.btnUseNumerator.getSelection()) {
                fs.setNumerator((double)this.spnNumerator.getSelection());
            } else {
                fs.setNumerator(0.0);
            }
            return fs;
        }

        void widgetSelected(SelectionEvent e) {
            if (e.widget.equals(this.btnApproximate)) {
                this.getFormatSpecifier().setPrecise(!this.btnApproximate.getSelection());
                this.setEnabled(true);
            } else if (e.widget.equals(this.btnUseNumerator)) {
                this.spnNumerator.setEnabled(true);
                this.spnFractionDigits.setEnabled(false);
            } else if (e.widget.equals(this.btnUseDenorminator)) {
                this.spnNumerator.setEnabled(false);
                this.spnFractionDigits.setEnabled(true);
            } else if (e.widget.equals(this.spnFractionDigits)) {
                this.getFormatSpecifier().setFractionDigits(this.spnFractionDigits.getSelection());
            } else if (e.widget.equals(this.spnNumerator)) {
                this.getFormatSpecifier().setNumerator((double)this.spnNumerator.getSelection());
            }
        }

        public void handleEvent(Event event) {
            if (event.type == 13) {
                this.widgetSelected(new SelectionEvent(event));
            } else if (event.type == 24) {
                this.modifyText(new ModifyEvent(event));
            }
            FormatSpecifierComposite.this.updatePreview();
        }
    }

    private class NumberStandardComposite
    extends Composite
    implements IFormatSpecifierUIComponent,
    ModifyListener,
    Listener {
        private Text txtPrefix;
        private Text txtSuffix;
        private LocalizedNumberEditorComposite txtMultiplier;
        private Spinner iscFractionDigits;
        private Label lblPrefix;
        private Label lblSuffix;
        private Label lblMultiplier;
        private Label lblFractionDigit;

        private NumberStandardComposite(Composite parent) {
            super(parent, 0);
            this.txtPrefix = null;
            this.txtSuffix = null;
            this.txtMultiplier = null;
            this.iscFractionDigits = null;
            this.placeComponents();
        }

        private void placeComponents() {
            GridLayout glNumberStandard = new GridLayout();
            glNumberStandard.verticalSpacing = 5;
            glNumberStandard.numColumns = 4;
            glNumberStandard.marginHeight = 2;
            glNumberStandard.marginWidth = 2;
            GridData gdGRPNumberStandard = new GridData(1808);
            this.setLayoutData(gdGRPNumberStandard);
            this.setLayout((Layout)glNumberStandard);
            this.lblPrefix = new Label((Composite)this, 0);
            GridData gdLBLPrefix = new GridData();
            this.lblPrefix.setLayoutData((Object)gdLBLPrefix);
            this.lblPrefix.setText(Messages.getString("FormatSpecifierComposite.Lbl.Prefix"));
            this.txtPrefix = new Text((Composite)this, 2052);
            GridData gdTXTPrefix = new GridData(768);
            gdTXTPrefix.widthHint = 60;
            this.txtPrefix.setLayoutData((Object)gdTXTPrefix);
            this.txtPrefix.addModifyListener((ModifyListener)this);
            this.lblSuffix = new Label((Composite)this, 0);
            GridData gdLBLSuffix = new GridData();
            this.lblSuffix.setLayoutData((Object)gdLBLSuffix);
            this.lblSuffix.setText(Messages.getString("FormatSpecifierComposite.Lbl.Suffix"));
            this.txtSuffix = new Text((Composite)this, 2052);
            GridData gdTXTSuffix = new GridData(768);
            gdTXTSuffix.widthHint = 60;
            this.txtSuffix.setLayoutData((Object)gdTXTSuffix);
            this.txtSuffix.addModifyListener((ModifyListener)this);
            this.lblMultiplier = new Label((Composite)this, 0);
            GridData gdLBLMultiplier = new GridData();
            this.lblMultiplier.setLayoutData((Object)gdLBLMultiplier);
            this.lblMultiplier.setText(Messages.getString("FormatSpecifierComposite.Lbl.Multiplier"));
            this.txtMultiplier = new LocalizedNumberEditorComposite(this, 2052);
            GridData gdTXTMultiplier = new GridData(768);
            gdTXTMultiplier.widthHint = 60;
            this.txtMultiplier.setLayoutData(gdTXTMultiplier);
            this.txtMultiplier.addModifyListener(this);
            this.lblFractionDigit = new Label((Composite)this, 0);
            GridData gdLBLFractionDigit = new GridData();
            this.lblFractionDigit.setLayoutData((Object)gdLBLFractionDigit);
            this.lblFractionDigit.setText(Messages.getString("FormatSpecifierComposite.Lbl.FractionDigits"));
            this.iscFractionDigits = new Spinner((Composite)this, 2048);
            GridData gdISCFractionDigits = new GridData(768);
            gdISCFractionDigits.widthHint = 60;
            this.iscFractionDigits.setLayoutData((Object)gdISCFractionDigits);
            this.iscFractionDigits.setSelection(2);
            this.iscFractionDigits.addListener(13, (Listener)this);
        }

        public void modifyText(ModifyEvent e) {
            Object oSource = e.getSource();
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (oSource.equals(this.txtPrefix)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)NumberFormatSpecifierImpl.create();
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setSuffix(this.txtSuffix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setFractionDigits(this.iscFractionDigits.getSelection());
                    if (this.txtMultiplier.isSetValue()) {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtMultiplier.getValue());
                    } else {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getNumberFormatSpecifier_Multiplier());
                    }
                }
                ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPrefix(this.txtPrefix.getText());
            } else if (oSource.equals(this.txtSuffix)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)NumberFormatSpecifierImpl.create();
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPrefix(this.txtPrefix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setFractionDigits(this.iscFractionDigits.getSelection());
                    if (this.txtMultiplier.isSetValue()) {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtMultiplier.getValue());
                    } else {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getNumberFormatSpecifier_Multiplier());
                    }
                }
                ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setSuffix(this.txtSuffix.getText());
            } else if (oSource.equals((Object)this.txtMultiplier)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)NumberFormatSpecifierImpl.create();
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPrefix(this.txtPrefix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setSuffix(this.txtSuffix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setFractionDigits(this.iscFractionDigits.getSelection());
                }
                if (this.txtMultiplier.isSetValue()) {
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtMultiplier.getValue());
                } else {
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eUnset((EStructuralFeature)AttributePackage.eINSTANCE.getNumberFormatSpecifier_Multiplier());
                }
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
            FormatSpecifierComposite.this.updatePreview();
        }

        public void setEnabled(boolean enabled) {
            this.lblPrefix.setEnabled(enabled);
            this.lblSuffix.setEnabled(enabled);
            this.lblMultiplier.setEnabled(enabled);
            this.lblFractionDigit.setEnabled(enabled);
            this.txtPrefix.setEnabled(enabled);
            this.txtSuffix.setEnabled(enabled);
            this.txtMultiplier.setEnabled(enabled);
            this.iscFractionDigits.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public void populateLists() {
            if (FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier) {
                String suffix;
                String prefix = ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if ((suffix = ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getSuffix()) == null) {
                    suffix = "";
                }
                int fDigits = ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getFractionDigits();
                if (((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).eIsSet((EStructuralFeature)AttributePackage.eINSTANCE.getNumberFormatSpecifier_Multiplier())) {
                    this.txtMultiplier.setValue(((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).getMultiplier());
                }
                this.iscFractionDigits.setSelection(fDigits);
                this.txtPrefix.setText(prefix);
                this.txtSuffix.setText(suffix);
            }
        }

        public FormatSpecifier buildFormatSpecifier() {
            NumberFormatSpecifier fs = NumberFormatSpecifierImpl.create();
            fs.setPrefix(this.txtPrefix.getText());
            fs.setSuffix(this.txtSuffix.getText());
            fs.setFractionDigits(this.iscFractionDigits.getSelection());
            if (this.txtMultiplier.isSetValue()) {
                fs.setMultiplier(this.txtMultiplier.getValue());
            }
            return fs;
        }

        public void handleEvent(Event event) {
            FormatSpecifierComposite.this.bEnableEvents = false;
            if (event.type == 13 && event.widget.equals(this.iscFractionDigits)) {
                if (!(FormatSpecifierComposite.this.formatspecifier instanceof NumberFormatSpecifier)) {
                    FormatSpecifierComposite.this.formatspecifier = (FormatSpecifier)NumberFormatSpecifierImpl.create();
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setPrefix(this.txtPrefix.getText());
                    ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setSuffix(this.txtSuffix.getText());
                    if (this.txtMultiplier.isSetValue()) {
                        ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setMultiplier(this.txtMultiplier.getValue());
                    }
                }
                ((NumberFormatSpecifier)FormatSpecifierComposite.this.formatspecifier).setFractionDigits(this.iscFractionDigits.getSelection());
            }
            FormatSpecifierComposite.this.bEnableEvents = true;
            FormatSpecifierComposite.this.updatePreview();
        }
    }
}

