/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Collection;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillCanvas;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PositiveNegativeColorDialog
extends TrayDialog
implements Listener {
    private transient Composite cmpContent = null;
    private transient Composite cmpPos = null;
    private transient Composite cmpNeg = null;
    private transient FillChooserComposite fccPosColor = null;
    private transient FillChooserComposite fccNegColor = null;
    private transient FillCanvas cnvPreview = null;
    private transient MultipleFill mCurrent = null;
    private transient MultipleFill mBackup = null;
    private transient ChartWizardContext wizardContext;

    public PositiveNegativeColorDialog(Shell shellParent, ChartWizardContext wizardContext, MultipleFill mSelected, ColorDefinition selectedColor) {
        super(shellParent);
        this.wizardContext = wizardContext;
        if (mSelected != null) {
            this.mCurrent = (MultipleFill)EcoreUtil.copy((EObject)mSelected);
            this.mBackup = (MultipleFill)EcoreUtil.copy((EObject)mSelected);
        } else {
            this.mCurrent = AttributeFactory.eINSTANCE.createMultipleFill();
            this.setMultipleColor(this.mCurrent, selectedColor);
        }
    }

    public PositiveNegativeColorDialog(Shell shellParent, ChartWizardContext wizardContext, MultipleFill mSelected) {
        this(shellParent, wizardContext, mSelected, ColorDefinitionImpl.create((int)0, (int)0, (int)254));
    }

    protected Control createContents(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.GradientEditor_ID");
        this.getShell().setText(Messages.getString("PositiveNegativeColorDialog.Lbl.PositiveNegativeColorEditor"));
        this.getShell().setSize(420, 220);
        UIHelper.centerOnScreen((Shell)this.getShell());
        return super.createContents(parent);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        this.cmpContent.setLayoutData((Object)new GridData(1808));
        this.cmpPos = new Composite(this.cmpContent, 0);
        this.cmpPos.setLayoutData((Object)new GridData(1808));
        this.cmpPos.setLayout((Layout)new GridLayout());
        this.cmpNeg = new Composite(this.cmpContent, 0);
        this.cmpNeg.setLayoutData((Object)new GridData(1808));
        this.cmpNeg.setLayout((Layout)new GridLayout());
        Label lblStartColor = new Label(this.cmpPos, 0);
        GridData gdLBLStartColor = new GridData();
        lblStartColor.setLayoutData((Object)gdLBLStartColor);
        lblStartColor.setText(Messages.getString("PositiveNegativeColorDialog.Lbl.PositiveColor"));
        this.fccPosColor = new FillChooserComposite(this.cmpPos, 0, this.wizardContext, (Fill)this.mCurrent.getFills().get(0), false, false);
        GridData gdFCCStartColor = new GridData(768);
        this.fccPosColor.setLayoutData(gdFCCStartColor);
        this.fccPosColor.addListener(this);
        Label lblEndColor = new Label(this.cmpNeg, 0);
        GridData gdLBLEndColor = new GridData();
        lblEndColor.setLayoutData((Object)gdLBLEndColor);
        lblEndColor.setText(Messages.getString("PositiveNegativeColorDialog.Lbl.NegativeColor"));
        this.fccNegColor = new FillChooserComposite(this.cmpNeg, 0, this.wizardContext, (Fill)this.mCurrent.getFills().get(1), false, false);
        GridData gdFCCEndColor = new GridData(768);
        this.fccNegColor.setLayoutData(gdFCCEndColor);
        this.fccNegColor.addListener(this);
        Group grpPreview = new Group(this.cmpContent, 0);
        GridData gdGRPPreview = new GridData(1808);
        gdGRPPreview.horizontalSpan = 2;
        grpPreview.setLayoutData((Object)gdGRPPreview);
        grpPreview.setLayout((Layout)new FillLayout());
        grpPreview.setText(Messages.getString("PositiveNegativeColorDialog.Lbl.Preview"));
        this.cnvPreview = new FillCanvas((Composite)grpPreview, 524288);
        this.cnvPreview.setFill((Fill)this.mCurrent);
        return this.cmpContent;
    }

    private void setMultipleColor(MultipleFill mFill, ColorDefinition selectedColor) {
        int currentLuminance = this.convertRGBToLuminance(selectedColor.getRed(), selectedColor.getGreen(), selectedColor.getBlue());
        if (currentLuminance < 200) {
            mFill.getFills().add(0, (Object)selectedColor);
            ColorDefinition newColor = (ColorDefinition)EcoreUtil.copy((EObject)selectedColor);
            newColor.eAdapters().addAll((Collection)selectedColor.eAdapters());
            int lumDiff = 240 - currentLuminance;
            newColor.setRed(this.getNewColor(lumDiff, newColor.getRed(), 0.3));
            newColor.setGreen(this.getNewColor(lumDiff, newColor.getGreen(), 0.59));
            newColor.setBlue(this.getNewColor(lumDiff, newColor.getBlue(), 0.11));
            mFill.getFills().add(1, (Object)newColor);
        } else {
            mFill.getFills().add(0, (Object)selectedColor);
            ColorDefinition newColor = (ColorDefinition)EcoreUtil.copy((EObject)selectedColor);
            newColor.eAdapters().addAll((Collection)selectedColor.eAdapters());
            int lumDiff = -100;
            newColor.setRed(this.getNewColor(lumDiff, newColor.getRed(), 0.3));
            newColor.setGreen(this.getNewColor(lumDiff, newColor.getGreen(), 0.59));
            newColor.setBlue(this.getNewColor(lumDiff, newColor.getBlue(), 0.11));
            mFill.getFills().add(1, (Object)newColor);
        }
    }

    public MultipleFill getMultipleColor() {
        return this.mCurrent;
    }

    private int convertRGBToLuminance(int red, int green, int blue) {
        return (int)(0.3 * (double)red + 0.59 * (double)green + 0.11 * (double)blue);
    }

    private int getNewColor(int lumDiff, int oldColor, double coefficient) {
        int newColor = (int)((double)lumDiff * coefficient) + oldColor;
        return newColor < 255 ? newColor : 255;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccPosColor)) {
            this.mCurrent.getFills().set(0, event.data);
        } else if (event.widget.equals((Object)this.fccNegColor)) {
            this.mCurrent.getFills().set(1, event.data);
        }
        this.cnvPreview.redraw();
    }

    protected void cancelPressed() {
        this.mCurrent = this.mBackup;
        super.cancelPressed();
    }
}

