/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.SeriesValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.TriggerSupportMatrix;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.swt.custom.TextCombo;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TriggerDataComposite
extends Composite
implements SelectionListener {
    private Group grpValue = null;
    private Composite cmpURL = null;
    private Group grpParameters = null;
    private Text txtBaseParm = null;
    private Text txtValueParm = null;
    private Text txtSeriesParm = null;
    private Composite cmpCallback = null;
    private Composite cmpDefault = null;
    private Composite cmpScript = null;
    private Text txtScript = null;
    private Button btnScriptExpBuilder = null;
    private Composite cmpTooltip = null;
    private Text txtTooltipText = null;
    private Button btnTooltipExpBuilder = null;
    private Composite cmpVisiblity = null;
    private Composite cmpHighlight = null;
    private Composite cmpDPVisibility = null;
    private StackLayout slValues = null;
    private TextCombo cmbTriggerType = null;
    private Combo cmbActionType = null;
    private ChartWizardContext wizardContext;
    private Button btnBaseURL;
    private Button btnAdvanced;
    private String sBaseURL = "";
    private boolean bEnableURLParameters;
    private boolean bEnableShowTooltipValue;
    private boolean bAdvanced = false;
    private EList triggersList;
    private Map triggersMap;
    private String lastTriggerType;
    private boolean needSaveWhenDisposing = false;
    private static final int INDEX_1_URL_REDIRECT = 1;
    private static final int INDEX_2_TOOLTIP = 2;
    private static final int INDEX_3_TOOGLE_VISABILITY = 3;
    private static final int INDEX_4_SCRIPT = 4;
    private static final int INDEX_5_HIGHLIGHT = 5;
    private static final int INDEX_6_CALLBACK = 6;
    private static final int INDEX_7_TOOGLE_DATAPOINT = 7;
    private TriggerSupportMatrix triggerMatrix;

    public TriggerDataComposite(Composite parent, int style, EList triggers, ChartWizardContext wizardContext, int iInteractivityType, boolean bEnableURLParameters, boolean bEnableShowTooltipValue) {
        super(parent, style);
        this.wizardContext = wizardContext;
        this.bEnableURLParameters = bEnableURLParameters;
        this.bEnableShowTooltipValue = bEnableShowTooltipValue;
        this.triggersList = triggers;
        this.triggerMatrix = new TriggerSupportMatrix(wizardContext.getOutputFormat(), iInteractivityType);
        this.init();
        this.placeComponents();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TriggerDataComposite.this.needSaveWhenDisposing) {
                    TriggerDataComposite.this.updateTrigger(TriggerDataComposite.this.cmbTriggerType.getText());
                }
            }
        });
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
        this.triggersMap = new HashMap();
        int i = 0;
        while (i < this.triggersList.size()) {
            Trigger trigger = (Trigger)this.triggersList.get(i);
            this.triggersMap.put(LiteralHelper.triggerConditionSet.getDisplayNameByName(trigger.getCondition().getName()), trigger);
            ++i;
        }
    }

    private void placeComponents() {
        GridLayout glCMPTrigger = new GridLayout();
        glCMPTrigger.numColumns = 2;
        glCMPTrigger.horizontalSpacing = 16;
        glCMPTrigger.verticalSpacing = 5;
        this.slValues = new StackLayout();
        GridLayout glURL = new GridLayout();
        glURL.marginWidth = 2;
        glURL.marginHeight = 6;
        glURL.horizontalSpacing = 6;
        glURL.numColumns = 3;
        GridLayout glParameter = new GridLayout();
        glParameter.marginWidth = 2;
        glParameter.marginHeight = 6;
        glParameter.horizontalSpacing = 6;
        glParameter.numColumns = 3;
        this.setLayout((Layout)glCMPTrigger);
        Label lblTriggerEvent = new Label((Composite)this, 0);
        GridData gdLBLTriggerEvent = new GridData();
        gdLBLTriggerEvent.horizontalIndent = 4;
        lblTriggerEvent.setLayoutData((Object)gdLBLTriggerEvent);
        lblTriggerEvent.setText(Messages.getString("TriggerDataComposite.Lbl.Event"));
        this.cmbTriggerType = new TextCombo((Composite)this, 0);
        GridData gdCMBTriggerType = new GridData(768);
        this.cmbTriggerType.setLayoutData((Object)gdCMBTriggerType);
        this.cmbTriggerType.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                TriggerDataComposite.this.updateTrigger(TriggerDataComposite.this.lastTriggerType);
                TriggerDataComposite.this.updateActionTypeItems();
                Trigger trigger = (Trigger)TriggerDataComposite.this.triggersMap.get(TriggerDataComposite.this.cmbTriggerType.getText());
                if (trigger != null && TriggerDataComposite.this.triggerMatrix.check(trigger)) {
                    TriggerDataComposite.this.cmbActionType.setText(TriggerDataComposite.this.getActionText(trigger));
                } else {
                    TriggerDataComposite.this.cmbActionType.select(0);
                }
                TriggerDataComposite.this.updateUI(trigger);
                TriggerDataComposite.this.switchUI();
                TriggerDataComposite.this.lastTriggerType = TriggerDataComposite.this.cmbTriggerType.getText();
            }
        });
        Label lblActionType = new Label((Composite)this, 0);
        GridData gdLBLActionType = new GridData();
        gdLBLActionType.horizontalIndent = 4;
        lblActionType.setLayoutData((Object)gdLBLActionType);
        lblActionType.setText(Messages.getString("TriggerDataComposite.Lbl.Action"));
        this.cmbActionType = new Combo((Composite)this, 12);
        GridData gdCMBActionType = new GridData(768);
        this.cmbActionType.setLayoutData((Object)gdCMBActionType);
        this.cmbActionType.addSelectionListener((SelectionListener)this);
        this.cmbActionType.setVisibleItemCount(10);
        this.grpValue = new Group((Composite)this, 0);
        GridData gdGRPValue = new GridData(1808);
        gdGRPValue.horizontalSpan = 2;
        this.grpValue.setLayoutData((Object)gdGRPValue);
        this.grpValue.setText(Messages.getString("TriggerDataComposite.Lbl.ActionDetails"));
        this.grpValue.setLayout((Layout)this.slValues);
        this.cmpDefault = new Composite((Composite)this.grpValue, 0);
        this.cmpCallback = new Composite((Composite)this.grpValue, 0);
        this.cmpCallback.setLayout((Layout)new GridLayout());
        this.addDescriptionLabel(this.cmpCallback, 1, Messages.getString("TriggerDataComposite.Label.CallbackDescription"));
        this.cmpHighlight = new Composite((Composite)this.grpValue, 0);
        this.cmpHighlight.setLayout((Layout)new GridLayout());
        this.addDescriptionLabel(this.cmpHighlight, 1, Messages.getString("TriggerDataComposite.Label.HighlightDescription"));
        this.cmpVisiblity = new Composite((Composite)this.grpValue, 0);
        this.cmpVisiblity.setLayout((Layout)new GridLayout());
        this.addDescriptionLabel(this.cmpVisiblity, 1, Messages.getString("TriggerDataComposite.Label.VisiblityDescription"));
        this.cmpDPVisibility = new Composite((Composite)this.grpValue, 0);
        this.cmpDPVisibility.setLayout((Layout)new GridLayout());
        this.addDescriptionLabel(this.cmpDPVisibility, 1, Messages.getString("TriggerDataComposite.Label.DPVisibilityDescription"));
        this.cmpScript = new Composite((Composite)this.grpValue, 0);
        this.cmpScript.setLayout((Layout)new GridLayout(2, false));
        Label lblScript = new Label(this.cmpScript, 0);
        GridData gdLBLScript = new GridData(2);
        lblScript.setLayoutData((Object)gdLBLScript);
        lblScript.setText(Messages.getString("TriggerDataComposite.Lbl.Script"));
        this.txtScript = new Text(this.cmpScript, 2562);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.txtScript.setLayoutData((Object)gd);
        this.txtScript.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.InputScript"));
        this.btnScriptExpBuilder = new Button(this.cmpScript, 8);
        gd = new GridData();
        gd.heightHint = 20;
        gd.widthHint = 20;
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 3;
        this.btnScriptExpBuilder.setLayoutData((Object)gd);
        this.btnScriptExpBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
        this.btnScriptExpBuilder.addSelectionListener((SelectionListener)this);
        this.btnScriptExpBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
        this.btnScriptExpBuilder.getImage().setBackground(this.btnScriptExpBuilder.getBackground());
        this.cmpTooltip = new Composite((Composite)this.grpValue, 0);
        this.cmpTooltip.setLayout((Layout)new GridLayout(3, false));
        Label lblText = new Label(this.cmpTooltip, 0);
        lblText.setText(Messages.getString("TriggerDataComposite.Lbl.TooltipText"));
        if (this.bEnableShowTooltipValue) {
            GridData lblGd = new GridData();
            lblGd.horizontalSpan = 3;
            lblText.setLayoutData((Object)lblGd);
            this.txtTooltipText = new Text(this.cmpTooltip, 2562);
            GridData gdTXTTooltipText = new GridData(1808);
            gdTXTTooltipText.horizontalSpan = 3;
            this.txtTooltipText.setLayoutData((Object)gdTXTTooltipText);
        } else {
            this.txtTooltipText = new Text(this.cmpTooltip, 2052);
            this.txtTooltipText.setLayoutData((Object)new GridData(768));
            this.btnTooltipExpBuilder = new Button(this.cmpTooltip, 8);
            GridData gdBTNBuilder = new GridData();
            gdBTNBuilder.heightHint = 20;
            gdBTNBuilder.widthHint = 20;
            this.btnTooltipExpBuilder.setLayoutData((Object)gdBTNBuilder);
            this.btnTooltipExpBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
            this.btnTooltipExpBuilder.addSelectionListener((SelectionListener)this);
            this.btnTooltipExpBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
            this.btnTooltipExpBuilder.getImage().setBackground(this.btnTooltipExpBuilder.getBackground());
            this.addDescriptionLabel(this.cmpTooltip, 3, Messages.getString("TriggerDataComposite.Label.TooltipUsingDataLabelOfSeries"));
        }
        this.cmpURL = new Composite((Composite)this.grpValue, 0);
        this.cmpURL.setLayout((Layout)glURL);
        Label lblBaseURL = new Label(this.cmpURL, 0);
        GridData gdLBLBaseURL = new GridData();
        gdLBLBaseURL.horizontalIndent = 2;
        lblBaseURL.setLayoutData((Object)gdLBLBaseURL);
        lblBaseURL.setText(Messages.getString("TriggerDataComposite.Lbl.BaseURL"));
        this.btnBaseURL = new Button(this.cmpURL, 0);
        GridData gd2 = new GridData();
        this.btnBaseURL.setLayoutData((Object)gd2);
        this.btnBaseURL.setText(Messages.getString("TriggerDataComposite.Text.EditBaseURL"));
        this.btnBaseURL.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.InvokeURLBuilder"));
        this.btnBaseURL.addSelectionListener((SelectionListener)this);
        this.btnBaseURL.setEnabled(this.wizardContext.getUIServiceProvider().isInvokingSupported());
        Label lblDefine = new Label(this.cmpURL, 64);
        GridData gd3 = new GridData();
        gd3.horizontalIndent = 2;
        gd3.horizontalSpan = 3;
        gd3.widthHint = 200;
        lblDefine.setLayoutData((Object)gd3);
        lblDefine.setText(Messages.getString("TriggerDataComposite.Label.Description"));
        this.btnAdvanced = new Button(this.cmpURL, 0);
        gd3 = new GridData();
        gd3.horizontalSpan = 2;
        this.btnAdvanced.setLayoutData((Object)gd3);
        this.btnAdvanced.setText(this.getAdvancedButtonText(this.bAdvanced));
        this.btnAdvanced.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.Advanced"));
        this.btnAdvanced.addSelectionListener((SelectionListener)this);
        this.btnAdvanced.setEnabled(this.bEnableURLParameters);
        this.grpParameters = new Group(this.cmpURL, 0);
        GridData gdGRPParameters = new GridData(768);
        gdGRPParameters.horizontalSpan = 3;
        this.grpParameters.setLayoutData((Object)gdGRPParameters);
        this.grpParameters.setLayout((Layout)glParameter);
        this.grpParameters.setText(Messages.getString("TriggerDataComposite.Lbl.ParameterNames"));
        this.grpParameters.setVisible(this.bAdvanced);
        StyledText stParameters = new StyledText((Composite)this.grpParameters, 64);
        GridData gd4 = new GridData();
        gd4.horizontalIndent = 2;
        gd4.horizontalSpan = 3;
        gd4.widthHint = 200;
        stParameters.setLayoutData((Object)gd4);
        stParameters.setText(Messages.getString("TriggerDataComposite.Label.OptionalURLParameters"));
        StyleRange[] sr = new StyleRange[]{new StyleRange(0, 4, this.getForeground(), this.getBackground(), 2), new StyleRange(4, stParameters.getText().length() - 4, this.getForeground(), this.getBackground(), 0)};
        stParameters.setStyleRanges(sr);
        stParameters.setBackground(this.getBackground());
        Label lblBaseParm = new Label((Composite)this.grpParameters, 0);
        GridData gdLBLBaseParm = new GridData();
        gdLBLBaseParm.horizontalIndent = 2;
        lblBaseParm.setLayoutData((Object)gdLBLBaseParm);
        lblBaseParm.setText(Messages.getString("TriggerDataComposite.Lbl.CategorySeries"));
        lblBaseParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterCategory"));
        this.txtBaseParm = new Text((Composite)this.grpParameters, 2048);
        GridData gdTXTBaseParm = new GridData(768);
        gdTXTBaseParm.horizontalSpan = 2;
        this.txtBaseParm.setLayoutData((Object)gdTXTBaseParm);
        this.txtBaseParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterCategory"));
        Label lblValueParm = new Label((Composite)this.grpParameters, 0);
        GridData gdLBLValueParm = new GridData();
        gdLBLValueParm.horizontalIndent = 2;
        lblValueParm.setLayoutData((Object)gdLBLValueParm);
        lblValueParm.setText(Messages.getString("TriggerDataComposite.Lbl.ValueSeries"));
        lblValueParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterValue"));
        this.txtValueParm = new Text((Composite)this.grpParameters, 2048);
        GridData gdTXTValueParm = new GridData(768);
        gdTXTValueParm.horizontalSpan = 2;
        this.txtValueParm.setLayoutData((Object)gdTXTValueParm);
        this.txtValueParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterValue"));
        Label lblSeriesParm = new Label((Composite)this.grpParameters, 0);
        GridData gdLBLSeriesParm = new GridData();
        gdLBLSeriesParm.horizontalIndent = 2;
        lblSeriesParm.setLayoutData((Object)gdLBLSeriesParm);
        lblSeriesParm.setText(Messages.getString("TriggerDataComposite.Lbl.ValueSeriesName"));
        lblSeriesParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterSeries"));
        this.txtSeriesParm = new Text((Composite)this.grpParameters, 2048);
        GridData gdTXTSeriesParm = new GridData(768);
        gdTXTSeriesParm.horizontalSpan = 2;
        this.txtSeriesParm.setLayoutData((Object)gdTXTSeriesParm);
        this.txtSeriesParm.setToolTipText(Messages.getString("TriggerDataComposite.Tooltip.ParameterSeries"));
        this.populateLists();
    }

    private void populateLists() {
        Object[] triggerTypes = LiteralHelper.triggerConditionSet.getDisplayNames();
        this.cmbTriggerType.setItems(triggerTypes);
        this.cmbTriggerType.select(0);
        Trigger firstTrigger = null;
        int i = 0;
        while (i < triggerTypes.length) {
            Trigger trigger;
            if (this.triggersMap.containsKey(triggerTypes[i]) && this.triggerMatrix.check(trigger = (Trigger)this.triggersMap.get(triggerTypes[i]))) {
                this.cmbTriggerType.markSelection((String)triggerTypes[i]);
                if (firstTrigger == null) {
                    firstTrigger = trigger;
                    this.cmbTriggerType.setText((String)triggerTypes[i]);
                }
            }
            ++i;
        }
        this.lastTriggerType = this.cmbTriggerType.getText();
        this.updateActionTypeItems();
        if (firstTrigger != null) {
            this.cmbActionType.setText(LiteralHelper.actionTypeSet.getDisplayNameByName(firstTrigger.getAction().getType().getName()));
            this.updateUI(firstTrigger);
        } else {
            this.cmbActionType.select(0);
            this.slValues.topControl = this.cmpDefault;
        }
    }

    private void updateActionTypeItems() {
        TriggerCondition condition = TriggerCondition.getByName((String)LiteralHelper.triggerConditionSet.getNameByDisplayName(this.cmbTriggerType.getText()));
        this.cmbActionType.setItems(this.triggerMatrix.getSupportedActionsDisplayName(condition));
        this.cmbActionType.add(Messages.getString("TriggerDataComposite.Lbl.None." + condition.getName()), 0);
    }

    private int getTriggerIndex() {
        if (this.cmbActionType.getText().equals(LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.SHOW_TOOLTIP_LITERAL.getName()))) {
            return 2;
        }
        if (this.cmbActionType.getText().equals(LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.URL_REDIRECT_LITERAL.getName()))) {
            return 1;
        }
        if (this.cmbActionType.getText().equals(LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.INVOKE_SCRIPT_LITERAL.getName()))) {
            return 4;
        }
        if (this.cmbActionType.getText().equals(LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.HIGHLIGHT_LITERAL.getName()))) {
            return 5;
        }
        if (this.cmbActionType.getText().equals(LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.TOGGLE_VISIBILITY_LITERAL.getName()))) {
            return 3;
        }
        if (this.cmbActionType.getText().equals(LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.TOGGLE_DATA_POINT_VISIBILITY_LITERAL.getName()))) {
            return 7;
        }
        if (this.cmbActionType.getText().equals(LiteralHelper.actionTypeSet.getDisplayNameByName(ActionType.CALL_BACK_LITERAL.getName()))) {
            return 6;
        }
        return 0;
    }

    private Label addDescriptionLabel(Composite parent, int horizontalSpan, String description) {
        Label label = new Label(parent, 64);
        GridData gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gd);
        label.setText(description);
        return label;
    }

    public void markSaveWhenClosing() {
        this.needSaveWhenDisposing = true;
    }

    public void setTrigger(Trigger trigger) {
        if (trigger == null) {
            this.clear();
            return;
        }
        this.cmbTriggerType.setText(LiteralHelper.triggerConditionSet.getDisplayNameByName(trigger.getCondition().getName()));
        this.updateActionTypeItems();
        if (this.triggerMatrix.check(trigger)) {
            this.cmbActionType.setText(LiteralHelper.actionTypeSet.getDisplayNameByName(trigger.getAction().getType().getName()));
        } else {
            this.cmbActionType.select(0);
        }
        this.updateUI(trigger);
    }

    private void initUI() {
        this.txtBaseParm.setText("");
        this.txtValueParm.setText("");
        this.txtSeriesParm.setText("");
        this.txtTooltipText.setText("");
        this.txtScript.setText("");
    }

    private void updateUI(Trigger trigger) {
        if (trigger == null) {
            this.initUI();
            return;
        }
        switch (this.getTriggerIndex()) {
            case 1: {
                this.slValues.topControl = this.cmpURL;
                URLValue urlValue = (URLValue)trigger.getAction().getValue();
                this.sBaseURL = urlValue.getBaseUrl();
                this.txtBaseParm.setText(urlValue.getBaseParameterName().length() > 0 ? urlValue.getBaseParameterName() : "");
                this.txtValueParm.setText(urlValue.getValueParameterName().length() > 0 ? urlValue.getValueParameterName() : "");
                this.txtSeriesParm.setText(urlValue.getSeriesParameterName().length() > 0 ? urlValue.getSeriesParameterName() : "");
                break;
            }
            case 2: {
                this.slValues.topControl = this.cmpTooltip;
                TooltipValue tooltipValue = (TooltipValue)trigger.getAction().getValue();
                this.txtTooltipText.setText(tooltipValue.getText() != null ? tooltipValue.getText() : "");
                break;
            }
            case 3: {
                this.slValues.topControl = this.cmpVisiblity;
                break;
            }
            case 4: {
                this.slValues.topControl = this.cmpScript;
                ScriptValue scriptValue = (ScriptValue)trigger.getAction().getValue();
                this.txtScript.setText(scriptValue.getScript().length() > 0 ? scriptValue.getScript() : "");
                break;
            }
            case 5: {
                this.slValues.topControl = this.cmpHighlight;
                break;
            }
            case 6: {
                this.slValues.topControl = this.cmpCallback;
                break;
            }
            case 7: {
                this.slValues.topControl = this.cmpDPVisibility;
                break;
            }
            default: {
                this.slValues.topControl = this.cmpDefault;
            }
        }
        this.grpValue.layout();
    }

    public Trigger getTrigger() {
        if (this.cmbActionType.getSelectionIndex() == 0) {
            return null;
        }
        SeriesValue value = null;
        switch (this.getTriggerIndex()) {
            case 1: {
                value = URLValueImpl.create((String)this.sBaseURL, null, (String)this.txtBaseParm.getText(), (String)this.txtValueParm.getText(), (String)this.txtSeriesParm.getText());
                break;
            }
            case 2: {
                value = TooltipValueImpl.create((int)200, (String)"");
                ((TooltipValue)value).setText(this.txtTooltipText.getText());
                break;
            }
            case 3: {
                value = AttributeFactory.eINSTANCE.createSeriesValue();
                value.setName("");
                break;
            }
            case 4: {
                value = AttributeFactory.eINSTANCE.createScriptValue();
                ((ScriptValue)value).setScript(this.txtScript.getText());
                break;
            }
            case 5: {
                value = AttributeFactory.eINSTANCE.createSeriesValue();
                value.setName("");
                break;
            }
            case 7: {
                value = AttributeFactory.eINSTANCE.createSeriesValue();
                value.setName("");
            }
        }
        Action action = ActionImpl.create((ActionType)ActionType.getByName((String)LiteralHelper.actionTypeSet.getNameByDisplayName(this.cmbActionType.getText())), (ActionValue)value);
        return TriggerImpl.create((TriggerCondition)TriggerCondition.getByName((String)LiteralHelper.triggerConditionSet.getNameByDisplayName(this.lastTriggerType == null ? this.cmbTriggerType.getText() : this.lastTriggerType)), (Action)action);
    }

    public void clear() {
        this.cmbTriggerType.select(0);
        this.cmbActionType.select(0);
        this.switchUI();
    }

    private void switchUI() {
        switch (this.getTriggerIndex()) {
            case 1: {
                this.slValues.topControl = this.cmpURL;
                break;
            }
            case 2: {
                this.slValues.topControl = this.cmpTooltip;
                break;
            }
            case 3: {
                this.slValues.topControl = this.cmpVisiblity;
                break;
            }
            case 4: {
                this.slValues.topControl = this.cmpScript;
                break;
            }
            case 5: {
                this.slValues.topControl = this.cmpHighlight;
                break;
            }
            case 6: {
                this.slValues.topControl = this.cmpCallback;
                break;
            }
            case 7: {
                this.slValues.topControl = this.cmpDPVisibility;
                break;
            }
            default: {
                this.slValues.topControl = this.cmpDefault;
            }
        }
        this.grpValue.layout();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbActionType)) {
            String triggerType = this.cmbTriggerType.getText();
            if (this.cmbActionType.getSelectionIndex() == 0) {
                this.cmbTriggerType.unmarkSelection(triggerType);
                Object trigger = this.triggersMap.get(triggerType);
                if (trigger != null) {
                    this.triggersMap.remove(triggerType);
                    this.triggersList.remove(trigger);
                }
            } else {
                this.cmbTriggerType.markSelection(triggerType);
            }
            this.cmbTriggerType.setText(triggerType);
            this.switchUI();
        } else if (e.getSource().equals(this.btnBaseURL)) {
            try {
                if (this.wizardContext != null) {
                    this.sBaseURL = this.wizardContext.getUIServiceProvider().invoke(this.getHyperlinkBuilderCommand(), this.sBaseURL, this.wizardContext.getExtendedItem(), null);
                }
            }
            catch (ChartException ex) {
                WizardBase.displayException((Throwable)ex);
            }
        } else if (e.getSource().equals(this.btnAdvanced)) {
            this.bAdvanced = !this.bAdvanced;
            this.btnAdvanced.setText(this.getAdvancedButtonText(this.bAdvanced));
            this.grpParameters.setVisible(this.bAdvanced);
            this.slValues.topControl = this.cmpURL;
            this.grpValue.layout(true, true);
        } else if (e.getSource().equals(this.btnTooltipExpBuilder)) {
            try {
                String sExpr = this.wizardContext.getUIServiceProvider().invoke(this.getExpressionBuilderTooltipCommand(), this.txtTooltipText.getText(), this.wizardContext.getExtendedItem(), null);
                this.txtTooltipText.setText(sExpr);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        } else if (e.getSource().equals(this.btnScriptExpBuilder)) {
            try {
                String sExpr = this.wizardContext.getUIServiceProvider().invoke(this.getExpressionBuilderScriptCommand(), this.txtScript.getText(), this.wizardContext.getExtendedItem(), null);
                this.txtScript.setText(sExpr);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private String getActionText(Trigger trigger) {
        return LiteralHelper.actionTypeSet.getDisplayNameByName(trigger.getAction().getType().getName());
    }

    private void updateTrigger(String triggerType) {
        if (triggerType == null || triggerType.length() == 0) {
            return;
        }
        if (this.cmbActionType.getSelectionIndex() <= 0) {
            this.cmbTriggerType.unmarkSelection(triggerType);
            return;
        }
        this.cmbTriggerType.markSelection(triggerType);
        Object oldTrigger = this.triggersMap.get(triggerType);
        Trigger newTrigger = this.getTrigger();
        if (oldTrigger != null) {
            int index = this.triggersList.indexOf(oldTrigger);
            if (index >= 0) {
                this.triggersList.set(index, (Object)newTrigger);
            }
        } else {
            this.triggersList.add((Object)newTrigger);
        }
        this.triggersMap.put(triggerType, newTrigger);
    }

    private String getAdvancedButtonText(boolean bAdvanced) {
        if (bAdvanced) {
            return Messages.getString("TriggerDataComposite.Text.OpenAdvanced");
        }
        return Messages.getString("TriggerDataComposite.Text.Advanced");
    }

    private int getExpressionBuilderScriptCommand() {
        int type = this.triggerMatrix.getType();
        if ((type & 1) == 1) {
            return 4;
        }
        return 3;
    }

    private int getExpressionBuilderTooltipCommand() {
        int type = this.triggerMatrix.getType();
        if ((type & 1) == 1) {
            return 5;
        }
        return 3;
    }

    private int getHyperlinkBuilderCommand() {
        int type = this.triggerMatrix.getType();
        if ((type & 1) == 1) {
            return 7;
        }
        return 6;
    }
}

