/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.DialChartImpl;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeterChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Meter Chart";
    protected static final String STANDARD_SUBTYPE_LITERAL = "Standard Meter Chart";
    protected static final String SUPERIMPOSED_SUBTYPE_LITERAL = "Superimposed Meter Chart";
    private static final String CHART_TITLE = Messages.getString("MeterChart.Txt.DefaultMeterChartTitle");
    private static final String sStandardDescription = Messages.getString("MeterChart.Txt.Description");
    private static final String sSuperimposedDescription = Messages.getString("MeterChart.Txt.SuperimposedDescription");
    private transient Image imgIcon = UIHelper.getImage((String)"icons/obj16/metercharticon.gif");
    private transient Image imgStandard = null;
    private transient Image imgSuperimposed = null;

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return this.imgIcon;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("MeterChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (!orientation.equals(Orientation.VERTICAL_LITERAL)) {
            return vSubTypes;
        }
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            this.imgStandard = UIHelper.getImage((String)"icons/wizban/meterchartimage.gif");
            this.imgSuperimposed = UIHelper.getImage((String)"icons/wizban/meterchartsuperimposedimage.gif");
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STANDARD_SUBTYPE_LITERAL, this.imgStandard, sStandardDescription, Messages.getString("MeterChart.SubType.Standard")));
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(SUPERIMPOSED_SUBTYPE_LITERAL, this.imgSuperimposed, sSuperimposedDescription, Messages.getString("MeterChart.SubType.Superimposed")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        DialChart newChart = null;
        if (currentChart != null && (newChart = (DialChart)this.getConvertedChart(currentChart, sSubType, sDimension)) != null) {
            return newChart;
        }
        newChart = (DialChart)DialChartImpl.create();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        newChart.setDimension(this.getDimensionFor(sDimension));
        newChart.setUnits("Points");
        newChart.setDialSuperimposition(sSubType.equals(SUPERIMPOSED_SUBTYPE_LITERAL));
        newChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.getSeriesPalette().shift(0);
        Series categorySeries = SeriesImpl.create();
        sdX.getSeries().add((Object)categorySeries);
        sdX.getQuery().setDefinition("Base Series");
        newChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(0);
        DialSeries valueSeries = (DialSeries)DialSeriesImpl.create();
        valueSeries.getLabel().setVisible(true);
        valueSeries.setSeriesIdentifier((Object)"valueSeriesIdentifier");
        sdY.getSeries().add((Object)valueSeries);
        sdX.getSeriesDefinitions().add((Object)sdY);
        newChart.getSeriesDefinitions().add((Object)sdX);
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("A, B, C");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5, 4, 12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        newChart.setSampleData(sd);
    }

    private Chart getConvertedChart(Chart currentChart, String sNewSubType, String sNewDimension) {
        Chart helperModel = (Chart)EcoreUtil.copy((EObject)currentChart);
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        if (currentChart instanceof ChartWithAxes) {
            if (!ChartPreviewPainter.isLivePreviewActive()) {
                helperModel.setSampleData(this.getConvertedSampleData(helperModel.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType()));
            }
            currentChart = DialChartImpl.create();
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            currentChart.setDimension(this.getDimensionFor(sNewDimension));
            ((DialChart)currentChart).setDialSuperimposition(false);
            currentChart.setBlock(helperModel.getBlock());
            currentChart.setDescription(helperModel.getDescription());
            currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            if (helperModel.getInteractivity() != null) {
                currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
            }
            currentChart.setSampleData(helperModel.getSampleData());
            currentChart.setScript(helperModel.getScript());
            currentChart.setUnits(helperModel.getUnits());
            if (helperModel.getGridColumnCount() > 0) {
                currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            } else {
                currentChart.setGridColumnCount(0);
            }
            ((ChartWithoutAxes)currentChart).getSeriesDefinitions().add(((Axis)((ChartWithAxes)helperModel).getAxes().get(0)).getSeriesDefinitions().get(0));
            Vector<SeriesDefinition> vOSD = new Vector<SeriesDefinition>();
            Axis primaryOrthogonalAxis = ((ChartWithAxes)helperModel).getPrimaryOrthogonalAxis((Axis)((ChartWithAxes)helperModel).getAxes().get(0));
            EList osd = primaryOrthogonalAxis.getSeriesDefinitions();
            int j = 0;
            while (j < osd.size()) {
                SeriesDefinition sd = (SeriesDefinition)osd.get(j);
                Series series = sd.getDesignTimeSeries();
                sd.getSeries().clear();
                sd.getSeries().add((Object)this.getConvertedSeries(series, j));
                vOSD.add(sd);
                ++j;
            }
            ((SeriesDefinition)((ChartWithoutAxes)currentChart).getSeriesDefinitions().get(0)).getSeriesDefinitions().clear();
            ((SeriesDefinition)((ChartWithoutAxes)currentChart).getSeriesDefinitions().get(0)).getSeriesDefinitions().addAll(vOSD);
            currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
            currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        } else if (currentChart instanceof ChartWithoutAxes) {
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                currentChart.setSubType(sNewSubType);
                ((DialChart)currentChart).setDialSuperimposition(sNewSubType.equals(SUPERIMPOSED_SUBTYPE_LITERAL));
                if (!currentChart.getDimension().equals(this.getDimensionFor(sNewDimension))) {
                    currentChart.setDimension(this.getDimensionFor(sNewDimension));
                }
            } else {
                currentChart = DialChartImpl.create();
                currentChart.setType(TYPE_LITERAL);
                currentChart.setSubType(sNewSubType);
                currentChart.setDimension(this.getDimensionFor(sNewDimension));
                ((DialChart)currentChart).setDialSuperimposition(sNewSubType.equals(SUPERIMPOSED_SUBTYPE_LITERAL));
                currentChart.setBlock(helperModel.getBlock());
                currentChart.setDescription(helperModel.getDescription());
                currentChart.setGridColumnCount(helperModel.getGridColumnCount());
                currentChart.setSampleData(helperModel.getSampleData());
                currentChart.setScript(helperModel.getScript());
                currentChart.setUnits(helperModel.getUnits());
                if (helperModel.getInteractivity() != null) {
                    currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                    currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
                }
                ((ChartWithoutAxes)currentChart).getSeriesDefinitions().clear();
                ((ChartWithoutAxes)currentChart).getSeriesDefinitions().add(((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0));
                EList seriesdefinitions = ((SeriesDefinition)((ChartWithoutAxes)currentChart).getSeriesDefinitions().get(0)).getSeriesDefinitions();
                int j = 0;
                while (j < seriesdefinitions.size()) {
                    Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                    series = this.getConvertedSeries(series, j);
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                    ++j;
                }
                currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
                currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
            }
        } else {
            return null;
        }
        return currentChart;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        DialSeries dialseries = (DialSeries)ChartCacheManager.getInstance().findSeries(DialSeriesImpl.class.getName(), seriesIndex);
        if (dialseries == null) {
            dialseries = (DialSeries)DialSeriesImpl.create();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)dialseries);
        return dialseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, AxisType axisType) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
        int i = 0;
        while (i < bsdList.size()) {
            BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)i));
            vNewBaseSampleData.add(bsd);
            ++i;
        }
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        int i2 = 0;
        while (i2 < osdList.size()) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i2);
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)AxisType.LINEAR_LITERAL, (String)osd.getDataSetRepresentation(), (int)i2));
            vNewOrthogonalSampleData.add(osd);
            ++i2;
        }
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return false;
    }

    private ChartDimension getDimensionFor(String sDimension) {
        return ChartDimension.TWO_DIMENSIONAL_LITERAL;
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        DefaultBaseSeriesComponent component = new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
        component.setLabelText(Messages.getString("PieBaseSeriesComponent.Label.CategoryDefinition"));
        component.setTooltipWhenBlank(Messages.getString("MeterChart.Tooltip.InputExpression"));
        return component;
    }

    public String getDisplayName() {
        return Messages.getString("MeterChart.Txt.DisplayName");
    }

    public Series getSeries() {
        return DialSeriesImpl.create();
    }
}

