/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.StringTokenizer;
import java.text.ParseException;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.impl.StockSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.type.BarChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StockChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Stock Chart";
    protected static final String STANDARD_SUBTYPE_LITERAL = "Standard Stock Chart";
    protected static final String BAR_STICK_SUBTYPE_LITERAL = "Bar Stick Stock Chart";
    private static final String CHART_TITLE = Messages.getString("StockChart.Txt.DefaultStockChartTitle");
    private static final String sCandleStickDescription = Messages.getString("StockChart.Txt.CandleStickDescription");
    private static final String sBarStickDescription = Messages.getString("StockChart.Txt.BarStickDescription");
    private transient Image imgIcon = UIHelper.getImage((String)"icons/obj16/stockcharticon.gif");
    private transient Image img2DCandleStick = null;
    private transient Image img2DBarlStick = null;

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return this.imgIcon;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("StockChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            if (orientation.equals(Orientation.VERTICAL_LITERAL)) {
                this.img2DCandleStick = UIHelper.getImage((String)"icons/wizban/stockchartimage.gif");
                this.img2DBarlStick = UIHelper.getImage((String)"icons/wizban/stockchartbarstickimage.gif");
            } else {
                this.img2DCandleStick = UIHelper.getImage((String)"icons/wizban/horizontalstockchartimage.gif");
                this.img2DBarlStick = UIHelper.getImage((String)"icons/wizban/horizontalstockchartbarstickimage.gif");
            }
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STANDARD_SUBTYPE_LITERAL, this.img2DCandleStick, sCandleStickDescription, Messages.getString("StockChart.SubType.CandleStick")));
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(BAR_STICK_SUBTYPE_LITERAL, this.img2DBarlStick, sBarStickDescription, Messages.getString("StockChart.SubType.BarStick")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.create();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        newChart.setOrientation(orientation);
        newChart.setDimension(this.getDimensionFor(sDimension));
        newChart.setUnits("Points");
        newChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        ((Axis)newChart.getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setType(AxisType.DATE_TIME_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setCategoryAxis(true);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        Series categorySeries = SeriesImpl.create();
        sdX.getSeries().add((Object)categorySeries);
        sdX.getSeriesPalette().shift(0);
        ((Axis)newChart.getAxes().get(0)).getSeriesDefinitions().add((Object)sdX);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(0);
        Series valueSeries = StockSeriesImpl.create();
        if (BAR_STICK_SUBTYPE_LITERAL.equals(sSubType)) {
            ((StockSeries)valueSeries).setShowAsBarStick(true);
        }
        sdY.getSeries().add((Object)valueSeries);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("01/25/2005,01/26/2005");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        newChart.setSampleData(sd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Chart helperModel = (Chart)EcoreUtil.copy((EObject)currentChart);
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        if (currentChart instanceof ChartWithAxes) {
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                if (!currentChart.getSubType().equals(sNewSubType)) {
                    currentChart.setSubType(sNewSubType);
                    EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                    int i = 0;
                    while (i < axes.size()) {
                        ((Axis)axes.get(i)).setPercent(false);
                        EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                        int j = 0;
                        while (j < seriesdefinitions.size()) {
                            Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                            series.setStacked(false);
                            if (series instanceof StockSeries) {
                                ((StockSeries)series).setShowAsBarStick(BAR_STICK_SUBTYPE_LITERAL.equals(currentChart.getSubType()));
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            } else {
                if (!currentChart.getType().equals("Line Chart") && !currentChart.getType().equals("Area Chart") && !currentChart.getType().equals(BarChart.TYPE_LITERAL) && !currentChart.getType().equals("Tube Chart") && !currentChart.getType().equals("Cone Chart") && !currentChart.getType().equals("Pyramid Chart") && !currentChart.getType().equals("Scatter Chart") && !currentChart.getType().equals("Bubble Chart") && !currentChart.getType().equals("Difference Chart") && !currentChart.getType().equals("Gantt Chart")) return null;
                if (!currentChart.getType().equals(TYPE_LITERAL)) {
                    currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), false));
                }
                currentChart.setType(TYPE_LITERAL);
                currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
                ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
                currentChart.setSubType(sNewSubType);
                EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                int i = 0;
                int seriesIndex = 0;
                while (i < axes.size()) {
                    if (!ChartPreviewPainter.isLivePreviewActive()) {
                        ((Axis)axes.get(i)).setType(AxisType.LINEAR_LITERAL);
                    }
                    ((Axis)axes.get(i)).setPercent(false);
                    EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                    int j = 0;
                    while (j < seriesdefinitions.size()) {
                        Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                        series = this.getConvertedSeries(series, seriesIndex++);
                        series.setStacked(false);
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                        ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                        ++j;
                    }
                    ++i;
                }
            }
        } else {
            currentChart = ChartWithAxesImpl.create();
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
            currentChart.setDimension(this.getDimensionFor(sNewDimension));
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
            currentChart.setBlock(helperModel.getBlock());
            currentChart.setDescription(helperModel.getDescription());
            currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            currentChart.setSampleData(this.getConvertedSampleData(helperModel.getSampleData(), true));
            currentChart.setScript(helperModel.getScript());
            currentChart.setSeriesThickness(helperModel.getSeriesThickness());
            currentChart.setUnits(helperModel.getUnits());
            if (helperModel.getInteractivity() != null) {
                currentChart.getInteractivity().setEnable(helperModel.getInteractivity().isEnable());
                currentChart.getInteractivity().setLegendBehavior(helperModel.getInteractivity().getLegendBehavior());
            }
            if (!helperModel.getType().equals("Pie Chart") && !helperModel.getType().equals("Meter Chart")) return null;
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().add(((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0));
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().addAll((Collection)((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeriesDefinitions());
            Series series = ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().clear();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().add((Object)series);
            EList seriesdefinitions = ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions();
            int j = 0;
            while (j < seriesdefinitions.size()) {
                series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series = this.getConvertedSeries(series, j);
                series.getLabel().setVisible(false);
                series.setStacked(false);
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                ++j;
            }
            currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
            currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        }
        if (currentChart instanceof ChartWithAxes && !((ChartWithAxes)currentChart).getOrientation().equals(newOrientation)) {
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
        }
        if (!currentChart.getDimension().equals(this.getDimensionFor(sNewDimension))) {
            currentChart.setDimension(this.getDimensionFor(sNewDimension));
        }
        ChartUIUtil.restoreLabelPositionFromCache((Chart)currentChart);
        return currentChart;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        StockSeries stockseries = (StockSeries)ChartCacheManager.getInstance().findSeries(StockSeriesImpl.class.getName(), seriesIndex);
        if (stockseries == null) {
            stockseries = (StockSeries)StockSeriesImpl.create();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)stockseries);
        return stockseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, boolean convertBaseToDate) {
        int i;
        if (convertBaseToDate) {
            EList bsdList = currentSampleData.getBaseSampleData();
            Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
            i = 0;
            while (i < bsdList.size()) {
                BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
                bsd.setDataSetRepresentation(this.getConvertedBaseSampleDataRepresentation(bsd.getDataSetRepresentation()));
                vNewBaseSampleData.add(bsd);
                ++i;
            }
            currentSampleData.getBaseSampleData().clear();
            currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        }
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        i = 0;
        while (i < osdList.size()) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i);
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)AxisType.LINEAR_LITERAL, (String)osd.getDataSetRepresentation(), (int)i));
            vNewOrthogonalSampleData.add(osd);
            ++i;
        }
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    private String getConvertedBaseSampleDataRepresentation(String sOldRepresentation) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        StringBuffer sbNewRepresentation = new StringBuffer("");
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        int iValueCount = 0;
        while (strtok.hasMoreTokens()) {
            Calendar cal;
            String sElement = strtok.nextToken().trim();
            if (!sElement.startsWith("'")) {
                cal = Calendar.getInstance();
                cal.set(5, cal.get(5) + iValueCount);
                sbNewRepresentation.append(sdf.format(cal.getTime()));
                ++iValueCount;
            } else {
                sElement = sElement.substring(1, sElement.length() - 1);
                try {
                    sdf.parse(sElement);
                    sbNewRepresentation.append(sElement);
                }
                catch (ParseException parseException) {
                    cal = Calendar.getInstance();
                    cal.set(5, cal.get(5) + iValueCount);
                    sbNewRepresentation.append(sdf.format(cal.getTime()));
                    ++iValueCount;
                }
            }
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return false;
    }

    private ChartDimension getDimensionFor(String sDimension) {
        return ChartDimension.TWO_DIMENSIONAL_LITERAL;
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("StockChart.Txt.DisplayName");
    }

    public Series getSeries() {
        return StockSeriesImpl.create();
    }

    public boolean canCombine() {
        return true;
    }
}

