/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.axis;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierDialog;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.InteractivitySheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisGridLinesSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisLabelSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisMarkersSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisScaleSheet;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.axis.AxisTitleSheet;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

abstract class AbstractAxisSubtask
extends SubtaskSheetImpl
implements Listener,
SelectionListener {
    private Button btnCategoryAxis;
    private Button btnReverse;
    private ExternalizedTextEditorComposite txtTitle;
    private Button btnTitleVisible;
    private Combo cmbTypes;
    private Combo cmbOrigin;
    private Button btnFormatSpecifier;
    private Label lblValue;
    private TextEditorComposite txtValue;
    private Button btnLabelVisible;
    private FontDefinitionComposite fdcFont;
    private Button cbStaggered;

    AbstractAxisSubtask() {
    }

    protected abstract Axis getAxisForProcessing();

    protected abstract int getAxisAngleType();

    protected boolean isChart3D(Axis ax) {
        if (this.getChart() instanceof ChartWithAxes) {
            return this.getChart().getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL;
        }
        return false;
    }

    public void createControl(Composite parent) {
        GridData gd;
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(2, false);
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd2 = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd2);
        Composite cmpBasic = new Composite(this.cmpContent, 0);
        cmpBasic.setLayout((Layout)new GridLayout(3, false));
        cmpBasic.setLayoutData((Object)new GridData(768));
        if (this.getAxisAngleType() == 1) {
            this.btnCategoryAxis = new Button(cmpBasic, 32);
            this.btnCategoryAxis.setText(Messages.getString("AbstractAxisSubtask.Lbl.IsCategoryAxis"));
            this.btnCategoryAxis.addSelectionListener((SelectionListener)this);
            this.btnCategoryAxis.setSelection(this.getAxisForProcessing().isCategoryAxis());
            this.btnCategoryAxis.setEnabled(!AxisType.TEXT_LITERAL.equals(this.getAxisForProcessing().getType()));
            this.btnReverse = new Button(cmpBasic, 32);
            gd2 = new GridData();
            gd2.horizontalSpan = 2;
            this.btnCategoryAxis.setLayoutData((Object)gd2);
            this.btnReverse.setText(Messages.getString("AbstractAxisSubtask.Label.ReverseCategory"));
            this.btnReverse.addSelectionListener((SelectionListener)this);
            this.btnReverse.setSelection(((ChartWithAxes)this.getChart()).isReverseCategory());
            this.btnReverse.setEnabled(this.btnCategoryAxis.getSelection());
        }
        Label lblTitle = new Label(cmpBasic, 0);
        lblTitle.setText(Messages.getString("AxisYSheetImpl.Label.Title"));
        List keys = null;
        IUIServiceProvider serviceprovider = this.getContext().getUIServiceProvider();
        if (serviceprovider != null) {
            keys = serviceprovider.getRegisteredKeys();
        }
        this.txtTitle = new ExternalizedTextEditorComposite(cmpBasic, 2052, -1, -1, keys, serviceprovider, this.getAxisForProcessing().getTitle().getCaption().getValue());
        GridData gd3 = new GridData();
        gd3.widthHint = 250;
        this.txtTitle.setLayoutData(gd3);
        this.txtTitle.addListener(this);
        this.btnTitleVisible = new Button(cmpBasic, 32);
        this.btnTitleVisible.setText(Messages.getString("ChartSheetImpl.Label.Visible"));
        this.btnTitleVisible.setSelection(this.getChart().getTitle().isVisible());
        this.btnTitleVisible.addSelectionListener((SelectionListener)this);
        this.btnTitleVisible.setSelection(this.getAxisForProcessing().getTitle().isVisible());
        if (this.getAxisAngleType() != 3) {
            Label lblType = new Label(cmpBasic, 0);
            lblType.setText(Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.Type"));
            this.cmbTypes = new Combo(cmpBasic, 12);
            gd = new GridData();
            gd.widthHint = 220;
            this.cmbTypes.setLayoutData((Object)gd);
            this.cmbTypes.addSelectionListener((SelectionListener)this);
            this.btnFormatSpecifier = new Button(cmpBasic, 8);
            GridData gdBTNFormatSpecifier = new GridData();
            ChartUIUtil.setChartImageButtonSizeByPlatform((GridData)gdBTNFormatSpecifier);
            gdBTNFormatSpecifier.horizontalIndent = -3;
            this.btnFormatSpecifier.setLayoutData((Object)gdBTNFormatSpecifier);
            this.btnFormatSpecifier.setImage(UIHelper.getImage((String)"icons/obj16/formatbuilder.gif"));
            this.btnFormatSpecifier.setToolTipText(Messages.getString("Shared.Tooltip.FormatSpecifier"));
            this.btnFormatSpecifier.addSelectionListener((SelectionListener)this);
            this.btnFormatSpecifier.getImage().setBackground(this.btnFormatSpecifier.getBackground());
            if (this.getChart().getDimension().getValue() != 2) {
                Label lblOrigin = new Label(cmpBasic, 0);
                lblOrigin.setText(Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.Origin"));
                this.cmbOrigin = new Combo(cmpBasic, 12);
                GridData gd4 = new GridData();
                gd4.widthHint = 220;
                gd4.horizontalSpan = 2;
                this.cmbOrigin.setLayoutData((Object)gd4);
                this.cmbOrigin.addSelectionListener((SelectionListener)this);
                boolean bValueOrigin = false;
                if (this.getAxisForProcessing().getOrigin() != null && this.getAxisForProcessing().getOrigin().getType().equals(IntersectionType.VALUE_LITERAL)) {
                    bValueOrigin = true;
                }
                this.lblValue = new Label(cmpBasic, 0);
                this.lblValue.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Value"));
                this.lblValue.setEnabled(bValueOrigin);
                this.txtValue = new TextEditorComposite(cmpBasic, 2052);
                GridData gd5 = new GridData();
                gd5.widthHint = 245;
                gd5.horizontalSpan = 2;
                this.txtValue.setLayoutData(gd5);
                this.txtValue.addListener(this);
                this.txtValue.setEnabled(bValueOrigin);
            }
            this.populateLists();
        }
        new Label(cmpBasic, 0).setText(Messages.getString("AxisYSheetImpl.Label.Labels"));
        this.fdcFont = new FontDefinitionComposite(cmpBasic, 0, this.getContext(), this.getAxisForProcessing().getLabel().getCaption().getFont(), this.getAxisForProcessing().getLabel().getCaption().getColor(), false);
        GridData gdFDCFont = new GridData();
        gdFDCFont.heightHint = this.fdcFont.getPreferredSize().y;
        gdFDCFont.widthHint = 250;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        Composite cmpLabel = new Composite(cmpBasic, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cmpLabel.setLayout((Layout)layout);
        this.btnLabelVisible = new Button(cmpLabel, 32);
        this.btnLabelVisible.setText(Messages.getString("AbstractAxisSubtask.Label.Visible2"));
        gd = new GridData(768);
        this.btnLabelVisible.setLayoutData((Object)gd);
        this.btnLabelVisible.addSelectionListener((SelectionListener)this);
        this.btnLabelVisible.setSelection(this.getAxisForProcessing().getLabel().isVisible());
        this.cbStaggered = new Button(cmpLabel, 32);
        Axis ax = this.getAxisForProcessing();
        boolean bStaggered = ax.isSetStaggered() && ax.isStaggered();
        boolean bNot3D = !this.isChart3D(ax);
        this.cbStaggered.setSelection(bNot3D && bStaggered);
        this.cbStaggered.setText(Messages.getString("AbstractAxisSubtask.Label.Stagger"));
        this.cbStaggered.addSelectionListener((SelectionListener)this);
        this.cbStaggered.setEnabled(bNot3D);
        this.createButtonGroup(this.cmpContent);
        this.setStateOfTitle();
        this.setStateOfLabel();
    }

    private void setStateOfTitle() {
        boolean isTitleEnabled = this.getAxisForProcessing().getTitle().isVisible();
        this.txtTitle.setEnabled(isTitleEnabled);
        this.setToggleButtonEnabled(".Title", isTitleEnabled);
    }

    private void setStateOfLabel() {
        Axis ax = this.getAxisForProcessing();
        boolean isLabelEnabled = ax.getLabel().isVisible();
        this.fdcFont.setEnabled(isLabelEnabled);
        this.cbStaggered.setEnabled(!this.isChart3D(ax) && isLabelEnabled);
        this.setToggleButtonEnabled(".Label", isLabelEnabled);
    }

    private void createButtonGroup(Composite parent) {
        AbstractPopupSheet popup;
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        gridData.horizontalAlignment = 1;
        cmp.setLayoutData((Object)gridData);
        if (this.getAxisAngleType() != 3) {
            popup = new AxisScaleSheet(Messages.getString("AxisYSheetImpl.Label.Scale"), this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType());
            Button btnScale = this.createToggleButton(cmp, ".Scale", Messages.getString("AxisYSheetImpl.Label.Scale&"), popup);
            btnScale.addSelectionListener((SelectionListener)this);
        }
        popup = new AxisTitleSheet(Messages.getString("AxisYSheetImpl.Label.TitleFormat"), this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType());
        Button btnAxisTitle = this.createToggleButton(cmp, ".Title", Messages.getString("AxisYSheetImpl.Label.TitleFormat&"), popup, this.btnTitleVisible.getSelection());
        btnAxisTitle.addSelectionListener((SelectionListener)this);
        popup = new AxisLabelSheet(Messages.getString("AxisYSheetImpl.Label.LabelFormat"), this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType());
        Button btnAxisLabel = this.createToggleButton(cmp, ".Label", Messages.getString("AxisYSheetImpl.Label.LabelFormat&"), popup, this.btnLabelVisible.getSelection());
        btnAxisLabel.addSelectionListener((SelectionListener)this);
        popup = new AxisGridLinesSheet(Messages.getString("AxisYSheetImpl.Label.Gridlines"), this.getContext(), this.getAxisForProcessing(), this.getAxisAngleType());
        Button btnGridlines = this.createToggleButton(cmp, ".Gridlines", Messages.getString("AxisYSheetImpl.Label.Gridlines&"), popup);
        btnGridlines.addSelectionListener((SelectionListener)this);
        if (this.getAxisAngleType() != 3) {
            popup = new AxisMarkersSheet(Messages.getString("AxisYSheetImpl.Label.Markers"), this.getContext(), this.getAxisForProcessing());
            Button btnMarkers = this.createToggleButton(cmp, ".Markers", Messages.getString("AxisYSheetImpl.Label.Markers&"), popup, !ChartUIUtil.is3DType((Chart)this.getChart()));
            btnMarkers.addSelectionListener((SelectionListener)this);
        }
        popup = new InteractivitySheet(Messages.getString("AbstractAxisSubtask.Label.Interactivity"), this.getContext(), this.getAxisForProcessing().getTriggers(), 8, false, true);
        Button btnInteractivity = this.createToggleButton(cmp, ".Interactivity", Messages.getString("SeriesYSheetImpl.Label.Interactivity&"), popup, this.getChart().getInteractivity().isEnable());
        btnInteractivity.addSelectionListener((SelectionListener)this);
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.axisTypeSet;
        if (this.getAxisAngleType() == 2) {
            ns = ChartUIUtil.getCompatibleAxisType((Series)((SeriesDefinition)this.getAxisForProcessing().getSeriesDefinitions().get(0)).getDesignTimeSeries());
        }
        this.cmbTypes.setItems(ns.getDisplayNames());
        this.cmbTypes.setText(ns.getDisplayNameByName(this.getAxisForProcessing().getType().getName()));
        if (this.getChart().getDimension().getValue() != 2) {
            ns = LiteralHelper.intersectionTypeSet;
            this.cmbOrigin.setItems(ns.getDisplayNames());
            this.cmbOrigin.select(ns.getSafeNameIndex(this.getAxisForProcessing().getOrigin().getType().getName()));
        }
        if (this.txtValue != null && !this.txtValue.isDisposed() && this.getAxisForProcessing().getOrigin().getType().equals(IntersectionType.VALUE_LITERAL)) {
            this.txtValue.setText(this.getValue(this.getAxisForProcessing().getOrigin().getValue()));
        }
    }

    private String getValue(DataElement de) {
        if (de instanceof DateTimeDataElement) {
            Date dt = ((DateTimeDataElement)de).getValueAsCalendar().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            return sdf.format(dt);
        }
        if (de instanceof NumberDataElement) {
            return ChartUIUtil.getDefaultNumberFormatInstance().format(((NumberDataElement)de).getValue());
        }
        return "";
    }

    private DataElement getTypedDataElement(String strDataElement) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
        try {
            Date dateElement = sdf.parse(strDataElement);
            Calendar cal = Calendar.getInstance((TimeZone)TimeZone.getDefault());
            cal.setTime(dateElement);
            return DateTimeDataElementImpl.create((Calendar)cal);
        }
        catch (ParseException parseException) {
            try {
                Number numberElement = nf.parse(strDataElement);
                return NumberDataElementImpl.create((double)numberElement.doubleValue());
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.txtTitle)) {
            this.getAxisForProcessing().getTitle().getCaption().setValue((String)event.data);
        } else if (event.widget.equals((Object)this.txtValue)) {
            DataElement de = this.getTypedDataElement(this.txtValue.getText());
            if (de != null) {
                this.getAxisForProcessing().getOrigin().setValue(de);
            }
        } else if (event.widget.equals((Object)this.fdcFont)) {
            this.getAxisForProcessing().getLabel().getCaption().setFont(this.fdcFont.getFontDefinition());
            this.getAxisForProcessing().getLabel().getCaption().setColor(this.fdcFont.getFontColor());
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.cmbTypes)) {
            AxisType axisType = AxisType.getByName((String)LiteralHelper.axisTypeSet.getNameByDisplayName(this.cmbTypes.getText()));
            if (this.getAxisForProcessing().getType() == axisType) {
                return;
            }
            ChartAdapter.beginIgnoreNotifications();
            this.convertSampleData(axisType);
            this.getAxisForProcessing().setFormatSpecifier(null);
            EList markerLines = this.getAxisForProcessing().getMarkerLines();
            int i = 0;
            while (i < markerLines.size()) {
                ((MarkerLine)markerLines.get(i)).setFormatSpecifier(null);
                ++i;
            }
            EList markerRanges = this.getAxisForProcessing().getMarkerRanges();
            int i2 = 0;
            while (i2 < markerRanges.size()) {
                ((MarkerRange)markerRanges.get(i2)).setFormatSpecifier(null);
                ++i2;
            }
            ChartAdapter.endIgnoreNotifications();
            this.getAxisForProcessing().setType(axisType);
            if (this.btnCategoryAxis != null) {
                this.btnCategoryAxis.setEnabled(!AxisType.TEXT_LITERAL.equals(axisType));
            }
            this.refreshPopupSheet();
        } else if (e.widget.equals(this.cmbOrigin)) {
            if (LiteralHelper.intersectionTypeSet.getNameByDisplayName(this.cmbOrigin.getText()).equals(IntersectionType.VALUE_LITERAL.getName())) {
                this.lblValue.setEnabled(true);
                this.txtValue.setEnabled(true);
            } else {
                this.lblValue.setEnabled(false);
                this.txtValue.setEnabled(false);
            }
            this.getAxisForProcessing().getOrigin().setType(IntersectionType.getByName((String)LiteralHelper.intersectionTypeSet.getNameByDisplayName(this.cmbOrigin.getText())));
        } else if (e.widget.equals(this.btnCategoryAxis)) {
            this.getAxisForProcessing().setCategoryAxis(this.btnCategoryAxis.getSelection());
            ChartCacheManager.getInstance().cacheCategory(((ChartWithAxes)this.getChart()).getType(), this.btnCategoryAxis.getSelection());
            this.refreshPopupSheet();
            this.btnReverse.setEnabled(this.btnCategoryAxis.getSelection());
            ((ChartWithAxes)this.getChart()).setReverseCategory(false);
            this.btnReverse.setSelection(false);
        } else if (e.widget.equals(this.btnReverse)) {
            ((ChartWithAxes)this.getChart()).setReverseCategory(this.btnReverse.getSelection());
        } else if (e.widget.equals(this.btnTitleVisible)) {
            this.getAxisForProcessing().getTitle().setVisible(this.btnTitleVisible.getSelection());
            this.setStateOfTitle();
            Button btnAxisTitle = this.getToggleButton(".Title");
            if (!this.btnTitleVisible.getSelection() && btnAxisTitle.getSelection()) {
                btnAxisTitle.setSelection(false);
                this.detachPopup((Widget)btnAxisTitle);
            } else {
                this.refreshPopupSheet();
            }
        } else if (e.widget.equals(this.btnLabelVisible)) {
            this.getAxisForProcessing().getLabel().setVisible(this.btnLabelVisible.getSelection());
            this.setStateOfLabel();
            Button btnAxisLabel = this.getToggleButton(".Label");
            if (!this.btnLabelVisible.getSelection() && btnAxisLabel.getSelection()) {
                btnAxisLabel.setSelection(false);
                this.detachPopup((Widget)btnAxisLabel);
            } else {
                this.refreshPopupSheet();
            }
        } else if (e.widget.equals(this.btnFormatSpecifier)) {
            FormatSpecifierDialog editor;
            String sAxisTitle = Messages.getString("OrthogonalAxisDataSheetImpl.Lbl.OrthogonalAxis");
            try {
                String sTitleString = this.getAxisForProcessing().getTitle().getCaption().getValue();
                int iSeparatorIndex = sTitleString.indexOf("=");
                if (iSeparatorIndex > 0) {
                    sTitleString = sTitleString.substring(iSeparatorIndex);
                } else if (iSeparatorIndex == 0) {
                    sTitleString = sTitleString.substring("=".length());
                }
                sAxisTitle = String.valueOf(sAxisTitle) + " (" + sTitleString + ")";
            }
            catch (NullPointerException nullPointerException) {}
            FormatSpecifier formatspecifier = null;
            if (this.getAxisForProcessing().getFormatSpecifier() != null) {
                formatspecifier = this.getAxisForProcessing().getFormatSpecifier();
            }
            if ((editor = new FormatSpecifierDialog(this.cmpContent.getShell(), formatspecifier, this.getAxisForProcessing().getType(), sAxisTitle)).open() == 0) {
                if (editor.getFormatSpecifier() == null) {
                    this.getAxisForProcessing().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getAxis_FormatSpecifier());
                    return;
                }
                this.getAxisForProcessing().setFormatSpecifier(editor.getFormatSpecifier());
            }
        } else if (e.getSource().equals(this.cbStaggered)) {
            this.getAxisForProcessing().setStaggered(this.cbStaggered.getSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void convertSampleData(AxisType axisType) {
        if (this.getAxisAngleType() == 1) {
            BaseSampleData bsd = (BaseSampleData)this.getChart().getSampleData().getBaseSampleData().get(0);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)0));
        } else if (this.getAxisAngleType() == 2) {
            int iStartIndex = this.getFirstSeriesDefinitionIndexForAxis();
            int iEndIndex = iStartIndex + this.getAxisForProcessing().getSeriesDefinitions().size();
            int iOSDSize = this.getChart().getSampleData().getOrthogonalSampleData().size();
            int i = 0;
            while (i < iOSDSize) {
                OrthogonalSampleData osd = (OrthogonalSampleData)this.getChart().getSampleData().getOrthogonalSampleData().get(i);
                if (osd.getSeriesDefinitionIndex() >= iStartIndex && osd.getSeriesDefinitionIndex() <= iEndIndex) {
                    osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)osd.getDataSetRepresentation(), (int)i));
                }
                ++i;
            }
        }
    }

    private int getFirstSeriesDefinitionIndexForAxis() {
        int iTmp = 0;
        int i = 0;
        while (i < this.getIndex()) {
            iTmp += ChartUIUtil.getAxisYForProcessing((ChartWithAxes)((ChartWithAxes)this.getChart()), (int)i).getSeriesDefinitions().size();
            ++i;
        }
        return iTmp;
    }
}

