/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class CSSUtil {
    private static final double CM_PER_INCH = 2.54;
    private static final double POINTS_PER_INCH = 72.0;
    private static final double POINTS_PER_CM = 28.346456692913385;
    private static final double POINTS_PER_PICA = 12.0;
    public static org.eclipse.swt.graphics.Point dpi = Display.getDefault().getDPI();

    public static int getFontSize(Object object) {
        if (object instanceof DesignElementHandle) {
            String font = CSSUtil.getFontSize((DesignElementHandle)object);
            return CSSUtil.getFontSizeIntValue(font);
        }
        if (object instanceof String) {
            return CSSUtil.getFontSizeIntValue((String)object);
        }
        return CSSUtil.getFontSizeIntValue("medium");
    }

    public static String getFontSize(DesignElementHandle handle) {
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return "medium";
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        StyleHandle styleHandle = handle.getPrivateStyle();
        assert (styleHandle != null);
        String fontSize = (String)styleHandle.getFontSize().getValue();
        if (fontSize.equals("larger")) {
            String parentFontSize = CSSUtil.getFontSize(handle.getContainer());
            return CSSUtil.getLargerFontSize(parentFontSize);
        }
        if (fontSize.equals("smaller")) {
            String parentFontSize = CSSUtil.getFontSize(handle.getContainer());
            return CSSUtil.getSmallerFontSize(parentFontSize);
        }
        return fontSize;
    }

    public static String getLargerFontSize(String curSize) {
        assert (curSize != null);
        int i = 0;
        while (i < DesignerConstants.fontSizes.length - 1) {
            if (curSize.equals(DesignerConstants.fontSizes[i][0])) {
                return DesignerConstants.fontSizes[i + 1][0];
            }
            ++i;
        }
        return DesignerConstants.fontSizes[DesignerConstants.fontSizes.length - 1][0];
    }

    public static String getSmallerFontSize(String curSize) {
        assert (curSize != null);
        int i = DesignerConstants.fontSizes.length - 1;
        while (i > 0) {
            if (curSize.equals(DesignerConstants.fontSizes[i][0])) {
                return DesignerConstants.fontSizes[i - 1][0];
            }
            --i;
        }
        return DesignerConstants.fontSizes[0][0];
    }

    public static int getFontSizeIntValue(String font) {
        assert (font != null);
        String size = "medium";
        int i = 0;
        while (i < DesignerConstants.fontSizes.length) {
            if (font.equals(DesignerConstants.fontSizes[i][0])) {
                size = DesignerConstants.fontSizes[i][1];
                break;
            }
            ++i;
        }
        return Integer.parseInt(size);
    }

    public static int getFontWeight(String fontWeight) {
        int weight = 400;
        if (fontWeight.equals("100")) {
            weight = 100;
        } else if (fontWeight.equals("200")) {
            weight = 200;
        } else if (fontWeight.equals("300")) {
            weight = 300;
        } else if (fontWeight.equals("400")) {
            weight = 400;
        } else if (fontWeight.equals("500")) {
            weight = 500;
        } else if (fontWeight.equals("600")) {
            weight = 600;
        } else if (fontWeight.equals("700")) {
            weight = 700;
        } else if (fontWeight.equals("800")) {
            weight = 800;
        } else if (fontWeight.equals("900")) {
            weight = 900;
        } else if (fontWeight.equals("normal")) {
            weight = 400;
        } else if (fontWeight.equals("bold")) {
            weight = 700;
        }
        return weight;
    }

    public static int getFontWeight(DesignElementHandle handle) {
        int fontWeight = 400;
        String font = null;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                font = "normal";
                return CSSUtil.getFontWeight(font);
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        StyleHandle styleHandle = handle.getPrivateStyle();
        assert (styleHandle != null);
        font = styleHandle.getFontWeight();
        if (font.equals("lighter")) {
            int parentFontWeight = CSSUtil.getFontWeight(handle.getContainer());
            return CSSUtil.getLighterFontWeight(parentFontWeight);
        }
        if (font.equals("bolder")) {
            String parentFontSize = CSSUtil.getFontSize(handle.getContainer());
            return CSSUtil.getBolderFontWeight(parentFontSize);
        }
        fontWeight = CSSUtil.getFontWeight(font);
        return fontWeight;
    }

    public static int getBolderFontWeight(int curWeight) {
        int weight = curWeight + 100;
        if (weight > 900) {
            weight = 900;
        }
        return weight;
    }

    public static int getBolderFontWeight(String curWeight) {
        int weight = CSSUtil.getFontWeight(curWeight) + 100;
        if (weight > 900) {
            weight = 900;
        }
        return weight;
    }

    public static int getLighterFontWeight(String curWeight) {
        int weight = CSSUtil.getFontWeight(curWeight) - 100;
        if (weight < 100) {
            weight = 100;
        }
        return weight;
    }

    public static int getLighterFontWeight(int curWeight) {
        int weight = curWeight - 100;
        if (weight < 100) {
            weight = 100;
        }
        return weight;
    }

    public static double convertToInch(Object model) {
        return CSSUtil.convertToInch(model, 0);
    }

    public static double convertToInch(Object object, int baseSize) {
        DimensionValue dimension;
        double inchValue = 0.0;
        double measure = 0.0;
        String units = "";
        if (object instanceof DimensionValue) {
            dimension = (DimensionValue)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        } else if (object instanceof DimensionHandle) {
            dimension = (DimensionHandle)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        }
        if ("".equalsIgnoreCase(units)) {
            units = SessionHandleAdapter.getInstance().creatReportDesign().getDefaultUnits();
        }
        if ("in".equals(units)) {
            return measure;
        }
        if (baseSize == 0) {
            Font defaultFont = JFaceResources.getDefaultFont();
            FontData[] fontData = defaultFont.getFontData();
            baseSize = fontData[0].getHeight();
        }
        inchValue = "em".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize), (String)"pt", (String)"in").getMeasure() : ("ex".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize / 3.0), (String)"pt", (String)"in").getMeasure() : ("%".equals(units) ? DimensionUtil.convertTo((double)(measure * (double)baseSize / 100.0), (String)"pt", (String)"in").getMeasure() : ("px".equals(units) ? CSSUtil.pixelToInch(measure) : DimensionUtil.convertTo((double)measure, (String)units, (String)"in").getMeasure())));
        return inchValue;
    }

    public static double convertToPixel(Object object, int baseSize) {
        return CSSUtil.inchToPixel(CSSUtil.convertToInch(object, baseSize));
    }

    public static double convertToPixel(Object object) {
        return CSSUtil.inchToPixel(CSSUtil.convertToInch(object));
    }

    public static double convertToPoint(Object object, int baseSize) {
        return CSSUtil.inchToPoint(CSSUtil.convertToInch(object, baseSize));
    }

    public static double convertToPoint(Object object) {
        return CSSUtil.inchToPoint(CSSUtil.convertToInch(object));
    }

    public static double inchToPoint(double inch) {
        double pt = inch * 72.0;
        return pt;
    }

    public static double inchToPixel(double x) {
        return x * (double)CSSUtil.dpi.x;
    }

    public static Point inchToPixel(double x, double y) {
        int xpixel = (int)CSSUtil.inchToPixel(x);
        int ypixel = (int)CSSUtil.inchToPixel(y);
        return new Point(xpixel, ypixel);
    }

    public static double pixelToInch(double x) {
        return x / (double)CSSUtil.dpi.x;
    }

    public static double pixelToPoint(double p) {
        return CSSUtil.inchToPoint(CSSUtil.pixelToInch(p));
    }

    public static double pointToInch(double point) {
        double inch = point / 72.0;
        return inch;
    }

    public static double pointToPixel(double p) {
        return CSSUtil.inchToPixel(CSSUtil.pointToInch(p));
    }

    public static DimensionValue convertTo(double measure, String fromUnit, String targetUnit) {
        assert (CSSUtil.isAbsoluteUnits(fromUnit));
        if (targetUnit.equalsIgnoreCase(fromUnit)) {
            return new DimensionValue(measure, fromUnit);
        }
        double targetMeasure = 0.0;
        if ("in".equalsIgnoreCase(targetUnit)) {
            if ("cm".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure / 2.54;
            } else if ("mm".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure / 2.54 / 10.0;
            } else if ("pt".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure / 72.0;
            } else if ("pc".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 12.0 / 72.0;
            } else assert (false);
        } else if ("cm".equalsIgnoreCase(targetUnit)) {
            if ("in".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 2.54;
            } else if ("mm".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure / 10.0;
            } else if ("pt".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure / 28.346456692913385;
            } else if ("pc".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 12.0 / 28.346456692913385;
            } else assert (false);
        } else if ("mm".equalsIgnoreCase(targetUnit)) {
            if ("in".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 2.54 * 10.0;
            } else if ("cm".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 10.0;
            } else if ("pt".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 10.0 / 28.346456692913385;
            } else if ("pc".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 12.0 * 10.0 / 28.346456692913385;
            } else assert (false);
        } else if ("pt".equalsIgnoreCase(targetUnit)) {
            if ("in".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 72.0;
            } else if ("cm".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 28.346456692913385;
            } else if ("mm".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 28.346456692913385 / 10.0;
            } else if ("pc".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 12.0;
            } else assert (false);
        } else if ("pc".equalsIgnoreCase(targetUnit)) {
            if ("in".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 72.0 / 12.0;
            } else if ("cm".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 28.346456692913385 / 12.0;
            } else if ("mm".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure * 28.346456692913385 / 10.0 / 12.0;
            } else if ("pt".equalsIgnoreCase(fromUnit)) {
                targetMeasure = measure / 12.0;
            } else assert (false);
        } else assert (false);
        return new DimensionValue(targetMeasure, targetUnit);
    }

    public static DimensionValue convertTo(DimensionValue dim, String defaultUnit, String targetUnits) {
        String fromUnit = dim.getUnits();
        if ("".equalsIgnoreCase(fromUnit)) {
            fromUnit = defaultUnit;
        }
        return CSSUtil.convertTo(dim.getMeasure(), fromUnit, targetUnits);
    }

    public static DimensionValue convertTo(String dimDesp, String defaultUnit, String targetUnits) throws PropertyValueException {
        DimensionValue dim = DimensionValue.parse((String)dimDesp);
        return CSSUtil.convertTo(dim, defaultUnit, targetUnits);
    }

    public static boolean isAbsoluteUnits(String unit) {
        return "in".equalsIgnoreCase(unit) || "cm".equalsIgnoreCase(unit) || "mm".equalsIgnoreCase(unit) || "pt".equalsIgnoreCase(unit) || "pc".equalsIgnoreCase(unit);
    }

    public static boolean isRelativeUnits(String unit) {
        return "em".equalsIgnoreCase(unit) || "ex".equalsIgnoreCase(unit) || "px".equalsIgnoreCase(unit) || "%".equalsIgnoreCase(unit);
    }
}

