/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.designer.core.commands.PasteCommand;
import org.eclipse.birt.report.designer.core.commands.PasteStructureCommand;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.CssSharedStyleHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.util.CopyUtil;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.StructuredSelection;

public final class DNDUtil {
    private static Logger logger = Logger.getLogger(DNDUtil.class.getName());
    public static final String TYPE_CUT = "CUT";
    public static final String TYPE_COPY = "COPY";
    public static final int CONTAIN_NO = 0;
    public static final int CONTAIN_THIS = 1;
    public static final int CONTAIN_PARENT = 2;

    private DNDUtil() {
    }

    public static boolean moveHandles(Object transferData, Object container, int position) {
        return DNDUtil.operateHandles(transferData, container, position, Messages.getString("DNDUtil.trans.cut"), TYPE_CUT);
    }

    public static boolean copyHandles(Object transferData, Object container, int position) {
        if (transferData instanceof Object[] && ((Object[])transferData)[0] instanceof CssSharedStyleHandle) {
            if (container instanceof SlotHandle && ((SlotHandle)container).getElementHandle() instanceof ReportDesignHandle || container instanceof ReportDesignHandle) {
                ReportDesignHandle report = null;
                report = container instanceof ReportDesignHandle ? (ReportDesignHandle)container : (ReportDesignHandle)((SlotHandle)container).getElementHandle();
                return DNDUtil.ImportCssStyle((CssSharedStyleHandle)((Object[])transferData)[0], report);
            }
            if (container instanceof SlotHandle && ((SlotHandle)container).getElementHandle() instanceof ThemeHandle || container instanceof ThemeHandle) {
                ThemeHandle theme = null;
                theme = container instanceof ThemeHandle ? (ThemeHandle)container : (ThemeHandle)((SlotHandle)container).getElementHandle();
                return DNDUtil.ImportCssStyle((CssSharedStyleHandle)((Object[])transferData)[0], theme);
            }
        }
        return DNDUtil.operateHandles(transferData, container, position, Messages.getString("DNDUtil.trans.copy"), TYPE_COPY);
    }

    public static boolean copyHandles(Object transferData, Object targetObj) {
        targetObj = DNDUtil.unwrapToModel(targetObj);
        if (DNDUtil.getColumnHandle(transferData) != null) {
            return DNDUtil.copyColumn(DNDUtil.getColumnHandle(transferData), targetObj, false);
        }
        int canContain = DNDUtil.handleValidateTargetCanContain(targetObj, transferData, true);
        int position = DNDUtil.calculateNextPosition(targetObj, canContain);
        if (position > -1) {
            Object temp = targetObj;
            if ((targetObj = DNDUtil.getDesignElementHandle(targetObj).getContainerSlotHandle()) == null) {
                targetObj = DNDUtil.getDesignElementHandle(temp).getContainer();
            }
        }
        return DNDUtil.copyHandles(transferData, targetObj, position);
    }

    public static boolean insertPasteColumn(Object transferData, Object targetObj) {
        if (DNDUtil.getColumnHandle(transferData) != null) {
            return DNDUtil.copyColumn(DNDUtil.getColumnHandle(transferData), targetObj, true);
        }
        return false;
    }

    private static ColumnBandData getColumnHandle(Object transferData) {
        if (transferData instanceof ColumnBandData) {
            return (ColumnBandData)transferData;
        }
        if (transferData instanceof Object[] && ((Object[])transferData).length == 1) {
            return DNDUtil.getColumnHandle(((Object[])transferData)[0]);
        }
        return null;
    }

    private static boolean copyColumn(ColumnBandData transferData, Object targetObj, boolean isNew) {
        try {
            int columnNumber = HandleAdapterFactory.getInstance().getColumnHandleAdapter(targetObj).getColumnNumber();
            DesignElementHandle parent = ((ColumnHandle)targetObj).getContainer();
            if (parent instanceof TableHandle) {
                if (isNew) {
                    ((TableHandle)parent).insertAndPasteColumn(transferData.copy(), columnNumber);
                } else {
                    ((TableHandle)parent).pasteColumn(transferData.copy(), columnNumber, true);
                }
            } else if (parent instanceof GridHandle) {
                if (isNew) {
                    ((GridHandle)parent).insertAndPasteColumn(transferData.copy(), columnNumber);
                } else {
                    ((GridHandle)parent).pasteColumn(transferData.copy(), columnNumber, true);
                }
            }
        }
        catch (SemanticException semanticException) {
            return false;
        }
        return true;
    }

    private static boolean operateHandles(Object transferData, Object targetObj, int position, String commandName, String commandType) {
        ModuleHandle designHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        CommandStack stack = designHandle.getCommandStack();
        try {
            stack.startTrans(commandName);
            CompoundCommand commands = new CompoundCommand();
            if (transferData instanceof StructuredSelection) {
                transferData = ((StructuredSelection)transferData).toArray();
            }
            DNDUtil.addCommandToCompound(transferData, targetObj, position, commandName, commandType, commands);
            commands.execute();
            stack.commit();
        }
        catch (Exception exception) {
            stack.rollbackAll();
            return false;
        }
        return true;
    }

    private static void addCommandToCompound(Object transferData, Object targetObj, int position, String commandName, String commandType, CompoundCommand commands) throws SemanticException {
        if (transferData instanceof SlotHandle) {
            transferData = DNDUtil.transferSlotHandle(commandType, transferData);
        }
        if (transferData instanceof Object[]) {
            Object[] array = (Object[])transferData;
            int i = 0;
            while (i < array.length) {
                if (array[i] instanceof EmbeddedImageHandle && ((EmbeddedImageHandle)array[i]).getElementHandle().getRoot() instanceof LibraryHandle) {
                    try {
                        array[i] = StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)((EmbeddedImageHandle)array[i]), (ModuleHandle)SessionHandleAdapter.getInstance().getReportDesignHandle());
                    }
                    catch (LibraryException libraryException) {}
                }
                DNDUtil.addCommandToCompound(array[i], targetObj, position, commandName, commandType, commands);
                if (position > -1) {
                    ++position;
                }
                ++i;
            }
        } else if (transferData instanceof DesignElementHandle || transferData instanceof IDesignElement || transferData instanceof IElementCopy) {
            if (transferData instanceof DesignElementHandle && targetObj instanceof SlotHandle && ((DesignElementHandle)transferData).getContainerSlotHandle() == targetObj) {
                ((DesignElementHandle)transferData).moveTo(position);
            } else if (targetObj instanceof DesignElementHandle || targetObj instanceof SlotHandle || targetObj instanceof PropertyHandle) {
                commands.add(DNDUtil.getNewCommand(commandType, transferData, targetObj, position));
            }
        } else if (transferData instanceof IStructure) {
            commands.add((Command)new PasteStructureCommand((IStructure)transferData, targetObj));
        } else if (transferData instanceof StructureHandle) {
            commands.add((Command)new PasteStructureCommand(((StructureHandle)transferData).getStructure(), targetObj));
        }
    }

    private static Command getNewCommand(String commandType, Object transferSource, Object newContainer, int position) throws SemanticException {
        boolean isCut = TYPE_CUT.equals(commandType);
        if (newContainer instanceof ParameterGroupHandle && (transferSource instanceof ParameterGroupHandle || DEUtil.isParameterGroup(transferSource))) {
            return DNDUtil.pasteParameterGroup(commandType, transferSource, (ParameterGroupHandle)newContainer);
        }
        if (transferSource instanceof DesignElementHandle) {
            return new PasteCommand((DesignElementHandle)transferSource, newContainer, position, isCut);
        }
        if (transferSource instanceof IDesignElement) {
            return new PasteCommand((IDesignElement)transferSource, newContainer, position);
        }
        if (transferSource instanceof IElementCopy) {
            return new PasteCommand((IElementCopy)transferSource, newContainer, position);
        }
        return null;
    }

    private static Command pasteParameterGroup(String commandType, Object childGroup, ParameterGroupHandle targetGroup) throws SemanticException {
        CompoundCommand commands = new CompoundCommand();
        ParameterGroupHandle childHandle = null;
        if (childGroup instanceof ParameterGroupHandle) {
            childHandle = (ParameterGroupHandle)childGroup;
        } else if (DEUtil.isParameterGroup(childGroup)) {
            childHandle = (ParameterGroupHandle)((IDesignElement)childGroup).getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle().getModule());
        }
        if (childHandle != null) {
            SlotHandle transferSlot = childHandle.getParameters();
            Iterator i = transferSlot.iterator();
            while (i.hasNext()) {
                commands.add(DNDUtil.getNewCommand(commandType, i.next(), targetGroup, -1));
            }
        }
        if (commandType.equals(TYPE_CUT)) {
            childHandle.drop();
        }
        return commands;
    }

    private static Object transferSlotHandle(String commandType, Object handle) {
        Object cloneObj = DNDUtil.cloneSource(handle);
        if (TYPE_CUT.equals(commandType)) {
            DNDUtil.dropSource(handle);
        }
        return cloneObj;
    }

    public static boolean handleValidateDragInOutline(Object selection) {
        if (selection instanceof StructuredSelection) {
            return DNDUtil.handleValidateDragInOutline(((StructuredSelection)selection).toArray());
        }
        if (selection instanceof Object[]) {
            Object[] array = (Object[])selection;
            if (array.length == 0) {
                return false;
            }
            if (array[0] instanceof ColumnHandle && ((ColumnHandle)array[0]).getRoot() != null) {
                boolean bool = false;
                int columnNumber = HandleAdapterFactory.getInstance().getColumnHandleAdapter(array[0]).getColumnNumber();
                DesignElementHandle parent = ((ColumnHandle)array[0]).getContainer();
                if (parent instanceof TableHandle) {
                    bool = ((TableHandle)parent).canCopyColumn(columnNumber);
                } else if (parent instanceof GridHandle) {
                    bool = ((GridHandle)parent).canCopyColumn(columnNumber);
                }
                if (bool && array.length == 1) {
                    return true;
                }
                return bool && array[1] instanceof CellHandle;
            }
            int i = 0;
            while (i < array.length) {
                if (!DNDUtil.checkContainerExists(array[i], array) && !DNDUtil.handleValidateDragInOutline(array[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (selection instanceof SlotHandle) {
            SlotHandle slot = (SlotHandle)selection;
            DesignElementHandle handle = slot.getElementHandle();
            return slot.getContents().size() > 0 && (handle instanceof ListHandle || handle instanceof ListGroupHandle);
        }
        if (selection instanceof ColumnHandle && ((ColumnHandle)selection).getRoot() != null) {
            int columnNumber = HandleAdapterFactory.getInstance().getColumnHandleAdapter(selection).getColumnNumber();
            DesignElementHandle parent = ((ColumnHandle)selection).getContainer();
            if (parent instanceof TableHandle) {
                return ((TableHandle)parent).canCopyColumn(columnNumber);
            }
            if (parent instanceof GridHandle) {
                return ((GridHandle)parent).canCopyColumn(columnNumber);
            }
        }
        return selection instanceof ReportItemHandle || selection instanceof DataSetHandle || selection instanceof DataSourceHandle || selection instanceof ScalarParameterHandle || selection instanceof ParameterGroupHandle || selection instanceof GroupHandle || selection instanceof StyleHandle || selection instanceof ThemeHandle || selection instanceof EmbeddedImageHandle || selection instanceof TemplateElementHandle || selection instanceof DataSetItemModel || selection instanceof ResultSetColumnHandle || selection instanceof CubeHandle;
    }

    public static Object cloneSource(Object source) {
        if ((source = DNDUtil.unwrapToModel(source)) instanceof Object[]) {
            Object[] array = (Object[])source;
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < array.length) {
                if (array[i] instanceof ColumnHandle) {
                    list.add(DNDUtil.cloneSource(array[i]));
                }
                ++i;
            }
            if (!list.isEmpty()) {
                return list.toArray();
            }
            i = 0;
            while (i < array.length) {
                if (!DNDUtil.checkContainerExists(array[i], array)) {
                    list.add(DNDUtil.cloneSource(array[i]));
                }
                ++i;
            }
            return list.toArray();
        }
        if (source instanceof StructuredSelection) {
            return DNDUtil.cloneSource(((StructuredSelection)source).toArray());
        }
        if (source instanceof ColumnHandle) {
            try {
                int columnNumber = HandleAdapterFactory.getInstance().getColumnHandleAdapter(source).getColumnNumber();
                DesignElementHandle parent = ((ColumnHandle)source).getContainer();
                if (parent instanceof TableHandle) {
                    return ((TableHandle)parent).copyColumn(columnNumber);
                }
                if (parent instanceof GridHandle) {
                    return ((GridHandle)parent).copyColumn(columnNumber);
                }
            }
            catch (SemanticException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return null;
        }
        if (source instanceof DesignElementHandle) {
            IElementCopy copyElement = CopyUtil.copy((DesignElementHandle)((DesignElementHandle)source));
            return copyElement;
        }
        if (source instanceof IDesignElement) {
            try {
                return ((IDesignElement)source).clone();
            }
            catch (CloneNotSupportedException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (source instanceof SlotHandle) {
            SlotHandle slot = (SlotHandle)source;
            Object[] array = new Object[slot.getCount()];
            int i = 0;
            while (i < array.length) {
                array[i] = slot.get(i);
                ++i;
            }
            return DNDUtil.cloneSource(array);
        }
        if (source instanceof StructureHandle) {
            return ((StructureHandle)source).getStructure().copy();
        }
        return null;
    }

    public static void dropSource(Object source) {
        DeleteCommand command = new DeleteCommand(source);
        if (command.canExecute()) {
            command.execute();
        }
    }

    public static DesignElementHandle getDesignElementHandle(Object target) {
        if ((target = DNDUtil.unwrapToModel(target)) instanceof DesignElementHandle) {
            return (DesignElementHandle)target;
        }
        if (target instanceof SlotHandle) {
            return ((SlotHandle)target).getElementHandle();
        }
        return null;
    }

    public static Object unwrapToModel(Object obj) {
        if (obj instanceof ListBandProxy) {
            return ((ListBandProxy)obj).getSlotHandle();
        }
        if (obj instanceof IAdaptable) {
            return ((IAdaptable)obj).getAdapter(DesignElementHandle.class);
        }
        return obj;
    }

    public static int getObjectLength(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof StructuredSelection) {
            return DNDUtil.getObjectLength(((StructuredSelection)obj).toArray());
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj).length;
        }
        return 1;
    }

    public static boolean checkContainerExists(Object content, Object[] handles) {
        content = DNDUtil.unwrapToModel(content);
        DesignElementHandle child = null;
        if (content instanceof SlotHandle) {
            child = ((SlotHandle)content).getElementHandle();
        } else if (content instanceof DesignElementHandle) {
            child = (DesignElementHandle)content;
        }
        if (child != null) {
            int i = 0;
            while (i < handles.length) {
                if (content != handles[i]) {
                    if (child == handles[i]) {
                        return true;
                    }
                    if (handles[i] instanceof DesignElementHandle) {
                        if (child instanceof CellHandle && handles[i] instanceof ColumnHandle) {
                            if (DNDUtil.isInSameColumn(new Object[]{child, handles[i]})) {
                                return true;
                            }
                        } else {
                            DesignElementHandle container = child.getContainer();
                            while (container != null) {
                                if (container.equals(handles[i])) {
                                    return true;
                                }
                                container = container.getContainer();
                            }
                        }
                    } else if (handles[i] instanceof SlotHandle && child.getContainerSlotHandle() == handles[i]) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static int calculateNextPosition(Object targetObj, int canContain) {
        DesignElementHandle afterHandle;
        int position = -1;
        if (canContain == 2 && (afterHandle = DNDUtil.getDesignElementHandle(targetObj)) != null) {
            position = afterHandle.getIndex();
            ++position;
        }
        return position;
    }

    public static void addElementHandle(Object container, DesignElementHandle handle) throws SemanticException {
        assert (container != null);
        if (handle == null) {
            return;
        }
        if ((container = DNDUtil.unwrapToModel(container)) instanceof DesignElementHandle) {
            ((DesignElementHandle)container).addElement(handle, DEUtil.getDefaultSlotID(container));
        } else if (container instanceof SlotHandle) {
            ((SlotHandle)container).add(handle);
        }
    }

    public static void addEmbeddedImageHandle(Object container, EmbeddedImage image) throws SemanticException {
        if (container instanceof EmbeddedImageNode) {
            container = ((EmbeddedImageNode)container).getReportDesignHandle();
        }
        try {
            ((ModuleHandle)container).rename(image);
            ((ModuleHandle)container).addImage(image);
        }
        catch (SemanticException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static boolean handleValidateTargetCanContain(Object targetObj, Object transferData) {
        return DNDUtil.handleValidateTargetCanContain(targetObj, transferData, true) != 0;
    }

    public static int handleValidateTargetCanContain(Object targetObj, Object transferData, boolean validateContainer) {
        if (targetObj == null || transferData == null) {
            return 0;
        }
        if (transferData instanceof StructuredSelection) {
            return DNDUtil.handleValidateTargetCanContain(targetObj, ((StructuredSelection)transferData).toArray(), validateContainer);
        }
        if (transferData instanceof Object[]) {
            Object[] array = (Object[])transferData;
            if (array.length == 1) {
                return DNDUtil.handleValidateTargetCanContain(targetObj, array[0], validateContainer);
            }
            int canContainAll = 0;
            int i = 0;
            while (i < array.length) {
                int canContain = DNDUtil.handleValidateTargetCanContain(targetObj, array[i], validateContainer);
                if (i == 0) {
                    canContainAll = canContain;
                }
                if (canContain == 0 || canContain != canContainAll) {
                    return 0;
                }
                ++i;
            }
            return canContainAll;
        }
        if (transferData instanceof DesignElementHandle) {
            return DNDUtil.handleValidateTargetCanContainByContainer(targetObj, (DesignElementHandle)transferData, validateContainer);
        }
        if (transferData instanceof ColumnBandData) {
            if (targetObj instanceof ColumnHandle) {
                return DNDUtil.handleValidateContainColumnPaste((ColumnHandle)targetObj, (ColumnBandData)transferData, false) ? 2 : 0;
            }
            return 0;
        }
        if (transferData instanceof IDesignElement) {
            DesignElementHandle childHandle = ((IDesignElement)transferData).getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle().getModule());
            return DNDUtil.handleValidateTargetCanContainByContainer(targetObj, childHandle, validateContainer);
        }
        if (transferData instanceof IElementCopy) {
            DesignElementHandle childHandle = ((IElementCopy)transferData).getHandle(SessionHandleAdapter.getInstance().getReportDesignHandle());
            return DNDUtil.handleValidateTargetCanContainByContainer(targetObj, childHandle, validateContainer);
        }
        if (transferData instanceof SlotHandle) {
            SlotHandle slot = (SlotHandle)transferData;
            Object[] childHandles = slot.getContents().toArray();
            return DNDUtil.handleValidateTargetCanContainByContainer(targetObj, childHandles, validateContainer);
        }
        if (transferData instanceof IStructure) {
            return DNDUtil.handleValidateTargetCanContainStructure(targetObj, (IStructure)transferData) ? 1 : 0;
        }
        if (transferData instanceof EmbeddedImageHandle) {
            if (targetObj instanceof ReportDesignHandle && ((EmbeddedImageHandle)transferData).getElementHandle().getRoot() instanceof LibraryHandle) {
                return 1;
            }
            if (targetObj instanceof EmbeddedImageNode) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static boolean handleValidateTargetCanContainStructure(Object targetObj, IStructure transferData) {
        if (targetObj instanceof EmbeddedImageNode) {
            targetObj = ((EmbeddedImageNode)targetObj).getReportDesignHandle();
        }
        return transferData instanceof EmbeddedImage && targetObj instanceof ModuleHandle;
    }

    public static boolean handleValidateContainColumnPaste(ColumnHandle targetObj, ColumnBandData transferData, boolean isNew) {
        int columnNumber = HandleAdapterFactory.getInstance().getColumnHandleAdapter(targetObj).getColumnNumber();
        DesignElementHandle parent = targetObj.getContainer();
        if (parent instanceof TableHandle) {
            if (isNew) {
                return ((TableHandle)parent).canInsertAndPasteColumn(transferData, columnNumber);
            }
            return ((TableHandle)parent).canPasteColumn(transferData, columnNumber, true);
        }
        if (parent instanceof GridHandle) {
            if (isNew) {
                return ((GridHandle)parent).canInsertAndPasteColumn(transferData, columnNumber);
            }
            return ((GridHandle)parent).canPasteColumn(transferData, columnNumber, true);
        }
        return false;
    }

    static int handleValidateTargetCanContainByContainer(Object targetObj, DesignElementHandle childHandle, boolean validateContainer) {
        if ((targetObj = DNDUtil.unwrapToModel(targetObj)) instanceof DesignElementHandle) {
            return DNDUtil.handleValidateTargetCanContainElementHandle((DesignElementHandle)targetObj, childHandle, validateContainer);
        }
        if (targetObj instanceof SlotHandle) {
            SlotHandle targetHandle = (SlotHandle)targetObj;
            if (childHandle.getModuleHandle() instanceof LibraryHandle && !childHandle.getElement().getDefn().canExtend() && childHandle.getModuleHandle() != targetHandle.getModule().getModuleHandle()) {
                return 0;
            }
            return targetHandle.getElementHandle().canContain(targetHandle.getSlotID(), childHandle) ? 1 : 0;
        }
        return 0;
    }

    static int handleValidateTargetCanContainByContainer(Object targetObj, Object[] childHandles, boolean validateContainer) {
        if (childHandles.length == 0) {
            return 0;
        }
        int i = 0;
        while (i < childHandles.length) {
            if (!(childHandles[i] instanceof DesignElementHandle) || DNDUtil.handleValidateTargetCanContainByContainer(targetObj, (DesignElementHandle)childHandles[i], validateContainer) == 0) {
                return 0;
            }
            ++i;
        }
        return 1;
    }

    static int handleValidateTargetCanContainElementHandle(DesignElementHandle targetHandle, DesignElementHandle childHandle, boolean validateContainer) {
        if (targetHandle instanceof CascadingParameterGroupHandle) {
            return childHandle.getContainer() == targetHandle ? 1 : 0;
        }
        if (targetHandle.canContain(DEUtil.getDefaultSlotID(targetHandle), childHandle)) {
            return 1;
        }
        if (targetHandle != childHandle && targetHandle instanceof ParameterGroupHandle && childHandle instanceof ParameterGroupHandle) {
            return 1;
        }
        if (targetHandle instanceof ReportDesignHandle && childHandle instanceof ThemeHandle) {
            return 1;
        }
        if (targetHandle.canContain(DEUtil.getDefaultContentName(targetHandle), childHandle)) {
            return 1;
        }
        if (validateContainer) {
            if (targetHandle.getContainer() == null) {
                return 0;
            }
            if (targetHandle.getContainerSlotHandle() == null ? !targetHandle.getContainerPropertyHandle().getDefn().isList() : !targetHandle.getContainer().getDefn().getSlot(targetHandle.getContainerSlotHandle().getSlotID()).isMultipleCardinality()) {
                return 0;
            }
            if (targetHandle.getClass().equals(childHandle.getClass())) {
                if (childHandle instanceof LevelHandle) {
                    return 0;
                }
                return 2;
            }
            if (targetHandle.getContainerSlotHandle() != null) {
                return targetHandle.getContainer().canContain(targetHandle.getContainerSlotHandle().getSlotID(), childHandle) ? 2 : 0;
            }
            if (targetHandle.getContainerPropertyHandle() != null) {
                return targetHandle.getContainer().canContain(targetHandle.getContainerPropertyHandle().getPropertyDefn().getName(), childHandle) ? 2 : 0;
            }
        }
        return 0;
    }

    public static boolean handleValidateTargetCanContainMore(Object targetObj, int length) {
        if (targetObj == null || length < 0) {
            return false;
        }
        if (targetObj instanceof StructuredSelection) {
            return DNDUtil.handleValidateTargetCanContainMore(((StructuredSelection)targetObj).toArray(), length);
        }
        if (targetObj instanceof Object[]) {
            Object[] array = (Object[])targetObj;
            int i = 0;
            while (i < array.length) {
                if (!DNDUtil.handleValidateTargetCanContainMore(array[i], length)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if ((targetObj = DNDUtil.unwrapToModel(targetObj)) instanceof SlotHandle) {
            SlotHandle slot = (SlotHandle)targetObj;
            return slot.getElementHandle().getDefn().getSlot(slot.getSlotID()).isMultipleCardinality() || slot.getCount() < 1 && length <= 1;
        }
        return targetObj instanceof DesignElementHandle || targetObj instanceof EmbeddedImageNode;
    }

    public static boolean handleValidateTargetCanContainType(Object targetObj, String dragObjType) {
        DesignElementHandle targetHandle = null;
        int slotId = 0;
        if ((targetObj = DNDUtil.unwrapToModel(targetObj)) instanceof DesignElementHandle) {
            targetHandle = (DesignElementHandle)targetObj;
            slotId = DEUtil.getDefaultSlotID(targetObj);
        } else if (targetObj instanceof SlotHandle) {
            targetHandle = ((SlotHandle)targetObj).getElementHandle();
            slotId = ((SlotHandle)targetObj).getSlotID();
        } else {
            return false;
        }
        if (slotId == -1) {
            return targetHandle.canContain(DEUtil.getDefaultContentName(targetObj), dragObjType);
        }
        return targetHandle.canContain(slotId, dragObjType);
    }

    public static boolean isInSameColumn(Object[] objs) {
        assert (objs != null && objs.length > 1);
        final class ColumnPosition {
            int columnNumber;
            Object parent;

            ColumnPosition(Object obj) {
                if (obj instanceof ColumnHandle) {
                    ColumnHandleAdapter columnAdapter = HandleAdapterFactory.getInstance().getColumnHandleAdapter(obj);
                    this.columnNumber = columnAdapter.getColumnNumber();
                    this.parent = columnAdapter.getTableParent();
                } else if (obj instanceof CellHandle) {
                    CellHandleAdapter cellAdapter = HandleAdapterFactory.getInstance().getCellHandleAdapter(obj);
                    this.columnNumber = cellAdapter.getColumnNumber();
                    this.parent = cellAdapter.getTableParent();
                }
            }
        }
        ColumnPosition position = null;
        int i = 0;
        while (i < objs.length) {
            ColumnPosition newPosi = new ColumnPosition(objs[i]);
            if (position == null) {
                position = newPosi;
            } else if (position.columnNumber != newPosi.columnNumber || position.parent != newPosi.parent) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean ImportCssStyle(CssSharedStyleHandle css, ReportDesignHandle report) {
        CssStyleSheetHandle cssStyleSheet = css.getCssStyleSheetHandle();
        ArrayList<CssSharedStyleHandle> styleList = new ArrayList<CssSharedStyleHandle>();
        styleList.add(css);
        report.importCssStyles(cssStyleSheet, styleList);
        return true;
    }

    protected static boolean ImportCssStyle(CssSharedStyleHandle css, ThemeHandle theme) {
        CssStyleSheetHandle cssStyleSheet = css.getCssStyleSheetHandle();
        ArrayList<CssSharedStyleHandle> styleList = new ArrayList<CssSharedStyleHandle>();
        styleList.add(css);
        LibraryHandle library = (LibraryHandle)theme.getRoot();
        library.importCssStyles(cssStyleSheet, styleList, theme.getName());
        return true;
    }
}

