/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import com.ibm.icu.util.Currency;
import java.util.Locale;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatNumberPattern;

public class FormatCurrencyNumPattern
extends FormatNumberPattern {
    private int decPlaces = 0;
    private boolean useSep = false;
    private boolean useSpace = false;
    private boolean useBracket = false;
    private String symbol = "";
    private String symPos = "";
    private static String[] symbols = new String[]{Messages.getString("FormatNumberPage.currency.symbol.none"), Currency.getInstance((Locale)Locale.getDefault()).getSymbol(), "\u00a5", "$", "\u20ac", "\u00a3", "\u20a9", "DKK"};

    public FormatCurrencyNumPattern(String category) {
        super(category);
        this.setType('C');
    }

    public String getPattern() {
        String numStr = "###0";
        String decStr = "";
        String positivePatt = numStr;
        String negativePatt = null;
        if (this.useSep) {
            positivePatt = "#,##0";
        }
        if ((decStr = DEUtil.getDecmalStr(this.decPlaces)) != "") {
            positivePatt = String.valueOf(positivePatt) + "." + decStr;
        }
        if (this.useBracket) {
            negativePatt = "(" + positivePatt + ")";
        }
        if (this.symbol.length() != 0 && !this.symbol.equalsIgnoreCase(FormatNumberPattern.TEXT_CURRENCY_SYMBOL_NONE)) {
            if (this.symPos.equalsIgnoreCase(FormatNumberPattern.SYMBOL_POSITION_BEFORE)) {
                positivePatt = String.valueOf(this.symbol) + (this.getUseSpace() ? " " : "") + positivePatt;
                if (negativePatt != null) {
                    negativePatt = String.valueOf(this.symbol) + (this.getUseSpace() ? " " : "") + negativePatt;
                }
            } else if (this.symPos.equalsIgnoreCase(FormatNumberPattern.SYMBOL_POSITION_AFTER)) {
                positivePatt = String.valueOf(positivePatt) + (this.getUseSpace() ? " " : "") + this.symbol;
                if (negativePatt != null) {
                    negativePatt = String.valueOf(negativePatt) + (this.getUseSpace() ? " " : "") + this.symbol;
                }
            }
        }
        String pattern = negativePatt != null ? String.valueOf(positivePatt) + ";" + negativePatt : positivePatt;
        return pattern;
    }

    public void setPattern(String patternStr) {
        String patt = this.valPattern(patternStr);
        this.useSep = patt.indexOf(",") != -1;
        this.useSpace = patt.indexOf(" ") != -1;
        boolean bl = this.useBracket = patt.indexOf("(") != -1 && patt.indexOf(")") != -1;
        if (patt.indexOf(".") != -1) {
            this.decPlaces = patt.lastIndexOf("0") - patt.lastIndexOf(".");
        }
        int i = 0;
        while (i < symbols.length) {
            String sTemp = symbols[i];
            int sPos = patt.indexOf(sTemp);
            if (sPos != -1) {
                this.symbol = sTemp;
                if (sPos == 0) {
                    this.symPos = FormatNumberPattern.SYMBOL_POSITION_BEFORE;
                    break;
                }
                this.symPos = FormatNumberPattern.SYMBOL_POSITION_AFTER;
                break;
            }
            ++i;
        }
    }

    protected String getDefaultPatt() {
        return this.DEFAULT_CURRENCY_PATTERN;
    }

    public int getDecPlaces() {
        return this.decPlaces;
    }

    public void setDecPlaces(int decPlaces) {
        this.decPlaces = decPlaces;
    }

    public boolean getUseSep() {
        return this.useSep;
    }

    public void setUseSep(boolean useSep) {
        this.useSep = useSep;
    }

    public boolean getUseBracket() {
        return this.useBracket;
    }

    public void setUseBracket(boolean useBracket) {
        this.useBracket = useBracket;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymPos() {
        return this.symPos;
    }

    public void setSymPos(String symPos) {
        this.symPos = symPos;
    }

    public boolean getUseSpace() {
        return this.useSpace;
    }

    public void setUseSpace(boolean useSpace) {
        this.useSpace = useSpace;
    }
}

