/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ImageManager {
    private static final String EMBEDDED_SUFFIX = ".Embedded.";
    private static final ImageManager instance = new ImageManager();
    private List invalidUrlList = new ArrayList();
    private String resourcesRootPath = "";

    private ImageManager() {
    }

    public static ImageManager getInstance() {
        return instance;
    }

    public Image getImage(ModuleHandle handle, String uri) {
        return this.getImage(handle, uri, false);
    }

    public Image getImage(ModuleHandle handle, String uri, boolean refresh) {
        Image image;
        block2: {
            image = null;
            URL url = null;
            try {
                url = this.generateURL(handle, uri);
                image = this.getImageFromURL(url, refresh);
            }
            catch (Exception exception) {
                if (url == null || this.invalidUrlList.contains(url.toString())) break block2;
                this.invalidUrlList.add(url.toString());
            }
        }
        return image;
    }

    private Image getImageFromURL(URL url, boolean refresh) throws IOException {
        if (url == null) {
            return null;
        }
        if (!refresh && this.invalidUrlList.contains(url.toString())) {
            return null;
        }
        String key = url.toString();
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            image = this.loadImage(url);
        }
        if (image == null) {
            if (!this.invalidUrlList.contains(url.toString())) {
                this.invalidUrlList.add(url.toString());
            }
        } else {
            this.invalidUrlList.remove(url.toString());
        }
        return image;
    }

    public Image getImage(String uri, boolean refresh) {
        return this.getImage(null, uri, refresh);
    }

    public Image getImage(String uri) {
        return this.getImage(null, uri, false);
    }

    public Image getEmbeddedImage(ModuleHandle handle, String name) {
        Image image;
        String key;
        block22: {
            key = this.generateKey(handle, name);
            EmbeddedImage embeddedImage = handle.findImage(name);
            if (embeddedImage == null) {
                this.removeCachedImage(key);
                return null;
            }
            image = this.getImageRegistry().get(key);
            if (image != null) {
                return image;
            }
            InputStream in = null;
            try {
                try {
                    if (key.toLowerCase().endsWith(".svg")) {
                        JPEGTranscoder transcoder = new JPEGTranscoder();
                        transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
                        TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(embeddedImage.getData(handle.getModule())));
                        input.setURI(this.generateURL(handle, handle.getFileName()).toString());
                        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                        try {
                            transcoder.transcode(input, output);
                        }
                        catch (TranscoderException transcoderException) {}
                        ostream.flush();
                        in = new ByteArrayInputStream(ostream.toByteArray());
                    } else {
                        in = new ByteArrayInputStream(embeddedImage.getData(handle.getModule()));
                    }
                    image = new Image(null, in);
                }
                catch (Exception exception) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (image != null) {
            this.getImageRegistry().put(key, image);
            if (DesignerConstants.TRACING_IMAGE_MANAGER_IMAGE_ADD) {
                System.out.println("Image Manager >> " + key + " added");
            }
        }
        return image;
    }

    public void removeCachedImage(String key) {
        this.getImageRegistry().remove(key);
        if (DesignerConstants.TRACING_IMAGE_MANAGER_IMAGE_REMOVE) {
            System.out.println("Image Manager >> " + key + " removed");
        }
    }

    public Image loadImage(ModuleHandle designHandle, String uri) throws IOException {
        URL url = this.generateURL(designHandle, uri);
        if (url == null) {
            throw new FileNotFoundException(uri);
        }
        return this.loadImage(url);
    }

    public Image loadImage(String uri) throws IOException {
        return this.loadImage(null, uri);
    }

    public Image loadImage(URL url) throws IOException {
        String key = url.toString();
        Image image = this.getImageRegistry().get(key);
        if (image != null) {
            return image;
        }
        InputStream in = null;
        try {
            if (url.toString().toLowerCase().endsWith(".svg")) {
                JPEGTranscoder transcoder = new JPEGTranscoder();
                transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
                String svgURI = url.toString();
                TranscoderInput input = new TranscoderInput(svgURI);
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                try {
                    transcoder.transcode(input, output);
                }
                catch (TranscoderException transcoderException) {}
                ostream.flush();
                in = new ByteArrayInputStream(ostream.toByteArray());
            } else {
                in = url.openStream();
            }
            image = new Image(null, in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (image != null) {
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    private ImageRegistry getImageRegistry() {
        return CorePlugin.getDefault().getImageRegistry();
    }

    private URL generateURL(ModuleHandle designHandle, String uri) throws MalformedURLException {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            String path = URIUtil.getLocalPath((String)uri);
            if (designHandle == null) {
                designHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
            }
            if (path != null && designHandle != null) {
                return designHandle.findResource(path, 1);
            }
            return URI.create(uri).toURL();
        }
    }

    public String generateKey(ModuleHandle reportDesignHandle, String name) {
        return String.valueOf(reportDesignHandle.hashCode()) + EMBEDDED_SUFFIX + name;
    }

    public Image getURIImage(ModuleHandle moduleHandel, String uri) {
        Image image;
        block8: {
            URL url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException malformedURLException) {
                String path = URIUtil.getLocalPath((String)uri);
                try {
                    url = URI.create(uri).toURL();
                }
                catch (Exception exception) {
                    path = URIUtil.resolveAbsolutePath((String)this.resourcesRootPath, (String)uri);
                    try {
                        url = new File(path).toURI().toURL();
                    }
                    catch (Exception exception2) {}
                }
            }
            image = null;
            try {
                image = this.getImageFromURL(url, false);
            }
            catch (Exception exception) {
                if (url == null || this.invalidUrlList.contains(url.toString())) break block8;
                this.invalidUrlList.add(url.toString());
            }
        }
        return image;
    }

    public void setURIRootPath(String rootPath) {
        this.resourcesRootPath = rootPath;
    }
}

