/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.CollectionAttributeNodeIterator;
import org.apache.commons.jxpath.ri.model.beans.CollectionChildNodeIterator;
import org.apache.commons.jxpath.util.ValueUtils;

public class CollectionPointer
extends NodePointer {
    private Object collection;
    private NodePointer valuePointer;

    public CollectionPointer(Object collection, Locale locale) {
        super(null, locale);
        this.collection = collection;
    }

    public CollectionPointer(NodePointer parent, Object collection) {
        super(parent);
        this.collection = collection;
    }

    public QName getName() {
        return null;
    }

    public Object getBaseValue() {
        return this.collection;
    }

    public boolean isCollection() {
        return true;
    }

    public int getLength() {
        return ValueUtils.getLength(this.getBaseValue());
    }

    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public boolean isContainer() {
        return this.index != Integer.MIN_VALUE;
    }

    public Object getImmediateNode() {
        if (this.index != Integer.MIN_VALUE) {
            return ValueUtils.getValue(this.collection, this.index);
        }
        return ValueUtils.getValue(this.collection);
    }

    public void setValue(Object value) {
        if (this.index == Integer.MIN_VALUE) {
            this.parent.setValue(value);
        } else {
            ValueUtils.setValue(this.collection, this.index, value);
        }
    }

    public void setIndex(int index) {
        super.setIndex(index);
        this.valuePointer = null;
    }

    public NodePointer getValuePointer() {
        if (this.valuePointer == null) {
            if (this.index == Integer.MIN_VALUE) {
                this.valuePointer = this;
            } else {
                Object value = this.getImmediateNode();
                this.valuePointer = NodePointer.newChildNodePointer(this, this.getName(), value);
            }
        }
        return this.valuePointer;
    }

    public NodePointer createPath(JXPathContext context) {
        Object collection = this.getBaseValue();
        if (ValueUtils.getLength(collection) <= this.index) {
            collection = ValueUtils.expandCollection(this.getNode(), this.index + 1);
        }
        return this;
    }

    public NodePointer createPath(JXPathContext context, Object value) {
        NodePointer ptr = this.createPath(context);
        ptr.setValue(value);
        return ptr;
    }

    public NodePointer createChild(JXPathContext context, QName name, int index, Object value) {
        NodePointer ptr = (NodePointer)this.clone();
        ptr.setIndex(index);
        return ptr.createPath(context, value);
    }

    public NodePointer createChild(JXPathContext context, QName name, int index) {
        NodePointer ptr = (NodePointer)this.clone();
        ptr.setIndex(index);
        return ptr.createPath(context);
    }

    public int hashCode() {
        return System.identityHashCode(this.collection) + this.index;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CollectionPointer)) {
            return false;
        }
        CollectionPointer other = (CollectionPointer)object;
        return this.collection == other.collection && this.index == other.index;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        if (this.index == Integer.MIN_VALUE) {
            return new CollectionChildNodeIterator(this, test, reverse, startWith);
        }
        return this.getValuePointer().childIterator(test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName name) {
        if (this.index == Integer.MIN_VALUE) {
            return new CollectionAttributeNodeIterator(this, name);
        }
        return this.getValuePointer().attributeIterator(name);
    }

    public NodeIterator namespaceIterator() {
        if (this.index == Integer.MIN_VALUE) {
            return null;
        }
        return this.getValuePointer().namespaceIterator();
    }

    public NodePointer namespacePointer(String namespace) {
        if (this.index == Integer.MIN_VALUE) {
            return null;
        }
        return this.getValuePointer().namespacePointer(namespace);
    }

    public boolean testNode(NodeTest nodeTest) {
        return this.getValuePointer().testNode(nodeTest);
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return pointer1.getIndex() - pointer2.getIndex();
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        NodePointer parent = this.getImmediateParentPointer();
        if (parent != null) {
            buffer.append(parent.asPath());
            if (this.index != Integer.MIN_VALUE) {
                if (parent.getIndex() != Integer.MIN_VALUE) {
                    buffer.append("/.");
                }
                buffer.append("[").append(this.index + 1).append(']');
            }
        } else if (this.index != Integer.MIN_VALUE) {
            buffer.append("/.[").append(this.index + 1).append(']');
        } else {
            buffer.append("/");
        }
        return buffer.toString();
    }
}

