/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.build.AntLogAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class BundleHelper {
    private Bundle bundle;
    private BundleContext context;
    private static BundleHelper defaultInstance;
    private boolean debug = false;
    private ILog log = null;

    public static BundleHelper getDefault() {
        return defaultInstance;
    }

    static void close() {
        if (defaultInstance != null) {
            BundleHelper.defaultInstance.context = null;
            BundleHelper.defaultInstance.bundle = null;
            defaultInstance = null;
        }
    }

    BundleHelper(BundleContext context) throws RuntimeException {
        if (defaultInstance != null) {
            throw new RuntimeException("Can not instantiate bundle helper");
        }
        this.context = context;
        defaultInstance = this;
        this.bundle = context.getBundle();
        this.debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.pde.build/debug"));
    }

    public final URL find(IPath path) {
        return FileLocator.find((Bundle)this.bundle, (IPath)path, null);
    }

    public final URL find(IPath path, Map override) {
        return FileLocator.find((Bundle)this.bundle, (IPath)path, (Map)override);
    }

    public final ILog getLog() {
        if (this.log == null) {
            return Platform.getLog((Bundle)this.bundle);
        }
        return this.log;
    }

    public final IPath getStateLocation() throws IllegalStateException {
        return Platform.getStateLocation((Bundle)BundleHelper.getDefault().bundle);
    }

    public final InputStream openStream(IPath file) throws IOException {
        return FileLocator.openStream((Bundle)this.bundle, (IPath)file, (boolean)false);
    }

    public final InputStream openStream(IPath file, boolean localized) throws IOException {
        return FileLocator.openStream((Bundle)this.bundle, (IPath)file, (boolean)localized);
    }

    public String toString() {
        return this.bundle.getSymbolicName();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Object acquireService(String serviceName) {
        ServiceReference reference = this.context.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        return this.context.getService(reference);
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public Filter createFilter(String filter) {
        try {
            return this.context.createFilter(filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    public void setLog(Object antLog) {
        if (antLog == null) {
            this.log = null;
            return;
        }
        try {
            this.log = new AntLogAdapter(antLog);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log = null;
        }
    }

    public String[] getRuntimeJavaProfiles() {
        Bundle systemBundle = this.context.getBundle(0L);
        URL url = systemBundle.getEntry("profile.list");
        if (url != null) {
            try {
                return BundleHelper.getJavaProfiles(new BufferedInputStream(url.openStream()));
            }
            catch (IOException iOException) {}
        }
        ArrayList<String> results = new ArrayList<String>(6);
        Enumeration entries = systemBundle.findEntries("/", "*.profile", false);
        while (entries.hasMoreElements()) {
            URL entryUrl = (URL)entries.nextElement();
            results.add(entryUrl.getFile().substring(1));
        }
        return BundleHelper.sortProfiles(results.toArray(new String[results.size()]));
    }

    public static String[] getJavaProfiles(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return ManifestElement.getArrayFromList((String)props.getProperty("java.profiles"), (String)",");
    }

    public static String[] sortProfiles(String[] profiles) {
        Arrays.sort(profiles, new Comparator(){

            public int compare(Object profile1, Object profile2) {
                String p1 = (String)profile1;
                String p2 = (String)profile2;
                if (p1.startsWith("JavaSE") && !p2.startsWith("JavaSE")) {
                    return -1;
                }
                if (!p1.startsWith("JavaSE") && p2.startsWith("JavaSE")) {
                    return 1;
                }
                if (p1.startsWith("J2SE") && !p2.startsWith("J2SE")) {
                    return -1;
                }
                if (!p1.startsWith("J2SE") && p2.startsWith("J2SE")) {
                    return 1;
                }
                return -p1.compareTo(p2);
            }
        });
        return profiles;
    }
}

