/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.ShapeAdvisor;
import org.eclipse.pde.internal.build.Utils;

public class P2Utils {
    private static final String SRC_BUNDLE_TXT_FOLDER = "org.eclipse.equinox.source";
    private static final String BUNDLE_TXT_FOLDER = "org.eclipse.equinox.simpleconfigurator";
    private static final String SRC_BUNDLE_TXT_PATH = "org.eclipse.equinox.source/source.info";
    public static final String BUNDLE_TXT_PATH = "org.eclipse.equinox.simpleconfigurator/bundles.info";

    public static URL[] readBundlesTxt(String platformHome) {
        File configArea = new File(platformHome, "configuration");
        File bundlesTxt = new File(configArea, BUNDLE_TXT_PATH);
        Path basePath = new Path(platformHome);
        List bundles = P2Utils.getBundlesFromFile(bundlesTxt, basePath);
        if (bundles == null) {
            return null;
        }
        File srcBundlesTxt = new File(configArea, SRC_BUNDLE_TXT_PATH);
        List srcBundles = P2Utils.getBundlesFromFile(srcBundlesTxt, basePath);
        if (srcBundles == null) {
            return bundles.toArray(new URL[bundles.size()]);
        }
        bundles.addAll(srcBundles);
        return bundles.toArray(new URL[bundles.size()]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List getBundlesFromFile(File file, Path basePath) {
        if (!file.exists()) {
            return null;
        }
        url = null;
        try {
            url = file.toURL();
        }
        catch (MalformedURLException v0) {
            return null;
        }
        bundles = new ArrayList<URL>();
        try {
            r = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0 || line.startsWith("org.eclipse.equinox.simpleconfigurator.baseUrl=")) continue;
                    tok = new StringTokenizer(line, ",", true);
                    symbolicName = tok.nextToken();
                    if (symbolicName.equals(",")) {
                        symbolicName = null;
                    } else {
                        tok.nextToken();
                    }
                    version = tok.nextToken();
                    if (version.equals(",")) {
                        version = null;
                    } else {
                        tok.nextToken();
                    }
                    urlSt = tok.nextToken();
                    if (urlSt.equals(",")) {
                        urlSt = symbolicName != null && version != null ? String.valueOf(symbolicName) + "_" + version + ".jar" : null;
                    } else {
                        tok.nextToken();
                    }
                    try {
                        bundleUrl = new URL(urlSt);
                        path = new Path(bundleUrl.getFile());
                        if (!path.isAbsolute()) {
                            urlSt = basePath.append((IPath)path).toOSString();
                            bundleUrl = new URL("file:" + urlSt);
                        }
                        bundles.add(bundleUrl);
                    }
                    catch (MalformedURLException v1) {}
                    ** GOTO lbl-1000
                    tok.nextToken();
                    tok.nextToken();
                    tok.nextToken();
                }
                try {
                    r.close();
                    return bundles;
                }
                catch (IOException v2) {
                    return null;
                }
lbl-1000:
                // 2 sources

                {
                    while (true) {
                        try {
                            r.close();
                            return null;
                        }
                        catch (IOException v3) {
                            return null;
                        }
                        break;
                    }
                }
            }
            catch (IOException v4) {
                ** continue;
            }
            catch (Throwable var12_12) {
                try {
                    r.close();
                    throw var12_12;
                }
                catch (IOException v5) {
                    return null;
                }
            }
        }
        catch (MalformedURLException v6) {
            return null;
        }
        catch (IOException v7) {
            return null;
        }
    }

    public static URL writeBundlesTxt(Map bundles, int defaultStartLevel, boolean defaultAutoStart, File directory) {
        if (bundles.size() == 0) {
            return null;
        }
        ShapeAdvisor advisor = new ShapeAdvisor();
        File bundlesTxt = new File(directory, BUNDLE_TXT_PATH);
        File srcBundlesTxt = new File(directory, SRC_BUNDLE_TXT_PATH);
        BufferedWriter out = null;
        BufferedWriter srcOut = null;
        try {
            try {
                new File(directory, SRC_BUNDLE_TXT_FOLDER).mkdirs();
                new File(directory, BUNDLE_TXT_FOLDER).mkdirs();
                bundlesTxt.createNewFile();
                srcBundlesTxt.createNewFile();
                out = new BufferedWriter(new FileWriter(bundlesTxt));
                srcOut = new BufferedWriter(new FileWriter(srcBundlesTxt));
                Iterator iterator = bundles.keySet().iterator();
                while (iterator.hasNext()) {
                    BundleDescription currentModel = (BundleDescription)iterator.next();
                    String name = currentModel.getSymbolicName();
                    String version = currentModel.getVersion().toString();
                    boolean sourceBundle = Utils.isSourceBundle(currentModel);
                    BufferedWriter writer = sourceBundle ? srcOut : out;
                    writer.write(name);
                    writer.write(44);
                    writer.write(version);
                    writer.write(",file:plugins/");
                    writer.write((String)advisor.getFinalShape(currentModel)[0]);
                    if (Utils.isSourceBundle(currentModel)) {
                        writer.write(",-1,false");
                    } else {
                        String auto;
                        writer.write(44);
                        String currentLevel = (String)bundles.get(currentModel);
                        int index = currentLevel.indexOf(58);
                        String level = index > 0 ? currentLevel.substring(0, index) : "default";
                        String string = auto = index > 0 && index < currentLevel.length() - 1 ? currentLevel.substring(index + 1) : "default";
                        if ("default".equals(auto)) {
                            auto = Boolean.toString(defaultAutoStart);
                        }
                        if ("default".equals(level)) {
                            level = Integer.toString(defaultStartLevel);
                        }
                        writer.write(level);
                        writer.write(44);
                        writer.write(auto);
                    }
                    writer.newLine();
                }
                out.flush();
                out.close();
                srcOut.flush();
                srcOut.close();
            }
            catch (IOException iOException) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException2) {}
                }
                if (srcOut != null) {
                    try {
                        srcOut.close();
                    }
                    catch (IOException iOException3) {}
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (srcOut != null) {
                try {
                    srcOut.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        if (srcOut != null) {
            try {
                srcOut.close();
            }
            catch (IOException iOException) {}
        }
        if (!bundlesTxt.exists()) {
            return null;
        }
        try {
            return bundlesTxt.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL writeBundlesTxt(Collection bundles, File directory, boolean refactoredRuntime) {
        String defaultAppend = "default:default";
        HashMap<BundleDescription, String> bundleMap = new HashMap<BundleDescription, String>(bundles.size());
        Iterator iterator = bundles.iterator();
        while (iterator.hasNext()) {
            BundleDescription desc = (BundleDescription)iterator.next();
            if (desc == null) continue;
            String modelName = desc.getSymbolicName();
            if (BUNDLE_TXT_FOLDER.equals(modelName)) {
                bundleMap.put(desc, "1:true");
                continue;
            }
            if ("org.eclipse.equinox.common".equals(modelName)) {
                bundleMap.put(desc, "2:true");
                continue;
            }
            if ("org.eclipse.osgi".equals(modelName)) {
                bundleMap.put(desc, "-1:true");
                continue;
            }
            if ("org.eclipse.update.configurator".equals(modelName)) {
                bundleMap.put(desc, "3:true");
                continue;
            }
            if ("org.eclipse.core.runtime".equals(modelName)) {
                if (refactoredRuntime) {
                    bundleMap.put(desc, "default:true");
                    continue;
                }
                bundleMap.put(desc, "2:true");
                continue;
            }
            bundleMap.put(desc, defaultAppend);
        }
        return P2Utils.writeBundlesTxt(bundleMap, 4, false, directory);
    }
}

