/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskActivationHistory {
    private final List<AbstractTask> history = new ArrayList<AbstractTask>();
    private int currentIndex = -1;

    public void addTask(AbstractTask task) {
        this.history.remove(task);
        this.history.add(task);
        this.currentIndex = this.history.size() - 1;
    }

    public boolean containsTask(ITask task) {
        return this.history.contains(task);
    }

    public boolean removeTask(ITask task) {
        return this.history.remove(task);
    }

    public AbstractTask getPreviousTask() {
        boolean active = false;
        for (AbstractTask task : this.history) {
            if (!task.isActive()) continue;
            active = true;
            break;
        }
        if (this.hasPrevious()) {
            if (!active) {
                return this.history.get(this.currentIndex);
            }
            if (this.currentIndex < this.history.size() - 1 && this.currentIndex == 0 && !this.history.get(this.currentIndex).isActive()) {
                return this.history.get(this.currentIndex);
            }
            if (this.currentIndex > 0 && this.currentIndex < this.history.size()) {
                return this.history.get(--this.currentIndex);
            }
        }
        return null;
    }

    public List<AbstractTask> getPreviousTasks() {
        return Collections.unmodifiableList(new ArrayList<AbstractTask>(this.history));
    }

    public List<AbstractTask> getPreviousTasks(Set<AbstractTaskContainer> containers) {
        if (containers.isEmpty()) {
            return this.getPreviousTasks();
        }
        HashSet<ITask> allWorkingSetTasks = new HashSet<ITask>();
        for (ITaskContainer iTaskContainer : containers) {
            allWorkingSetTasks.addAll(iTaskContainer.getChildren());
        }
        ArrayList<AbstractTask> arrayList = new ArrayList<AbstractTask>(this.getPreviousTasks());
        Iterator it = arrayList.iterator();
        while (it.hasNext()) {
            AbstractTask task = (AbstractTask)it.next();
            if (allWorkingSetTasks.contains(task)) continue;
            it.remove();
        }
        return Collections.unmodifiableList(arrayList);
    }

    public boolean hasPrevious() {
        return this.currentIndex == 0 && !this.history.get(this.currentIndex).isActive() || this.currentIndex > 0;
    }

    public void clear() {
        this.history.clear();
        this.currentIndex = -1;
    }

    public int indexOf(ITask task) {
        return this.history.indexOf(task);
    }

    public int getSize() {
        return this.history.size();
    }
}

