/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.deprecated;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AbstractAttributeFactory;
import org.eclipse.mylyn.internal.tasks.core.deprecated.AttributeContainer;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryAttachment;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryOperation;
import org.eclipse.mylyn.internal.tasks.core.deprecated.RepositoryTaskAttribute;
import org.eclipse.mylyn.internal.tasks.core.deprecated.TaskComment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class RepositoryTaskData
extends AttributeContainer
implements Serializable {
    private static final long serialVersionUID = 2304501248225237699L;
    private boolean isNew = false;
    private final String reportID;
    private String repositoryURL;
    private final String repositoryKind;
    private String taskKind;
    private final List<TaskComment> taskComments = new ArrayList<TaskComment>();
    private final List<RepositoryAttachment> attachments = new ArrayList<RepositoryAttachment>();
    private RepositoryOperation selectedOperation = null;
    private final List<RepositoryOperation> repositoryOperations = new ArrayList<RepositoryOperation>();
    private boolean partial;

    public RepositoryTaskData(AbstractAttributeFactory factory, String repositoryKind, String repositoryURL, String id) {
        this(factory, repositoryKind, repositoryURL, id, "task");
    }

    public RepositoryTaskData(AbstractAttributeFactory factory, String repositoryKind, String repositoryURL, String id, String taskKind) {
        super(factory);
        this.reportID = id;
        this.repositoryKind = repositoryKind;
        this.repositoryURL = repositoryURL;
        this.taskKind = taskKind;
    }

    public String getLabel() {
        if (this.isNew()) {
            return "<unsubmitted> " + this.getRepositoryUrl();
        }
        return this.getSummary();
    }

    public String getResolution() {
        return this.getAttributeValue("task.common.resolution");
    }

    public String getStatus() {
        return this.getAttributeValue("task.common.status");
    }

    public String getLastModified() {
        return this.getAttributeValue("task.common.date.modified");
    }

    public void setSelectedOperation(RepositoryOperation o) {
        this.selectedOperation = o;
    }

    public RepositoryOperation getSelectedOperation() {
        return this.selectedOperation;
    }

    public List<RepositoryOperation> getOperations() {
        return this.repositoryOperations;
    }

    public String getReporter() {
        return this.getAttributeValue("task.common.user.reporter");
    }

    public RepositoryOperation getOperation(String displayText) {
        for (RepositoryOperation o : this.repositoryOperations) {
            String opName = o.getOperationName();
            opName = opName.replaceAll("</.*>", "");
            if (!(opName = opName.replaceAll("<.*>", "")).equals(displayText)) continue;
            return o;
        }
        return null;
    }

    public String getSummary() {
        return this.getAttributeValue("task.common.summary");
    }

    public void setSummary(String summary) {
        this.setAttributeValue("task.common.summary", summary);
    }

    public String getProduct() {
        return this.getAttributeValue("task.common.product");
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public String getCreated() {
        return this.getAttributeValue("task.common.date.created");
    }

    public List<String> getKeywords() {
        StringTokenizer st = new StringTokenizer(this.getAttributeValue("task.common.keywords"), ",", false);
        ArrayList<String> keywords = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            keywords.add(s);
        }
        return keywords;
    }

    public void addOperation(RepositoryOperation o) {
        this.repositoryOperations.add(o);
    }

    public List<String> getCc() {
        return this.getAttributeValues("task.common.user.cc");
    }

    public void removeCc(String email) {
        this.removeAttributeValue("task.common.user.cc", email);
    }

    public String getAssignedTo() {
        return this.getAttributeValue("task.common.user.assigned");
    }

    public String getNewComment() {
        RepositoryTaskAttribute attribute = this.getAttribute("task.common.comment.new");
        return attribute != null ? attribute.getValue() : "";
    }

    public void setNewComment(String newComment) {
        this.setAttributeValue("task.common.comment.new", newComment);
    }

    public void addComment(TaskComment taskComment) {
        this.taskComments.add(taskComment);
    }

    public List<TaskComment> getComments() {
        return this.taskComments;
    }

    public void setDescription(String description) {
        this.setAttributeValue("task.common.description", description);
    }

    public String getDescription() {
        RepositoryTaskAttribute attribute = this.getDescriptionAttribute();
        return attribute != null ? attribute.getValue() : "";
    }

    public RepositoryTaskAttribute getDescriptionAttribute() {
        List<TaskComment> coms;
        RepositoryTaskAttribute attribute = this.getAttribute("task.common.description");
        if (attribute == null && (coms = this.getComments()) != null && coms.size() > 0) {
            return coms.get(0).getAttribute("task.common.comment.text");
        }
        return attribute;
    }

    public void addAttachment(RepositoryAttachment attachment) {
        this.attachments.add(attachment);
        attachment.setTaskData(this);
    }

    public List<RepositoryAttachment> getAttachments() {
        return this.attachments;
    }

    @Deprecated
    public String getId() {
        return this.getTaskId();
    }

    public String getTaskId() {
        return this.reportID;
    }

    public String getTaskKey() {
        RepositoryTaskAttribute attr = this.getAttribute("task.common.key");
        if (attr != null) {
            return attr.getValue();
        }
        return this.getTaskId();
    }

    public void setTaskKey(String key) {
        this.setAttributeValue("task.common.key", key);
    }

    public String getRepositoryUrl() {
        return this.repositoryURL;
    }

    @Override
    public List<String> getAttributeValues(String key) {
        RepositoryTaskAttribute attribute = this.getAttribute(key);
        if (attribute != null) {
            return attribute.getValues();
        }
        return new ArrayList<String>();
    }

    public void removeAttributeValue(String key, String value) {
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib != null) {
            attrib.removeValue(value);
        }
    }

    @Deprecated
    public String getRepositoryKind() {
        return this.getConnectorKind();
    }

    public String getConnectorKind() {
        return this.repositoryKind;
    }

    @Override
    public void setAttributeFactory(AbstractAttributeFactory factory) {
        super.setAttributeFactory(factory);
        for (TaskComment taskComment : this.taskComments) {
            taskComment.setAttributeFactory(factory);
        }
        for (RepositoryAttachment attachment : this.attachments) {
            attachment.setAttributeFactory(factory);
        }
    }

    public String getTaskKind() {
        return this.taskKind;
    }

    public void setTaskKind(String taskKind) {
        this.taskKind = taskKind;
    }

    public void setRepositoryURL(String repositoryURL) {
        this.repositoryURL = repositoryURL;
        for (RepositoryAttachment attachment : this.attachments) {
            attachment.setRepositoryUrl(repositoryURL);
        }
    }

    public final String getHandleIdentifier() {
        return RepositoryTaskHandleUtil.getHandle(this.getRepositoryUrl(), this.getTaskId());
    }

    @Override
    public void addAttribute(String key, RepositoryTaskAttribute attribute) {
        super.addAttribute(key, attribute);
        attribute.setTaskData(this);
    }

    public void refresh() {
        this.setTaskData(this);
        for (AttributeContainer attributeContainer : this.taskComments) {
            attributeContainer.setTaskData(this);
        }
        for (AttributeContainer attributeContainer : this.attachments) {
            attributeContainer.setTaskData(this);
        }
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public boolean isPartial() {
        return this.partial;
    }
}

