/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.util.Date;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeQueriesJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeRepositoriesJob
extends SynchronizationJob {
    private final TaskList taskList;
    private final TaskDataManager taskDataManager;
    private final IRepositoryManager repositoryManager;
    private final Set<TaskRepository> repositories;
    private final Object family = new Object();
    private final IRepositoryModel tasksModel;

    public SynchronizeRepositoriesJob(TaskList taskList, TaskDataManager taskDataManager, IRepositoryModel tasksModel, IRepositoryManager repositoryManager, Set<TaskRepository> repositories) {
        super("Synchronizing Task List");
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.tasksModel = tasksModel;
        this.repositoryManager = repositoryManager;
        this.repositories = repositories;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Processing", this.repositories.size() * 100);
            for (TaskRepository repository : this.repositories) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    if (repository.isOffline()) {
                        monitor.worked(100);
                        continue;
                    }
                    monitor.setTaskName("Processing " + repository.getRepositoryLabel());
                    AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(repository.getConnectorKind());
                    Set<RepositoryQuery> queries = this.taskList.getRepositoryQueries(repository.getRepositoryUrl());
                    if (this.isUser() || queries.isEmpty()) {
                        monitor.worked(20);
                    } else {
                        this.updateRepositoryConfiguration(repository, connector, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    }
                    SynchronizeQueriesJob job = new SynchronizeQueriesJob(this.taskList, this.taskDataManager, this.tasksModel, connector, repository, queries){

                        public boolean belongsTo(Object family) {
                            return SynchronizeRepositoriesJob.this.family == family;
                        }
                    };
                    job.setUser(this.isUser());
                    job.setFullSynchronization(true);
                    job.setPriority(50);
                    if (this.isUser()) {
                        job.schedule();
                        continue;
                    }
                    job.run((IProgressMonitor)new SubProgressMonitor(monitor, 80));
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public Object getFamily() {
        return this.family;
    }

    private void updateRepositoryConfiguration(TaskRepository repository, AbstractRepositoryConnector connector, IProgressMonitor monitor) throws InterruptedException {
        try {
            try {
                if (!this.isUser()) {
                    monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
                }
                monitor.beginTask("Updating repository configuration for " + repository.getRepositoryUrl(), 100);
                if (connector.isRepositoryConfigurationStale(repository, monitor)) {
                    connector.updateRepositoryConfiguration(repository, monitor);
                    repository.setConfigurationDate(new Date());
                }
            }
            catch (CoreException e) {
                repository.setStatus((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Updating of repository configuration failed", (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

