/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import org.eclipse.core.runtime.Assert;

public class TaskRelation {
    private final String taskId;
    private final Kind kind;
    private final Direction direction;

    private TaskRelation(Kind kind, Direction direction, String taskId) {
        Assert.isNotNull((Object)((Object)kind));
        Assert.isNotNull((Object)((Object)direction));
        Assert.isNotNull((Object)taskId);
        this.kind = kind;
        this.direction = direction;
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static TaskRelation parentTask(String taskId) {
        return new TaskRelation(Kind.CONTAINMENT, Direction.INWARD, taskId);
    }

    public static TaskRelation subtask(String taskId) {
        return new TaskRelation(Kind.CONTAINMENT, Direction.OUTWARD, taskId);
    }

    public static TaskRelation dependency(String taskId, Direction direction) {
        return new TaskRelation(Kind.DEPENDENCY, direction, taskId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        INWARD,
        OUTWARD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        CONTAINMENT,
        DEPENDENCY,
        DUPLICATE;

    }
}

