/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.request.IRequestConvert;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.lib.commands.SetCurrentEditModelCommand;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.IDEMultiPageReportEditor;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.TemplateParameterDefinitionHandle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;

class BIRTGotoMarker
implements IGotoMarker {
    protected IDEMultiPageReportEditor editorPart;

    public BIRTGotoMarker(IDEMultiPageReportEditor editorPart) {
        this.editorPart = editorPart;
    }

    public void gotoMarker(IMarker marker) {
        assert (this.editorPart != null);
        if (!marker.exists()) {
            return;
        }
        ModuleHandle moduleHandle = this.editorPart.getModel();
        ReportElementHandle reportElementHandle = this.getReportElementHandle(moduleHandle, marker);
        if (reportElementHandle == null || reportElementHandle != null && this.isElementTemplateParameterDefinition((DesignElementHandle)reportElementHandle)) {
            this.gotoXMLSourcePage(marker);
        } else if (moduleHandle instanceof ReportDesignHandle) {
            if (this.isElementInMasterPage((DesignElementHandle)reportElementHandle)) {
                this.gotoLayoutPage("org.eclipse.birt.report.designer.ui.editors.masterpage", marker, reportElementHandle);
            } else {
                this.gotoLayoutPage("org.eclipse.birt.report.designer.ui.editors.layout", marker, reportElementHandle);
            }
        } else if (moduleHandle instanceof LibraryHandle) {
            if (this.isElementInMasterPage((DesignElementHandle)reportElementHandle)) {
                this.gotoLayoutPage("org.eclipse.birt.report.designer.ui.editors.masterpage", marker, reportElementHandle);
            } else {
                this.gotoLibraryLayoutPage(marker, reportElementHandle);
            }
        }
    }

    protected void gotoLibraryLayoutPage(IMarker marker, ReportElementHandle reportElementHandle) {
        String pageId = "org.eclipse.birt.report.designer.ui.editors.library.layout";
        if (!this.activatePage(pageId)) {
            return;
        }
        ModuleHandle moduleHandle = this.editorPart.getModel();
        reportElementHandle = this.getReportElementHandle(moduleHandle, marker);
        if (reportElementHandle != null && !this.isElementInMasterPage((DesignElementHandle)reportElementHandle)) {
            SetCurrentEditModelCommand command = new SetCurrentEditModelCommand((Object)reportElementHandle);
            command.execute();
        } else {
            MessageDialog.openError((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"BIRTGotoMarker.Error.Title"), (String)Messages.getString((String)"BIRTGotoMarker.Error.Message"));
        }
    }

    protected void gotoLayoutPage(String pageId, final IMarker marker, final ReportElementHandle reportElementHandle) {
        if (!this.activatePage(pageId)) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                BIRTGotoMarker.this.gotoLayoutMarker(marker, reportElementHandle);
            }
        });
    }

    protected void gotoXMLSourcePage(final IMarker marker) {
        if (!this.activatePage("org.eclipse.birt.report.designer.ui.editors.xmlsource")) {
            return;
        }
        final IReportEditorPage reportXMLSourcePage = (IReportEditorPage)this.editorPart.getActivePageInstance();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                BIRTGotoMarker.this.gotoXMLSourceMarker(reportXMLSourcePage, marker);
            }
        });
    }

    protected void gotoXMLSourceMarker(IReportEditorPage reportXMLSourcePage, IMarker marker) {
        reportXMLSourcePage.selectReveal((Object)marker);
    }

    protected boolean activatePage(String pageId) {
        if (pageId.equals(this.editorPart.getActivePageInstance().getId())) {
            return true;
        }
        IFormPage formPage = this.editorPart.setActivePage(pageId);
        return formPage != null;
    }

    protected ReportElementHandle getReportElementHandle(ModuleHandle moduleHandle, IMarker marker) {
        Integer elementId = new Integer(0);
        try {
            elementId = (Integer)marker.getAttribute("ElementId");
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (elementId != null && elementId > 0) {
            DesignElementHandle elementHandle = moduleHandle.getElementByID((long)elementId.intValue());
            if (elementHandle == null || !(elementHandle instanceof ReportElementHandle)) {
                return null;
            }
            if (elementHandle instanceof CellHandle || elementHandle instanceof ColumnHandle || elementHandle instanceof MasterPageHandle || elementHandle instanceof ReportItemHandle || elementHandle instanceof RowHandle || elementHandle instanceof TemplateElementHandle) {
                return (ReportElementHandle)elementHandle;
            }
        }
        return null;
    }

    protected void gotoLayoutMarker(IMarker marker, ReportElementHandle reportElementHandle) {
        ModuleHandle moduleHandle = this.editorPart.getModel();
        reportElementHandle = this.getReportElementHandle(moduleHandle, marker);
        if (reportElementHandle == null) {
            MessageDialog.openError((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"BIRTGotoMarker.Error.Title"), (String)Messages.getString((String)"BIRTGotoMarker.Error.Message"));
            return;
        }
        ArrayList<ReportElementHandle> list = new ArrayList<ReportElementHandle>();
        list.add(reportElementHandle);
        ReportRequest r = new ReportRequest();
        r.setType((Object)"selection");
        r.setRequestConvert(new IRequestConvert(){

            public List convertSelectionToModelLisr(List list) {
                ArrayList lst = new ArrayList();
                for (Object obj : list) {
                    lst.add(obj);
                }
                return lst;
            }
        });
        r.setSelectionObject(list);
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
    }

    protected boolean isElementInMasterPage(DesignElementHandle elementHandle) {
        ModuleHandle root = elementHandle.getRoot();
        DesignElementHandle container = elementHandle;
        while (container != null && container != root) {
            if (container instanceof MasterPageHandle) {
                return true;
            }
            container = container.getContainer();
        }
        return false;
    }

    protected boolean isElementTemplateParameterDefinition(DesignElementHandle elementHandle) {
        ModuleHandle root = elementHandle.getRoot();
        DesignElementHandle container = elementHandle;
        while (container != null && container != root) {
            if (container instanceof TemplateParameterDefinitionHandle) {
                return true;
            }
            container = container.getContainer();
        }
        return false;
    }
}

