/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.dstore;

import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.internal.services.dstore.files.DStoreFileService;
import org.eclipse.rse.internal.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.AbstractRemoteFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;

public class DStoreFile
extends AbstractRemoteFile {
    protected DStoreHostFile _dstoreHostFile;

    private DStoreFileService getDStoreFileService() {
        FileServiceSubSystem ss = (FileServiceSubSystem)this._context.getParentRemoteFileSubSystem();
        return (DStoreFileService)ss.getFileService();
    }

    public IRemoteFile getParentRemoteFile() {
        if (this._parentFile == null) {
            if (this.isRoot()) {
                return null;
            }
            DStoreFile parentFile = null;
            String pathOnly = this.getParentPath();
            if (pathOnly != null) {
                DStoreFileService fileService = this.getDStoreFileService();
                IRemoteFileSubSystem ss = this._context.getParentRemoteFileSubSystem();
                if (ss != null) {
                    char sep;
                    block22: {
                        block21: {
                            sep = this.getSeparatorChar();
                            if (pathOnly.length() != 0) break block21;
                            return null;
                        }
                        if (!pathOnly.equals(this.getAbsolutePath())) break block22;
                        return null;
                    }
                    try {
                        if (pathOnly.length() == 1) {
                            IHostFile hostParent = fileService.getHostFile(pathOnly);
                            if (hostParent == null) {
                                DataStore ds = this._dstoreHostFile.getDataElement().getDataStore();
                                DataElement element = ds.createObject(null, "universal.FolderObject", "");
                                element.setAttribute(3, pathOnly);
                                hostParent = new DStoreHostFile(element);
                            }
                            parentFile = new DStoreFile((FileServiceSubSystem)ss, this._context, null, (DStoreHostFile)hostParent);
                        } else if (pathOnly.charAt(pathOnly.length() - 1) != sep) {
                            DataStore ds = this._dstoreHostFile.getDataElement().getDataStore();
                            IHostFile hostParent = fileService.getHostFile(pathOnly);
                            if (hostParent == null) {
                                int nameSep = pathOnly.lastIndexOf(sep);
                                String parentName = pathOnly;
                                String parentPath = pathOnly;
                                if (nameSep > 0) {
                                    parentName = pathOnly.substring(nameSep + 1);
                                    parentPath = pathOnly.substring(0, nameSep);
                                    if (parentPath.endsWith(":")) {
                                        parentPath = String.valueOf(parentPath) + sep;
                                    }
                                } else {
                                    parentName = pathOnly.substring(nameSep + 1);
                                    parentPath = "" + sep;
                                }
                                DataElement element = ds.createObject(null, "universal.FolderObject", parentName);
                                element.setAttribute(3, parentPath);
                                hostParent = new DStoreHostFile(element);
                            }
                            parentFile = new DStoreFile((FileServiceSubSystem)ss, this._context, null, (DStoreHostFile)hostParent);
                        } else {
                            DataStore ds = this._dstoreHostFile.getDataElement().getDataStore();
                            IHostFile hostParent = fileService.getHostFile(pathOnly);
                            if (hostParent == null) {
                                int nameSep = pathOnly.lastIndexOf(sep);
                                String parentName = pathOnly;
                                String parentPath = pathOnly;
                                if (nameSep > 0) {
                                    parentName = pathOnly.substring(nameSep + 1);
                                    parentPath = pathOnly.substring(0, nameSep);
                                    if (parentPath.endsWith(":")) {
                                        parentPath = String.valueOf(parentPath) + sep;
                                    }
                                } else {
                                    parentName = pathOnly.substring(nameSep + 1);
                                    parentPath = "" + sep;
                                }
                                DataElement element = ds.createObject(null, "universal.FolderObject", parentName);
                                element.setAttribute(3, parentPath);
                                hostParent = new DStoreHostFile(element);
                            }
                            parentFile = new DStoreFile((FileServiceSubSystem)ss, this._context, null, (DStoreHostFile)hostParent);
                        }
                    }
                    catch (Exception e) {
                        SystemBasePlugin.logError((String)"RemoteFileImpl.getParentRemoteFile()", (Throwable)e);
                    }
                }
            }
            this._parentFile = parentFile;
        }
        return this._parentFile;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public DStoreFile(FileServiceSubSystem ss, IRemoteFileContext context, IRemoteFile parent, DStoreHostFile hostFile) {
        super(ss, context, parent, (IHostFile)hostFile);
        this._dstoreHostFile = hostFile;
    }

    public boolean isVirtual() {
        DataElement element = this._dstoreHostFile.getDataElement();
        String type = element.getType();
        return type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject");
    }

    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    public String getClassification() {
        return this._dstoreHostFile.getClassification();
    }
}

