/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelAgentForwarding;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelForwardedTCPIP;
import com.jcraft.jsch.ChannelSession;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.ChannelSubsystem;
import com.jcraft.jsch.ChannelX11;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.RequestSignal;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Vector;

public abstract class Channel
implements Runnable {
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
    static final int SSH_OPEN_ADMINISTRATIVELY_PROHIBITED = 1;
    static final int SSH_OPEN_CONNECT_FAILED = 2;
    static final int SSH_OPEN_UNKNOWN_CHANNEL_TYPE = 3;
    static final int SSH_OPEN_RESOURCE_SHORTAGE = 4;
    static int index;
    private static Vector pool;
    int id;
    int recipient = -1;
    byte[] type = "foo".getBytes();
    int lwsize_max;
    int lwsize = this.lwsize_max = 0x100000;
    int lmpsize = 16384;
    int rwsize = 0;
    int rmpsize = 0;
    IO io = null;
    Thread thread = null;
    boolean eof_local = false;
    boolean eof_remote = false;
    boolean close = false;
    boolean connected = false;
    int exitstatus = -1;
    int reply = 0;
    int connectTimeout = 0;
    Session session;
    int notifyme = 0;

    static Channel getChannel(String type) {
        if (type.equals("session")) {
            return new ChannelSession();
        }
        if (type.equals("shell")) {
            return new ChannelShell();
        }
        if (type.equals("exec")) {
            return new ChannelExec();
        }
        if (type.equals("x11")) {
            return new ChannelX11();
        }
        if (type.equals("auth-agent@openssh.com")) {
            return new ChannelAgentForwarding();
        }
        if (type.equals("direct-tcpip")) {
            return new ChannelDirectTCPIP();
        }
        if (type.equals("forwarded-tcpip")) {
            return new ChannelForwardedTCPIP();
        }
        if (type.equals("sftp")) {
            return new ChannelSftp();
        }
        if (type.equals("subsystem")) {
            return new ChannelSubsystem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Channel getChannel(int id, Session session) {
        Vector vector = pool;
        synchronized (vector) {
            int i = 0;
            while (i < pool.size()) {
                Channel c = (Channel)pool.elementAt(i);
                if (c.id == id && c.session == session) {
                    return c;
                }
                ++i;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void del(Channel c) {
        Vector vector = pool;
        synchronized (vector) {
            pool.removeElement(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel() {
        Vector vector = pool;
        synchronized (vector) {
            this.id = index++;
            pool.addElement(this);
        }
    }

    void setRecipient(int foo) {
        this.recipient = foo;
    }

    int getRecipient() {
        return this.recipient;
    }

    void init() {
    }

    public void connect() throws JSchException {
        this.connect(0);
    }

    public void connect(int connectTimeout) throws JSchException {
        if (!this.session.isConnected()) {
            throw new JSchException("session is down");
        }
        this.connectTimeout = connectTimeout;
        try {
            Buffer buf = new Buffer(100);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)90);
            buf.putString(this.type);
            buf.putInt(this.id);
            buf.putInt(this.lwsize);
            buf.putInt(this.lmpsize);
            this.session.write(packet);
            int retry = 1000;
            long start = System.currentTimeMillis();
            long timeout = connectTimeout;
            while (this.getRecipient() == -1 && this.session.isConnected() && retry > 0) {
                if (timeout > 0L && System.currentTimeMillis() - start > timeout) {
                    retry = 0;
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                --retry;
            }
            if (!this.session.isConnected()) {
                throw new JSchException("session is down");
            }
            if (retry == 0) {
                throw new JSchException("channel is not opened.");
            }
            if (this.isClosed()) {
                throw new JSchException("channel is not opened.");
            }
            this.connected = true;
            this.start();
        }
        catch (Exception e) {
            this.connected = false;
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            throw new JSchException(e.toString());
        }
    }

    public void setXForwarding(boolean foo) {
    }

    public void start() throws JSchException {
    }

    public boolean isEOF() {
        return this.eof_remote;
    }

    void getData(Buffer buf) {
        this.setRecipient(buf.getInt());
        this.setRemoteWindowSize(buf.getInt());
        this.setRemotePacketSize(buf.getInt());
    }

    public void setInputStream(InputStream in) {
        this.io.setInputStream(in, false);
    }

    public void setInputStream(InputStream in, boolean dontclose) {
        this.io.setInputStream(in, dontclose);
    }

    public void setOutputStream(OutputStream out) {
        this.io.setOutputStream(out, false);
    }

    public void setOutputStream(OutputStream out, boolean dontclose) {
        this.io.setOutputStream(out, dontclose);
    }

    public void setExtOutputStream(OutputStream out) {
        this.io.setExtOutputStream(out, false);
    }

    public void setExtOutputStream(OutputStream out, boolean dontclose) {
        this.io.setExtOutputStream(out, dontclose);
    }

    public InputStream getInputStream() throws IOException {
        MyPipedInputStream in = new MyPipedInputStream(32768);
        this.io.setOutputStream(new PassiveOutputStream(in), false);
        return in;
    }

    public InputStream getExtInputStream() throws IOException {
        MyPipedInputStream in = new MyPipedInputStream(32768);
        this.io.setExtOutputStream(new PassiveOutputStream(in), false);
        return in;
    }

    public OutputStream getOutputStream() throws IOException {
        final Channel channel = this;
        OutputStream out = new OutputStream(){
            private int dataLen = 0;
            private Buffer buffer = null;
            private Packet packet = null;
            private boolean closed = false;
            byte[] b = new byte[1];

            private synchronized void init() throws IOException {
                this.buffer = new Buffer(Channel.this.rmpsize);
                this.packet = new Packet(this.buffer);
                byte[] _buf = this.buffer.buffer;
                if (_buf.length - 14 - 32 - 20 <= 0) {
                    this.buffer = null;
                    this.packet = null;
                    throw new IOException("failed to initialize the channel.");
                }
            }

            public void write(int w) throws IOException {
                this.b[0] = (byte)w;
                this.write(this.b, 0, 1);
            }

            public void write(byte[] buf, int s, int l) throws IOException {
                if (this.packet == null) {
                    this.init();
                }
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                byte[] _buf = this.buffer.buffer;
                int _bufl = _buf.length;
                while (l > 0) {
                    int _l = l;
                    if (l > _bufl - (14 + this.dataLen) - 32 - 20) {
                        _l = _bufl - (14 + this.dataLen) - 32 - 20;
                    }
                    if (_l <= 0) {
                        this.flush();
                        continue;
                    }
                    System.arraycopy(buf, s, _buf, 14 + this.dataLen, _l);
                    this.dataLen += _l;
                    s += _l;
                    l -= _l;
                }
            }

            public void flush() throws IOException {
                if (this.closed) {
                    throw new IOException("Already closed");
                }
                if (this.dataLen == 0) {
                    return;
                }
                this.packet.reset();
                this.buffer.putByte((byte)94);
                this.buffer.putInt(Channel.this.recipient);
                this.buffer.putInt(this.dataLen);
                this.buffer.skip(this.dataLen);
                try {
                    int foo = this.dataLen;
                    this.dataLen = 0;
                    Channel.this.session.write(this.packet, channel, foo);
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException(e.toString());
                }
            }

            public void close() throws IOException {
                if (this.packet == null) {
                    try {
                        this.init();
                    }
                    catch (IOException e) {
                        return;
                    }
                }
                if (this.closed) {
                    return;
                }
                if (this.dataLen > 0) {
                    this.flush();
                }
                channel.eof();
                this.closed = true;
            }
        };
        return out;
    }

    void setLocalWindowSizeMax(int foo) {
        this.lwsize_max = foo;
    }

    void setLocalWindowSize(int foo) {
        this.lwsize = foo;
    }

    void setLocalPacketSize(int foo) {
        this.lmpsize = foo;
    }

    synchronized void setRemoteWindowSize(int foo) {
        this.rwsize = foo;
    }

    synchronized void addRemoteWindowSize(int foo) {
        this.rwsize += foo;
        if (this.notifyme > 0) {
            this.notifyAll();
        }
    }

    void setRemotePacketSize(int foo) {
        this.rmpsize = foo;
    }

    public void run() {
    }

    void write(byte[] foo) throws IOException {
        this.write(foo, 0, foo.length);
    }

    void write(byte[] foo, int s, int l) throws IOException {
        try {
            this.io.put(foo, s, l);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    void write_ext(byte[] foo, int s, int l) throws IOException {
        try {
            this.io.put_ext(foo, s, l);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    void eof_remote() {
        this.eof_remote = true;
        try {
            if (this.io.out != null) {
                this.io.out.close();
                this.io.out = null;
            }
        }
        catch (NullPointerException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void eof() {
        if (this.close) {
            return;
        }
        if (this.eof_local) {
            return;
        }
        this.eof_local = true;
        try {
            Buffer buf = new Buffer(100);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)96);
            buf.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (this.close) {
            return;
        }
        this.close = true;
        this.eof_remote = true;
        this.eof_local = true;
        try {
            Buffer buf = new Buffer(100);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)97);
            buf.putInt(this.getRecipient());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disconnect(Session session) {
        int i;
        Channel[] channels = null;
        int count = 0;
        Vector vector = pool;
        synchronized (vector) {
            channels = new Channel[pool.size()];
            i = 0;
            while (i < pool.size()) {
                try {
                    Channel c = (Channel)pool.elementAt(i);
                    if (c.session == session) {
                        channels[count++] = c;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
        }
        i = 0;
        while (i < count) {
            channels[i].disconnect();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Channel channel = this;
        synchronized (channel) {
            if (!this.connected) {
                return;
            }
            this.connected = false;
        }
        this.close();
        this.eof_local = true;
        this.eof_remote = true;
        this.thread = null;
        try {
            if (this.io != null) {
                this.io.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.io = null;
        Channel.del(this);
    }

    public boolean isConnected() {
        if (this.session != null) {
            return this.session.isConnected() && this.connected;
        }
        return false;
    }

    public void sendSignal(String foo) throws Exception {
        RequestSignal request = new RequestSignal();
        request.setSignal(foo);
        request.request(this.session, this);
    }

    void setExitStatus(int foo) {
        this.exitstatus = foo;
    }

    public int getExitStatus() {
        return this.exitstatus;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public int getId() {
        return this.id;
    }

    protected void sendOpenConfirmation() throws Exception {
        Buffer buf = new Buffer(100);
        Packet packet = new Packet(buf);
        packet.reset();
        buf.putByte((byte)91);
        buf.putInt(this.getRecipient());
        buf.putInt(this.id);
        buf.putInt(this.lwsize);
        buf.putInt(this.lmpsize);
        this.session.write(packet);
    }

    protected void sendOpenFailure(int reasoncode) {
        try {
            Buffer buf = new Buffer(100);
            Packet packet = new Packet(buf);
            packet.reset();
            buf.putByte((byte)92);
            buf.putInt(this.getRecipient());
            buf.putInt(reasoncode);
            buf.putString("open failed".getBytes());
            buf.putString("".getBytes());
            this.session.write(packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
        SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
        SSH_MSG_CHANNEL_WINDOW_ADJUST = 93;
        SSH_OPEN_ADMINISTRATIVELY_PROHIBITED = 1;
        SSH_OPEN_CONNECT_FAILED = 2;
        SSH_OPEN_UNKNOWN_CHANNEL_TYPE = 3;
        SSH_OPEN_RESOURCE_SHORTAGE = 4;
        index = 0;
        pool = new Vector();
    }

    class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream() throws IOException {
        }

        MyPipedInputStream(int size) throws IOException {
            this.buffer = new byte[size];
        }

        MyPipedInputStream(PipedOutputStream out) throws IOException {
            super(out);
        }

        MyPipedInputStream(PipedOutputStream out, int size) throws IOException {
            super(out);
            this.buffer = new byte[size];
        }
    }

    class PassiveInputStream
    extends MyPipedInputStream {
        PipedOutputStream out;

        PassiveInputStream(PipedOutputStream out, int size) throws IOException {
            super(out, size);
            this.out = out;
        }

        PassiveInputStream(PipedOutputStream out) throws IOException {
            super(out);
            this.out = out;
        }

        public void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    class PassiveOutputStream
    extends PipedOutputStream {
        PassiveOutputStream(PipedInputStream in) throws IOException {
            super(in);
        }
    }
}

