/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.Constants;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.p2.extensionlocation.SiteListener;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.spi.p2.core.repository.AbstractRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ExtensionLocationArtifactRepository
extends AbstractRepository
implements IFileArtifactRepository,
Constants {
    public static final String TYPE = "org.eclipse.equinox.p2.extensionlocation.artifactRepository";
    public static final Integer VERSION = new Integer(1);
    IFileArtifactRepository artifactRepository;
    private File base;
    private Object state = SiteListener.UNINITIALIZED;

    public static URL getLocalRepositoryLocation(URL location) {
        BundleContext context = Activator.getContext();
        String stateDirName = Integer.toString(location.toExternalForm().hashCode());
        File bundleData = context.getDataFile(null);
        File stateDir = new File(bundleData, stateDirName);
        try {
            return stateDir.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ExtensionLocationArtifactRepository(URL location, IFileArtifactRepository repository, IProgressMonitor monitor) throws ProvisionException {
        super(Activator.getRepositoryName(location), TYPE, VERSION.toString(), location, null, null, null);
        this.artifactRepository = repository;
        this.base = ExtensionLocationArtifactRepository.getBaseDirectory(location);
    }

    public synchronized void ensureInitialized() {
        if (this.state == SiteListener.INITIALIZED || this.state == SiteListener.INITIALIZING) {
            return;
        }
        SiteListener.synchronizeRepositories(null, this, this.base);
    }

    void reload() {
        try {
            ExtensionLocationArtifactRepository repo = (ExtensionLocationArtifactRepository)new ExtensionLocationArtifactRepositoryFactory().load(this.getLocation(), null);
            this.artifactRepository = repo.artifactRepository;
            this.base = repo.base;
        }
        catch (ProvisionException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    void state(Object value) {
        this.state = value;
    }

    public static void validate(URL location, IProgressMonitor monitor) throws ProvisionException {
        File base = ExtensionLocationArtifactRepository.getBaseDirectory(location);
        if (new File(base, ".eclipseextension").exists()) {
            return;
        }
        if (ExtensionLocationArtifactRepository.containsUpdateSiteFile(base)) {
            String message = NLS.bind((String)Messages.error_update_site, (Object)location.toExternalForm());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, message, null));
        }
    }

    private static boolean containsUpdateSiteFile(File base) {
        String[] fileNames = base.list();
        if (fileNames == null) {
            return false;
        }
        int i = 0;
        while (i < fileNames.length) {
            if (fileNames[i].endsWith(".xml") && fileNames[i].indexOf("site") != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static File getBaseDirectory(URL url) throws ProvisionException {
        File base;
        if (!"file".equals(url.getProtocol())) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, Messages.not_file_protocol, null));
        }
        String path = url.getPath();
        if (path.endsWith(".eclipseextension")) {
            path = path.substring(0, path.length() - ".eclipseextension".length());
        }
        if (!(base = new File(path)).isDirectory()) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_directory, (Object)url.toExternalForm()), null));
        }
        if (ExtensionLocationArtifactRepository.isBaseDirectory(base)) {
            return base;
        }
        File eclipseBase = new File(base, "eclipse");
        if (ExtensionLocationArtifactRepository.isBaseDirectory(eclipseBase)) {
            return eclipseBase;
        }
        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_eclipse_extension, (Object)url.toExternalForm()), null));
    }

    private static boolean isBaseDirectory(File base) {
        File plugins = new File(base, "plugins");
        File features = new File(base, "features");
        return plugins.isDirectory() || features.isDirectory();
    }

    public void addDescriptor(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    public void addDescriptors(IArtifactDescriptor[] descriptors) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public void removeDescriptor(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    public void removeDescriptor(IArtifactKey key) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        this.ensureInitialized();
        return this.artifactRepository.contains(descriptor);
    }

    public boolean contains(IArtifactKey key) {
        this.ensureInitialized();
        return this.artifactRepository.contains(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifact(descriptor, destination, monitor);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifactDescriptors(key);
    }

    public IArtifactKey[] getArtifactKeys() {
        this.ensureInitialized();
        return this.artifactRepository.getArtifactKeys();
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifacts(requests, monitor);
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        this.ensureInitialized();
        return this.artifactRepository.getOutputStream(descriptor);
    }

    public File getArtifactFile(IArtifactKey key) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifactFile(key);
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifactFile(descriptor);
    }

    public Map getProperties() {
        this.ensureInitialized();
        return this.artifactRepository.getProperties();
    }

    public String setProperty(String key, String value) {
        this.ensureInitialized();
        return this.artifactRepository.setProperty(key, value);
    }
}

