/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.Constants;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.p2.extensionlocation.SiteListener;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.AbstractMetadataRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ExtensionLocationMetadataRepository
extends AbstractMetadataRepository
implements Constants {
    public static final String TYPE = "org.eclipse.equinox.p2.extensionlocation.metadataRepository";
    public static final Integer VERSION = new Integer(1);
    IMetadataRepository metadataRepository;
    private File base;
    private Object state = SiteListener.UNINITIALIZED;

    public static URL getLocalRepositoryLocation(URL location) {
        BundleContext context = Activator.getContext();
        String stateDirName = Integer.toString(location.toExternalForm().hashCode());
        File bundleData = context.getDataFile(null);
        File stateDir = new File(bundleData, stateDirName);
        try {
            return stateDir.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ExtensionLocationMetadataRepository(URL location, IMetadataRepository repository, IProgressMonitor monitor) throws ProvisionException {
        super(Activator.getRepositoryName(location), TYPE, VERSION.toString(), location, null, null, null);
        this.metadataRepository = repository;
        this.base = ExtensionLocationMetadataRepository.getBaseDirectory(location);
    }

    public synchronized void ensureInitialized() {
        if (this.state == SiteListener.INITIALIZED || this.state == SiteListener.INITIALIZING) {
            return;
        }
        SiteListener.synchronizeRepositories(this, null, this.base);
    }

    void reload() {
        try {
            ExtensionLocationMetadataRepository repo = (ExtensionLocationMetadataRepository)new ExtensionLocationMetadataRepositoryFactory().load(this.getLocation(), null);
            this.metadataRepository = repo.metadataRepository;
            this.base = repo.base;
        }
        catch (ProvisionException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    void state(Object value) {
        this.state = value;
    }

    public void addInstallableUnits(IInstallableUnit[] installableUnits) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public boolean removeInstallableUnits(Query query, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        this.ensureInitialized();
        return this.metadataRepository.query(query, collector, monitor);
    }

    public static void validate(URL location, IProgressMonitor monitor) throws ProvisionException {
        File base = ExtensionLocationMetadataRepository.getBaseDirectory(location);
        if (new File(base, ".eclipseextension").exists()) {
            return;
        }
        if (ExtensionLocationMetadataRepository.containsUpdateSiteFile(base)) {
            String message = NLS.bind((String)Messages.error_update_site, (Object)location.toExternalForm());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, message, null));
        }
    }

    private static boolean containsUpdateSiteFile(File base) {
        String[] fileNames = base.list();
        if (fileNames == null) {
            return false;
        }
        int i = 0;
        while (i < fileNames.length) {
            if (fileNames[i].endsWith(".xml") && fileNames[i].indexOf("site") != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static File getBaseDirectory(URL url) throws ProvisionException {
        File base;
        if (!"file".equals(url.getProtocol())) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, Messages.not_file_protocol, null));
        }
        String path = url.getPath();
        if (path.endsWith(".eclipseextension")) {
            path = path.substring(0, path.length() - ".eclipseextension".length());
        }
        if (!(base = new File(path)).isDirectory()) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_directory, (Object)url.toExternalForm()), null));
        }
        if (ExtensionLocationMetadataRepository.isBaseDirectory(base)) {
            return base;
        }
        File eclipseBase = new File(base, "eclipse");
        if (ExtensionLocationMetadataRepository.isBaseDirectory(eclipseBase)) {
            return eclipseBase;
        }
        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_eclipse_extension, (Object)url.toExternalForm()), null));
    }

    private static boolean isBaseDirectory(File base) {
        File plugins = new File(base, "plugins");
        File features = new File(base, "features");
        return plugins.isDirectory() || features.isDirectory();
    }

    public Map getProperties() {
        this.ensureInitialized();
        return this.metadataRepository.getProperties();
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
    }

    public String setProperty(String key, String value) {
        this.ensureInitialized();
        return this.metadataRepository.setProperty(key, value);
    }
}

