/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.dialogs.JdbcDriverManagerDialog;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverInfo;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JDBCDriverInfoManager;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JDBCDriverInformation;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JarFile;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JdbcDriverConfigUtil;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.ui.PlatformUI;

public class JdbcToolKit {
    private static List jdbcDriverInfos = null;
    private static List failLoadFileList = null;
    private static HashMap driverNameMap = null;
    private static Hashtable file2Drivers = null;
    private static final Class DriverClass = Driver.class;

    public static void resetJdbcDriverNames() {
        jdbcDriverInfos = null;
        failLoadFileList = null;
        driverNameMap = null;
        file2Drivers = null;
    }

    public static void getJdbcDriverFromFile(List fileList) {
        if (failLoadFileList != null) {
            int i = 0;
            while (i < failLoadFileList.size()) {
                boolean duplicated = false;
                File failToLoadFile = (File)failLoadFileList.get(i);
                int j = 0;
                while (j < fileList.size()) {
                    if (failToLoadFile.getName().equals(((File)fileList.get(j)).getName())) {
                        duplicated = true;
                        break;
                    }
                    ++j;
                }
                if (!duplicated) {
                    fileList.add(failToLoadFile);
                }
                ++i;
            }
        }
        jdbcDriverInfos.addAll(JdbcToolKit.getJDBCDriverInfoList(fileList));
    }

    public static List getJdbcDriversFromODADir(String driverName) {
        if (jdbcDriverInfos != null) {
            if (!driverNameMap.containsValue(jdbcDriverInfos.get(0))) {
                jdbcDriverInfos.remove(0);
            }
            if (JdbcDriverManagerDialog.needResetPreferences()) {
                JdbcToolKit.resetPreferences();
                JdbcDriverManagerDialog.resetDriverChangedStatus();
            }
            return JdbcToolKit.getDriverList();
        }
        jdbcDriverInfos = new ArrayList();
        failLoadFileList = new ArrayList();
        driverNameMap = new HashMap();
        file2Drivers = new Hashtable();
        JdbcToolKit.addDriversFromFiles();
        JDBCDriverInformation ODBCJDBCInfo = null;
        JDBCDriverInformation[] driverInfos = JDBCDriverInfoManager.getDrivers();
        int i = 0;
        while (i < driverInfos.length) {
            JDBCDriverInformation newInfo = driverInfos[i];
            JDBCDriverInformation existing = (JDBCDriverInformation)driverNameMap.get(newInfo.getDriverClassName());
            if (existing == null) {
                if (newInfo.getDriverClassName().equalsIgnoreCase("sun.jdbc.odbc.JdbcOdbcDriver")) {
                    ODBCJDBCInfo = newInfo;
                } else {
                    jdbcDriverInfos.add(newInfo);
                    driverNameMap.put(newInfo.getDriverClassName(), newInfo);
                }
            } else {
                existing.setDisplayName(newInfo.getDisplayName());
                existing.setUrlFormat(newInfo.getUrlFormat());
            }
            ++i;
        }
        if (ODBCJDBCInfo != null) {
            jdbcDriverInfos.add(ODBCJDBCInfo);
            driverNameMap.put(ODBCJDBCInfo.getDriverClassName(), ODBCJDBCInfo);
        }
        JdbcToolKit.resetPreferences();
        return JdbcToolKit.getDriverList();
    }

    private static void resetPreferences() {
        Map preferenceMap = Utility.getPreferenceStoredMap("JDBC Driver Map");
        for (JDBCDriverInformation info : jdbcDriverInfos) {
            Object ob = preferenceMap.get(info.toString());
            if (ob == null) continue;
            DriverInfo driverInfo = (DriverInfo)ob;
            if (driverInfo.getDisplayName() != null && driverInfo.getDisplayName().length() >= 0) {
                info.setDisplayName(driverInfo.getDisplayName());
            }
            if (driverInfo.getUrlTemplate() == null || driverInfo.getUrlTemplate().length() < 0) continue;
            info.setUrlFormat(driverInfo.getUrlTemplate());
        }
    }

    private static List getJDBCDriverInfoList(List fileList) {
        ArrayList<JDBCDriverInformation> driverList = new ArrayList<JDBCDriverInformation>();
        int i = 0;
        while (i < fileList.size()) {
            URLClassLoader urlClassLoader = JdbcToolKit.createClassLoader((File)fileList.get(i));
            String[] resourceNames = JdbcToolKit.getAllResouceNames((File)fileList.get(i));
            ArrayList<JDBCDriverInformation> subDriverList = new ArrayList<JDBCDriverInformation>();
            int j = 0;
            while (j < resourceNames.length) {
                JDBCDriverInformation info;
                Class aClass;
                String resourceName = resourceNames[j];
                if (resourceName.endsWith(".class") && JdbcToolKit.isImplementedDriver(aClass = JdbcToolKit.loadClass(urlClassLoader, resourceName = JdbcToolKit.modifyResourceName(resourceName))) && (info = JDBCDriverInformation.newInstance(aClass)) != null) {
                    driverList.add(info);
                    subDriverList.add(info);
                }
                ++j;
            }
            if (subDriverList.isEmpty()) {
                if (!failLoadFileList.contains(fileList.get(i))) {
                    failLoadFileList.add(fileList.get(i));
                }
            } else if (failLoadFileList.contains(fileList.get(i))) {
                failLoadFileList.remove(fileList.get(i));
            }
            file2Drivers.put(((File)fileList.get(i)).getName(), subDriverList);
            ++i;
        }
        return driverList;
    }

    public static void addToDriverList(List fileList) {
        if (fileList != null && fileList.size() != 0) {
            JdbcToolKit.getJdbcDriverFromFile(fileList);
        }
    }

    public static void removeFromDriverList(List fileList) {
        int i = 0;
        while (i < fileList.size()) {
            String fileName = ((File)fileList.get(i)).getName();
            List driverNames = (List)file2Drivers.get(fileName);
            int j = 0;
            while (j < jdbcDriverInfos.size()) {
                int k = 0;
                while (k < driverNames.size()) {
                    if (((JDBCDriverInformation)jdbcDriverInfos.get(j)).getDriverClassName().equals(((JDBCDriverInformation)driverNames.get(k)).getDriverClassName())) {
                        jdbcDriverInfos.remove(j);
                    }
                    ++k;
                }
                ++j;
            }
            if (failLoadFileList.contains(fileList.get(i))) {
                failLoadFileList.remove(fileList.get(i));
            }
            ++i;
        }
    }

    public static List getDriverList() {
        HashSet jdbcDriverSet = new HashSet();
        int i = 0;
        while (i < jdbcDriverInfos.size()) {
            jdbcDriverSet.add(jdbcDriverInfos.get(i));
            ++i;
        }
        return new ArrayList(jdbcDriverSet);
    }

    private static String modifyResourceName(String resourceName) {
        resourceName = resourceName.replaceAll("/", ".").substring(0, resourceName.length() - 6);
        return resourceName;
    }

    public static List getDriverByJar(JarFile jar) {
        List drivers = null;
        if (jar == null) {
            return drivers;
        }
        ArrayList<File> jarList = new ArrayList<File>(1);
        jarList.add(new File(jar.getFilePath()));
        drivers = JdbcToolKit.getJDBCDriverInfoList(jarList);
        return drivers;
    }

    private static void addDriversFromFiles() {
        List jdbcDriverFiles = JdbcDriverConfigUtil.getDriverFiles();
        if (jdbcDriverFiles == null || jdbcDriverFiles.size() == 0) {
            return;
        }
        List driverList = JdbcToolKit.getJDBCDriverInfoList(jdbcDriverFiles);
        jdbcDriverInfos.addAll(driverList);
        int i = 0;
        while (i < driverList.size()) {
            JDBCDriverInformation info = (JDBCDriverInformation)driverList.get(i);
            driverNameMap.put(info.getDriverClassName(), info);
            ++i;
        }
    }

    private static URLClassLoader createClassLoader(File jdbcDriverFile) {
        URL[] urlList = new URL[1];
        try {
            urlList[0] = new URL("file", null, jdbcDriverFile.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urlList, ClassLoader.getSystemClassLoader());
        return urlClassLoader;
    }

    private static Class loadClass(URLClassLoader urlClassLoader, String resourceName) {
        Class<?> aClass = null;
        try {
            aClass = urlClassLoader.loadClass(resourceName);
        }
        catch (Throwable throwable) {}
        return aClass;
    }

    private static boolean isImplementedDriver(Class aClass) {
        return aClass != null && JdbcToolKit.implementsSQLDriverClass(aClass) && !Modifier.isAbstract(aClass.getModifiers());
    }

    private static String[] getAllResouceNames(File jarFile) {
        ArrayList<String> jarEntries = new ArrayList<String>();
        try {
            ZipFile zf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) continue;
                jarEntries.add(ze.getName());
            }
            zf.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
        }
        return jarEntries.toArray(new String[jarEntries.size()]);
    }

    private static boolean implementsSQLDriverClass(Class aClass) {
        return DriverClass.isAssignableFrom(aClass);
    }
}

