/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import com.lowagie.text.pdf.BaseFont;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.wpml.EmitterContext;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.emitter.wpml.WpmlWriter;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.font.FontSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.engine.util.FlashFile;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.w3c.dom.css.CSSValue;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordEmitterImpl {
    protected static Logger logger = Logger.getLogger(WordEmitterImpl.class.getName());
    protected OutputStream out = null;
    IEmitterServices eservice = null;
    protected ContentEmitterVisitor contentVisitor;
    WpmlWriter writer = null;
    public static final String OUTPUT_FORMAT = "doc";
    private int pageWidth = 0;
    private int pageHeight = 0;
    private int contentHeight = 0;
    private int contentWidth = 0;
    private int headerHeight = 0;
    private int footerHeight = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private boolean firstBg = true;
    private String orientation = "portrait";
    private EmitterContext context = null;
    private IPageContent page = null;
    private Stack<IStyle> styles = new Stack();
    private Stack<IStyle> inlineStyles = new Stack();
    private Vector cacheCells = new Vector();
    static final int NORMAL = -1;
    private static int firstPage = 0;
    private static int normalPage = 1;
    private int pageStatus;
    private HashSet marks = new HashSet();
    boolean rowFilledFlag = false;
    private ArrayList groupIdList = new ArrayList();
    private IReportContent reportContent;
    private static IGroupContent groupContent = null;
    private static boolean inForeign = false;
    private static boolean hasPInside = false;
    private int tocLevel = 1;

    public WordEmitterImpl(ContentEmitterVisitor contentVisitor) {
        this.contentVisitor = contentVisitor;
    }

    public void initialize(IEmitterServices service) {
        this.eservice = service;
        if (service != null) {
            this.out = EmitterUtil.getOuputStream((IEmitterServices)service, (String)"report.doc");
        }
        this.writer = new WpmlWriter(this.out);
        this.context = new EmitterContext();
    }

    public String getOutputFormat() {
        return OUTPUT_FORMAT;
    }

    public void startPage(IPageContent page) {
        if (this.page != null) {
            this.completePrePage(this.page);
            this.pageStatus = normalPage;
            this.context.resetWidth();
        } else {
            this.pageStatus = firstPage;
            if (this.reportContent != null) {
                IContent rootContent = this.reportContent.getRoot();
                if (rootContent != null && rootContent.isRTL()) {
                    this.writer.start(this.reportContent, true);
                } else {
                    this.writer.start(this.reportContent, false);
                }
            } else {
                this.writer.start(this.reportContent, false);
            }
        }
        this.page = page;
        this.accountPageProp(page);
        this.context.addWidth(this.contentWidth);
        this.writer.startPg();
    }

    public void completePrePage(IPageContent page) {
        this.adjustInline();
        this.writer.startPageBreak();
        this.writeSection(page);
        this.writer.endPageBreak();
        this.writer.endPg();
        this.handlePageBg();
    }

    private void handlePageBg() {
        if (this.firstBg) {
            IStyle style = this.page.getStyle();
            String bgcolor = style.getBackgroundColor();
            String bgimg = style.getBackgroundImage();
            if (bgimg != null) {
                try {
                    File file = new File(bgimg);
                    byte[] img = this.getImage(new FileInputStream(file));
                    Base64 base = new Base64();
                    byte[] pic2Text = base.encode(img);
                    this.writer.writePageBackground("image", new String(pic2Text));
                    this.firstBg = false;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Can not get background image");
                }
            } else if (bgcolor != null && !"transparent".equalsIgnoreCase(bgcolor)) {
                this.writer.writePageBackground("color", bgcolor);
                this.firstBg = false;
            }
        }
    }

    public void end(IReportContent report) {
        this.adjustInline();
        this.writeSection(this.page);
        this.writer.endPg();
        this.handlePageBg();
        this.writer.end();
    }

    private void increaseTOCLevel(IContent content) {
        if (content != null && content.getTOC() != null) {
            ++this.tocLevel;
        }
    }

    private void decreaseTOCLevel(IContent content) {
        if (content != null && content.getTOC() != null) {
            --this.tocLevel;
        }
    }

    public void writeSection(IPageContent page) {
        this.accountPageProp(page);
        this.writer.startSection();
        if (this.pageStatus == firstPage) {
            this.writeHeaderFooter();
        }
        this.writer.writePgProp(this.pageHeight, this.pageWidth, this.headerHeight, this.footerHeight, this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin, this.orientation);
        this.writer.endSection();
    }

    public void writeHeaderFooter() {
        SimpleMasterPageDesign master = (SimpleMasterPageDesign)this.page.getReportContent().getDesign().getPageSetup().getMasterPage(0);
        if (!master.isShowHeaderOnFirst()) {
            this.writer.startHeader(true);
        } else {
            this.writer.startHeader(false);
        }
        if (this.page.getPageHeader() != null) {
            this.contentVisitor.visitChildren(this.page.getPageHeader(), null);
        }
        this.writer.endHeader();
        this.writer.startFooter();
        if (this.page.getPageFooter() != null) {
            this.contentVisitor.visitChildren(this.page.getPageFooter(), null);
        }
        this.writer.endFooter();
    }

    public void accountPageProp(IPageContent page) {
        this.pageWidth = WordUtil.convertTo(page.getPageWidth(), 0);
        this.pageHeight = WordUtil.convertTo(page.getPageHeight(), 0);
        this.footerHeight = WordUtil.convertTo(page.getFooterHeight(), 0);
        this.headerHeight = WordUtil.convertTo(page.getHeaderHeight(), 0);
        this.topMargin = WordUtil.convertTo(page.getMarginTop(), 0);
        this.bottomMargin = WordUtil.convertTo(page.getMarginBottom(), 0);
        this.contentHeight = this.pageHeight - this.headerHeight - this.footerHeight - this.topMargin - this.bottomMargin;
        this.leftMargin = WordUtil.convertTo(page.getMarginLeft(), 0);
        this.rightMargin = WordUtil.convertTo(page.getMarginRight(), 0);
        this.contentWidth = this.pageWidth - this.leftMargin - this.rightMargin;
        this.orientation = page.getOrientation();
    }

    public void endCell(ICellContent cell) {
        this.adjustInline();
        this.context.removeWidth();
        this.writer.endTblCell(this.context.needEmptyP());
        this.context.endCell();
    }

    public void endContainer(IContainerContent container) {
        boolean flag = this.hasForeignParent(container);
        if (flag) {
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.adjustInline();
            }
            if (!this.styles.isEmpty()) {
                this.styles.pop();
            }
            if (!this.inlineStyles.isEmpty()) {
                this.inlineStyles.pop();
            }
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                if (inForeign && hasPInside) {
                    this.context.addContainer(false);
                    hasPInside = false;
                } else {
                    this.context.addContainer(true);
                }
                this.context.setLast(true);
            }
        }
    }

    private boolean hasForeignParent(IContainerContent container) {
        boolean flag = false;
        IContainerContent con = container;
        while (con != null) {
            if (con.getParent() instanceof IForeignContent) {
                flag = true;
                break;
            }
            con = (IContainerContent)con.getParent();
        }
        return flag;
    }

    public void startContainer(IContainerContent container) {
        boolean flag = this.hasForeignParent(container);
        if (flag) {
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.adjustInline();
            }
            if (this.context.isLastTable()) {
                this.writer.insertHiddenP();
            }
            if (!"inline".equalsIgnoreCase(container.getComputedStyle().getDisplay())) {
                this.styles.push(container.getComputedStyle());
            } else {
                this.inlineStyles.push(container.getComputedStyle());
            }
        }
    }

    public void endContent(IContent content) {
    }

    public void endGroup(IGroupContent group) {
    }

    public void endList(IListContent list) {
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.context.addContainer(true);
        this.writer.endTable();
        this.context.setLast(true);
        this.decreaseTOCLevel((IContent)list);
    }

    public void endListBand(IListBandContent listBand) {
        this.adjustInline();
        this.context.endCell();
        this.writer.endTblCell(true);
        this.writer.endTblRow();
    }

    public void endListGroup(IListGroupContent group) {
    }

    public void endPage(IPageContent page) {
    }

    public void endRow(IRowContent row) {
        if (!this.isHidden((IContent)row)) {
            int col;
            List spans;
            if (!this.styles.isEmpty()) {
                this.styles.pop();
            }
            if ((spans = this.context.getSpans(col = this.context.getCurrentTblCols().length - 1)) != null) {
                int spanSize = spans.size();
                if (spanSize > 0) {
                    this.rowFilledFlag = true;
                }
                int i = 0;
                while (i < spanSize) {
                    this.writer.writeSpanCell((SpanInfo)spans.get(i));
                    ++i;
                }
            }
            if (!this.rowFilledFlag) {
                this.writer.writeEmptyCell();
                this.rowFilledFlag = true;
            }
            this.writer.endTblRow();
            IGroupContent group = row.getGroup();
            this.decreaseTOCLevel((IContent)group);
        }
    }

    public void endTable(ITableContent table) {
        this.context.addContainer(true);
        hasPInside = false;
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.writer.endTable();
        this.context.setLast(true);
        this.context.removeTable();
        this.decreaseTOCLevel((IContent)table);
    }

    public void endTableBand(ITableBandContent band) {
    }

    public void endTableGroup(ITableGroupContent group) {
    }

    public void start(IReportContent report) {
        this.reportContent = report;
    }

    public void startAutoText(IAutoTextContent autoText) {
        this.writeContent(autoText.getType(), null, (IContent)autoText);
    }

    public void startCell(ICellContent cell) {
        this.rowFilledFlag = true;
        this.context.startCell();
        int col = cell.getColumn();
        List spans = this.context.getSpans(col);
        if (spans != null) {
            int i = 0;
            while (i < spans.size()) {
                this.writer.writeSpanCell((SpanInfo)spans.get(i));
                ++i;
            }
        }
        int cs = cell.getColSpan();
        int rs = cell.getRowSpan();
        int cw = this.context.getCellWidth(col, cs);
        IStyle style = this.computeStyle(cell.getComputedStyle());
        if (rs > 1) {
            this.context.addSpan(col, cs, cw, rs, style);
            this.cacheCells.add(new SpanCell(cell, rs, col, cw, style));
        }
        SpanInfo info = null;
        if (cs > 1 || rs > 1) {
            info = new SpanInfo(col, cs, cw, true, style);
        }
        this.writer.startTblCell(cw, style, info);
        this.context.addWidth(WordUtil.getWidth(cw, style));
    }

    private IStyle computeStyle(IStyle style) {
        if (this.styles.size() == 0) {
            return style;
        }
        int i = 0;
        while (i < 60) {
            if (this.isHeritProperty(i) && this.isNullValue(style.getProperty(i))) {
                style.setProperty(i, null);
                int p = this.styles.size() - 1;
                while (p >= 0) {
                    IStyle pstyle = (IStyle)this.styles.get(p);
                    if (!this.isNullValue(pstyle.getProperty(i))) {
                        style.setProperty(i, pstyle.getProperty(i));
                        break;
                    }
                    --p;
                }
            }
            ++i;
        }
        return style;
    }

    private boolean isNullValue(CSSValue value) {
        String[] nullvals = new String[]{"none", "transparent"};
        if (value == null) {
            return true;
        }
        int i = 0;
        while (i < nullvals.length) {
            if (nullvals[i].equalsIgnoreCase(value.getCssText())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isHeritProperty(int p) {
        int[] ignores = new int[]{8, 11, 22, 13, 9, 57, 41, 43, 51, 7, 10, 21};
        int i = 0;
        while (i < ignores.length) {
            if (p == ignores[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void startContent(IContent content) {
    }

    public void startData(IDataContent data) {
        this.writeContent(-1, data.getText(), (IContent)data);
    }

    public void startForeign(IForeignContent foreign) {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            inForeign = true;
            boolean inlineBrother = this.context.isInline();
            this.context.endInline();
            this.writeToc((IContent)foreign);
            HTML2Content.html2Content((IForeignContent)foreign);
            this.context.startCell();
            if (this.context.isLastTable()) {
                this.writer.insertHiddenP();
            }
            this.writer.startTable(foreign.getComputedStyle(), this.context.getCurrentWidth());
            this.writer.startTblRow(-1.0);
            this.writer.startTblCell(this.context.getCurrentWidth(), foreign.getComputedStyle(), null);
            this.contentVisitor.visitChildren((IContent)foreign, null);
            this.adjustInline();
            this.writer.endTblCell(this.context.needEmptyP());
            this.context.endCell();
            this.writer.endTblRow();
            this.writer.endTable();
            this.context.setLast(true);
            this.context.addContainer(true);
            hasPInside = false;
            if (inlineBrother) {
                this.context.startInline();
            }
            inForeign = false;
        } else {
            Object rawValue = foreign.getRawValue();
            String text = rawValue == null ? "" : rawValue.toString();
            this.writeContent(-1, text, (IContent)foreign);
        }
    }

    public void startGroup(IGroupContent group) {
    }

    public void startImage(IImageContent image) {
        String uri = image.getURI();
        String mimeType = image.getMIMEType();
        String extension = image.getExtension();
        boolean inline = false;
        boolean first_inline = false;
        IStyle style = image.getComputedStyle();
        if ("inline".equalsIgnoreCase(style.getDisplay())) {
            if (!this.context.isInline()) {
                this.context.startInline();
                first_inline = true;
            }
            inline = true;
        } else {
            this.adjustInline();
        }
        if (FlashFile.isFlash((String)mimeType, (String)uri, (String)extension)) {
            this.writer.drawImage(null, 0.0, 0.0, null, style, inline, first_inline, image.getAltText());
            return;
        }
        byte[] data = this.parseImage(image);
        if (data == null) {
            this.writer.drawImage(null, 0.0, 0.0, null, style, inline, first_inline, image.getAltText());
            return;
        }
        int defaultW = 0;
        int defaultH = 0;
        try {
            BufferedImage imageData = ImageIO.read(new ByteArrayInputStream(data));
            if (imageData != null) {
                defaultW = ((Image)imageData).getWidth(null);
                defaultH = ((Image)imageData).getHeight(null);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        double height = WordUtil.convertImageSize(image.getHeight(), defaultH);
        double width = WordUtil.convertImageSize(image.getWidth(), defaultW);
        String pic2Text = new BASE64Encoder().encode(data);
        this.writeBookmark((IContent)image);
        this.writeToc((IContent)image);
        HyperlinkInfo hyper = this.getHyperlink((IContent)image);
        this.writer.drawImage(pic2Text, height, width, hyper, style, inline, first_inline, image.getAltText());
    }

    public void startLabel(ILabelContent label) {
        String txt = label.getText() == null ? label.getLabelText() : label.getText();
        label.getComputedStyle().getMarginTop();
        label.getComputedStyle().getMarginBottom();
        txt = txt == null ? "" : txt;
        this.writeContent(-1, txt, (IContent)label);
    }

    private IReportContext getReportContext() {
        if (this.eservice != null) {
            return this.eservice.getReportContext();
        }
        return null;
    }

    public void startList(IListContent list) {
        this.adjustInline();
        this.styles.push(list.getComputedStyle());
        this.writeBookmark((IContent)list);
        this.writeToc((IContent)list);
        this.increaseTOCLevel((IContent)list);
        if (this.context.isLastTable()) {
            this.writer.insertHiddenP();
        }
        this.writer.startTable(list.getComputedStyle(), this.context.getCurrentWidth());
    }

    public void startListBand(IListBandContent listBand) {
        this.context.startCell();
        this.writer.startTblRow(-1.0);
        IStyle style = this.computeStyle(listBand.getComputedStyle());
        this.writer.startTblCell(this.context.getCurrentWidth(), style, null);
    }

    public void startListGroup(IListGroupContent group) {
    }

    public void startRow(IRowContent row) {
        if (!this.isHidden((IContent)row)) {
            this.rowFilledFlag = false;
            boolean isHeader = false;
            this.styles.push(row.getComputedStyle());
            if (row.getBand() != null && row.getBand().getBandType() == 1) {
                isHeader = true;
            }
            double height = WordUtil.convertTo(row.getHeight());
            this.writer.startTblRow(height, isHeader, row.getTable().isHeaderRepeat());
            if (row.getGroup() != null) {
                InstanceID rowGroupId = row.getGroup().getInstanceID();
                if (!this.groupIdList.contains(rowGroupId)) {
                    this.groupIdList.add(rowGroupId);
                    groupContent = row.getGroup();
                    this.writeToc((IContent)groupContent);
                    this.increaseTOCLevel((IContent)groupContent);
                } else {
                    this.increaseTOCLevel((IContent)row.getGroup());
                }
            }
            this.context.newRow();
        }
    }

    protected boolean isHidden(IContent content) {
        if (content != null) {
            IStyle style = content.getStyle();
            if (!IStyle.NONE_VALUE.equals(style.getProperty(33))) {
                return this.isHiddenByVisibility(content);
            }
            return true;
        }
        return false;
    }

    private boolean isHiddenByVisibility(IContent content) {
        assert (content != null);
        IStyle style = content.getStyle();
        String formats = style.getVisibleFormat();
        return this.contains(formats, OUTPUT_FORMAT);
    }

    private boolean contains(String formats, String format) {
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0 || formats.indexOf(format) >= 0);
    }

    public void startTable(ITableContent table) {
        this.adjustInline();
        this.styles.push(table.getComputedStyle());
        IStyle style = table.getComputedStyle();
        this.writeBookmark((IContent)table);
        this.writeToc((IContent)table);
        this.increaseTOCLevel((IContent)table);
        String caption = table.getCaption();
        if (caption != null) {
            this.writer.writeCaption(caption);
        }
        if (this.context.isLastTable()) {
            this.writer.insertHiddenP();
        }
        int tblWid = WordUtil.convertTo(table.getWidth(), this.context.getCurrentWidth());
        tblWid = Math.min(tblWid, this.context.getCurrentWidth());
        this.writer.startTable(table.getComputedStyle(), tblWid);
        int colCount = table.getColumnCount();
        int[] cols = new int[colCount];
        int count = 0;
        int total = 0;
        int i = 0;
        while (i < colCount) {
            IColumn col = table.getColumn(i);
            if (col.getWidth() == null) {
                cols[i] = -1;
                ++count;
            } else {
                cols[i] = WordUtil.convertTo(col.getWidth(), tblWid);
                total += cols[i];
            }
            ++i;
        }
        i = 0;
        while (i < cols.length) {
            if (cols[i] == -1) {
                cols[i] = (tblWid - total) / count;
            }
            ++i;
        }
        this.writer.writeCol(cols);
        this.context.addTable(cols, style);
    }

    public void startTableBand(ITableBandContent band) {
    }

    public void startTableGroup(ITableGroupContent group) {
    }

    public void startText(ITextContent text) {
        this.writeContent(-1, text.getText(), (IContent)text);
    }

    private void writeToc(IContent content) {
        Object tocObj;
        if (content != null && (tocObj = content.getTOC()) != null) {
            String toc = tocObj.toString();
            if (!"".equals(toc = toc.trim())) {
                this.writer.writeTC(toc, this.tocLevel);
            }
        }
    }

    private void writeBookmark(IContent content) {
        Object design = content.getGenerateBy();
        if (this.marks.contains(design)) {
            return;
        }
        String bookmark = content.getBookmark();
        if (bookmark == null || bookmark.toLowerCase().indexOf("_toc") > 0) {
            return;
        }
        bookmark = bookmark.replaceAll(" ", "_");
        this.writer.writeBookmark(bookmark);
        this.marks.add(design);
    }

    private HyperlinkInfo getHyperlink(IContent content) {
        IHyperlinkAction linkaction = content.getHyperlinkAction();
        HyperlinkInfo hyper = null;
        if (linkaction != null) {
            String toolTip = linkaction.getTooltip();
            if (linkaction.getType() == 2) {
                String bookmark = linkaction.getBookmark().replaceAll(" ", "_");
                hyper = new HyperlinkInfo(HyperlinkInfo.BOOKMARK, bookmark, toolTip);
            } else if (linkaction.getType() == 1) {
                hyper = new HyperlinkInfo(HyperlinkInfo.HYPERLINK, linkaction.getHyperlink(), toolTip);
            } else if (linkaction.getType() == 3) {
                IReportRunnable reportRunnable = this.eservice.getReportRunnable();
                String systemId = null;
                if (reportRunnable != null) {
                    systemId = reportRunnable.getReportName();
                }
                Action act = new Action(systemId, linkaction);
                IHTMLActionHandler actionHandler = null;
                Object ac = this.eservice.getOption("actionHandler");
                if (ac != null && ac instanceof IHTMLActionHandler) {
                    actionHandler = (IHTMLActionHandler)ac;
                    String url = actionHandler.getURL((IAction)act, this.getReportContext());
                    hyper = act.getBookmark() == null ? new HyperlinkInfo(HyperlinkInfo.HYPERLINK, url, toolTip) : new HyperlinkInfo(HyperlinkInfo.HYPERLINK, url, act.getBookmark());
                }
            }
        }
        return hyper;
    }

    private byte[] getImage(InputStream is) throws Exception {
        int cnt;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((cnt = is.read(buf)) >= 0) {
            baos.write(buf, 0, cnt);
        }
        is.close();
        baos.close();
        return baos.toByteArray();
    }

    private byte[] parseImage(IImageContent image) {
        byte[] data;
        block20: {
            data = null;
            InputStream in = null;
            String uri = image.getURI();
            int source = image.getImageSource();
            try {
                try {
                    if (3 == source || source == 0) {
                        if (uri != null) {
                            URL url = new URL(uri);
                            in = url.openStream();
                            data = SvgFile.isSvg((String)uri) ? SvgFile.transSvgToArray((InputStream)in) : this.getImage(in);
                        }
                    } else if (source == 2 || source == 1) {
                        if (SvgFile.isSvg((String)image.getMIMEType(), (String)uri, (String)image.getExtension())) {
                            in = new ByteArrayInputStream(image.getData());
                            data = SvgFile.transSvgToArray((InputStream)in);
                        } else {
                            data = image.getData();
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage());
                    if (in != null) {
                        try {
                            in.close();
                            in = null;
                        }
                        catch (Exception exception) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (Exception exception) {}
            }
        }
        return data;
    }

    private void writeContent(int type, String txt, IContent content) {
        if (inForeign) {
            hasPInside = true;
        }
        this.context.addContainer(false);
        boolean inline = false;
        boolean first_inline = false;
        IStyle c_style = content.getComputedStyle();
        IStyle inlineStyle = null;
        if ("inline".equalsIgnoreCase(content.getComputedStyle().getDisplay())) {
            if (!this.context.isInline()) {
                this.context.startInline();
                first_inline = true;
                if (!this.styles.isEmpty()) {
                    c_style = (ComputedStyle)this.styles.peek();
                }
            }
            if (!this.inlineStyles.isEmpty()) {
                inlineStyle = this.mergeStyles(this.inlineStyles);
            }
            inline = true;
        } else {
            this.adjustInline();
        }
        this.writeBookmark(content);
        this.writeToc(content);
        HyperlinkInfo hyper = this.getHyperlink(content);
        if (content instanceof TextContent) {
            WpmlWriter.TextFlag flag = WpmlWriter.TextFlag.start;
            String fontFamily = null;
            if ("".equals(txt)) {
                this.writer.writeContent(type, txt, c_style, inlineStyle, fontFamily, hyper, inline, first_inline, flag);
            } else {
                FontSplitter fontSplitter = this.getFontSplitter(content);
                while (fontSplitter.hasMore()) {
                    Chunk ch = fontSplitter.getNext();
                    FontInfo info = ch.getFontInfo();
                    BaseFont basefont = null;
                    if (info != null) {
                        basefont = info.getBaseFont();
                        String[][] fontName = basefont.getFamilyFontName();
                        int x = fontName.length - 1;
                        int y = fontName[0].length - 1;
                        fontFamily = fontName[x][y];
                    } else {
                        fontFamily = c_style.getFontFamily();
                    }
                    this.writer.writeContent(type, ch.getText(), c_style, inlineStyle, fontFamily, hyper, inline, first_inline, flag);
                    flag = !fontSplitter.hasMore() ? WpmlWriter.TextFlag.end : WpmlWriter.TextFlag.middle;
                }
            }
            if (!inline) {
                this.writer.writeContent(type, null, c_style, inlineStyle, fontFamily, hyper, inline, first_inline, WpmlWriter.TextFlag.end);
            }
        } else {
            this.writer.writeContent(type, txt, c_style, inlineStyle, c_style.getFontFamily(), hyper, inline, first_inline, WpmlWriter.TextFlag.whole);
        }
        this.context.setLast(false);
    }

    private FontSplitter getFontSplitter(IContent content) {
        FontMappingManager fontManager = FontMappingManagerFactory.getInstance().getFontMappingManager(OUTPUT_FORMAT, Locale.getDefault());
        String text = ((TextContent)content).getText();
        FontSplitter fontSplitter = new FontSplitter(fontManager, new Chunk(text), (ITextContent)((TextContent)content), true);
        return fontSplitter;
    }

    private IStyle mergeStyles(Stack<IStyle> inlineStyles) {
        IStyle style = inlineStyles.peek();
        int i = 0;
        while (i < 60) {
            if (this.isNullValue(style.getProperty(i))) {
                style.setProperty(i, null);
                int p = inlineStyles.size() - 1;
                while (p >= 0) {
                    IStyle pstyle = (IStyle)inlineStyles.get(p);
                    if (!this.isNullValue(pstyle.getProperty(i))) {
                        style.setProperty(i, pstyle.getProperty(i));
                        break;
                    }
                    --p;
                }
            }
            ++i;
        }
        return style;
    }

    private void adjustInline() {
        if (this.context.isInline()) {
            this.writer.endParagraph();
            this.context.endInline();
        }
    }

    class SpanCell {
        ICellContent cell;
        int rowSpan;
        int col;
        int cw;
        IStyle style;

        SpanCell(ICellContent cell, int rowSpan, int col, int cw, IStyle style) {
            this.cell = cell;
            this.rowSpan = rowSpan;
            this.col = col;
            this.cw = cw;
            this.style = style;
        }
    }
}

