/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.core.builders;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ds.core.Messages;
import org.eclipse.pde.internal.ds.core.builders.DSErrorReporter;
import org.eclipse.pde.internal.ds.core.builders.DefaultSAXParser;

public class DSBuilder
extends IncrementalProjectBuilder {
    private static String PDE_NATURE = "org.eclipse.pde.PluginNature";
    private static IProject[] EMPTY_LIST = new IProject[0];

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            IProject project = this.getProject();
            project.accept((IResourceVisitor)new ResourceVisitor(monitor));
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        }
        return EMPTY_LIST;
    }

    private boolean isDSFile(IFile candidate) {
        IContentDescription description;
        block3: {
            try {
                description = candidate.getContentDescription();
                if (description != null) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        IContentType type = description.getContentType();
        return "org.eclipse.pde.ds.core.content-type".equals(type.getId());
    }

    private void checkFile(IFile file, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String message = NLS.bind((String)Messages.DSBuilder_verifying, (Object)file.getFullPath().toString());
        monitor.subTask(message);
        DSErrorReporter reporter = new DSErrorReporter(file);
        DefaultSAXParser.parse(file, reporter);
        if (reporter != null) {
            reporter.validateContent(monitor);
            monitor.subTask(Messages.DSBuilder_updating);
        }
        monitor.done();
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) {
            IFile candidate;
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                try {
                    return project.hasNature(PDE_NATURE);
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            if (resource instanceof IFile && DSBuilder.this.isDSFile(candidate = (IFile)resource) && delta.getKind() != 2) {
                DSBuilder.this.checkFile(candidate, this.monitor);
                return true;
            }
            return true;
        }
    }

    class ResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        public ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            IFile candidate;
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                try {
                    return project.hasNature(PDE_NATURE);
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            if (resource instanceof IFile && DSBuilder.this.isDSFile(candidate = (IFile)resource)) {
                DSBuilder.this.checkFile(candidate, this.monitor);
                return true;
            }
            return false;
        }
    }
}

