/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.core.builders;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ds.core.Activator;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.Messages;
import org.eclipse.pde.internal.ds.core.builders.DSJavaHelper;
import org.eclipse.pde.internal.ds.core.builders.XMLErrorReporter;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DSErrorReporter
extends XMLErrorReporter {
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int IGNORE = 2;

    public DSErrorReporter(IFile file) {
        super(file);
    }

    public void validateContent(IProgressMonitor monitor) {
        try {
            Document textDocument = CoreUtility.getTextDocument((InputStream)this.fFile.getContents());
            DSModel model = new DSModel((IDocument)textDocument, false);
            model.load();
            IDSComponent component = model.getDSComponent();
            this.validateComponent(component);
            this.validateImplementation(component.getImplementation());
            this.validateService(component.getService());
            this.validatePropertyElements(component.getPropertyElements());
            this.validateProperties(component.getPropertiesElements());
            this.validateReferences(component.getReferences());
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private void validateBoolean(Element element, Attr attr) {
        String value;
        if (attr != null && !(value = attr.getValue()).equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            this.reportIllegalAttributeValue(element, attr);
        }
    }

    private void reportIllegalAttributeValue(Element element, Attr attr) {
        String message = NLS.bind((String)Messages.DSErrorReporter_attrValue, (Object[])new String[]{attr.getValue(), attr.getName()});
        this.report(message, this.getLine(element, attr.getName()), 0, "");
    }

    public void validateReferences(IDSReference[] references) {
        int i = 0;
        while (i < references.length) {
            IDSReference reference = references[i];
            Element element = (Element)this.getDocumentRoot().getElementsByTagName(reference.getXMLTagName()).item(i);
            if (reference.getName() == null) {
                this.reportMissingRequiredAttribute(element, "name", 0);
            }
            if (reference.getReferenceInterface() == null) {
                this.reportMissingRequiredAttribute(element, "interface", 0);
            } else {
                this.validateJavaElement(reference.getReferenceInterface(), "reference", "interface", i);
            }
            this.validateReferenceCardinality(element);
            this.validateReferencePolicy(element);
            ++i;
        }
    }

    private void validateReferencePolicy(Element element) {
        String attribute = element.getAttribute("policy");
        String[] allowedValues = new String[]{"dynamic", "static"};
        if (attribute != null) {
            int i = 0;
            while (i < allowedValues.length) {
                if (allowedValues[i].equalsIgnoreCase(attribute)) {
                    return;
                }
                ++i;
            }
            this.reportIllegalAttributeValue(element, element.getAttributeNode("policy"));
        }
    }

    private void validateReferenceCardinality(Element element) {
        String attribute = element.getAttribute("cardinality");
        String[] allowedValues = new String[]{"1..n", "1..1", "0..n", "0..1"};
        if (attribute != null) {
            int i = 0;
            while (i < allowedValues.length) {
                if (allowedValues[i].equalsIgnoreCase(attribute)) {
                    return;
                }
                ++i;
            }
            this.reportIllegalAttributeValue(element, element.getAttributeNode("cardinality"));
        }
    }

    public void validateProperties(IDSProperties[] propertiesElements) {
        int i = 0;
        while (i < propertiesElements.length) {
            IDSProperties properties = propertiesElements[i];
            Element element = (Element)this.getDocumentRoot().getElementsByTagName(properties.getXMLTagName()).item(i);
            if (properties.getEntry() == null) {
                this.reportMissingRequiredAttribute(element, "entry", 0);
            }
            this.validateResource(properties.getEntry(), "properties", "entry", i);
            ++i;
        }
    }

    public void validatePropertyElements(IDSProperty[] propertyElements) {
        int i = 0;
        while (i < propertyElements.length) {
            IDSProperty property = propertyElements[i];
            Element element = (Element)this.getDocumentRoot().getElementsByTagName(property.getXMLTagName()).item(i);
            if (property.getName() == null) {
                this.reportMissingRequiredAttribute(element, "name", 0);
            }
            this.validatePropertyTypeValues(element);
            ++i;
        }
    }

    private void validatePropertyTypeValues(Element element) {
        String attribute = element.getAttribute("type");
        String[] allowedValues = new String[]{"Boolean", "Byte", "Char", "Double", "Float", "Integer", "Long", "Short", "String"};
        if (attribute != null) {
            int i = 0;
            while (i < allowedValues.length) {
                if (allowedValues[i].equalsIgnoreCase(attribute)) {
                    return;
                }
                ++i;
            }
            this.reportIllegalAttributeValue(element, element.getAttributeNode("type"));
        }
    }

    public void validateImplementation(IDSImplementation implementation) {
        if (implementation != null) {
            String className = implementation.getClassName();
            Element element = (Element)this.getDocumentRoot().getElementsByTagName(implementation.getXMLTagName()).item(0);
            if (className == null) {
                this.reportMissingRequiredAttribute(element, "class", 0);
            } else {
                this.validateJavaElement(className, "implementation", "class", 0);
            }
        }
    }

    private void validateJavaElement(String fullyQualifiedName, String elementName, String attrName, int index) {
        try {
            IJavaProject jp;
            if (this.fProject.hasNature("org.eclipse.jdt.core.javanature") && !DSJavaHelper.isOnClasspath(fullyQualifiedName, jp = JavaCore.create((IProject)this.fProject))) {
                this.reportResourceNotFound(elementName, attrName, fullyQualifiedName, index);
            }
        }
        catch (CoreException coreException) {}
    }

    private void validateResource(String path, String elementName, String attrName, int index) {
        if (!this.fProject.exists((IPath)new Path(path))) {
            this.reportResourceNotFound(elementName, attrName, path, index);
        }
    }

    private void reportMissingRequiredAttribute(Element element, String attName, int severity) {
        String message = NLS.bind((String)Messages.DSErrorReporter_requiredAttribute, (Object[])new String[]{attName, element.getNodeName()});
        this.report(message, this.getLine(element), severity, "");
    }

    private void reportResourceNotFound(String elementConstant, String attributeConstant, String resource, int index) {
        Element documentRoot = this.getDocumentRoot();
        NodeList elementsByTagName = documentRoot.getElementsByTagName(elementConstant);
        Element element = (Element)elementsByTagName.item(index);
        Object[] binds = new String[]{resource, attributeConstant};
        this.report(NLS.bind((String)Messages.DSErrorReporter_cannotResolveResource, (Object[])binds), this.getLine(element), 1, "");
    }

    public void validateComponent(IDSComponent component) {
        if (component != null) {
            Element element = this.getDocumentRoot();
            if (component.getAttributeName() == null) {
                this.reportMissingRequiredAttribute(element, "name", 0);
            }
            if (component.getImplementation() == null) {
                this.report(NLS.bind((String)Messages.DSErrorReporter_requiredElement, (Object)"implementation"), this.getLine(this.getDocumentRoot()), 0, "");
            }
            this.validateBoolean(element, element.getAttributeNode("immediate"));
            this.validateBoolean(element, element.getAttributeNode("enabled"));
        }
    }

    public void validateService(IDSService service) {
        if (service != null) {
            Element element = (Element)this.getDocumentRoot().getElementsByTagName(service.getXMLTagName()).item(0);
            this.validateBoolean(element, element.getAttributeNode("servicefactory"));
            this.validateProvide(service.getProvidedServices());
        }
    }

    public void validateProvide(IDSProvide[] providedServices) {
        int i = 0;
        while (i < providedServices.length) {
            IDSProvide provide = providedServices[i];
            Element element = (Element)this.getDocumentRoot().getElementsByTagName(provide.getXMLTagName()).item(i);
            if (provide.getInterface() == null) {
                this.reportMissingRequiredAttribute(element, "interface", 0);
            } else {
                this.validateJavaElement(provide.getInterface(), "provide", "interface", i);
            }
            ++i;
        }
    }
}

