/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.core.text;

import org.eclipse.pde.internal.core.text.DocumentNodeFactory;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentNodeFactory;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.text.DSComponent;
import org.eclipse.pde.internal.ds.core.text.DSImplementation;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.pde.internal.ds.core.text.DSProperties;
import org.eclipse.pde.internal.ds.core.text.DSProperty;
import org.eclipse.pde.internal.ds.core.text.DSProvide;
import org.eclipse.pde.internal.ds.core.text.DSReference;
import org.eclipse.pde.internal.ds.core.text.DSService;

public class DSDocumentFactory
extends DocumentNodeFactory
implements IDocumentNodeFactory,
IDSDocumentFactory {
    private DSModel fModel;

    public DSDocumentFactory(DSModel model) {
        this.fModel = model;
    }

    public IDocumentElementNode createDocumentNode(String name, IDocumentElementNode parent) {
        if (this.isRoot(name)) {
            return this.createComponent();
        }
        if (this.isImplementation(name)) {
            return this.createImplementation();
        }
        if (this.isProperties(name)) {
            return this.createProperties();
        }
        if (this.isProperty(name)) {
            return this.createProperty();
        }
        if (this.isService(name)) {
            return this.createService();
        }
        if (this.isReference(name)) {
            return this.createReference();
        }
        if (this.isProvide(name)) {
            return this.createProvide();
        }
        return super.createDocumentNode(name, parent);
    }

    public IDSProvide createProvide() {
        return new DSProvide(this.fModel);
    }

    public IDSProperty createProperty() {
        return new DSProperty(this.fModel);
    }

    public IDSReference createReference() {
        return new DSReference(this.fModel);
    }

    public IDSService createService() {
        return new DSService(this.fModel);
    }

    public IDSProperties createProperties() {
        return new DSProperties(this.fModel);
    }

    public IDSImplementation createImplementation() {
        return new DSImplementation(this.fModel);
    }

    public IDSComponent createComponent() {
        return new DSComponent(this.fModel);
    }

    private boolean isReference(String name) {
        return name.equals("reference");
    }

    private boolean isService(String name) {
        return name.equals("service");
    }

    private boolean isProperties(String name) {
        return name.equals("properties");
    }

    private boolean isImplementation(String name) {
        return name.equals("implementation");
    }

    private boolean isRoot(String name) {
        return name.equals("component");
    }

    private boolean isProperty(String name) {
        return name.equals("property");
    }

    private boolean isProvide(String name) {
        return name.equals("provide");
    }
}

