/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.ui.progress.UIJob;

public class CreateApiFilterOperation
extends UIJob {
    private IMarker fBackingMarker = null;

    public CreateApiFilterOperation(IMarker marker) {
        super(MarkerMessages.CreateApiFilterOperation_0);
        this.fBackingMarker = marker;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            IResource resource = this.fBackingMarker.getResource();
            IProject project = resource.getProject();
            if (project == null) {
                return Status.CANCEL_STATUS;
            }
            IApiComponent component = ApiPlugin.getDefault().getApiProfileManager().getWorkspaceProfile().getApiComponent(project.getName());
            if (component == null) {
                return Status.CANCEL_STATUS;
            }
            IApiFilterStore store = component.getFilterStore();
            IApiProblem problem = ApiProblemFactory.newApiProblem((String)resource.getProjectRelativePath().toPortableString(), (String)this.getTypeNameFromMarker(), (String[])this.getMessageArgumentsFromMarker(), null, null, (int)this.fBackingMarker.getAttribute("lineNumber", -1), (int)this.fBackingMarker.getAttribute("charStart", -1), (int)this.fBackingMarker.getAttribute("charEnd", -1), (int)this.fBackingMarker.getAttribute("problemid", 0));
            store.addFilters(new IApiProblem[]{problem});
            resource.touch(null);
            return Status.OK_STATUS;
        }
        catch (CoreException ce) {
            ApiUIPlugin.log(ce);
            return Status.CANCEL_STATUS;
        }
    }

    private String[] getMessageArgumentsFromMarker() {
        ArrayList args = new ArrayList();
        String arguments = this.fBackingMarker.getAttribute("messagearguments", null);
        if (arguments != null) {
            return arguments.split("#");
        }
        return args.toArray(new String[args.size()]);
    }

    private String getTypeNameFromMarker() {
        return this.fBackingMarker.getAttribute("problemTypeName", null);
    }
}

