/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.stubs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.pde.api.tools.internal.provisional.stubs.Converter;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.stubs.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConverterUI
extends Dialog {
    static final int ALL_ID = 1041;
    static final int ARCHIVE_FILES_ID = 1037;
    static final int CLASS_FILES_ID = 1036;
    static final String[] COMMAND_LINE_OPTIONS = new String[18];
    static final int COMPRESS_ID = 1038;
    static final int INPUT_ID = 1034;
    static final int KEEP_ALL_ID = 1031;
    static final int KEEP_ID = 1025;
    static final int KEEP_NONE_ID = 1032;
    static final int KEEP_PACKAGE_ID = 1029;
    static final int KEEP_PRIVATE_ID = 1026;
    static final int KEEP_PROTECTED_ID = 1027;
    static final int KEEP_PUBLIC_ID = 1028;
    static final int KEEP_SYNTHETIC_ID = 1030;
    static final int OUTPUT_ID = 1033;
    static final int RECURSE_ID = 1039;
    static final int REFS_ID = 1040;
    static final int SKIP_RESOURCE_FILES_ID = 1042;
    static final int VERBOSE_ID = 1035;
    List commandLine;
    String input;
    Text inputText;
    boolean isFileInput;
    Map options;
    String output;
    Text outputText;
    String title = Messages.ConverterUI_18;
    List widgets = new ArrayList();

    static {
        ConverterUI.COMMAND_LINE_OPTIONS[0] = "keep";
        ConverterUI.COMMAND_LINE_OPTIONS[1] = "private";
        ConverterUI.COMMAND_LINE_OPTIONS[2] = "protected";
        ConverterUI.COMMAND_LINE_OPTIONS[3] = "public";
        ConverterUI.COMMAND_LINE_OPTIONS[4] = "package";
        ConverterUI.COMMAND_LINE_OPTIONS[5] = "synthetic";
        ConverterUI.COMMAND_LINE_OPTIONS[6] = "all";
        ConverterUI.COMMAND_LINE_OPTIONS[7] = "none";
        ConverterUI.COMMAND_LINE_OPTIONS[8] = "-output";
        ConverterUI.COMMAND_LINE_OPTIONS[9] = "-input";
        ConverterUI.COMMAND_LINE_OPTIONS[10] = "-v";
        ConverterUI.COMMAND_LINE_OPTIONS[11] = "-classfiles";
        ConverterUI.COMMAND_LINE_OPTIONS[13] = "-compress";
        ConverterUI.COMMAND_LINE_OPTIONS[12] = "-archives";
        ConverterUI.COMMAND_LINE_OPTIONS[15] = "-refs";
        ConverterUI.COMMAND_LINE_OPTIONS[14] = "-s";
        ConverterUI.COMMAND_LINE_OPTIONS[16] = "-all";
        ConverterUI.COMMAND_LINE_OPTIONS[17] = "-skipresourcefiles";
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        ConverterUI instance = new ConverterUI(shell);
        instance.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public ConverterUI(Shell parent) {
        super(parent);
        this.commandLine = new ArrayList();
        this.options = new HashMap();
        this.createDialogArea((Composite)parent);
    }

    void addNewOption(Composite composite, int id, String optionLabel, boolean selection) {
        Button button = new Button(composite, 32);
        button.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        button.setText(optionLabel);
        button.setSelection(selection);
        Integer idObject = new Integer(id);
        button.setData((Object)idObject);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConverterUI.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        this.options.put(idObject, button);
        this.widgets.add(button);
    }

    private void addToCommandLine(String argument) {
        this.commandLine.add(argument);
    }

    protected void buttonPressed(int buttonId) {
        Shell parent = new Shell();
        try {
            switch (buttonId) {
                case 1026: 
                case 1027: 
                case 1028: 
                case 1029: 
                case 1030: 
                case 1031: 
                case 1032: {
                    break;
                }
                case 1033: {
                    DirectoryDialog directoryDialog = new DirectoryDialog(parent, 32768);
                    String result = directoryDialog.open();
                    this.outputText.setText(result == null ? "" : result);
                    this.output = result;
                    this.getShell().setFocus();
                    break;
                }
                case 1034: {
                    String result = null;
                    if (this.isFileInput) {
                        FileDialog fileDialog = new FileDialog(parent, 32768);
                        result = fileDialog.open();
                    } else {
                        DirectoryDialog directoryDialog = new DirectoryDialog(parent, 32768);
                        result = directoryDialog.open();
                    }
                    this.inputText.setText(result == null ? "" : result);
                    this.input = result;
                    this.getShell().setFocus();
                    break;
                }
                case 1035: 
                case 1038: 
                case 1039: 
                case 1040: 
                case 1041: 
                case 1042: {
                    String commandLineOption = this.getCommandLineOptions(buttonId);
                    Button button = (Button)this.options.get(new Integer(buttonId));
                    if (button.getSelection()) {
                        if (!this.commandLine.contains(commandLineOption)) {
                            this.addToCommandLine(commandLineOption);
                        }
                    } else if (this.commandLine.contains(commandLineOption)) {
                        this.removeFromCommandLine(commandLineOption);
                    }
                    break;
                }
                case 1036: {
                    String commandLineOption = this.getCommandLineOptions(buttonId);
                    Button button = (Button)this.options.get(new Integer(buttonId));
                    if (button.getSelection()) {
                        Button button2 = (Button)this.options.get(new Integer(1037));
                        if (button2.getSelection()) {
                            this.removeFromCommandLine(this.getCommandLineOptions(1037));
                            this.removeFromCommandLine(this.getCommandLineOptions(1036));
                            this.addToCommandLine(this.getCommandLineOptions(1041));
                            break;
                        }
                        this.addToCommandLine(this.getCommandLineOptions(1036));
                        break;
                    }
                    this.removeFromCommandLine(this.getCommandLineOptions(1036));
                    break;
                }
                case 1037: {
                    String commandLineOption = this.getCommandLineOptions(buttonId);
                    Button button = (Button)this.options.get(new Integer(buttonId));
                    if (button.getSelection()) {
                        Button button2 = (Button)this.options.get(new Integer(1036));
                        if (button2.getSelection()) {
                            this.removeFromCommandLine(this.getCommandLineOptions(1037));
                            this.removeFromCommandLine(this.getCommandLineOptions(1036));
                            this.addToCommandLine(this.getCommandLineOptions(1041));
                            break;
                        }
                        this.addToCommandLine(this.getCommandLineOptions(1037));
                        break;
                    }
                    this.removeFromCommandLine(this.getCommandLineOptions(1037));
                    break;
                }
                case 0: {
                    String text = this.outputText.getText();
                    if (text != null && this.output == null) {
                        this.output = text;
                    }
                    if ((text = this.inputText.getText()) != null && this.input == null) {
                        this.input = text;
                    }
                    if (this.input != null) {
                        this.addToCommandLine(this.getCommandLineOptions(1034));
                        this.addToCommandLine(this.input);
                    }
                    if (this.output != null) {
                        this.addToCommandLine(this.getCommandLineOptions(1033));
                        this.addToCommandLine(this.output);
                    }
                    String[] cmd = new String[this.commandLine.size()];
                    this.commandLine.toArray(cmd);
                    int i = 0;
                    int max = cmd.length;
                    while (i < max) {
                        System.out.println(cmd[i]);
                        ++i;
                    }
                    try {
                        Converter.main((String[])cmd);
                    }
                    catch (RuntimeException e) {
                        ApiUIPlugin.log(e);
                    }
                }
                case 1: {
                    super.buttonPressed(buttonId);
                }
            }
        }
        finally {
            parent.dispose();
        }
    }

    public boolean close() {
        this.dispose();
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        this.createButton(composite, 0, Messages.ConverterUI_21, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        parent.setLayout((Layout)new GridLayout(2, false));
        Group inputGroup = new Group(parent, 0);
        this.setInputGroup(inputGroup);
        inputGroup.setText(Messages.ConverterUI_22);
        GridData gridData = new GridData(4, 0, true, true);
        gridData.horizontalSpan = 2;
        inputGroup.setLayoutData((Object)gridData);
        this.widgets.add(inputGroup);
        Group outputGroup = new Group(parent, 0);
        outputGroup.setText(Messages.ConverterUI_23);
        this.setOutputGroup(outputGroup);
        gridData = new GridData(4, 0, true, true);
        gridData.horizontalSpan = 2;
        outputGroup.setLayoutData((Object)gridData);
        this.widgets.add(outputGroup);
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setText(Messages.ConverterUI_24);
        this.setOptionsGroup(optionsGroup);
        gridData = new GridData(4, 0, true, true);
        gridData.horizontalSpan = 2;
        optionsGroup.setLayoutData((Object)gridData);
        this.widgets.add(optionsGroup);
        return composite;
    }

    public void dispose() {
        Iterator iterator = this.widgets.iterator();
        while (iterator.hasNext()) {
            Widget widget = (Widget)iterator.next();
            widget.dispose();
        }
        this.getParentShell().dispose();
    }

    public String getCommandLineOptions(int id) {
        return COMMAND_LINE_OPTIONS[id - 1024 - 1];
    }

    private void removeFromCommandLine(String argument) {
        this.commandLine.remove(argument);
    }

    private void setInputGroup(Group group) {
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        GC gc = new GC((Drawable)label);
        gc.setFont(label.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        label.setText(Messages.ConverterUI_25);
        GridData data = new GridData(4, 0, true, false);
        data.widthHint = ConverterUI.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)15);
        label.setLayoutData((Object)data);
        this.inputText = new Text((Composite)group, 2052);
        data = new GridData(4, 0, true, false);
        data.widthHint = ConverterUI.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)30);
        this.inputText.setLayoutData((Object)data);
        Button button = new Button((Composite)group, 8);
        button.setText(Messages.ConverterUI_26);
        button.setVisible(true);
        Button file = new Button((Composite)group, 32);
        file.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        file.setText(Messages.ConverterUI_27);
        file.setSelection(false);
        this.isFileInput = false;
        file.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConverterUI.this.isFileInput = !ConverterUI.this.isFileInput;
            }
        });
        button.setData((Object)new Integer(1034));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConverterUI.this.buttonPressed((Integer)event.widget.getData());
            }
        });
    }

    private void setKeepGroup(Group group) {
        group.setLayout((Layout)new GridLayout(2, true));
        this.addNewOption((Composite)group, 1026, Messages.ConverterUI_2, false);
        this.addNewOption((Composite)group, 1027, Messages.ConverterUI_1, false);
        this.addNewOption((Composite)group, 1028, Messages.ConverterUI_0, false);
        this.addNewOption((Composite)group, 1030, Messages.ConverterUI_3, false);
        this.addNewOption((Composite)group, 1029, Messages.ConverterUI_4, false);
        this.addNewOption((Composite)group, 1031, Messages.ConverterUI_5, false);
        this.addNewOption((Composite)group, 1032, Messages.ConverterUI_6, false);
    }

    private void setOptionsGroup(Group group) {
        group.setLayout((Layout)new GridLayout(2, true));
        this.addNewOption((Composite)group, 1035, Messages.ConverterUI_35, false);
        this.addNewOption((Composite)group, 1039, Messages.ConverterUI_36, false);
        this.addNewOption((Composite)group, 1036, Messages.ConverterUI_37, false);
        this.addNewOption((Composite)group, 1037, Messages.ConverterUI_38, false);
        this.addNewOption((Composite)group, 1038, Messages.ConverterUI_39, false);
        this.addNewOption((Composite)group, 1040, Messages.ConverterUI_40, false);
        this.addNewOption((Composite)group, 1042, Messages.ConverterUI_41, false);
        this.addNewOption((Composite)group, 1041, Messages.ConverterUI_42, false);
        Group group2 = new Group((Composite)group, 0);
        group2.setText(Messages.ConverterUI_43);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.setKeepGroup(group2);
        group2.setLayoutData((Object)gridData);
    }

    private void setOutputGroup(Group group) {
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        GC gc = new GC((Drawable)label);
        gc.setFont(label.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        label.setText(Messages.ConverterUI_44);
        GridData data = new GridData(4, 0, true, false);
        data.widthHint = ConverterUI.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)15);
        label.setLayoutData((Object)data);
        this.outputText = new Text((Composite)group, 2052);
        this.outputText.setEditable(true);
        data = new GridData(4, 0, true, false);
        data.widthHint = ConverterUI.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)30);
        this.outputText.setLayoutData((Object)data);
        Button button = new Button((Composite)group, 8);
        button.setText(Messages.ConverterUI_45);
        button.setData((Object)new Integer(1033));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConverterUI.this.buttonPressed((Integer)event.widget.getData());
            }
        });
    }
}

