/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.CachedManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class EclipseStorageHook
implements StorageHook,
HookConfigurator {
    private static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    private static final String PROP_COMPATIBILITY_LAZYSTART = "osgi.compatibility.eagerStart.LazyActivation";
    private static final boolean COMPATIBILITY_LAZYSTART = Boolean.valueOf(FrameworkProperties.getProperty("osgi.compatibility.eagerStart.LazyActivation", "true"));
    private static final int STORAGE_VERION = 3;
    public static final String KEY;
    public static final int HASHCODE;
    private static final byte FLAG_LAZY_START = 1;
    private static final byte FLAG_HAS_PACKAGE_INFO = 2;
    private static final byte FLAG_HAS_LAZY_INCLUDE = 8;
    private long manifestTimeStamp = 0L;
    private byte manifestType = 0;
    private BaseData bundledata;
    private String pluginClass = null;
    private String[] lazyStartExcludes;
    private String[] lazyStartIncludes;
    private int bundleManfestVersion;
    private String buddyList;
    private String registeredBuddyList;
    private byte flags = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
    }

    public int getStorageVersion() {
        return 3;
    }

    public StorageHook create(BaseData bundledata) throws BundleException {
        EclipseStorageHook storageHook = new EclipseStorageHook();
        storageHook.bundledata = bundledata;
        return storageHook;
    }

    public void initialize(Dictionary manifest) throws BundleException {
        ManifestElement generatedFrom;
        String genFrom;
        String activationPolicy = (String)manifest.get("Bundle-ActivationPolicy");
        if (activationPolicy != null) {
            this.parseActivationPolicy(this, activationPolicy);
        } else {
            String lazyStart = (String)manifest.get("Eclipse-LazyStart");
            if (lazyStart == null) {
                lazyStart = (String)manifest.get("Eclipse-AutoStart");
            }
            this.parseLazyStart(this, lazyStart);
        }
        try {
            String versionString = (String)manifest.get("Bundle-ManifestVersion");
            this.bundleManfestVersion = versionString == null ? 0 : Integer.parseInt(versionString);
        }
        catch (NumberFormatException numberFormatException) {
            this.bundleManfestVersion = 0;
        }
        this.pluginClass = (String)manifest.get("Plugin-Class");
        this.buddyList = (String)manifest.get("Eclipse-BuddyPolicy");
        this.registeredBuddyList = (String)manifest.get("Eclipse-RegisterBuddy");
        if (EclipseStorageHook.hasPackageInfo(this.bundledata.getEntry("META-INF/MANIFEST.MF"))) {
            this.flags = (byte)(this.flags | 2);
        }
        if ((genFrom = (String)manifest.get("Generated-from")) != null && (generatedFrom = ManifestElement.parseHeader("Generated-from", genFrom)[0]) != null) {
            this.manifestTimeStamp = Long.parseLong(generatedFrom.getValue());
            this.manifestType = Byte.parseByte(generatedFrom.getAttribute("type"));
        }
        if (this.isAutoStartable()) {
            this.bundledata.setStatus(this.bundledata.getStatus() | 2);
            if (COMPATIBILITY_LAZYSTART) {
                this.bundledata.setStatus(this.bundledata.getStatus() | 1 | 4);
            }
        }
    }

    public StorageHook load(BaseData target, DataInputStream in) throws IOException {
        EclipseStorageHook storageHook = new EclipseStorageHook();
        storageHook.bundledata = target;
        storageHook.flags = in.readByte();
        int pkgCount = in.readInt();
        String[] packageList = pkgCount > 0 ? new String[pkgCount] : null;
        int i = 0;
        while (i < pkgCount) {
            packageList[i] = in.readUTF();
            ++i;
        }
        storageHook.lazyStartExcludes = packageList;
        if ((storageHook.flags & 8) != 0) {
            pkgCount = in.readInt();
            packageList = pkgCount > 0 ? new String[pkgCount] : null;
            i = 0;
            while (i < pkgCount) {
                packageList[i] = in.readUTF();
                ++i;
            }
            storageHook.lazyStartIncludes = packageList;
        }
        storageHook.buddyList = AdaptorUtil.readString(in, false);
        storageHook.registeredBuddyList = AdaptorUtil.readString(in, false);
        storageHook.pluginClass = AdaptorUtil.readString(in, false);
        storageHook.manifestTimeStamp = in.readLong();
        storageHook.manifestType = in.readByte();
        storageHook.bundleManfestVersion = in.readInt();
        if (storageHook.isAutoStartable()) {
            if ((target.getStatus() & 2) == 0) {
                target.setStatus(target.getStatus() | 2);
            }
            if (COMPATIBILITY_LAZYSTART && (target.getStatus() & 1) == 0) {
                target.setStatus(target.getStatus() | 1 | 4);
            }
        }
        return storageHook;
    }

    public void save(DataOutputStream out) throws IOException {
        if (this.bundledata == null) {
            throw new IllegalStateException();
        }
        out.writeByte(this.flags);
        String[] excludes = this.getLazyStartExcludes();
        if (excludes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(excludes.length);
            int i = 0;
            while (i < excludes.length) {
                out.writeUTF(excludes[i]);
                ++i;
            }
        }
        if ((this.flags & 8) != 0) {
            String[] includes = this.getLazyStartIncludes();
            if (includes == null) {
                out.writeInt(0);
            } else {
                out.writeInt(includes.length);
                int i = 0;
                while (i < includes.length) {
                    out.writeUTF(includes[i]);
                    ++i;
                }
            }
        }
        AdaptorUtil.writeStringOrNull(out, this.getBuddyList());
        AdaptorUtil.writeStringOrNull(out, this.getRegisteredBuddyList());
        AdaptorUtil.writeStringOrNull(out, this.getPluginClass());
        out.writeLong(this.getManifestTimeStamp());
        out.writeByte(this.getManifestType());
        out.writeInt(this.getBundleManifestVersion());
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public boolean compare(KeyedElement other) {
        return other.getKey() == KEY;
    }

    public Object getKey() {
        return KEY;
    }

    public boolean isLazyStart() {
        return (this.flags & 1) == 1;
    }

    public String[] getLazyStartExcludes() {
        return this.lazyStartExcludes;
    }

    public String[] getLazyStartIncludes() {
        return this.lazyStartIncludes;
    }

    public String getBuddyList() {
        return this.buddyList;
    }

    public boolean hasPackageInfo() {
        return (this.flags & 2) == 2;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public String getRegisteredBuddyList() {
        return this.registeredBuddyList;
    }

    public long getManifestTimeStamp() {
        return this.manifestTimeStamp;
    }

    public byte getManifestType() {
        return this.manifestType;
    }

    public int getBundleManifestVersion() {
        return this.bundleManfestVersion;
    }

    public boolean isAutoStartable() {
        return this.isLazyStart() || this.lazyStartExcludes != null && this.lazyStartExcludes.length > 0;
    }

    private void parseLazyStart(EclipseStorageHook storageHook, String headerValue) {
        storageHook.lazyStartExcludes = null;
        ManifestElement[] allElements = null;
        try {
            allElements = ManifestElement.parseHeader("Eclipse-LazyStart", headerValue);
        }
        catch (BundleException e) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_GET_HEADERS, storageHook.bundledata.getLocation());
            this.bundledata.getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, message, 0, e, null));
        }
        if (allElements == null) {
            return;
        }
        if ("true".equalsIgnoreCase(allElements[0].getValue())) {
            storageHook.flags = (byte)(storageHook.flags | 1);
        }
        String[] exceptions = ManifestElement.getArrayFromList(allElements[0].getAttribute("exceptions"));
        storageHook.lazyStartExcludes = exceptions;
    }

    private void parseActivationPolicy(EclipseStorageHook storageHook, String headerValue) {
        storageHook.lazyStartExcludes = null;
        ManifestElement[] allElements = null;
        try {
            allElements = ManifestElement.parseHeader("Bundle-ActivationPolicy", headerValue);
        }
        catch (BundleException e) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_GET_HEADERS, storageHook.bundledata.getLocation());
            this.bundledata.getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, message, 0, e, null));
        }
        if (allElements == null) {
            return;
        }
        if (!"lazy".equalsIgnoreCase(allElements[0].getValue())) {
            return;
        }
        storageHook.flags = (byte)(storageHook.flags | 1);
        storageHook.lazyStartExcludes = ManifestElement.getArrayFromList(allElements[0].getDirective("exclude"));
        storageHook.lazyStartIncludes = ManifestElement.getArrayFromList(allElements[0].getDirective("include"));
        if (storageHook.lazyStartIncludes != null) {
            storageHook.flags = (byte)(storageHook.flags | 8);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasPackageInfo(URL url) {
        if (url == null) {
            return false;
        }
        br = null;
        try {
            br = new BufferedReader(new InputStreamReader(url.openStream()));
            ** GOTO lbl-1000
        }
        catch (IOException v0) {
            if (br == null) return false;
            try {
                br.close();
                return false;
            }
            catch (IOException v1) {
                return false;
            }
        }
        catch (Throwable var3_3) {
            if (br == null) throw var3_3;
            try {
                br.close();
                throw var3_3;
            }
            catch (IOException v2) {}
            throw var3_3;
        }
lbl21:
        // 1 sources

        while (true) {
            try {
                br.close();
                return true;
            }
            catch (IOException v3) {}
            return true;
        }
lbl-1000:
        // 2 sources

        {
            ** while ((line = br.readLine()) != null)
        }
lbl-1000:
        // 1 sources

        {
            if (!line.startsWith("Specification-Title: ") && !line.startsWith("Specification-Version: ") && !line.startsWith("Specification-Vendor: ") && !line.startsWith("Implementation-Title: ") && !line.startsWith("Implementation-Version: ") && !line.startsWith("Implementation-Vendor: ")) continue;
            if (br == null) return true;
            ** continue;
lbl31:
            // 1 sources

            ** GOTO lbl21
        }
lbl32:
        // 1 sources

        if (br == null) return false;
        try {
            br.close();
            return false;
        }
        catch (IOException v4) {}
        return false;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addStorageHook(this);
    }

    private void checkTimeStamp() throws IllegalArgumentException {
        if (!this.checkManifestTimeStamp()) {
            throw new IllegalArgumentException();
        }
    }

    private boolean checkManifestTimeStamp() {
        if (!"true".equalsIgnoreCase(FrameworkProperties.getProperty(PROP_CHECK_CONFIG))) {
            return true;
        }
        if (PluginConverterImpl.getTimeStamp(this.bundledata.getBundleFile().getBaseFile(), this.getManifestType()) == this.getManifestTimeStamp()) {
            if ((this.getManifestType() & 9) != 0) {
                return true;
            }
            String cacheLocation = FrameworkProperties.getProperty("osgi.manifest.cache");
            Location parentConfiguration = LocationManager.getConfigurationLocation().getParentLocation();
            if (parentConfiguration != null) {
                try {
                    return this.checkManifestAndParent(cacheLocation, this.bundledata.getSymbolicName(), this.bundledata.getVersion().toString(), this.getManifestType()) != null;
                }
                catch (BundleException bundleException) {
                    return false;
                }
            }
            File cacheFile = new File(cacheLocation, String.valueOf(this.bundledata.getSymbolicName()) + '_' + this.bundledata.getVersion() + ".MF");
            if (cacheFile.isFile()) {
                return true;
            }
        }
        return false;
    }

    private Headers checkManifestAndParent(String cacheLocation, String symbolicName, String version, byte inputType) throws BundleException {
        Headers result = this.basicCheckManifest(cacheLocation, symbolicName, version, inputType);
        if (result != null) {
            return result;
        }
        Location parentConfiguration = null;
        parentConfiguration = LocationManager.getConfigurationLocation().getParentLocation();
        if (parentConfiguration != null) {
            result = this.basicCheckManifest(new File(parentConfiguration.getURL().getFile(), "org.eclipse.osgi/manifests").toString(), symbolicName, version, inputType);
        }
        return result;
    }

    private Headers basicCheckManifest(String cacheLocation, String symbolicName, String version, byte inputType) throws BundleException {
        File currentFile = new File(cacheLocation, String.valueOf(symbolicName) + '_' + version + ".MF");
        if (PluginConverterImpl.upToDate(currentFile, this.bundledata.getBundleFile().getBaseFile(), inputType)) {
            try {
                return Headers.parseManifest(new FileInputStream(currentFile));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    Dictionary createCachedManifest(boolean firstTime) throws BundleException {
        return firstTime ? this.getGeneratedManifest() : new CachedManifest(this);
    }

    public Dictionary getGeneratedManifest() throws BundleException {
        Dictionary builtIn = AdaptorUtil.loadManifestFrom(this.bundledata);
        if (builtIn != null) {
            Dictionary generatedManifest;
            if (!this.isComplete(builtIn) && (generatedManifest = this.generateManifest(builtIn)) != null) {
                return generatedManifest;
            }
            this.manifestType = 1;
            if (this.bundledata.getBundleFile().getBaseFile().isFile()) {
                this.manifestTimeStamp = this.bundledata.getBundleFile().getBaseFile().lastModified();
                this.manifestType = (byte)(this.manifestType | 8);
            } else {
                this.manifestTimeStamp = this.bundledata.getBundleFile().getEntry("META-INF/MANIFEST.MF").getTime();
            }
            return builtIn;
        }
        Dictionary result = this.generateManifest(null);
        if (result == null) {
            throw new BundleException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_DATA_MANIFEST_NOT_FOUND, this.bundledata.getLocation()));
        }
        return result;
    }

    private Dictionary generateManifest(Dictionary builtIn) throws BundleException {
        Dictionary generatedManifest;
        Headers existingHeaders;
        String cacheLocation = FrameworkProperties.getProperty("osgi.manifest.cache");
        if (this.bundledata.getSymbolicName() != null && (existingHeaders = this.checkManifestAndParent(cacheLocation, this.bundledata.getSymbolicName(), this.bundledata.getVersion().toString(), this.manifestType)) != null) {
            return existingHeaders;
        }
        PluginConverterImpl converter = PluginConverterImpl.getDefault();
        if (converter == null) {
            converter = new PluginConverterImpl(this.bundledata.getAdaptor(), this.bundledata.getAdaptor().getContext());
        }
        try {
            generatedManifest = converter.convertManifest(this.bundledata.getBundleFile().getBaseFile(), true, null, true, null);
        }
        catch (PluginConversionException pce) {
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_CONVERTING, this.bundledata.getBundleFile().getBaseFile());
            throw new BundleException(message, 3, pce);
        }
        Version version = Version.parseVersion((String)generatedManifest.get("Bundle-Version"));
        String symbolicName = ManifestElement.parseHeader("Bundle-SymbolicName", (String)generatedManifest.get("Bundle-SymbolicName"))[0].getValue();
        ManifestElement generatedFrom = ManifestElement.parseHeader("Generated-from", (String)generatedManifest.get("Generated-from"))[0];
        Headers existingHeaders2 = this.checkManifestAndParent(cacheLocation, symbolicName, version.toString(), Byte.parseByte(generatedFrom.getAttribute("type")));
        this.manifestTimeStamp = Long.parseLong(generatedFrom.getValue());
        this.manifestType = Byte.parseByte(generatedFrom.getAttribute("type"));
        if (this.bundledata.getAdaptor().isReadOnly() || existingHeaders2 != null) {
            return existingHeaders2;
        }
        if (builtIn != null) {
            Enumeration keysEnum = builtIn.keys();
            while (keysEnum.hasMoreElements()) {
                Object key = keysEnum.nextElement();
                generatedManifest.put(key, builtIn.get(key));
            }
        }
        File bundleManifestLocation = new File(cacheLocation, String.valueOf(symbolicName) + '_' + version.toString() + ".MF");
        try {
            converter.writeManifest(bundleManifestLocation, generatedManifest, true);
        }
        catch (Exception exception) {}
        return generatedManifest;
    }

    private boolean isComplete(Dictionary manifest) {
        if (manifest.get("Bundle-SymbolicName") != null) {
            return true;
        }
        return this.bundledata.getEntry("plugin.xml") == null && this.bundledata.getEntry("fragment.xml") == null;
    }

    public BaseData getBaseData() {
        return this.bundledata;
    }

    public void copy(StorageHook storageHook) {
    }

    public void validate() throws IllegalArgumentException {
        this.checkTimeStamp();
    }

    public FrameworkAdaptor getAdaptor() {
        if (this.bundledata != null) {
            return this.bundledata.getAdaptor();
        }
        return null;
    }

    public Dictionary getManifest(boolean firstLoad) throws BundleException {
        return this.createCachedManifest(firstLoad);
    }

    public boolean forgetStatusChange(int status) {
        return false;
    }

    public boolean forgetStartLevelChange(int startlevel) {
        return false;
    }

    public boolean matchDNChain(String pattern) {
        return false;
    }
}

