/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context;

import java.util.Iterator;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitProperties;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitPropertyListListener
implements ListChangeListener {
    private PersistenceUnitProperties parent;

    public PersistenceUnitPropertyListListener(PersistenceUnitProperties parent) {
        this.parent = parent;
    }

    protected boolean add(Property newItem, Model source) {
        if (this.model().itemIsProperty(newItem)) {
            String propertyName = this.model().propertyIdFor(newItem);
            this.model().propertyChanged(new PropertyChangeEvent(source, propertyName, null, (Object)newItem));
            return true;
        }
        return false;
    }

    protected boolean remove(Property item, Model source) {
        if (this.model().itemIsProperty(item)) {
            String propertyName = this.model().propertyIdFor(item);
            this.model().propertyChanged(new PropertyChangeEvent(source, propertyName, (Object)item, null));
            return true;
        }
        return false;
    }

    protected Property set(Property newItem, Model source) {
        if (this.model().itemIsProperty(newItem)) {
            String propertyName = this.model().propertyIdFor(newItem);
            this.model().propertyChanged(new PropertyChangeEvent(source, propertyName, null, (Object)newItem));
            return newItem;
        }
        return null;
    }

    public void itemsAdded(ListChangeEvent e) {
        Iterator<Property> stream = this.items(e);
        while (stream.hasNext()) {
            this.add(stream.next(), e.getSource());
        }
    }

    public void itemsRemoved(ListChangeEvent e) {
        Iterator<Property> stream = this.items(e);
        while (stream.hasNext()) {
            this.remove(stream.next(), e.getSource());
        }
    }

    public void itemsReplaced(ListChangeEvent e) {
        Iterator<Property> newStream = this.items(e);
        while (newStream.hasNext()) {
            this.set(newStream.next(), e.getSource());
        }
    }

    public void itemsMoved(ListChangeEvent e) {
        throw new UnsupportedOperationException("source: " + e.getSource() + " - aspect: " + e.getAspectName());
    }

    public void listCleared(ListChangeEvent e) {
        throw new UnsupportedOperationException("source: " + e.getSource() + " - aspect: " + e.getAspectName());
    }

    public void listChanged(ListChangeEvent e) {
        throw new UnsupportedOperationException("source: " + e.getSource() + " - aspect: " + e.getAspectName());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "( " + this.model().getClass().getSimpleName() + ")";
    }

    private PersistenceUnitProperties model() {
        return this.parent;
    }

    private Iterator<Property> items(ListChangeEvent event) {
        return event.items();
    }
}

