/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.EclipseLinkJpaFactory;
import org.eclipse.jpt.eclipselink.core.context.java.EclipseLinkJavaConvert;
import org.eclipse.jpt.eclipselink.core.context.java.EclipseLinkJavaNamedConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConvertAnnotation;

public class EclipseLinkJavaConvertImpl
extends AbstractJavaJpaContextNode
implements EclipseLinkJavaConvert {
    private String specifiedConverterName;
    private JavaResourcePersistentAttribute resourcePersistentAttribute;
    private EclipseLinkJavaNamedConverter converter;

    public EclipseLinkJavaConvertImpl(JavaAttributeMapping parent, JavaResourcePersistentAttribute jrpa) {
        super((JpaContextNode)parent);
        this.initialize(jrpa);
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    protected EclipseLinkJpaFactory getJpaFactory() {
        return (EclipseLinkJpaFactory)super.getJpaFactory();
    }

    public String getType() {
        return "eclipseLinkConverter";
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Convert";
    }

    public void addToResourceModel() {
        this.resourcePersistentAttribute.addAnnotation(this.getAnnotationName());
    }

    public void removeFromResourceModel() {
        this.resourcePersistentAttribute.removeAnnotation(this.getAnnotationName());
        if (this.getConverter() != null) {
            this.getConverter().removeFromResourceModel();
        }
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceConvert().getTextRange(astRoot);
    }

    protected ConvertAnnotation getResourceConvert() {
        return (ConvertAnnotation)this.resourcePersistentAttribute.getAnnotation(this.getAnnotationName());
    }

    public String getConverterName() {
        return this.getSpecifiedConverterName() == null ? this.getDefaultConverterName() : this.getSpecifiedConverterName();
    }

    public String getDefaultConverterName() {
        return "none";
    }

    public String getSpecifiedConverterName() {
        return this.specifiedConverterName;
    }

    public void setSpecifiedConverterName(String newSpecifiedConverterName) {
        String oldSpecifiedConverterName = this.specifiedConverterName;
        this.specifiedConverterName = newSpecifiedConverterName;
        this.getResourceConvert().setValue(newSpecifiedConverterName);
        this.firePropertyChanged("specifiedConverterNameProperty", oldSpecifiedConverterName, newSpecifiedConverterName);
    }

    protected void setSpecifiedConverterName_(String newSpecifiedConverterName) {
        String oldSpecifiedConverterName = this.specifiedConverterName;
        this.specifiedConverterName = newSpecifiedConverterName;
        this.firePropertyChanged("specifiedConverterNameProperty", oldSpecifiedConverterName, newSpecifiedConverterName);
    }

    public EclipseLinkJavaNamedConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        if (this.converter == null) {
            return "noConverter";
        }
        return this.converter.getType();
    }

    public void setConverter(String converterType) {
        if (this.getConverterType() == converterType) {
            return;
        }
        EclipseLinkJavaNamedConverter oldConverter = this.converter;
        EclipseLinkJavaNamedConverter newConverter = this.buildConverter(converterType);
        this.converter = null;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.converter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("converterProperty", oldConverter, newConverter);
    }

    protected void setConverter(EclipseLinkJavaNamedConverter newConverter) {
        EclipseLinkJavaNamedConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converterProperty", oldConverter, newConverter);
    }

    protected void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.specifiedConverterName = this.specifiedConverterName(this.getResourceConvert());
        this.converter = this.buildConverter(this.converterType(jrpa));
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.setSpecifiedConverterName_(this.specifiedConverterName(this.getResourceConvert()));
        if (this.converterType(jrpa) == this.getConverterType()) {
            this.getConverter().update((JavaResourcePersistentMember)jrpa);
        } else {
            EclipseLinkJavaNamedConverter javaConverter = this.buildConverter(this.converterType(jrpa));
            this.setConverter(javaConverter);
        }
    }

    protected String specifiedConverterName(ConvertAnnotation resourceConvert) {
        return resourceConvert == null ? null : resourceConvert.getValue();
    }

    protected EclipseLinkJavaNamedConverter buildConverter(String converterType) {
        if (converterType == "noConverter") {
            return null;
        }
        if (converterType == "converter") {
            return this.getJpaFactory().buildEclipseLinkJavaConverter((JavaJpaContextNode)this, (JavaResourcePersistentMember)this.resourcePersistentAttribute);
        }
        if (converterType == "typeConverter") {
            return this.getJpaFactory().buildEclipseLinkJavaTypeConverter((JavaJpaContextNode)this, (JavaResourcePersistentMember)this.resourcePersistentAttribute);
        }
        if (converterType == "objectTypeConverter") {
            return this.getJpaFactory().buildEclipseLinkJavaObjectTypeConverter((JavaJpaContextNode)this, (JavaResourcePersistentMember)this.resourcePersistentAttribute);
        }
        if (converterType == "structConverter") {
            return this.getJpaFactory().buildEclipseLinkJavaStructConverter((JavaJpaContextNode)this, (JavaResourcePersistentMember)this.resourcePersistentAttribute);
        }
        return null;
    }

    protected String converterType(JavaResourcePersistentAttribute jrpa) {
        if (jrpa.getAnnotation("org.eclipse.persistence.annotations.Converter") != null) {
            return "converter";
        }
        if (jrpa.getAnnotation("org.eclipse.persistence.annotations.TypeConverter") != null) {
            return "typeConverter";
        }
        if (jrpa.getAnnotation("org.eclipse.persistence.annotations.ObjectTypeConverter") != null) {
            return "objectTypeConverter";
        }
        if (jrpa.getAnnotation("org.eclipse.persistence.annotations.StructConverter") != null) {
            return "structConverter";
        }
        return null;
    }
}

