/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.EclipseLinkJpaFactory;
import org.eclipse.jpt.eclipselink.core.context.java.EclipseLinkJavaConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConverterAnnotation;

public class EclipseLinkJavaConverterImpl
extends AbstractJavaJpaContextNode
implements EclipseLinkJavaConverter {
    private JavaResourcePersistentMember resourcePersistentMember;
    private String name;
    private String converterClass;

    public EclipseLinkJavaConverterImpl(JavaJpaContextNode parent, JavaResourcePersistentMember jrpm) {
        super((JpaContextNode)parent);
        this.initialize(jrpm);
    }

    protected EclipseLinkJpaFactory getJpaFactory() {
        return (EclipseLinkJpaFactory)super.getJpaFactory();
    }

    public String getType() {
        return "converter";
    }

    protected String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    public void addToResourceModel() {
        this.resourcePersistentMember.addAnnotation(this.getAnnotationName());
    }

    public void removeFromResourceModel() {
        this.resourcePersistentMember.removeAnnotation(this.getAnnotationName());
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceConverter().getTextRange(astRoot);
    }

    protected ConverterAnnotation getResourceConverter() {
        return (ConverterAnnotation)this.resourcePersistentMember.getAnnotation(this.getAnnotationName());
    }

    public String getConverterClass() {
        return this.converterClass;
    }

    public void setConverterClass(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.getResourceConverter().setConverterClass(newConverterClass);
        this.firePropertyChanged("converterClassProperty", oldConverterClass, newConverterClass);
    }

    protected void setConverterClass_(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.firePropertyChanged("converterClassProperty", oldConverterClass, newConverterClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.getResourceConverter().setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void initialize(JavaResourcePersistentMember jrpm) {
        this.resourcePersistentMember = jrpm;
        ConverterAnnotation resourceConverter = this.getResourceConverter();
        this.name = this.name(resourceConverter);
        this.converterClass = this.converterClass(resourceConverter);
    }

    public void update(JavaResourcePersistentMember jrpm) {
        this.resourcePersistentMember = jrpm;
        ConverterAnnotation resourceConverter = this.getResourceConverter();
        this.setName_(this.name(resourceConverter));
        this.setConverterClass_(this.converterClass(resourceConverter));
    }

    protected String name(ConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getName();
    }

    protected String converterClass(ConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getConverterClass();
    }
}

