/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.ConversionValueImpl;
import org.eclipse.jpt.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.NestableConversionValue;
import org.eclipse.jpt.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeConverterImpl
extends AbstractResourceAnnotation<Attribute>
implements ObjectTypeConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.ObjectTypeConverter");
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> dataTypeAdapter;
    private final AnnotationElementAdapter<String> objectTypeAdapter;
    private final AnnotationElementAdapter<String> defaultObjectValueAdapter;
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = ObjectTypeConverterImpl.buildNameAdapter();
    private static final DeclarationAnnotationElementAdapter<String> DATA_TYPE_ADAPTER = ObjectTypeConverterImpl.buildDataTypeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> OBJECT_TYPE_ADAPTER = ObjectTypeConverterImpl.buildObjectTypeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> DEFAULT_OBJECT_VALUE_ADAPTER = ObjectTypeConverterImpl.buildDefaultObjectValueAdapter();
    private String name;
    private String dataType;
    private String objectType;
    private String defaultObjectValue;
    private final List<NestableConversionValue> conversionValues;
    private final ConversionValuesContainerAnnotation conversionValuesContainerAnnotation;

    protected ObjectTypeConverterImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.nameAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, NAME_ADAPTER);
        this.dataTypeAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, DATA_TYPE_ADAPTER);
        this.objectTypeAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, OBJECT_TYPE_ADAPTER);
        this.defaultObjectValueAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, DEFAULT_OBJECT_VALUE_ADAPTER);
        this.conversionValues = new ArrayList<NestableConversionValue>();
        this.conversionValuesContainerAnnotation = new ConversionValuesContainerAnnotation();
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.dataType = this.dataType(astRoot);
        this.objectType = this.objectType(astRoot);
        this.defaultObjectValue = this.defaultObjectValue(astRoot);
        ContainerAnnotationTools.initializeNestedAnnotations((CompilationUnit)astRoot, (ContainerAnnotation)this.conversionValuesContainerAnnotation);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue((Object)newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String newDataType) {
        if (this.attributeValueHasNotChanged(this.dataType, newDataType)) {
            return;
        }
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.dataTypeAdapter.setValue((Object)newDataType);
        this.firePropertyChanged("dataTypeProperty", oldDataType, newDataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String newObjectType) {
        if (this.attributeValueHasNotChanged(this.objectType, newObjectType)) {
            return;
        }
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.objectTypeAdapter.setValue((Object)newObjectType);
        this.firePropertyChanged("objectTypeProperty", oldObjectType, newObjectType);
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String newDefaultObjectValue) {
        if (this.attributeValueHasNotChanged(this.defaultObjectValue, newDefaultObjectValue)) {
            return;
        }
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.defaultObjectValueAdapter.setValue((Object)newDefaultObjectValue);
        this.firePropertyChanged("defaultObjectValueProperty", oldDefaultObjectValue, newDefaultObjectValue);
    }

    @Override
    public ListIterator<ConversionValueAnnotation> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public NestableConversionValue conversionValueAt(int index) {
        return this.conversionValues.get(index);
    }

    @Override
    public int indexOfConversionValue(ConversionValueAnnotation conversionValue) {
        return this.conversionValues.indexOf(conversionValue);
    }

    @Override
    public NestableConversionValue addConversionValue(int index) {
        NestableConversionValue conversionValue = (NestableConversionValue)ContainerAnnotationTools.addNestedAnnotation((int)index, (ContainerAnnotation)this.conversionValuesContainerAnnotation);
        this.fireItemAdded("joinColumnsList", index, conversionValue);
        return conversionValue;
    }

    private void addConversionValue(int index, NestableConversionValue conversionValue) {
        this.addItemToList(index, conversionValue, this.conversionValues, "joinColumnsList");
    }

    @Override
    public void removeConversionValue(int index) {
        NestableConversionValue conversionValue = this.conversionValues.get(index);
        this.removeConversionValue(conversionValue);
        conversionValue.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove((int)index, (ContainerAnnotation)this.conversionValuesContainerAnnotation);
    }

    private void removeConversionValue(NestableConversionValue conversionValue) {
        this.removeItemFromList(conversionValue, this.conversionValues, "joinColumnsList");
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        this.moveConversionValueInternal(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove((int)targetIndex, (int)sourceIndex, (ContainerAnnotation)this.conversionValuesContainerAnnotation);
        this.fireItemMoved("joinColumnsList", targetIndex, sourceIndex);
    }

    protected void moveConversionValueInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.conversionValues, (int)targetIndex, (int)sourceIndex);
    }

    protected NestableConversionValue createConversionValue(int index) {
        return ConversionValueImpl.createConversionValue(this, (Attribute)this.getMember(), this.getDeclarationAnnotationAdapter(), index);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAME_ADAPTER, astRoot);
    }

    @Override
    public TextRange getDataTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DATA_TYPE_ADAPTER, astRoot);
    }

    @Override
    public TextRange getObjectTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OBJECT_TYPE_ADAPTER, astRoot);
    }

    @Override
    public TextRange getDefaultObjectValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DEFAULT_OBJECT_VALUE_ADAPTER, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
        this.setDataType(this.dataType(astRoot));
        this.setObjectType(this.objectType(astRoot));
        this.setDefaultObjectValue(this.defaultObjectValue(astRoot));
        ContainerAnnotationTools.updateNestedAnnotationsFromJava((CompilationUnit)astRoot, (ContainerAnnotation)this.conversionValuesContainerAnnotation);
    }

    protected String name(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    protected String dataType(CompilationUnit astRoot) {
        return (String)this.dataTypeAdapter.getValue(astRoot);
    }

    protected String objectType(CompilationUnit astRoot) {
        return (String)this.objectTypeAdapter.getValue(astRoot);
    }

    protected String defaultObjectValue(CompilationUnit astRoot) {
        return (String)this.defaultObjectValueAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "name", false, StringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildDataTypeAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "dataType", false, SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildObjectTypeAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "objectType", false, SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildDefaultObjectValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "defaultObjectValue", false, StringExpressionConverter.instance());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConversionValuesContainerAnnotation
    extends AbstractJavaResourceNode
    implements ContainerAnnotation<NestableConversionValue> {
        public ConversionValuesContainerAnnotation() {
            super((JavaResourceNode)ObjectTypeConverterImpl.this);
        }

        public void initialize(CompilationUnit astRoot) {
        }

        public NestableConversionValue addInternal(int index) {
            NestableConversionValue conversionValue = ObjectTypeConverterImpl.this.createConversionValue(index);
            ObjectTypeConverterImpl.this.conversionValues.add(index, conversionValue);
            return conversionValue;
        }

        public NestableConversionValue add(int index) {
            NestableConversionValue conversionValue = ObjectTypeConverterImpl.this.createConversionValue(index);
            ObjectTypeConverterImpl.this.addConversionValue(index, conversionValue);
            return conversionValue;
        }

        public int indexOf(NestableConversionValue conversionValue) {
            return ObjectTypeConverterImpl.this.indexOfConversionValue(conversionValue);
        }

        public void move(int targetIndex, int sourceIndex) {
            ObjectTypeConverterImpl.this.moveConversionValue(targetIndex, sourceIndex);
        }

        public void moveInternal(int targetIndex, int sourceIndex) {
            ObjectTypeConverterImpl.this.moveConversionValueInternal(targetIndex, sourceIndex);
        }

        public NestableConversionValue nestedAnnotationAt(int index) {
            return ObjectTypeConverterImpl.this.conversionValueAt(index);
        }

        public ListIterator<NestableConversionValue> nestedAnnotations() {
            return new CloneListIterator(ObjectTypeConverterImpl.this.conversionValues);
        }

        public int nestedAnnotationsSize() {
            return ObjectTypeConverterImpl.this.conversionValuesSize();
        }

        public void remove(int index) {
            this.remove(this.nestedAnnotationAt(index));
        }

        public void remove(NestableConversionValue conversionValue) {
            ObjectTypeConverterImpl.this.removeConversionValue(conversionValue);
        }

        public String getAnnotationName() {
            return ObjectTypeConverterImpl.this.getAnnotationName();
        }

        public String getNestableAnnotationName() {
            return "org.eclipse.persistence.annotations.ConversionValue";
        }

        public NestableConversionValue nestedAnnotationFor(org.eclipse.jdt.core.dom.Annotation jdtAnnotation) {
            for (NestableConversionValue conversionValue : CollectionTools.iterable(this.nestedAnnotations())) {
                if (jdtAnnotation != conversionValue.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
                return conversionValue;
            }
            return null;
        }

        public org.eclipse.jdt.core.dom.Annotation getJdtAnnotation(CompilationUnit astRoot) {
            return ObjectTypeConverterImpl.this.getJdtAnnotation(astRoot);
        }

        public void newAnnotation() {
            ObjectTypeConverterImpl.this.newAnnotation();
        }

        public void removeAnnotation() {
            ObjectTypeConverterImpl.this.removeAnnotation();
        }

        public void update(CompilationUnit astRoot) {
            ObjectTypeConverterImpl.this.update(astRoot);
        }

        public TextRange getTextRange(CompilationUnit astRoot) {
            return ObjectTypeConverterImpl.this.getTextRange(astRoot);
        }

        public String getElementName() {
            return "conversionValues";
        }
    }

    public static class ObjectTypeConverterAnnotationDefinition
    implements AnnotationDefinition {
        private static final ObjectTypeConverterAnnotationDefinition INSTANCE = new ObjectTypeConverterAnnotationDefinition();

        public static ObjectTypeConverterAnnotationDefinition instance() {
            return INSTANCE;
        }

        private ObjectTypeConverterAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new ObjectTypeConverterImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.ObjectTypeConverter";
        }
    }
}

