/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.TypeConverterAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverterImpl
extends AbstractResourceAnnotation<Attribute>
implements TypeConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.TypeConverter");
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> dataTypeAdapter;
    private final AnnotationElementAdapter<String> objectTypeAdapter;
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = TypeConverterImpl.buildNameAdapter();
    private static final DeclarationAnnotationElementAdapter<String> DATA_TYPE_ADAPTER = TypeConverterImpl.buildDataTypeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> OBJECT_TYPE_ADAPTER = TypeConverterImpl.buildObjectTypeAdapter();
    private String name;
    private String dataType;
    private String objectType;

    protected TypeConverterImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.nameAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, NAME_ADAPTER);
        this.dataTypeAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, DATA_TYPE_ADAPTER);
        this.objectTypeAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, OBJECT_TYPE_ADAPTER);
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.dataType = this.dataType(astRoot);
        this.objectType = this.objectType(astRoot);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.TypeConverter";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue((Object)newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String newDataType) {
        if (this.attributeValueHasNotChanged(this.dataType, newDataType)) {
            return;
        }
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.dataTypeAdapter.setValue((Object)newDataType);
        this.firePropertyChanged("dataTypeProperty", oldDataType, newDataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String newObjectType) {
        if (this.attributeValueHasNotChanged(this.objectType, newObjectType)) {
            return;
        }
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.objectTypeAdapter.setValue((Object)newObjectType);
        this.firePropertyChanged("objectTypeProperty", oldObjectType, newObjectType);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(NAME_ADAPTER, astRoot);
    }

    @Override
    public TextRange getDataTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DATA_TYPE_ADAPTER, astRoot);
    }

    @Override
    public TextRange getObjectTypeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OBJECT_TYPE_ADAPTER, astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
        this.setDataType(this.dataType(astRoot));
        this.setObjectType(this.objectType(astRoot));
    }

    protected String name(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    protected String dataType(CompilationUnit astRoot) {
        return (String)this.dataTypeAdapter.getValue(astRoot);
    }

    protected String objectType(CompilationUnit astRoot) {
        return (String)this.objectTypeAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildNameAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "name", false, StringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildDataTypeAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "dataType", false, SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildObjectTypeAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "objectType", false, SimpleTypeStringExpressionConverter.instance());
    }

    public static class TypeConverterAnnotationDefinition
    implements AnnotationDefinition {
        private static final TypeConverterAnnotationDefinition INSTANCE = new TypeConverterAnnotationDefinition();

        public static TypeConverterAnnotationDefinition instance() {
            return INSTANCE;
        }

        private TypeConverterAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new TypeConverterImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.TypeConverter";
        }
    }
}

