/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.ColumnImpl;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.NullWriteTransformerColumn;
import org.eclipse.jpt.eclipselink.core.resource.java.WriteTransformerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteTransformerImpl
extends AbstractResourceAnnotation<Attribute>
implements WriteTransformerAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.WriteTransformer");
    private final AnnotationElementAdapter<String> transformerClassAdapter;
    private final AnnotationElementAdapter<String> methodAdapter;
    private final MemberAnnotationAdapter columnAdapter;
    private static final DeclarationAnnotationElementAdapter<String> TRANSFORMER_CLASS_ADAPTER = WriteTransformerImpl.buildTransformerClassAdapter();
    private static final DeclarationAnnotationElementAdapter<String> METHOD_ADAPTER = WriteTransformerImpl.buildMethodAdapter();
    private String transformerClass;
    private String method;
    private ColumnImpl column;

    protected WriteTransformerImpl(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.transformerClassAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, TRANSFORMER_CLASS_ADAPTER);
        this.methodAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, METHOD_ADAPTER);
        this.columnAdapter = new MemberAnnotationAdapter(this.getMember(), WriteTransformerImpl.buildColumnAnnotationAdapter(this.getDeclarationAnnotationAdapter()));
    }

    public void initialize(CompilationUnit astRoot) {
        this.transformerClass = this.transformerClass(astRoot);
        this.method = this.method(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) != null) {
            this.column = WriteTransformerImpl.createColumn(this, this.getMember(), this.getDeclarationAnnotationAdapter());
            this.column.initialize(astRoot);
        }
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.WriteTransformer";
    }

    @Override
    public String getTransformerClass() {
        return this.transformerClass;
    }

    @Override
    public void setTransformerClass(String newTransformerClass) {
        if (this.attributeValueHasNotChanged(this.transformerClass, newTransformerClass)) {
            return;
        }
        String oldTransformerClass = this.transformerClass;
        this.transformerClass = newTransformerClass;
        this.transformerClassAdapter.setValue((Object)newTransformerClass);
        this.firePropertyChanged("transformerClassProperty", oldTransformerClass, newTransformerClass);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String newMethod) {
        if (this.attributeValueHasNotChanged(this.method, newMethod)) {
            return;
        }
        String oldMethod = this.method;
        this.method = newMethod;
        this.methodAdapter.setValue((Object)newMethod);
        this.firePropertyChanged("methodProperty", oldMethod, newMethod);
    }

    @Override
    public ColumnAnnotation getNonNullColumn() {
        return this.getColumn() != null ? this.getColumn() : new NullWriteTransformerColumn(this);
    }

    @Override
    public ColumnAnnotation getColumn() {
        return this.column;
    }

    @Override
    public ColumnAnnotation addColumn() {
        ColumnImpl column = WriteTransformerImpl.createColumn(this, this.getMember(), this.getDeclarationAnnotationAdapter());
        column.newAnnotation();
        this.setColumn(column);
        return column;
    }

    @Override
    public void removeColumn() {
        this.column.removeAnnotation();
        this.setColumn(null);
    }

    protected void setColumn(ColumnImpl newColumn) {
        ColumnImpl oldColumn = this.column;
        this.column = newColumn;
        this.firePropertyChanged("columnProperty", oldColumn, newColumn);
    }

    @Override
    public TextRange getTransformerClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TRANSFORMER_CLASS_ADAPTER, astRoot);
    }

    @Override
    public TextRange getMethodTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(METHOD_ADAPTER, astRoot);
    }

    @Override
    public TextRange getColumnTextRange(CompilationUnit astRoot) {
        if (this.column != null) {
            return this.column.getTextRange(astRoot);
        }
        return this.getTextRange(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setTransformerClass(this.transformerClass(astRoot));
        this.setMethod(this.method(astRoot));
        if (this.columnAdapter.getAnnotation(astRoot) == null) {
            this.setColumn(null);
        } else if (this.getColumn() != null) {
            this.getColumn().update(astRoot);
        } else {
            ColumnImpl column = WriteTransformerImpl.createColumn(this, this.getMember(), this.getDeclarationAnnotationAdapter());
            column.initialize(astRoot);
            this.setColumn(column);
        }
    }

    protected String transformerClass(CompilationUnit astRoot) {
        return (String)this.transformerClassAdapter.getValue(astRoot);
    }

    protected String method(CompilationUnit astRoot) {
        return (String)this.methodAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTransformerClassAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "transformerClass", false, SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildMethodAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"method", (boolean)false);
    }

    private static DeclarationAnnotationAdapter buildColumnAnnotationAdapter(DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(writeTransformerAnnotationAdapter, "column", "javax.persistence.Column", false);
    }

    private static ColumnImpl createColumn(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new ColumnImpl(parent, member, WriteTransformerImpl.buildColumnAnnotationAdapter(writeTransformerAnnotationAdapter));
    }

    public static class WriteTransformerAnnotationDefinition
    implements AnnotationDefinition {
        private static final WriteTransformerAnnotationDefinition INSTANCE = new WriteTransformerAnnotationDefinition();

        public static WriteTransformerAnnotationDefinition instance() {
            return INSTANCE;
        }

        private WriteTransformerAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourcePersistentMember parent, Member member) {
            return new WriteTransformerImpl((JavaResourcePersistentAttribute)parent, (Attribute)member);
        }

        public Annotation buildNullAnnotation(JavaResourcePersistentMember parent, Member member) {
            return null;
        }

        public String getAnnotationName() {
            return "org.eclipse.persistence.annotations.WriteTransformer";
        }
    }
}

