/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.dialogs.ResourceChooserDialog;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.FEUiPlugin;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.IGenerateDDL;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FESelectFileWizardPage
extends WizardPage
implements IContextProvider {
    private static final String FE_SELECT_DATABASE_PAGE_HEADER_SUBTITLE = ResourceLoader.INSTANCE.queryString("FE_SELECT_DATABASE_PAGE_HEADER_SUBTITLE");
    private static final String FE_SELECT_DATABASE_PAGE_HEADER_TITLE = ResourceLoader.INSTANCE.queryString("FE_SELECT_DATABASE_PAGE_HEADER_TITLE");
    private static final String FILE_PATH_LABEL_TEXT = ResourceLoader.INSTANCE.queryString("FILE_PATH_LABEL_TEXT");
    private static final String BROWSE_BUTTON_TEXT_2 = ResourceLoader.INSTANCE.queryString("BROWSE_BUTTON_TEXT_2");
    private static final String DEFAULT_SCRIPT_FILE_BASE_NAME = ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.defaultScriptFileBaseName");
    private Label projectPathLabel;
    private Text projectPathText;
    private Button browseButton;
    private Label fileNameLabel;
    private Text fileNameText;
    private IContainer selectedContainer;
    private Text ddlPreviewText;
    private Button executeCheckBox;
    private Button openDDLCheckbox;
    private List selection;
    private String terminator = ";";
    private Text terminatorText;
    private Button applyTerminatorButton;
    private static final String SCRIPT_FILE_EXTENSION = "sql";
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(FEUiPlugin.getDefault().getBundle().getSymbolicName());

    public FESelectFileWizardPage(String pageName) {
        this(pageName, null);
    }

    public FESelectFileWizardPage(String pageName, List selection) {
        super(pageName);
        this.selection = selection;
        this.setTitle(FE_SELECT_DATABASE_PAGE_HEADER_TITLE);
        this.setDescription(FE_SELECT_DATABASE_PAGE_HEADER_SUBTITLE);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.projectPathLabel = new Label(composite, 0);
        this.projectPathLabel.setText(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.folderLabel"));
        this.projectPathLabel.setLayoutData((Object)new GridData());
        this.projectPathText = new Text(composite, 2048);
        this.projectPathText.setLayoutData((Object)new GridData(768));
        this.projectPathText.setText("");
        this.projectPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FESelectFileWizardPage.this.setPageComplete(FESelectFileWizardPage.this.validatePage());
            }
        });
        this.browseButton = new Button(composite, 0);
        GridData data = new GridData(128);
        data.horizontalSpan = 1;
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.setText(BROWSE_BUTTON_TEXT_2);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FESelectFileWizardPage.this.onClickBrowse();
            }
        });
        this.fileNameLabel = new Label(composite, 0);
        this.fileNameLabel.setText(FILE_PATH_LABEL_TEXT);
        this.fileNameLabel.setLayoutData((Object)new GridData());
        this.fileNameText = new Text(composite, 2052);
        data = new GridData(256);
        data.horizontalSpan = 2;
        this.fileNameText.setLayoutData((Object)data);
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FESelectFileWizardPage.this.setPageComplete(FESelectFileWizardPage.this.validatePage());
            }
        });
        Group previewGroup = new Group(composite, 0);
        previewGroup.setText(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.ddlPreviewGroup"));
        data = new GridData(1296);
        data.horizontalSpan = 3;
        previewGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        previewGroup.setLayout((Layout)layout);
        this.ddlPreviewText = new Text((Composite)previewGroup, 2826);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.ddlPreviewText.setLayoutData((Object)data);
        Label terminatorLabel = new Label((Composite)previewGroup, 0);
        terminatorLabel.setText(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.terminatorLabel"));
        terminatorLabel.setLayoutData((Object)new GridData());
        this.terminatorText = new Text((Composite)previewGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.terminatorText.setLayoutData((Object)data);
        this.terminatorText.setText(this.terminator);
        this.terminatorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FESelectFileWizardPage.this.onTerminatorTextModified();
            }
        });
        this.applyTerminatorButton = new Button((Composite)previewGroup, 0);
        data = new GridData(32);
        data.horizontalSpan = 1;
        this.applyTerminatorButton.setLayoutData((Object)data);
        this.applyTerminatorButton.setText(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.terminatorApplyButton"));
        this.applyTerminatorButton.setEnabled(false);
        this.applyTerminatorButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FESelectFileWizardPage.this.onClickApplyTerminator();
            }
        });
        this.executeCheckBox = new Button(composite, 32);
        this.executeCheckBox.setText(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.executeDDLCheckbox"));
        this.executeCheckBox.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FESelectFileWizardPage.this.setPageComplete(FESelectFileWizardPage.this.validatePage());
            }
        });
        data = new GridData(8);
        data.horizontalSpan = 2;
        this.executeCheckBox.setLayoutData((Object)data);
        this.openDDLCheckbox = new Button(composite, 32);
        this.openDDLCheckbox.setText(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.openDDLCheckbox"));
        data = new GridData(8);
        data.horizontalSpan = 2;
        this.openDDLCheckbox.setLayoutData((Object)data);
        this.setControl((Control)composite);
        String defaultProjectName = this.getDefaultProjectName();
        this.projectPathText.setText(defaultProjectName);
        this.fileNameText.setText(this.getDefaultFileName(defaultProjectName));
        this.setPageComplete(this.validatePage());
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"GENERATE_DDL_FILE_WIZARD_PAGE", (String)FEUiPlugin.getDefault().getBundle().getSymbolicName()));
    }

    private void populatePreviewDDL() {
        String ddlScriptText = ((IGenerateDDL)this.getWizard()).generateDDL().toString();
        this.ddlPreviewText.setText(ddlScriptText);
    }

    protected String getSubtitle() {
        return FE_SELECT_DATABASE_PAGE_HEADER_SUBTITLE;
    }

    public boolean validatePage() {
        String ext;
        boolean isValid = true;
        String container = this.projectPathText.getText();
        String fileName = this.fileNameText.getText();
        if (container.length() == 0) {
            this.updateMessage(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.specifyFolderMessage"));
            return false;
        }
        Path containerPath = new Path(String.valueOf(String.valueOf('/')) + container.trim());
        if (containerPath.segmentCount() == 0) {
            this.updateError(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.specifyValidFolderMessage"));
            return false;
        }
        if (containerPath.segmentCount() == 1) {
            if (!ResourcesPlugin.getWorkspace().getRoot().exists((IPath)containerPath) || !ResourcesPlugin.getWorkspace().getRoot().getProject(container.trim()).exists()) {
                this.updateError(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.specifyValidFolderMessage"));
                return false;
            }
        } else if (!ResourcesPlugin.getWorkspace().getRoot().exists((IPath)containerPath) || !ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)containerPath).exists()) {
            this.updateError(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.specifyValidFolderMessage"));
            return false;
        }
        if (fileName.length() == 0) {
            this.updateMessage(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.specifyFileMessage"));
            return false;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(SCRIPT_FILE_EXTENSION)) {
            this.updateError(ResourceLoader.INSTANCE.queryString("FEWizard.SelectFilePage.invalidFileExtensionMessage"));
            return false;
        }
        if (isValid) {
            this.updateError(null);
        }
        return isValid;
    }

    private void updateError(String message) {
        this.setErrorMessage(message);
        this.setMessage(null);
    }

    private void updateMessage(String message) {
        this.setMessage(message);
        this.setErrorMessage(null);
    }

    private void onClickBrowse() {
        Iterator selectionIterator;
        Object[] result;
        IStructuredSelection selection;
        ResourceChooserDialog dialog = new ResourceChooserDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, null, false);
        dialog.showClosedProjects(false);
        if (dialog.open() == 0 && (selection = (IStructuredSelection)(result = dialog.getResult())[0]) != null && (selectionIterator = selection.iterator()).hasNext()) {
            IResource selectedItem = (IResource)selectionIterator.next();
            this.selectedContainer = (IContainer)selectedItem;
            this.projectPathText.setText(selectedItem.getFullPath().toOSString());
        }
    }

    public String getResourcePath() {
        String path = "";
        if (this.projectPathText.getText() != null) {
            path = String.valueOf(this.projectPathText.getText()) + String.valueOf('/') + this.fileNameText.getText();
        }
        return path;
    }

    public IContainer getSelectedContainer() {
        return this.selectedContainer;
    }

    public boolean isExecuteSelected() {
        boolean selected = false;
        if (this.executeCheckBox != null) {
            selected = this.executeCheckBox.getSelection();
        }
        return selected;
    }

    public boolean isOpenDDLSelected() {
        boolean isSelected = false;
        if (this.openDDLCheckbox != null) {
            isSelected = this.openDDLCheckbox.getSelection();
        }
        return isSelected;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.populatePreviewDDL();
        }
    }

    public void setTerminator(String terminator) {
        this.terminator = terminator;
        if (this.terminatorText != null) {
            this.terminatorText.setText(terminator);
        }
    }

    public String getTerminator() {
        return this.terminator;
    }

    private void onClickApplyTerminator() {
        if (this.terminatorText != null) {
            this.terminator = this.terminatorText.getText().trim();
            this.populatePreviewDDL();
            this.applyTerminatorButton.setEnabled(false);
        }
    }

    private void onTerminatorTextModified() {
        this.applyTerminatorButton.setEnabled(true);
    }

    private String getDefaultProjectName() {
        String projectName = "";
        String selectionProject = null;
        try {
            selectionProject = this.selection != null && ((SQLObject)this.selection.get(0)).eResource() != null ? ((SQLObject)this.selection.get(0)).eResource().getURI().segmentsList().get(1).toString() : null;
        }
        catch (Exception exception) {}
        if (selectionProject != null && !selectionProject.equals("") && ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(selectionProject))) {
            projectName = String.valueOf(String.valueOf('/')) + selectionProject;
        } else {
            IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int index = 0;
            while (index < allProjects.length) {
                if (allProjects[index].isOpen()) {
                    String path = allProjects[index].getFullPath().toString();
                    projectName = path.substring(1, path.length());
                    break;
                }
                ++index;
            }
        }
        return projectName;
    }

    private String getDefaultFileName(String folderName) {
        String fileName = "";
        String baseName = DEFAULT_SCRIPT_FILE_BASE_NAME;
        if (!ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(String.valueOf(folderName) + String.valueOf('/') + baseName + "." + SCRIPT_FILE_EXTENSION))) {
            fileName = String.valueOf(baseName) + "." + SCRIPT_FILE_EXTENSION;
        } else {
            int index = 1;
            while (true) {
                try {
                    if (!ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(String.valueOf(folderName) + String.valueOf('/') + baseName + index + "." + SCRIPT_FILE_EXTENSION))) {
                        fileName = String.valueOf(baseName) + index + "." + SCRIPT_FILE_EXTENSION;
                        break;
                    }
                }
                catch (Exception exception) {}
                ++index;
            }
        }
        return fileName;
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

