/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.BTreeValues;
import org.eclipse.birt.core.btree.LeafEntry;
import org.eclipse.birt.core.btree.LeafNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeCursor<K, V> {
    protected BTree<K, V> btree;
    protected LeafEntry<K, V> entry;

    BTreeCursor(BTree<K, V> btree) {
        this.btree = btree;
        this.entry = null;
    }

    public int getTotalKeys() {
        return this.btree.getTotalKeys();
    }

    public int getTotalValues() {
        return this.btree.getTotalValues();
    }

    public void reset() throws IOException {
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
            this.entry = null;
        }
    }

    public boolean moveTo(K key) throws IOException {
        LeafEntry<K, V> tgtEntry = this.btree.findEntry(key);
        if (tgtEntry != null) {
            this.btree.lockEntry(tgtEntry);
            if (this.entry != null) {
                this.btree.unlockEntry(this.entry);
            }
            this.entry = tgtEntry;
            K tgtKey = this.btree.getKey(tgtEntry.getKey());
            if (key.equals(tgtKey)) {
                return true;
            }
        }
        return false;
    }

    private LeafEntry<K, V> getPrevEntry(LeafEntry<K, V> entry) throws IOException {
        LeafEntry<K, V> prevEntry = entry.getPrev();
        if (prevEntry != null) {
            return prevEntry;
        }
        int prevNodeId = entry.getNode().getPrevNodeId();
        if (prevNodeId != -1) {
            LeafNode prevNode = (LeafNode)this.btree.loadBTreeNode(prevNodeId);
            try {
                LeafEntry leafEntry = prevNode.getLastEntry();
                return leafEntry;
            }
            finally {
                prevNode.unlock();
            }
        }
        return null;
    }

    private LeafEntry<K, V> getNextEntry(LeafEntry<K, V> entry) throws IOException {
        LeafEntry<K, V> nextEntry = entry.getNext();
        if (nextEntry != null) {
            return nextEntry;
        }
        int nextNodeId = entry.getNode().getNextNodeId();
        if (nextNodeId != -1) {
            LeafNode nextNode = (LeafNode)this.btree.loadBTreeNode(nextNodeId);
            try {
                LeafEntry leafEntry = nextNode.getFirstEntry();
                return leafEntry;
            }
            finally {
                nextNode.unlock();
            }
        }
        return null;
    }

    public boolean previous() throws IOException {
        LeafEntry<K, V> tgtEntry = this.getPrevEntry(this.entry);
        if (tgtEntry != null) {
            this.btree.lockEntry(tgtEntry);
            if (this.entry != null) {
                this.btree.unlockEntry(this.entry);
            }
            this.entry = tgtEntry;
            return true;
        }
        return false;
    }

    public boolean next() throws IOException {
        LeafEntry<K, V> tgtEntry = this.getNextEntry(this.entry);
        if (tgtEntry != null) {
            this.btree.lockEntry(tgtEntry);
            if (this.entry != null) {
                this.btree.unlockEntry(this.entry);
            }
            this.entry = tgtEntry;
            return true;
        }
        return false;
    }

    public boolean hasPrevious() throws IOException {
        LeafEntry<K, V> prev = this.getPrevEntry(this.entry);
        return prev != null;
    }

    public boolean hasNext() throws IOException {
        LeafEntry<K, V> next = this.getNextEntry(this.entry);
        return next != null;
    }

    public K getKey() throws IOException {
        if (this.entry == null) {
            throw new IOException("Invalid cursor position");
        }
        return this.btree.getKey(this.entry.getKey());
    }

    public V getValue() throws IOException {
        if (!this.btree.hasValue()) {
            return null;
        }
        BTreeValues<V> values = this.entry.getValues();
        BTreeValues.Value<V> value = values.getFirstValue();
        BTreeValue<V> v = value.getValue();
        return this.btree.getValue(v);
    }

    public Collection<V> getValues() throws IOException {
        if (this.entry != null) {
            BTreeValues<V> values = this.entry.getValues();
            ArrayList<V> list = new ArrayList<V>(values.getValueCount());
            BTreeValues.Value<V> value = values.getFirstValue();
            while (value != null) {
                BTreeValue<V> bv = value.getValue();
                V v = this.btree.getValue(bv);
                list.add(v);
            }
            return list;
        }
        throw new IOException("must initialize the cursor first");
    }

    public void insert(K key, V value) throws IOException {
        LeafEntry<K, V> tgtEntry = this.btree.insertEntry(key, value);
        this.btree.lockEntry(tgtEntry);
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
        }
        this.entry = tgtEntry;
    }

    public void remove() throws IOException {
        throw new UnsupportedOperationException("remove");
    }

    public void setValue(V value) throws IOException {
        throw new UnsupportedOperationException("setValue(V)");
    }

    public void close() {
        if (this.entry != null) {
            this.btree.unlockEntry(this.entry);
            this.entry = null;
        }
    }
}

