/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.AbstractClassFileContainer;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;

public abstract class AbstractApiComponent
extends AbstractClassFileContainer
implements IApiComponent {
    private IApiDescription fApiDescription = null;
    private IApiFilterStore fFilterStore = null;
    private IApiProfile fProfile = null;

    public AbstractApiComponent(IApiProfile profile) {
        this.fProfile = profile;
    }

    public void accept(ClassFileContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            super.accept(visitor);
        }
        visitor.end(this);
    }

    public IApiProfile getProfile() {
        return this.fProfile;
    }

    public void dispose() {
        try {
            this.close();
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        this.fApiDescription = null;
        this.fProfile = null;
    }

    public synchronized IApiDescription getApiDescription() throws CoreException {
        if (this.fApiDescription == null) {
            this.fApiDescription = this.createApiDescription();
        }
        return this.fApiDescription;
    }

    protected synchronized boolean isApiDescriptionInitialized() {
        return this.fApiDescription != null;
    }

    protected synchronized boolean hasApiFilterStore() {
        return this.fFilterStore != null;
    }

    public synchronized IClassFileContainer[] getClassFileContainers() {
        return super.getClassFileContainers();
    }

    public synchronized IClassFileContainer[] getClassFileContainers(String id) {
        if (this.hasFragments()) {
            return super.getClassFileContainers(id);
        }
        return super.getClassFileContainers();
    }

    protected abstract IApiDescription createApiDescription() throws CoreException;

    public IApiFilterStore getFilterStore() throws CoreException {
        if (this.fFilterStore == null) {
            this.fFilterStore = this.createApiFilterStore();
        }
        return this.fFilterStore;
    }

    public IApiProblemFilter newProblemFilter(IApiProblem problem) {
        return new ApiProblemFilter(this.getId(), problem);
    }

    protected abstract IApiFilterStore createApiFilterStore() throws CoreException;
}

