/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.EEVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.api.tools.internal.AnyValue;
import org.eclipse.pde.api.tools.internal.BundleApiComponent;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApiProfile
implements IApiProfile,
IVMInstallChangedListener {
    private static boolean DEBUG = Util.DEBUG;
    public static IWorkspaceRoot ROOT;
    public static IPath ROOT_LOCATION_PATH;
    private IApiComponent[] EMPTY_COMPONENTS = new IApiComponent[0];
    private String fName;
    private State fState;
    private long fNextId = 0L;
    private String fExecutionEnvironment;
    private IApiComponent fSystemLibraryComponent;
    private boolean fAutoResolve = false;
    private IStatus fEEStatus = null;
    private AnyValue ANY_VALUE = new AnyValue("*");
    private HashMap fComponentsCache = null;
    private Map fComponents = null;
    private Map fComponentsById = null;
    private Set fSystemPackageNames = null;
    private IVMInstall fVMBinding = null;

    static {
        try {
            ROOT = ResourcesPlugin.getWorkspace().getRoot();
            ROOT_LOCATION_PATH = ROOT.getLocation();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public ApiProfile(String name) {
        this.fName = name;
        this.fAutoResolve = true;
        this.fEEStatus = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiProfile_0);
        this.fState = StateObjectFactory.defaultFactory.createState(true);
    }

    public ApiProfile(String name, File eeDescription) throws CoreException {
        this(name);
        this.fAutoResolve = false;
        EEVMType.clearProperties((File)eeDescription);
        String profile = EEVMType.getProperty((String)"-Dee.class.library.level", (File)eeDescription);
        this.initialize(profile, eeDescription);
        this.fEEStatus = new Status(0, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiProfile_1, (Object[])new String[]{profile}));
    }

    private void initialize(String environmentId, File eeFile) throws CoreException {
        Properties properties = null;
        properties = ApiPlugin.isRunningInFramework() ? ApiProfile.getJavaProfileProperties(environmentId) : Util.getEEProfile(eeFile);
        if (properties == null) {
            ApiProfile.abort("Unknown execution environment: " + environmentId, null);
        } else {
            this.initialize(properties, eeFile);
        }
    }

    private static void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }

    public static Properties getJavaProfileProperties(String ee) throws CoreException {
        Bundle osgiBundle = Platform.getBundle((String)"org.eclipse.osgi");
        if (osgiBundle == null) {
            return null;
        }
        URL profileURL = osgiBundle.getEntry(String.valueOf(ee.replace('/', '_')) + ".profile");
        if (profileURL != null) {
            InputStream is = null;
            try {
                profileURL = FileLocator.resolve((URL)profileURL);
                URLConnection openConnection = profileURL.openConnection();
                openConnection.setUseCaches(false);
                is = openConnection.getInputStream();
                if (is != null) {
                    Properties profile = new Properties();
                    profile.load(is);
                    Properties properties = profile;
                    return properties;
                }
            }
            catch (IOException e) {
                ApiProfile.abort("Unable to read profile: " + ee, e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    private void initialize(Properties profile, File description) throws CoreException {
        String value = profile.getProperty("org.osgi.framework.system.packages");
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        String[] systemPackages = null;
        if (value != null) {
            systemPackages = value.split(",");
            ((Dictionary)dictionary).put("org.osgi.framework.system.packages", value);
        }
        if ((value = profile.getProperty("org.osgi.framework.executionenvironment")) != null) {
            ((Dictionary)dictionary).put("org.osgi.framework.executionenvironment", value);
        }
        this.fExecutionEnvironment = profile.getProperty("osgi.java.profile.name");
        if (this.fExecutionEnvironment == null) {
            ApiProfile.abort("Profile file missing 'osgi.java.profile.name'", null);
        }
        ((Dictionary)dictionary).put("osgi.os", this.ANY_VALUE);
        ((Dictionary)dictionary).put("osgi.arch", this.ANY_VALUE);
        ((Dictionary)dictionary).put("osgi.ws", this.ANY_VALUE);
        ((Dictionary)dictionary).put("osgi.nl", this.ANY_VALUE);
        this.fState.setPlatformProperties(dictionary);
        if (this.fSystemLibraryComponent != null && this.fComponentsById != null) {
            this.fComponentsById.remove(this.fSystemLibraryComponent.getId());
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
            this.fSystemPackageNames = null;
        }
        this.clearComponentsCache();
        this.fSystemLibraryComponent = new SystemLibraryApiComponent(this, description, systemPackages);
        this.addComponent(this.fSystemLibraryComponent);
    }

    private void clearComponentsCache() {
        if (this.fComponentsCache != null) {
            this.fComponentsCache.clear();
            this.fComponentsCache = null;
        }
    }

    private void addComponent(IApiComponent component) {
        if (component == null) {
            return;
        }
        if (this.fComponentsById == null) {
            this.fComponentsById = new HashMap();
        }
        this.fComponentsById.put(component.getId(), component);
    }

    public void addApiComponents(IApiComponent[] components) {
        HashSet<String> ees = new HashSet<String>();
        int i = 0;
        while (i < components.length) {
            BundleApiComponent component = (BundleApiComponent)components[i];
            if (!component.isSourceComponent()) {
                BundleDescription description = component.getBundleDescription();
                this.fState.addBundle(description);
                this.storeBundleDescription(description, component);
                this.addComponent(component);
                ees.addAll(Arrays.asList(component.getExecutionEnvironments()));
            }
            ++i;
        }
        this.resolveSystemLibrary(ees);
        this.fState.resolve();
        if (DEBUG) {
            ResolverError[] errors = this.getErrors();
            int length = errors.length;
            if (length != 0) {
                System.out.println("Errors found during state resolution");
                int i2 = 0;
                while (i2 < length) {
                    ResolverError resolverError = errors[i2];
                    System.err.println(resolverError);
                    ++i2;
                }
                System.out.println("All components added to the state");
                BundleDescription[] bundles = this.fState.getBundles();
                Arrays.sort(bundles, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        BundleDescription bundleDescription1 = (BundleDescription)o1;
                        BundleDescription bundleDescription2 = (BundleDescription)o2;
                        return bundleDescription1.getSymbolicName().compareTo(bundleDescription2.getSymbolicName());
                    }
                });
                int i3 = 0;
                int max = bundles.length;
                while (i3 < max) {
                    BundleDescription bundleDescription = bundles[i3];
                    System.out.println("bundle descriptions added to the state[" + i3 + "] : " + bundleDescription.getSymbolicName());
                    ++i3;
                }
                System.out.println("All available components");
                Arrays.sort(components, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        IApiComponent component1 = (IApiComponent)o1;
                        IApiComponent component2 = (IApiComponent)o2;
                        return component1.getId().compareTo(component2.getId());
                    }
                });
                i3 = 0;
                max = components.length;
                while (i3 < max) {
                    IApiComponent component = components[i3];
                    if (component instanceof PluginProjectApiComponent) {
                        System.out.println("workspace component[" + i3 + "] : " + component);
                    } else {
                        System.out.println("Binary component   [" + i3 + "] : " + component);
                    }
                    ++i3;
                }
            } else {
                System.out.println("No errors found during state resolution");
            }
        }
    }

    private void resolveSystemLibrary(HashSet ees) {
        if (ApiPlugin.isRunningInFramework() && this.fAutoResolve) {
            Status error = null;
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            Iterator<Object> iterator = ees.iterator();
            HashMap<IVMInstall, HashSet<String>> VMsToEEs = new HashMap<IVMInstall, HashSet<String>>();
            while (iterator.hasNext()) {
                String ee = (String)iterator.next();
                IExecutionEnvironment environment = manager.getEnvironment(ee);
                if (environment == null) continue;
                IVMInstall[] compatibleVMs = environment.getCompatibleVMs();
                int i = 0;
                while (i < compatibleVMs.length) {
                    IVMInstall vm = compatibleVMs[i];
                    HashSet<String> EEs = (HashSet<String>)VMsToEEs.get(vm);
                    if (EEs == null) {
                        EEs = new HashSet<String>();
                        VMsToEEs.put(vm, EEs);
                    }
                    EEs.add(ee);
                    ++i;
                }
            }
            iterator = VMsToEEs.entrySet().iterator();
            IVMInstall bestFit = null;
            int bestCount = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Set EEs = (Set)entry.getValue();
                if (EEs.size() <= bestCount) continue;
                bestCount = EEs.size();
                bestFit = (IVMInstall)entry.getKey();
            }
            String systemEE = null;
            if (bestFit != null) {
                String javaVersion;
                IExecutionEnvironment[] environments = manager.getExecutionEnvironments();
                int i = 0;
                while (i < environments.length) {
                    IExecutionEnvironment environment = environments[i];
                    if (environment.isStrictlyCompatible(bestFit)) {
                        systemEE = environment.getId();
                        break;
                    }
                    ++i;
                }
                if (systemEE == null && bestFit instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)bestFit).getJavaVersion()) != null && javaVersion.startsWith("1.7")) {
                    systemEE = "JavaSE-1.6";
                }
                if (systemEE != null) {
                    if (!systemEE.equals(this.getExecutionEnvironment()) || this.fVMBinding == null) {
                        try {
                            File file = Util.createEEFile(bestFit, systemEE);
                            JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
                            this.fVMBinding = bestFit;
                            this.initialize(systemEE, file);
                        }
                        catch (CoreException e) {
                            error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiProfile_2, (Throwable)e);
                        }
                        catch (IOException e) {
                            error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiProfile_2, (Throwable)e);
                        }
                    }
                } else {
                    error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiProfile_4);
                }
            } else {
                error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiProfile_4);
            }
            if (error == null) {
                HashSet missing = new HashSet(ees);
                HashSet covered = new HashSet((Set)VMsToEEs.get(bestFit));
                missing.removeAll(covered);
                if (missing.isEmpty()) {
                    this.fEEStatus = new Status(0, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiProfile_1, (Object[])new String[]{systemEE}));
                } else {
                    iterator = missing.iterator();
                    MultiStatus multi = new MultiStatus("org.eclipse.pde.api.tools", 0, CoreMessages.ApiProfile_7, null);
                    while (iterator.hasNext()) {
                        String id = (String)iterator.next();
                        multi.add((IStatus)new Status(2, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiProfile_8, (Object[])new String[]{id})));
                    }
                    this.fEEStatus = multi;
                }
            } else {
                this.fEEStatus = error;
            }
        }
    }

    public IApiComponent[] getApiComponents() {
        if (this.fComponentsById == null) {
            return this.EMPTY_COMPONENTS;
        }
        Collection values = this.fComponentsById.values();
        return values.toArray(new IApiComponent[values.size()]);
    }

    public String getName() {
        return this.fName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized IApiComponent[] resolvePackage(IApiComponent sourceComponent, String packageName) throws CoreException {
        HashMap<IApiComponent, IApiComponent[]> componentsForPackage = null;
        if (this.fComponentsCache != null) {
            componentsForPackage = (HashMap<IApiComponent, IApiComponent[]>)this.fComponentsCache.get(packageName);
        } else {
            this.fComponentsCache = new HashMap(8);
        }
        IApiComponent[] cachedComponents = null;
        if (componentsForPackage != null) {
            cachedComponents = (IApiComponent[])componentsForPackage.get(sourceComponent);
            if (cachedComponents != null) {
                return cachedComponents;
            }
        } else {
            componentsForPackage = new HashMap<IApiComponent, IApiComponent[]>(8);
            this.fComponentsCache.put(packageName, componentsForPackage);
        }
        if (this.isSystemPackage(packageName)) {
            if (this.fSystemLibraryComponent == null) return this.EMPTY_COMPONENTS;
            cachedComponents = new IApiComponent[]{this.fSystemLibraryComponent};
        } else if (sourceComponent != null) {
            ArrayList componentsList = new ArrayList();
            this.resolvePackage0(sourceComponent, packageName, componentsList);
            if (componentsList.size() != 0) {
                cachedComponents = new IApiComponent[componentsList.size()];
                componentsList.toArray(cachedComponents);
            }
        }
        if (cachedComponents == null) {
            cachedComponents = this.EMPTY_COMPONENTS;
        }
        componentsForPackage.put(sourceComponent, cachedComponents);
        return cachedComponents;
    }

    private void resolvePackage0(IApiComponent component, String packageName, List componentsList) throws CoreException {
        BundleDescription bundle;
        if (component instanceof BundleApiComponent && (bundle = ((BundleApiComponent)component).getBundleDescription()) != null) {
            StateHelper helper = this.fState.getStateHelper();
            ExportPackageDescription[] visiblePackages = helper.getVisiblePackages(bundle);
            int i = 0;
            while (i < visiblePackages.length) {
                BundleDescription bundleDescription;
                IApiComponent exporter;
                ExportPackageDescription pkg = visiblePackages[i];
                if (packageName.equals(pkg.getName()) && (exporter = this.getBundleDescription(bundleDescription = pkg.getExporter())) != null) {
                    componentsList.add(exporter);
                }
                ++i;
            }
            String[] packageNames = component.getPackageNames();
            int i2 = 0;
            while (i2 < packageNames.length) {
                if (packageName.equals(packageNames[i2])) {
                    componentsList.add(component);
                }
                ++i2;
            }
        }
    }

    private boolean isSystemPackage(String packageName) {
        if (packageName.startsWith("java.")) {
            return true;
        }
        if (this.fSystemPackageNames == null) {
            ExportPackageDescription[] systemPackages = this.fState.getSystemPackages();
            this.fSystemPackageNames = new HashSet(systemPackages.length);
            int i = 0;
            while (i < systemPackages.length) {
                this.fSystemPackageNames.add(systemPackages[i].getName());
                ++i;
            }
        }
        return this.fSystemPackageNames.contains(packageName);
    }

    public IApiComponent newApiComponent(String location) throws CoreException {
        BundleApiComponent component = new BundleApiComponent(this, location);
        if (component.isValidBundle()) {
            component.init(this.fState, this.nextId());
            return component;
        }
        return null;
    }

    public IApiComponent newApiComponent(IPluginModelBase model) throws CoreException {
        BundleDescription bundleDescription = model.getBundleDescription();
        if (bundleDescription == null) {
            return null;
        }
        String location = bundleDescription.getLocation();
        if (location == null) {
            return null;
        }
        Path pathForLocation = new Path(location);
        BundleApiComponent component = null;
        if (ROOT_LOCATION_PATH != null && ROOT_LOCATION_PATH.isPrefixOf((IPath)pathForLocation)) {
            if (this.isValidProject(location)) {
                component = new PluginProjectApiComponent(this, location, model);
            }
        } else {
            component = new BundleApiComponent(this, location);
        }
        if (component != null && component.isValidBundle()) {
            component.init(this.fState, this.nextId());
            return component;
        }
        return null;
    }

    private boolean isValidProject(String location) throws CoreException {
        Path path = new Path(location);
        IProject project = ROOT.getProject(path.lastSegment());
        return project != null && project.exists();
    }

    private long nextId() {
        return ++this.fNextId;
    }

    public IApiComponent getApiComponent(String id) {
        if (this.fComponentsById == null) {
            return null;
        }
        return (IApiComponent)this.fComponentsById.get(id);
    }

    public String getExecutionEnvironment() {
        return this.fExecutionEnvironment;
    }

    public ResolverError[] getErrors() {
        ArrayList<ResolverError> errs = new ArrayList<ResolverError>();
        BundleDescription[] bundles = this.fState.getBundles();
        int i = 0;
        while (i < bundles.length) {
            ResolverError[] errors = this.fState.getResolverErrors(bundles[i]);
            int j = 0;
            while (j < errors.length) {
                errs.add(errors[j]);
                ++j;
            }
            ++i;
        }
        return errs.toArray(new ResolverError[errs.size()]);
    }

    public void setName(String name) {
        if (name != null) {
            this.fName = name;
        }
    }

    static File getBundle(String bundleName) {
        File[] bundles;
        File bundlesRoot;
        String root = System.getProperty("requiredBundles");
        if (root != null && (bundlesRoot = new File(root)).exists() && bundlesRoot.isDirectory() && (bundles = bundlesRoot.listFiles()) != null) {
            StringBuffer buffer = new StringBuffer(bundleName);
            buffer.append('_');
            String key = String.valueOf(buffer);
            int i = 0;
            while (i < bundles.length) {
                File file = bundles[i];
                if (file.getName().startsWith(key)) {
                    return file;
                }
                ++i;
            }
        }
        return null;
    }

    static Properties getEEProfile(File location, String ee) throws CoreException {
        String filename = String.valueOf(ee) + ".profile";
        InputStream is = null;
        ZipFile zipFile = null;
        try {
            if (location.isDirectory()) {
                File file = new File(location, filename);
                if (file.exists()) {
                    is = new FileInputStream(file);
                }
            } else {
                try {
                    zipFile = new ZipFile(location, 1);
                    ZipEntry entry = zipFile.getEntry(filename);
                    if (entry != null) {
                        is = zipFile.getInputStream(entry);
                    }
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                Properties profile = new Properties();
                profile.load(is);
                Properties properties = profile;
                return properties;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    public void dispose() {
        if (ApiPlugin.isRunningInFramework()) {
            JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
        }
        IApiComponent[] components = this.getApiComponents();
        int i = 0;
        while (i < components.length) {
            components[i].dispose();
            ++i;
        }
        if (this.fComponents != null) {
            this.fComponents.clear();
            this.fComponents = null;
        }
        this.clearComponentsCache();
        if (this.fComponentsById != null) {
            this.fComponentsById.clear();
            this.fComponentsById = null;
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
        }
        if (this.fSystemLibraryComponent != null) {
            this.fSystemLibraryComponent.dispose();
            this.fSystemLibraryComponent = null;
        }
        this.fState = null;
    }

    public void close() throws CoreException {
        IApiComponent[] components = this.getApiComponents();
        int i = 0;
        while (i < components.length) {
            components[i].close();
            ++i;
        }
    }

    public void writeProfileDescription(OutputStream stream) throws CoreException {
        String xml = this.getProfileXML(this);
        try {
            stream.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            ApiProfile.abort("Error writing pofile descrition", e);
        }
        catch (IOException e) {
            ApiProfile.abort("Error writing pofile descrition", e);
        }
    }

    private String getProfileXML(IApiProfile profile) throws CoreException {
        File dir;
        HashMap<File, ArrayList<IApiComponent>> pools = new HashMap<File, ArrayList<IApiComponent>>();
        ArrayList<IApiComponent> unRooted = new ArrayList<IApiComponent>();
        IApiComponent[] components = profile.getApiComponents();
        int i = 0;
        while (i < components.length) {
            String location;
            File file;
            if (!components[i].isSystemComponent() && (file = new File(location = components[i].getLocation())).exists()) {
                dir = file.getParentFile();
                if (dir != null) {
                    ArrayList<IApiComponent> pool = (ArrayList<IApiComponent>)pools.get(dir);
                    if (pool == null) {
                        pool = new ArrayList<IApiComponent>();
                        pools.put(dir, pool);
                    }
                    pool.add(components[i]);
                } else {
                    unRooted.add(components[i]);
                }
            }
            ++i;
        }
        Document document = Util.newDocument();
        Element root = document.createElement("apiprofile");
        document.appendChild(root);
        root.setAttribute("name", profile.getName());
        root.setAttribute("version", "1");
        Element subroot = null;
        dir = null;
        List comps = null;
        IApiComponent comp = null;
        Element celement = null;
        Iterator<Object> iter = pools.keySet().iterator();
        while (iter.hasNext()) {
            dir = (File)iter.next();
            subroot = document.createElement("pool");
            root.appendChild(subroot);
            subroot.setAttribute("location", new Path(dir.getAbsolutePath()).toPortableString());
            comps = (List)pools.get(dir);
            Iterator iter2 = comps.iterator();
            while (iter2.hasNext()) {
                comp = (IApiComponent)iter2.next();
                celement = document.createElement("apicomponent");
                celement.setAttribute("id", comp.getId());
                celement.setAttribute("version", comp.getVersion());
                subroot.appendChild(celement);
            }
        }
        iter = unRooted.iterator();
        while (iter.hasNext()) {
            comp = (IApiComponent)iter.next();
            celement = document.createElement("apicomponent");
            celement.setAttribute("id", comp.getId());
            celement.setAttribute("version", comp.getVersion());
            celement.setAttribute("location", new Path(comp.getLocation()).toPortableString());
            root.appendChild(celement);
        }
        return Util.serializeDocument(document);
    }

    public IApiComponent[] getDependentComponents(IApiComponent[] components) {
        ArrayList bundles = this.getBundleDescriptions(components);
        BundleDescription[] bundleDescriptions = this.fState.getStateHelper().getDependentBundles(bundles.toArray(new BundleDescription[bundles.size()]));
        return this.getApiComponents(bundleDescriptions);
    }

    private IApiComponent[] getApiComponents(BundleDescription[] bundles) {
        ArrayList<IApiComponent> dependents = new ArrayList<IApiComponent>(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            BundleDescription bundle = bundles[i];
            IApiComponent component = this.getApiComponent(bundle.getSymbolicName());
            if (component != null) {
                dependents.add(component);
            }
            ++i;
        }
        return dependents.toArray(new IApiComponent[dependents.size()]);
    }

    private ArrayList getBundleDescriptions(IApiComponent[] components) {
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>(components.length);
        int i = 0;
        while (i < components.length) {
            IApiComponent component = components[i];
            if (component instanceof BundleApiComponent) {
                bundles.add(((BundleApiComponent)component).getBundleDescription());
            }
            ++i;
        }
        return bundles;
    }

    public IApiComponent[] getPrerequisiteComponents(IApiComponent[] components) {
        ArrayList bundles = this.getBundleDescriptions(components);
        BundleDescription[] bundlesDescriptions = this.fState.getStateHelper().getPrerequisites(bundles.toArray(new BundleDescription[bundles.size()]));
        return this.getApiComponents(bundlesDescriptions);
    }

    private IApiComponent getBundleDescription(BundleDescription bundleDescription) {
        if (this.fComponents == null) {
            return null;
        }
        return (IApiComponent)this.fComponents.get(String.valueOf(bundleDescription.getSymbolicName()) + bundleDescription.getVersion().toString());
    }

    private void storeBundleDescription(BundleDescription bundleDescription, IApiComponent component) {
        if (this.fComponents == null) {
            this.fComponents = new HashMap(8);
        }
        this.fComponents.put(String.valueOf(bundleDescription.getSymbolicName()) + bundleDescription.getVersion().toString(), component);
    }

    protected synchronized void clearPackage(String packageName) {
        if (this.fComponentsCache != null) {
            this.fComponentsCache.remove(packageName);
        }
    }

    public String toString() {
        return this.getName();
    }

    public IStatus getExecutionEnvironmentStatus() {
        return this.fEEStatus;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
    }

    public void vmAdded(IVMInstall vm) {
        if (!(vm instanceof VMStandin)) {
            this.rebindVM();
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
        String property;
        if (!(event.getSource() instanceof VMStandin) && (IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION.equals(property = event.getProperty()) || IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS.equals(property))) {
            this.rebindVM();
        }
    }

    private void rebindVM() {
        this.fVMBinding = null;
        IApiComponent[] components = this.getApiComponents();
        HashSet<String> ees = new HashSet<String>();
        int i = 0;
        while (i < components.length) {
            ees.addAll(Arrays.asList(components[i].getExecutionEnvironments()));
            ++i;
        }
        this.resolveSystemLibrary(ees);
    }

    public void vmRemoved(IVMInstall vm) {
        if (vm.equals(this.fVMBinding)) {
            this.rebindVM();
        }
    }
}

