/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.AbstractClassFile;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;

public class ArchiveClassFileContainer
implements IClassFileContainer {
    private String fLocation;
    private String fOrigin;
    private Map fPackages;
    private String[] fPackageNames;
    private ZipFile fZipFile = null;

    public ArchiveClassFileContainer(String path, String origin) {
        this.fLocation = path;
        this.fOrigin = origin;
    }

    public void accept(ClassFileContainerVisitor visitor) throws CoreException {
        this.init();
        ArrayList packages = new ArrayList(this.fPackages.keySet());
        Collections.sort(packages);
        Iterator iterator = packages.iterator();
        while (iterator.hasNext()) {
            String pkg = (String)iterator.next();
            if (visitor.visitPackage(pkg)) {
                ArrayList types = new ArrayList((Set)this.fPackages.get(pkg));
                Iterator cfIterator = types.iterator();
                ArrayList<ArchiveClassFile> classFiles = new ArrayList<ArchiveClassFile>(types.size());
                while (cfIterator.hasNext()) {
                    String entryName = (String)cfIterator.next();
                    classFiles.add(new ArchiveClassFile(this, entryName));
                }
                Collections.sort(classFiles);
                cfIterator = classFiles.iterator();
                while (cfIterator.hasNext()) {
                    ArchiveClassFile classFile = (ArchiveClassFile)cfIterator.next();
                    visitor.visit(pkg, classFile);
                    visitor.end(pkg, classFile);
                }
            }
            visitor.endVisitPackage(pkg);
        }
    }

    public synchronized void close() throws CoreException {
        if (this.fZipFile != null) {
            try {
                this.fZipFile.close();
                this.fZipFile = null;
            }
            catch (IOException e) {
                this.abort("Failed to close class file archive", e);
            }
        }
    }

    public IClassFile findClassFile(String qualifiedName) throws CoreException {
        String fileName;
        Set classFileNames;
        this.init();
        int index = qualifiedName.lastIndexOf(46);
        String packageName = "";
        if (index >= 0) {
            packageName = qualifiedName.substring(0, index);
        }
        if ((classFileNames = (Set)this.fPackages.get(packageName)) != null && classFileNames.contains(fileName = String.valueOf(qualifiedName.replace('.', '/')) + ".class")) {
            return new ArchiveClassFile(this, fileName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPackageNames() throws CoreException {
        this.init();
        ArchiveClassFileContainer archiveClassFileContainer = this;
        synchronized (archiveClassFileContainer) {
            if (this.fPackageNames == null) {
                Set names = this.fPackages.keySet();
                this.fPackageNames = names.toArray(new String[names.size()]);
            }
            return this.fPackageNames;
        }
    }

    private synchronized void init() throws CoreException {
        ZipFile zipFile = this.open();
        if (this.fPackages == null) {
            this.fPackages = new HashMap();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                HashSet<String> fileNames;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String pkg = "";
                int index = name.lastIndexOf(47);
                if (index >= 0) {
                    pkg = name.substring(0, index).replace('/', '.');
                }
                if ((fileNames = (HashSet<String>)this.fPackages.get(pkg)) == null) {
                    fileNames = new HashSet<String>();
                    this.fPackages.put(pkg, fileNames);
                }
                fileNames.add(name);
            }
        }
    }

    private synchronized ZipFile open() throws CoreException {
        if (this.fZipFile == null) {
            try {
                this.fZipFile = new ZipFile(this.fLocation);
            }
            catch (IOException e) {
                this.abort("Failed to open archive: " + this.fLocation, e);
            }
        }
        return this.fZipFile;
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArchiveClassFileContainer) {
            return this.fLocation.equals(((ArchiveClassFileContainer)obj).fLocation);
        }
        return false;
    }

    public int hashCode() {
        return this.fLocation.hashCode();
    }

    public IClassFile findClassFile(String qualifiedName, String id) throws CoreException {
        return this.findClassFile(qualifiedName);
    }

    public String getOrigin() {
        return this.fOrigin;
    }

    class ArchiveClassFile
    extends AbstractClassFile
    implements Comparable {
        private ArchiveClassFileContainer fArchive;
        private String fEntryName;
        private String fTypeName;

        public ArchiveClassFile(ArchiveClassFileContainer container, String entryName) {
            this.fArchive = container;
            this.fEntryName = entryName;
        }

        public String getTypeName() {
            if (this.fTypeName == null) {
                this.fTypeName = this.fEntryName.replace('/', '.').substring(0, this.fEntryName.length() - ".class".length());
            }
            return this.fTypeName;
        }

        public int compareTo(Object o) {
            return this.getTypeName().compareTo(((ArchiveClassFile)o).getTypeName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArchiveClassFile) {
                ArchiveClassFile classFile = (ArchiveClassFile)obj;
                return this.fEntryName.equals(classFile.fEntryName);
            }
            return false;
        }

        public int hashCode() {
            return this.fEntryName.hashCode();
        }

        public InputStream getInputStream() throws CoreException {
            ZipFile zipFile = this.fArchive.open();
            ZipEntry entry = zipFile.getEntry(this.fEntryName);
            if (entry != null) {
                try {
                    return zipFile.getInputStream(entry);
                }
                catch (IOException e) {
                    ArchiveClassFileContainer.this.abort("Failed to open class file: " + this.getTypeName() + " in archive: " + this.fArchive.fLocation, e);
                }
            }
            ArchiveClassFileContainer.this.abort("Class file not found: " + this.getTypeName() + " in archive: " + this.fArchive.fLocation, null);
            return null;
        }
    }
}

