/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.api.tools.internal.AbstractApiComponent;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ArchiveClassFileContainer;
import org.eclipse.pde.api.tools.internal.BundleVersionRange;
import org.eclipse.pde.api.tools.internal.CompositeApiDescription;
import org.eclipse.pde.api.tools.internal.DirectoryClassFileContainer;
import org.eclipse.pde.api.tools.internal.RequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.scanner.ApiDescriptionProcessor;
import org.eclipse.pde.api.tools.internal.util.SourceDefaultHandler;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.osgi.framework.BundleException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BundleApiComponent
extends AbstractApiComponent {
    private Dictionary fManifest;
    private boolean fHasApiDescription = false;
    private String fLocation;
    private BundleDescription fBundleDescription;

    public BundleApiComponent(IApiProfile profile, String location) throws CoreException {
        super(profile);
        this.fLocation = location;
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            this.fManifest = null;
            this.fBundleDescription = null;
        }
    }

    protected synchronized Dictionary getManifest() throws CoreException {
        if (this.fManifest == null) {
            try {
                this.fManifest = (Dictionary)((Object)this.loadManifest(new File(this.fLocation)));
            }
            catch (IOException e) {
                this.abort("Unable to load manifest due to IO error", e);
            }
        }
        return this.fManifest;
    }

    public boolean isValidBundle() throws CoreException {
        Dictionary manifest = this.getManifest();
        return manifest != null && manifest.get("Bundle-Name") != null && manifest.get("Bundle-Version") != null;
    }

    protected void init(State state, long bundleId) throws CoreException {
        try {
            Dictionary manifest = this.getManifest();
            if (this.isBinaryBundle() && "workspace".equals(this.getProfile().getName())) {
                TargetWeaver.weaveManifest((Dictionary)manifest);
            }
            StateObjectFactory factory = StateObjectFactory.defaultFactory;
            this.fBundleDescription = factory.createBundleDescription(state, manifest, this.fLocation, bundleId);
        }
        catch (BundleException e) {
            this.abort("Unable to create API component from specified location: " + this.fLocation, e);
        }
    }

    protected boolean isBinaryBundle() {
        return true;
    }

    protected IApiDescription createApiDescription() throws CoreException {
        BundleDescription[] fragments = this.getBundleDescription().getFragments();
        if (fragments.length == 0) {
            return this.createLocalApiDescription();
        }
        IApiDescription[] descriptions = new IApiDescription[fragments.length + 1];
        int i = 0;
        while (i < fragments.length) {
            BundleDescription fragment = fragments[i];
            BundleApiComponent component = (BundleApiComponent)this.getProfile().getApiComponent(fragment.getSymbolicName());
            descriptions[i + 1] = component.getApiDescription();
            ++i;
        }
        descriptions[0] = this.createLocalApiDescription();
        return new CompositeApiDescription(descriptions);
    }

    protected IApiDescription createLocalApiDescription() throws CoreException {
        ApiDescription apiDesc = new ApiDescription(this.getId());
        BundleApiComponent.initializeApiDescription(apiDesc, this.getBundleDescription(), this.getLocalPackageNames());
        try {
            String xml = this.loadApiDescription(new File(this.fLocation));
            this.setHasApiDescription(xml != null);
            if (xml != null) {
                ApiDescriptionProcessor.annotateApiSettings(null, apiDesc, xml);
            }
        }
        catch (IOException e) {
            this.abort("Unable to load component.xml", e);
        }
        return apiDesc;
    }

    protected Set getLocalPackageNames() throws CoreException {
        HashSet<String> names = new HashSet<String>();
        IClassFileContainer[] containers = this.getClassFileContainers();
        int i = 0;
        while (i < containers.length) {
            if (containers[i].getOrigin().equals(this.getId())) {
                String[] packageNames = containers[i].getPackageNames();
                int j = 0;
                while (j < packageNames.length) {
                    names.add(packageNames[j]);
                    ++j;
                }
            }
            ++i;
        }
        return names;
    }

    protected static void initializeApiDescription(IApiDescription apiDesc, BundleDescription bundle, Set packages) throws CoreException {
        int i;
        Iterator iterator = packages.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            apiDesc.setVisibility(Factory.packageDescriptor(name), 2);
        }
        ArrayList supplied = new ArrayList();
        ExportPackageDescription[] exportPackages = bundle.getExportPackages();
        BundleApiComponent.addSuppliedPackages(packages, supplied, exportPackages);
        HostSpecification host = bundle.getHost();
        if (host != null) {
            BundleDescription[] hosts = host.getHosts();
            i = 0;
            while (i < hosts.length) {
                BundleApiComponent.addSuppliedPackages(packages, supplied, hosts[i].getExportPackages());
                ++i;
            }
        }
        BundleDescription[] fragments = bundle.getFragments();
        i = 0;
        while (i < fragments.length) {
            BundleApiComponent.addSuppliedPackages(packages, supplied, fragments[i].getExportPackages());
            ++i;
        }
        BundleApiComponent.annotateExportedPackages(apiDesc, supplied.toArray(new ExportPackageDescription[supplied.size()]));
    }

    protected static void addSuppliedPackages(Set packages, List supplied, ExportPackageDescription[] exportPackages) {
        int i = 0;
        while (i < exportPackages.length) {
            ExportPackageDescription pkg = exportPackages[i];
            String name = pkg.getName();
            if (name.equals(".")) {
                name = "";
            }
            if (packages.contains(name)) {
                supplied.add(pkg);
            }
            ++i;
        }
    }

    protected static void annotateExportedPackages(IApiDescription apiDesc, ExportPackageDescription[] exportedPackages) {
        int i = 0;
        while (i < exportedPackages.length) {
            ExportPackageDescription pkg = exportedPackages[i];
            boolean internal = (Boolean)pkg.getDirective("x-internal");
            String[] friends = (String[])pkg.getDirective("x-friends");
            String pkgName = pkg.getName();
            if (pkgName.equals(".")) {
                pkgName = "";
            }
            IPackageDescriptor pkgDesc = Factory.packageDescriptor(pkgName);
            if (internal) {
                apiDesc.setVisibility(pkgDesc, 2);
            }
            if (friends != null) {
                apiDesc.setVisibility(pkgDesc, 2);
            }
            if (!internal && friends == null) {
                apiDesc.setVisibility(pkgDesc, 1);
            }
            ++i;
        }
    }

    protected IApiFilterStore createApiFilterStore() throws CoreException {
        return null;
    }

    protected List createClassFileContainers() throws CoreException {
        ArrayList<IClassFileContainer> containers = new ArrayList<IClassFileContainer>(5);
        try {
            BundleApiComponent component;
            ArrayList<BundleApiComponent> all = new ArrayList<BundleApiComponent>();
            all.add(this);
            boolean considerFragments = true;
            if ("org.eclipse.swt".equals(this.getId())) {
                boolean bl = considerFragments = !this.isApiEnabled();
            }
            if (considerFragments) {
                BundleDescription[] fragments = this.fBundleDescription.getFragments();
                int i = 0;
                while (i < fragments.length) {
                    BundleDescription fragment = fragments[i];
                    component = (BundleApiComponent)this.getProfile().getApiComponent(fragment.getSymbolicName());
                    if (component != null) {
                        component.getClassFileContainers();
                        all.add(component);
                    }
                    ++i;
                }
            }
            Iterator iterator = all.iterator();
            HashSet<String> entryNames = new HashSet<String>(5);
            BundleApiComponent other = null;
            while (iterator.hasNext()) {
                component = (BundleApiComponent)iterator.next();
                String[] paths = this.getClasspathEntries(component.getManifest());
                int i = 0;
                while (i < paths.length) {
                    String path = paths[i];
                    if (".".equals(path) || !entryNames.contains(path)) {
                        IClassFileContainer container = component.createClassFileContainer(path);
                        if (container == null) {
                            Iterator iter = all.iterator();
                            while (iter.hasNext()) {
                                other = (BundleApiComponent)iter.next();
                                if (other == component) continue;
                                container = other.createClassFileContainer(path);
                            }
                        }
                        if (container != null) {
                            containers.add(container);
                            if (!".".equals(path)) {
                                entryNames.add(path);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        catch (BundleException e) {
            this.abort("Unable to parse bundle classpath", e);
        }
        catch (IOException e) {
            this.abort("Unable to initialize class file containers", e);
        }
        return containers;
    }

    protected boolean isApiEnabled() {
        return false;
    }

    protected String[] getClasspathEntries(Dictionary manifest) throws BundleException {
        ManifestElement[] classpath = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)manifest.get("Bundle-ClassPath")));
        String[] elements = null;
        if (classpath == null) {
            elements = new String[]{"."};
        } else {
            elements = new String[classpath.length];
            int i = 0;
            while (i < classpath.length) {
                elements[i] = classpath[i].getValue();
                ++i;
            }
        }
        return elements;
    }

    protected IClassFileContainer createClassFileContainer(String path) throws IOException {
        block24: {
            File bundle = new File(this.fLocation);
            if (bundle.isDirectory()) {
                File entry = new File(bundle, path);
                if (entry.exists()) {
                    if (entry.isFile()) {
                        return new ArchiveClassFileContainer(entry.getCanonicalPath(), this.getId());
                    }
                    return new DirectoryClassFileContainer(entry.getCanonicalPath(), this.getId());
                }
            } else {
                ZipFile zip = null;
                try {
                    File tempFile;
                    if (path.equals(".")) {
                        ArchiveClassFileContainer archiveClassFileContainer = new ArchiveClassFileContainer(this.fLocation, this.getId());
                        return archiveClassFileContainer;
                    }
                    zip = new ZipFile(this.fLocation);
                    ZipEntry entry = zip.getEntry(path);
                    if (entry == null) break block24;
                    InputStream inputStream = null;
                    FileOutputStream outputStream = null;
                    try {
                        inputStream = zip.getInputStream(entry);
                        tempFile = File.createTempFile("api", "tmp");
                        tempFile.deleteOnExit();
                        outputStream = new FileOutputStream(tempFile);
                        byte[] bytes = new byte[8096];
                        while (inputStream.available() > 0) {
                            int read = inputStream.read(bytes);
                            if (read <= 0) continue;
                            outputStream.write(bytes, 0, read);
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                ApiPlugin.log(e);
                            }
                        }
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException e) {
                                ApiPlugin.log(e);
                            }
                        }
                    }
                    ArchiveClassFileContainer archiveClassFileContainer = new ArchiveClassFileContainer(tempFile.getCanonicalPath(), this.getId());
                    return archiveClassFileContainer;
                }
                finally {
                    if (zip != null) {
                        zip.close();
                    }
                }
            }
        }
        return null;
    }

    protected Map loadManifest(File bundleLocation) throws IOException {
        block11: {
            Map map;
            ZipFile jarFile = null;
            InputStream manifestStream = null;
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            try {
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry != null) {
                        manifestStream = jarFile.getInputStream(manifestEntry);
                    }
                } else {
                    File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                    if (file.exists()) {
                        manifestStream = new FileInputStream(file);
                    }
                }
                if (manifestStream == null) {
                    this.closingZipFileAndStream(manifestStream, jarFile);
                    return null;
                }
                map = ManifestElement.parseBundleManifest((InputStream)manifestStream, new Hashtable(10));
                this.closingZipFileAndStream(manifestStream, jarFile);
            }
            catch (BundleException e) {
                ApiPlugin.log(e);
                break block11;
            }
            finally {
                this.closingZipFileAndStream(manifestStream, jarFile);
            }
            return map;
        }
        return null;
    }

    protected Manifest readManifest(File bundleLocation) throws IOException {
        InputStream manifestStream;
        ZipFile jarFile;
        block7: {
            jarFile = null;
            manifestStream = null;
            try {
                String extension = new Path(bundleLocation.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry != null) {
                        manifestStream = jarFile.getInputStream(manifestEntry);
                    }
                } else {
                    File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
                    if (file.exists()) {
                        manifestStream = new FileInputStream(file);
                    }
                }
                if (manifestStream != null) break block7;
                this.closingZipFileAndStream(manifestStream, jarFile);
                return null;
            }
            catch (Throwable throwable) {
                this.closingZipFileAndStream(manifestStream, jarFile);
                throw throwable;
            }
        }
        Manifest manifest = new Manifest(manifestStream);
        this.closingZipFileAndStream(manifestStream, jarFile);
        return manifest;
    }

    void closingZipFileAndStream(InputStream stream, ZipFile jarFile) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
    }

    protected String readFileContents(String xmlFileName, File bundleLocation) {
        ZipFile jarFile = null;
        InputStream stream = null;
        try {
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry(xmlFileName);
                if (manifestEntry != null) {
                    stream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, xmlFileName);
                if (file.exists()) {
                    stream = new FileInputStream(file);
                }
            }
            if (stream == null) {
                this.closingZipFileAndStream(stream, jarFile);
                return null;
            }
            String string = new String(Util.getInputStreamAsCharArray(stream, -1, "UTF-8"));
            this.closingZipFileAndStream(stream, jarFile);
            return string;
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        finally {
            this.closingZipFileAndStream(stream, jarFile);
        }
        return null;
    }

    protected String loadApiDescription(File bundleLocation) throws IOException {
        String contents;
        InputStream stream;
        ZipFile jarFile;
        block7: {
            jarFile = null;
            stream = null;
            contents = null;
            try {
                String extension = new Path(bundleLocation.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
                    jarFile = new ZipFile(bundleLocation, 1);
                    ZipEntry manifestEntry = jarFile.getEntry(".api_description");
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                } else {
                    File file = new File(bundleLocation, ".api_description");
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    }
                }
                if (stream != null) break block7;
                this.closingZipFileAndStream(stream, jarFile);
                return null;
            }
            catch (Throwable throwable) {
                this.closingZipFileAndStream(stream, jarFile);
                throw throwable;
            }
        }
        char[] charArray = Util.getInputStreamAsCharArray(stream, -1, "UTF-8");
        contents = new String(charArray);
        this.closingZipFileAndStream(stream, jarFile);
        return contents;
    }

    protected URL getFileInBundle(File bundleLocation, String filePath) throws MalformedURLException {
        String extension = new Path(bundleLocation.getName()).getFileExtension();
        StringBuffer urlSt = new StringBuffer();
        if (extension != null && extension.equals("jar") && bundleLocation.isFile()) {
            urlSt.append("jar:file:");
            urlSt.append(bundleLocation.getAbsolutePath());
            urlSt.append("!/");
            urlSt.append(filePath);
        } else {
            urlSt.append("file:");
            urlSt.append(bundleLocation.getAbsolutePath());
            urlSt.append(File.separatorChar);
            urlSt.append(filePath);
        }
        return new URL(urlSt.toString());
    }

    public String[] getExecutionEnvironments() {
        return this.fBundleDescription.getExecutionEnvironments();
    }

    public String getId() {
        return this.fBundleDescription.getSymbolicName();
    }

    public String getName() throws CoreException {
        return (String)this.getManifest().get("Bundle-Name");
    }

    public IRequiredComponentDescription[] getRequiredComponents() {
        BundleSpecification[] requiredBundles = this.fBundleDescription.getRequiredBundles();
        IRequiredComponentDescription[] req = new IRequiredComponentDescription[requiredBundles.length];
        int i = 0;
        while (i < requiredBundles.length) {
            BundleSpecification bundle = requiredBundles[i];
            req[i] = new RequiredComponentDescription(bundle.getName(), new BundleVersionRange(bundle.getVersionRange()), bundle.isOptional(), bundle.isExported());
            ++i;
        }
        return req;
    }

    public String getVersion() {
        return this.fBundleDescription.getVersion().toString();
    }

    protected BundleDescription getBundleDescription() {
        return this.fBundleDescription;
    }

    public String toString() {
        if (this.fBundleDescription != null) {
            return this.fBundleDescription.toString();
        }
        return super.toString();
    }

    public String getLocation() {
        return this.fLocation;
    }

    public boolean isSystemComponent() {
        return false;
    }

    protected boolean getBooleanOption(Map options, String optionName, boolean defaultValue) {
        Boolean optionB = (Boolean)options.get(optionName);
        if (optionB != null) {
            return optionB;
        }
        return defaultValue;
    }

    public boolean isSourceComponent() {
        ManifestElement[] sourceBundle = null;
        try {
            sourceBundle = ManifestElement.parseHeader((String)"Eclipse-SourceBundle", (String)((String)this.fManifest.get("Eclipse-SourceBundle")));
        }
        catch (BundleException bundleException) {}
        if (sourceBundle != null) {
            return true;
        }
        String pluginXMLContents = this.readFileContents("plugin.xml", new File(this.getLocation()));
        if (pluginXMLContents != null && this.containsSourceExtensionPoint(pluginXMLContents)) {
            return true;
        }
        pluginXMLContents = this.readFileContents("fragment.xml", new File(this.getLocation()));
        return pluginXMLContents != null && this.containsSourceExtensionPoint(pluginXMLContents);
    }

    private boolean containsSourceExtensionPoint(String pluginXMLContents) {
        SAXParserFactory factory = null;
        try {
            factory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return false;
        }
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
        if (saxParser == null) {
            return false;
        }
        InputSource inputSource = new InputSource(new BufferedReader(new StringReader(pluginXMLContents)));
        try {
            SourceDefaultHandler defaultHandler = new SourceDefaultHandler();
            saxParser.parse(inputSource, (DefaultHandler)defaultHandler);
            return defaultHandler.isSource();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    public boolean isFragment() {
        return this.fBundleDescription.getHost() != null;
    }

    public boolean hasFragments() {
        return this.fBundleDescription.getFragments().length != 0;
    }

    public String getOrigin() {
        return this.getId();
    }

    protected void setHasApiDescription(boolean hasApiDescription) {
        this.fHasApiDescription = hasApiDescription;
    }

    public boolean hasApiDescription() {
        try {
            this.getApiDescription();
        }
        catch (CoreException coreException) {}
        return this.fHasApiDescription;
    }
}

