/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;

public class CompilationUnit {
    private String name = null;
    private String filepath = null;
    private ICompilationUnit unit = null;

    public CompilationUnit(String filepath) {
        File file = new File(filepath);
        if (!file.exists()) {
            throw new IllegalArgumentException("The specified path is not an existing file");
        }
        this.filepath = filepath;
        this.name = file.getName();
    }

    public CompilationUnit(ICompilationUnit compilationUnit) {
        this.unit = compilationUnit;
        this.name = compilationUnit.getElementName();
    }

    public String getName() {
        return this.name;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.unit != null) {
            try {
                return ((IFile)this.unit.getCorrespondingResource()).getContents();
            }
            catch (CoreException e) {
                throw new FileNotFoundException(e.getStatus().getMessage());
            }
        }
        return new FileInputStream(new File(this.filepath));
    }
}

