/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.api.tools.internal.AbstractClassFile;
import org.eclipse.pde.api.tools.internal.provisional.ClassFileContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;

public class DirectoryClassFileContainer
implements IClassFileContainer {
    private File fRoot;
    private String fOrigin;
    private Map fPackages;
    private String[] fPackageNames;

    public DirectoryClassFileContainer(String location, String origin) {
        this.fRoot = new File(location);
        this.fOrigin = origin;
    }

    private void abort(String message, Throwable e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", message, e));
    }

    public void accept(ClassFileContainerVisitor visitor) throws CoreException {
        this.init();
        String[] packageNames = this.getPackageNames();
        int i = 0;
        while (i < packageNames.length) {
            File dir;
            File[] files;
            String pkg = packageNames[i];
            if (visitor.visitPackage(pkg) && (files = (dir = (File)this.fPackages.get(pkg)).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".class");
                }
            })) != null) {
                ArrayList<ClassFile> classFiles = new ArrayList<ClassFile>();
                int j = 0;
                while (j < files.length) {
                    File file = files[j];
                    String name = file.getName();
                    String typeName = name.substring(0, name.length() - 6);
                    if (pkg.length() > 0) {
                        typeName = String.valueOf(pkg) + "." + typeName;
                    }
                    classFiles.add(new ClassFile(file, typeName));
                    ++j;
                }
                Collections.sort(classFiles);
                Iterator cfIterator = classFiles.iterator();
                while (cfIterator.hasNext()) {
                    IClassFile classFile = (IClassFile)cfIterator.next();
                    visitor.visit(pkg, classFile);
                    visitor.end(pkg, classFile);
                }
            }
            visitor.endVisitPackage(pkg);
            ++i;
        }
    }

    public synchronized void close() throws CoreException {
        this.fPackages = null;
        this.fPackageNames = null;
    }

    public IClassFile findClassFile(String qualifiedName) throws CoreException {
        File file;
        File dir;
        this.init();
        int index = qualifiedName.lastIndexOf(46);
        String cfName = qualifiedName;
        String pkg = "";
        if (index > 0) {
            pkg = qualifiedName.substring(0, index);
            cfName = qualifiedName.substring(index + 1);
        }
        if ((dir = (File)this.fPackages.get(pkg)) != null && (file = new File(dir, String.valueOf(cfName) + ".class")).exists()) {
            return new ClassFile(file, qualifiedName);
        }
        return null;
    }

    public String[] getPackageNames() throws CoreException {
        this.init();
        if (this.fPackageNames == null) {
            ArrayList names = new ArrayList(this.fPackages.keySet());
            Collections.sort(names);
            this.fPackageNames = names.toArray(new String[names.size()]);
        }
        return this.fPackageNames;
    }

    private synchronized void init() {
        if (this.fPackages == null) {
            this.fPackages = new HashMap();
            this.processDirectory("", this.fRoot);
        }
    }

    private void processDirectory(String packageName, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            boolean hasClassFiles = false;
            ArrayList<File> dirs = new ArrayList<File>();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    dirs.add(file);
                } else if (!hasClassFiles && file.getName().endsWith(".class")) {
                    this.fPackages.put(packageName, dir);
                    hasClassFiles = true;
                }
                ++i;
            }
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                File child = (File)iterator.next();
                String nextName = null;
                nextName = packageName.length() == 0 ? child.getName() : String.valueOf(packageName) + "." + child.getName();
                this.processDirectory(nextName, child);
            }
        }
    }

    public IClassFile findClassFile(String qualifiedName, String id) throws CoreException {
        return this.findClassFile(qualifiedName);
    }

    public String getOrigin() {
        return this.fOrigin;
    }

    class ClassFile
    extends AbstractClassFile
    implements Comparable {
        private File fFile;
        private String fTypeName;

        public ClassFile(File file, String typeName) {
            this.fFile = file;
            this.fTypeName = typeName;
        }

        public String getTypeName() {
            return this.fTypeName;
        }

        public int compareTo(Object o) {
            return this.fTypeName.compareTo(((ClassFile)o).fTypeName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassFile) {
                return ((ClassFile)obj).fTypeName.equals(this.fTypeName);
            }
            return false;
        }

        public int hashCode() {
            return this.fTypeName.hashCode();
        }

        public InputStream getInputStream() throws CoreException {
            try {
                return new FileInputStream(this.fFile);
            }
            catch (FileNotFoundException e) {
                DirectoryClassFileContainer.this.abort("File not found", e);
                return null;
            }
        }
    }
}

