/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.ApiProfile;
import org.eclipse.pde.api.tools.internal.ArchiveClassFileContainer;
import org.eclipse.pde.api.tools.internal.BundleApiComponent;
import org.eclipse.pde.api.tools.internal.CompositeApiDescription;
import org.eclipse.pde.api.tools.internal.CompositeClassFileContainer;
import org.eclipse.pde.api.tools.internal.DirectoryClassFileContainer;
import org.eclipse.pde.api.tools.internal.FolderClassFileContainer;
import org.eclipse.pde.api.tools.internal.ProjectApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.scanner.TagScanner;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class PluginProjectApiComponent
extends BundleApiComponent {
    private static boolean DEBUG = Util.DEBUG;
    private IJavaProject fProject = null;
    private IPluginModelBase fModel = null;
    private Map fPathToOutputContainers = null;
    private Map fOutputLocationToContainer = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public PluginProjectApiComponent(IApiProfile profile, String location, IPluginModelBase model) throws CoreException {
        super(profile, location);
        Path path = new Path(location);
        IProject project = ApiProfile.ROOT.getProject(path.lastSegment());
        this.fProject = JavaCore.create((IProject)project);
        this.fModel = model;
    }

    protected boolean isBinaryBundle() {
        return false;
    }

    protected boolean isApiEnabled() {
        return Util.isApiProject(this.fProject);
    }

    public void dispose() {
        try {
            try {
                if (this.isApiDescriptionInitialized()) {
                    try {
                        IApiDescription description = this.getApiDescription();
                        if (description instanceof ProjectApiDescription) {
                            ((ProjectApiDescription)description).disconnect(this.getBundleDescription());
                        } else if (description instanceof CompositeApiDescription) {
                            ((CompositeApiDescription)description).disconnect(this.getBundleDescription());
                        }
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e.getStatus());
                    }
                }
                if (this.hasApiFilterStore()) {
                    this.getFilterStore().dispose();
                }
                this.fModel = null;
                if (this.fOutputLocationToContainer != null) {
                    this.fOutputLocationToContainer.clear();
                    this.fOutputLocationToContainer = null;
                }
                if (this.fPathToOutputContainers != null) {
                    this.fPathToOutputContainers.clear();
                    this.fPathToOutputContainers = null;
                }
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    protected IApiDescription createLocalApiDescription() throws CoreException {
        long time = System.currentTimeMillis();
        IApiDescription apiDesc = null;
        if (Util.isApiProject(this.getJavaProject())) {
            this.setHasApiDescription(true);
            apiDesc = ApiDescriptionManager.getDefault().getApiDescription(this.getJavaProject(), this.getBundleDescription());
        } else {
            apiDesc = super.createLocalApiDescription();
        }
        if (DEBUG) {
            System.out.println("Time to create api description for: [" + this.fProject.getElementName() + "] " + (System.currentTimeMillis() - time) + "ms");
        }
        return apiDesc;
    }

    protected void loadSourceTags(IApiDescription apiDescription) throws CoreException {
        ArrayList<IPackageFragmentRoot> sourceRoots = new ArrayList<IPackageFragmentRoot>();
        if (this.fProject.exists() && this.fProject.getProject().isOpen()) {
            IClasspathEntry[] entries = this.fProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry classpathEntry = entries[i];
                if (classpathEntry.getEntryKind() == 3) {
                    IPackageFragmentRoot[] roots = this.fProject.findPackageFragmentRoots(classpathEntry);
                    int j = 0;
                    while (j < roots.length) {
                        sourceRoots.add(roots[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        TagScanner scanner = TagScanner.newScanner();
        Iterator iterator = sourceRoots.iterator();
        ICompilationUnit[] units = null;
        IJavaElement[] pkgs = null;
        while (iterator.hasNext()) {
            pkgs = ((IPackageFragmentRoot)iterator.next()).getChildren();
            int i = 0;
            while (i < pkgs.length) {
                if (pkgs[i] instanceof IPackageFragment) {
                    units = ((IPackageFragment)pkgs[i]).getCompilationUnits();
                    int j = 0;
                    while (j < units.length) {
                        try {
                            scanner.scan(units[j], apiDescription, this);
                        }
                        catch (CoreException e) {
                            this.abort("Unable to initialize from Javadoc tags", e);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected IApiFilterStore createApiFilterStore() throws CoreException {
        long time = System.currentTimeMillis();
        ApiFilterStore store = new ApiFilterStore(this.getJavaProject());
        if (DEBUG) {
            System.out.println("Time to create api filter store for: [" + this.fProject.getElementName() + "] " + (System.currentTimeMillis() - time) + "ms");
        }
        return store;
    }

    protected List createClassFileContainers() throws CoreException {
        block15: {
            block16: {
                IBuild build;
                block17: {
                    this.fPathToOutputContainers = new HashMap(4);
                    this.fOutputLocationToContainer = new HashMap(4);
                    if (!this.fProject.exists() || !this.fProject.getProject().isOpen()) break block15;
                    IFile prop = this.fProject.getProject().getFile("build.properties");
                    if (!prop.exists()) break block16;
                    WorkspaceBuildModel properties = new WorkspaceBuildModel(prop);
                    build = properties.getBuild();
                    IBuildEntry entry = build.getEntry("custom");
                    if (entry == null) break block17;
                    String[] tokens = entry.getTokens();
                    if (tokens.length != 1 || !tokens[0].equals("true")) break block16;
                    IClasspathEntry[] classpathEntries = this.fProject.getRawClasspath();
                    ArrayList<IClassFileContainer> containers = new ArrayList<IClassFileContainer>();
                    int i = 0;
                    while (i < classpathEntries.length) {
                        IClasspathEntry classpathEntry = classpathEntries[i];
                        switch (classpathEntry.getEntryKind()) {
                            case 3: {
                                String containerPath = classpathEntry.getPath().removeFirstSegments(1).toString();
                                IClassFileContainer container = this.getClassFileContainer(containerPath, this.getId());
                                if (container == null || containers.contains(container)) break;
                                containers.add(container);
                                break;
                            }
                            case 4: {
                                classpathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntry);
                            }
                            case 1: {
                                IPath path = classpathEntry.getPath();
                                if (!Util.isArchive(path.lastSegment())) break;
                                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                                if (resource != null) {
                                    containers.add(new ArchiveClassFileContainer(resource.getLocation().toOSString(), this.getId()));
                                    break;
                                }
                                containers.add(new ArchiveClassFileContainer(path.toOSString(), this.getId()));
                            }
                        }
                        ++i;
                    }
                    if (containers.isEmpty()) break block16;
                    IClassFileContainer cfc = null;
                    cfc = containers.size() == 1 ? (IClassFileContainer)containers.get(0) : new CompositeClassFileContainer(containers, this.getId());
                    this.fPathToOutputContainers.put(".", cfc);
                    break block16;
                }
                IBuildEntry[] entries = build.getBuildEntries();
                int length = entries.length;
                int i = 0;
                while (i < length) {
                    IBuildEntry buildEntry = entries[i];
                    if (buildEntry.getName().startsWith("source.")) {
                        String jar = buildEntry.getName().substring("source.".length());
                        String[] tokens = buildEntry.getTokens();
                        if (tokens.length == 1) {
                            IClassFileContainer container = this.getClassFileContainer(tokens[0], this.getId());
                            if (container != null) {
                                this.fPathToOutputContainers.put(jar, container);
                            }
                        } else {
                            ArrayList<IClassFileContainer> containers = new ArrayList<IClassFileContainer>();
                            int j = 0;
                            while (j < tokens.length) {
                                String currentToken = tokens[j];
                                IClassFileContainer container = this.getClassFileContainer(currentToken, this.getId());
                                if (container != null && !containers.contains(container)) {
                                    containers.add(container);
                                }
                                ++j;
                            }
                            if (!containers.isEmpty()) {
                                IClassFileContainer cfc = null;
                                cfc = containers.size() == 1 ? (IClassFileContainer)containers.get(0) : new CompositeClassFileContainer(containers, this.getId());
                                this.fPathToOutputContainers.put(jar, cfc);
                            }
                        }
                    }
                    ++i;
                }
            }
            return super.createClassFileContainers();
        }
        return Collections.EMPTY_LIST;
    }

    protected IClassFileContainer createClassFileContainer(String path) throws IOException {
        IClassFileContainer container = (IClassFileContainer)this.fPathToOutputContainers.get(path);
        if (container == null) {
            container = this.findClassFileContainer(path);
        }
        return container;
    }

    private IClassFileContainer findClassFileContainer(String location) {
        IResource res = this.fProject.getProject().findMember((IPath)new Path(location));
        if (res != null) {
            if (res.getType() == 1) {
                return new ArchiveClassFileContainer(res.getLocation().toOSString(), this.getId());
            }
            return new DirectoryClassFileContainer(res.getLocation().toOSString(), this.getId());
        }
        return null;
    }

    private IClassFileContainer getClassFileContainer(String location, String id) throws CoreException {
        IPackageFragmentRoot root;
        IResource res = this.fProject.getProject().findMember((IPath)new Path(location));
        if (res != null && (root = this.fProject.getPackageFragmentRoot(res)).exists()) {
            IFolder container;
            IClassFileContainer cfc;
            IClasspathEntry entry = root.getRawClasspathEntry();
            IPath outputLocation = entry.getOutputLocation();
            if (outputLocation == null) {
                outputLocation = this.fProject.getOutputLocation();
            }
            if ((cfc = (IClassFileContainer)this.fOutputLocationToContainer.get(outputLocation)) == null && (container = this.fProject.getProject().getWorkspace().getRoot().getFolder(outputLocation)).exists()) {
                cfc = new FolderClassFileContainer((IContainer)container, id);
                this.fOutputLocationToContainer.put(outputLocation, cfc);
            }
            return cfc;
        }
        return null;
    }

    public String getName() throws CoreException {
        return this.fModel.getResourceString(super.getName());
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }
}

