/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.builder.BaseApiAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.builder.IApiAnalyzer;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class ApiAnalysisBuilder
extends IncrementalProjectBuilder {
    private static boolean DEBUG = Util.DEBUG;
    private static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    public static final int REF_TYPE_FLAG = 0;
    public static final String SOURCE = "Api Tooling";
    private IProject fCurrentProject = null;
    private IApiAnalyzer fAnalyzer = null;
    private HashMap fProjectToOutputLocations = new HashMap();
    private StringSet fTypes = new StringSet(3);
    private StringSet fPackages = new StringSet(3);
    private HashSet fTypesToCheck = new HashSet();
    private HashSet fRemovedTypes = new HashSet(2);
    private HashSet fChangedTypes = new HashSet(5);
    private BuildState fBuildState;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public static void cleanupMarkers(IResource resource) {
        ApiAnalysisBuilder.cleanupUsageMarkers(resource);
        ApiAnalysisBuilder.cleanupCompatibiltiyMarkers(resource);
        ApiAnalysisBuilder.cleanupUnsupportedTagMarkers(resource);
    }

    private static void cleanupUnsupportedTagMarkers(IResource resource) {
        try {
            if (DEBUG) {
                System.out.println("cleaning unsupported tag problems");
            }
            resource.deleteMarkers("org.eclipse.pde.api.tools.unsupported_tags", false, 2);
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    private static void cleanupCompatibiltiyMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.compatibility", false, 2);
                resource.deleteMarkers("org.eclipse.pde.api.tools.marker.sincetags", false, 2);
                if (resource.getType() == 4) {
                    resource.deleteMarkers("org.eclipse.pde.api.tools.version_numbering", false, 2);
                    resource.deleteMarkers("org.eclipse.pde.api.tools.api_profile", true, 0);
                }
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    private static void cleanupUsageMarkers(IResource resource) {
        try {
            if (resource != null && resource.isAccessible()) {
                resource.deleteMarkers("org.eclipse.pde.api.tools.api_usage", false, 2);
            }
        }
        catch (CoreException e) {
            ApiPlugin.log(e.getStatus());
        }
    }

    private void addDependentsOf(IPath path) {
        path = path.setDevice(null);
        String packageName = path.removeLastSegments(1).toString();
        String typeName = path.lastSegment();
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        if (this.fTypes.add(typeName) && this.fPackages.add(packageName) && DEBUG) {
            System.out.println("  will look for dependents of " + typeName + " in " + packageName);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.fCurrentProject = this.getProject();
        this.fAnalyzer = this.getAnalyzer();
        if (this.fCurrentProject == null || !this.fCurrentProject.isAccessible() || !this.fCurrentProject.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature") || this.hasBeenBuilt(this.fCurrentProject)) {
            return new IProject[0];
        }
        if (DEBUG) {
            System.out.println("\nStarting build of " + this.fCurrentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        this.updateMonitor(monitor, 0);
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_builder, (int)2);
        IProject[] projects = this.getRequiredProjects(true);
        try {
            switch (kind) {
                case 6: {
                    if (DEBUG) {
                        System.out.println("Performing full build as requested by user");
                    }
                    this.buildAll((IProgressMonitor)localMonitor.newChild(1));
                    break;
                }
                case 9: 
                case 10: {
                    IResourceDelta[] deltas = this.getDeltas(projects);
                    boolean shouldRunFullBuild = false;
                    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                    int i = 0;
                    while (i < deltas.length) {
                        deltas[i].accept((IResourceDeltaVisitor)visitor);
                        if (visitor.shouldRunFullBuild()) {
                            shouldRunFullBuild = true;
                            break;
                        }
                        ++i;
                    }
                    if (shouldRunFullBuild) {
                        if (DEBUG) {
                            System.out.println("Performing full build since MANIFEST.MF was modified");
                        }
                        this.buildAll((IProgressMonitor)localMonitor.newChild(1));
                        break;
                    }
                    if (deltas.length == 0) {
                        if (DEBUG) {
                            System.out.println("Performing full build since deltas are missing after incremental request");
                        }
                        this.buildAll((IProgressMonitor)localMonitor.newChild(1));
                        break;
                    }
                    State state = (State)JavaModelManager.getJavaModelManager().getLastBuiltState(this.fCurrentProject, (IProgressMonitor)new NullProgressMonitor());
                    if (state == null) {
                        this.buildAll((IProgressMonitor)localMonitor.newChild(1));
                        break;
                    }
                    this.fBuildState = ApiAnalysisBuilder.getLastBuiltState(this.fCurrentProject);
                    if (this.fBuildState == null) {
                        this.buildAll((IProgressMonitor)localMonitor.newChild(1));
                        break;
                    }
                    this.build(state, (IProgressMonitor)localMonitor.newChild(1));
                }
            }
            this.updateMonitor(monitor, 0);
        }
        finally {
            this.fTypes.clear();
            this.fPackages.clear();
            this.fTypesToCheck.clear();
            this.fChangedTypes.clear();
            this.fRemovedTypes.clear();
            this.fProjectToOutputLocations.clear();
            this.updateMonitor(monitor, 0);
            this.fAnalyzer.dispose();
            if (monitor != null) {
                monitor.done();
            }
            if (this.fBuildState != null) {
                ApiAnalysisBuilder.saveBuiltState(this.fCurrentProject, this.fBuildState);
                this.fBuildState = null;
            }
        }
        if (DEBUG) {
            System.out.println("Finished build of " + this.fCurrentProject.getName() + " @ " + new Date(System.currentTimeMillis()));
        }
        return projects;
    }

    private void buildAll(IProgressMonitor monitor) throws CoreException {
        IApiProfile wsprofile = null;
        try {
            this.clearLastState();
            this.fBuildState = new BuildState();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_on_0, (int)4);
            localMonitor.subTask(NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_initializing_analyzer, (Object)this.fCurrentProject.getName()));
            IApiProfile profile = ApiPlugin.getDefault().getApiProfileManager().getDefaultApiProfile();
            ApiAnalysisBuilder.cleanupMarkers((IResource)this.fCurrentProject);
            ApiAnalysisBuilder.cleanupUnsupportedTagMarkers((IResource)this.fCurrentProject);
            IPluginModelBase currentModel = this.getCurrentModel();
            if (currentModel != null) {
                localMonitor.subTask(BuilderMessages.building_workspace_profile);
                wsprofile = this.getWorkspaceProfile();
                this.updateMonitor((IProgressMonitor)localMonitor, 1);
                if (wsprofile == null) {
                    if (DEBUG) {
                        System.err.println("Could not retrieve a workspace profile");
                    }
                    return;
                }
                String id = currentModel.getBundleDescription().getSymbolicName();
                IApiComponent apiComponent = wsprofile.getApiComponent(id);
                if (apiComponent != null) {
                    this.fAnalyzer.analyzeComponent(this.fBuildState, null, profile, apiComponent, null, null, (IProgressMonitor)localMonitor.newChild(1));
                    this.updateMonitor((IProgressMonitor)localMonitor, 1);
                    this.createMarkers();
                    this.updateMonitor((IProgressMonitor)localMonitor, 1);
                }
            }
        }
        finally {
            if (wsprofile != null) {
                wsprofile.close();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void createMarkers() {
        try {
            this.fCurrentProject.deleteMarkers("org.eclipse.pde.api.tools.version_numbering", true, 2);
            this.fCurrentProject.deleteMarkers("org.eclipse.pde.api.tools.api_profile", true, 0);
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
        }
        IApiProblem[] problems = this.fAnalyzer.getProblems();
        String type = null;
        int i = 0;
        while (i < problems.length) {
            type = this.getProblemTypeFromCategory(problems[i].getCategory(), problems[i].getKind());
            if (type != null) {
                if (DEBUG) {
                    System.out.println("creating marker for: " + problems[i].toString());
                }
                this.createMarkerForProblem(type, problems[i]);
            }
            ++i;
        }
    }

    private String getProblemTypeFromCategory(int category, int kind) {
        switch (category) {
            case 0x50000000: {
                return "org.eclipse.pde.api.tools.api_profile";
            }
            case 0x10000000: {
                return "org.eclipse.pde.api.tools.compatibility";
            }
            case 0x40000000: {
                return "org.eclipse.pde.api.tools.marker.sincetags";
            }
            case 0x20000000: {
                if (kind == 7) {
                    return "org.eclipse.pde.api.tools.unsupported_tags";
                }
                return "org.eclipse.pde.api.tools.api_usage";
            }
            case 0x30000000: {
                return "org.eclipse.pde.api.tools.version_numbering";
            }
        }
        return null;
    }

    private void createMarkerForProblem(String type, IApiProblem problem) {
        IResource resource = this.resolveResource(problem);
        if (resource == null) {
            return;
        }
        try {
            String typeName;
            IMarker marker = resource.createMarker(type);
            marker.setAttributes(new String[]{"message", "severity", "lineNumber", "charStart", "charEnd", "sourceId", "problemid"}, new Object[]{problem.getMessage(), new Integer(ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId(problem), this.fCurrentProject)), new Integer(problem.getLineNumber()), new Integer(problem.getCharStart()), new Integer(problem.getCharEnd()), SOURCE, new Integer(problem.getId())});
            String[] args = problem.getMessageArguments();
            if (args.length > 0) {
                marker.setAttribute("messagearguments", (Object)this.createArgAttribute(args));
            }
            if ((typeName = problem.getTypeName()) != null) {
                marker.setAttribute("problemTypeName", (Object)typeName);
            }
            if (problem.getExtraMarkerAttributeIds().length > 0) {
                marker.setAttributes(problem.getExtraMarkerAttributeIds(), problem.getExtraMarkerAttributeValues());
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private IResource resolveResource(IApiProblem problem) {
        String resourcePath = problem.getResourcePath();
        if (resourcePath == null) {
            return null;
        }
        IResource resource = this.fCurrentProject.findMember((IPath)new Path(resourcePath));
        if (resource == null) {
            return null;
        }
        if (!resource.isAccessible()) {
            return null;
        }
        return resource;
    }

    private String createArgAttribute(String[] args) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            buff.append(args[i]);
            if (i < args.length - 1) {
                buff.append("#");
            }
            ++i;
        }
        return buff.toString();
    }

    private void updateMonitor(IProgressMonitor monitor, int ticks) throws OperationCanceledException {
        if (monitor != null) {
            monitor.worked(ticks);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void build(State state, IProgressMonitor monitor) throws CoreException {
        IApiProfile wsprofile = null;
        try {
            this.clearLastState();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_on_0, (int)6);
            localMonitor.subTask(NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_finding_affected_source_files, (Object)this.fCurrentProject.getName()));
            this.updateMonitor((IProgressMonitor)localMonitor, 0);
            this.collectAffectedSourceFiles(state);
            this.updateMonitor((IProgressMonitor)localMonitor, 1);
            if (this.fTypesToCheck.size() == 0) return;
            IPluginModelBase currentModel = this.getCurrentModel();
            if (currentModel == null) return;
            wsprofile = this.getWorkspaceProfile();
            if (wsprofile == null) {
                if (!DEBUG) return;
                System.err.println("Could not retrieve a workspace profile");
                return;
            }
            String id = currentModel.getBundleDescription().getSymbolicName();
            IApiComponent apiComponent = wsprofile.getApiComponent(id);
            if (apiComponent == null) {
                return;
            }
            ArrayList tnames = new ArrayList(this.fTypesToCheck.size());
            ArrayList cnames = new ArrayList(this.fChangedTypes.size());
            this.collectAllQualifiedNames(this.fTypesToCheck, this.fChangedTypes, tnames, cnames, (IProgressMonitor)localMonitor.newChild(1));
            this.updateMonitor((IProgressMonitor)localMonitor, 1);
            IApiProfile profile = ApiPlugin.getDefault().getApiProfileManager().getDefaultApiProfile();
            this.fAnalyzer.analyzeComponent(this.fBuildState, null, profile, apiComponent, tnames.toArray(new String[tnames.size()]), cnames.toArray(new String[cnames.size()]), (IProgressMonitor)localMonitor.newChild(1));
            this.updateMonitor((IProgressMonitor)localMonitor, 1);
            this.createMarkers();
            this.updateMonitor((IProgressMonitor)localMonitor, 1);
            return;
        }
        finally {
            if (wsprofile != null) {
                wsprofile.close();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void collectAllQualifiedNames(HashSet alltypes, HashSet changedtypes, List tnames, List cnames, IProgressMonitor monitor) {
        IType[] types = null;
        IFile file = null;
        Iterator iterator = alltypes.iterator();
        while (iterator.hasNext()) {
            IType type;
            file = (IFile)iterator.next();
            ICompilationUnit unit = (ICompilationUnit)JavaCore.create((IFile)file);
            if (!unit.exists() || (type = unit.findPrimaryType()) == null) continue;
            this.updateMonitor(monitor, 0);
            if (changedtypes.contains(file)) {
                ApiAnalysisBuilder.cleanupUnsupportedTagMarkers((IResource)file);
                this.updateMonitor(monitor, 0);
                ApiAnalysisBuilder.cleanupCompatibiltiyMarkers((IResource)file);
                this.updateMonitor(monitor, 0);
                cnames.add(type.getFullyQualifiedName());
            }
            try {
                ApiAnalysisBuilder.cleanupUsageMarkers((IResource)file);
                this.updateMonitor(monitor, 0);
                types = unit.getAllTypes();
                int i = 0;
                while (i < types.length) {
                    tnames.add(types[i].getFullyQualifiedName('$'));
                    ++i;
                }
            }
            catch (JavaModelException e) {
                ApiPlugin.log(e.getStatus());
            }
            this.updateMonitor(monitor, 0);
        }
        iterator = this.fRemovedTypes.iterator();
        while (iterator.hasNext()) {
            cnames.add(iterator.next());
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.fCurrentProject = this.getProject();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format((String)BuilderMessages.CleaningAPIDescription, (Object[])new String[]{this.fCurrentProject.getName()}), (int)2);
        try {
            ApiAnalysisBuilder.cleanupUsageMarkers((IResource)this.fCurrentProject);
            ApiAnalysisBuilder.cleanupCompatibiltiyMarkers((IResource)this.fCurrentProject);
            ApiAnalysisBuilder.cleanupUnsupportedTagMarkers((IResource)this.fCurrentProject);
            this.updateMonitor((IProgressMonitor)localmonitor, 1);
            this.cleanupApiDescription(this.fCurrentProject);
            this.updateMonitor((IProgressMonitor)localmonitor, 1);
        }
        finally {
            localmonitor.done();
        }
    }

    private void cleanupApiDescription(IProject project) {
        if (project != null && project.exists()) {
            ApiDescriptionManager.getDefault().clean(JavaCore.create((IProject)project), true, false);
        }
    }

    private void collectAffectedSourceFiles(State state) {
        char[][] internedSimpleNames;
        char[][][] internedQualifiedNames = ReferenceCollection.internQualifiedNames((StringSet)this.fPackages);
        if (internedQualifiedNames.length < this.fPackages.elementSize) {
            internedQualifiedNames = null;
        }
        if ((internedSimpleNames = ReferenceCollection.internSimpleNames((StringSet)this.fTypes)).length < this.fTypes.elementSize) {
            internedSimpleNames = null;
        }
        Object[] keyTable = state.getReferences().keyTable;
        Object[] valueTable = state.getReferences().valueTable;
        int i = 0;
        int l = valueTable.length;
        while (i < l) {
            IFile file;
            ReferenceCollection refs;
            String typeLocator = (String)keyTable[i];
            if (typeLocator != null && (refs = (ReferenceCollection)valueTable[i]).includes(internedQualifiedNames, internedSimpleNames) && (file = this.fCurrentProject.getFile(typeLocator)) != null) {
                if (DEBUG) {
                    System.out.println("  adding affected source file " + typeLocator);
                }
                this.fTypesToCheck.add(file);
            }
            ++i;
        }
    }

    private void findAffectedSourceFiles(IResourceDelta binaryDelta) {
        IResource resource = binaryDelta.getResource();
        if (resource.getType() == 1 && Util.isClassFile(resource.getName())) {
            IPath typePath = this.resolveJavaPathFromResource(resource);
            if (typePath == null) {
                return;
            }
            switch (binaryDelta.getKind()) {
                case 2: {
                    StringBuffer buffer = new StringBuffer();
                    String[] segments = typePath.segments();
                    int i = 0;
                    int max = segments.length;
                    while (i < max) {
                        if (i > 0) {
                            buffer.append('.');
                        }
                        buffer.append(segments[i]);
                        ++i;
                    }
                    this.fRemovedTypes.add(String.valueOf(buffer));
                }
                case 1: {
                    if (DEBUG) {
                        System.out.println("Found added/removed class file " + typePath);
                    }
                    this.addDependentsOf(typePath);
                    return;
                }
                case 4: {
                    if ((binaryDelta.getFlags() & 0x100) == 0) {
                        return;
                    }
                    if (DEBUG) {
                        System.out.println("Found changed class file " + typePath);
                    }
                    this.addDependentsOf(typePath);
                }
            }
            return;
        }
    }

    private IPluginModelBase getCurrentModel() {
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        IPath location = this.fCurrentProject.getLocation();
        IPluginModelBase currentModel = null;
        BundleDescription desc = null;
        int i = 0;
        int max = workspaceModels.length;
        while (i < max) {
            desc = workspaceModels[i].getBundleDescription();
            if (desc != null) {
                Path path = new Path(desc.getLocation());
                if (path.equals((Object)location)) {
                    currentModel = workspaceModels[i];
                    break;
                }
            } else if (DEBUG) {
                System.out.println("Tried to look up bundle description for: " + workspaceModels[i].toString());
            }
            ++i;
        }
        return currentModel;
    }

    private IResourceDelta[] getDeltas(IProject[] projects) {
        if (DEBUG) {
            System.out.println("Searching for deltas for build of project: " + this.fCurrentProject.getName());
        }
        ArrayList<IResourceDelta> deltas = new ArrayList<IResourceDelta>();
        IResourceDelta delta = this.getDelta(this.fCurrentProject);
        if (delta != null) {
            if (DEBUG) {
                System.out.println("Found a delta: " + delta);
            }
            deltas.add(delta);
        }
        int i = 0;
        while (i < projects.length) {
            delta = this.getDelta(projects[i]);
            if (delta != null) {
                if (DEBUG) {
                    System.out.println("Found a delta: " + delta);
                }
                deltas.add(delta);
            }
            ++i;
        }
        return deltas.toArray(new IResourceDelta[deltas.size()]);
    }

    protected IApiAnalyzer getAnalyzer() {
        return new BaseApiAnalyzer();
    }

    private IProject[] getRequiredProjects(boolean includebinaries) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (this.fCurrentProject == null || workspaceRoot == null) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.fCurrentProject);
            HashSet<IPath> blocations = new HashSet<IPath>();
            blocations.add(javaProject.getOutputLocation());
            this.fProjectToOutputLocations.put(this.fCurrentProject, blocations);
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IClasspathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!this.isOptional(entry) || p.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includebinaries || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                        break;
                    }
                    case 3: {
                        IPath entrypath = entry.getOutputLocation();
                        if (entrypath == null) break;
                        blocations.add(entrypath);
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                    javaProject = JavaCore.create((IProject)p);
                    HashSet<IPath> bins = new HashSet<IPath>();
                    if (javaProject.exists()) {
                        bins.add(javaProject.getOutputLocation());
                        IClasspathEntry[] source = javaProject.getRawClasspath();
                        IPath entrypath = null;
                        int j = 0;
                        while (j < source.length) {
                            if (source[j].getEntryKind() == 3 && (entrypath = source[j].getOutputLocation()) != null) {
                                bins.add(entrypath);
                            }
                            ++j;
                        }
                        this.fProjectToOutputLocations.put(p, bins);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    private IApiProfile getWorkspaceProfile() {
        return ApiPlugin.getDefault().getApiProfileManager().getWorkspaceProfile();
    }

    private boolean isOptional(IClasspathEntry entry) {
        IClasspathAttribute[] attribs = entry.getExtraAttributes();
        int i = 0;
        int length = attribs.length;
        while (i < length) {
            IClasspathAttribute attribute = attribs[i];
            if ("optional".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IPath resolveJavaPathFromResource(IResource resource) {
        IJavaElement element = JavaCore.create((IResource)resource);
        if (element != null) {
            switch (element.getElementType()) {
                case 6: {
                    IClassFile classfile = (IClassFile)element;
                    IType type = classfile.getType();
                    HashSet paths = (HashSet)this.fProjectToOutputLocations.get(resource.getProject());
                    IPath prefix = null;
                    Iterator iter = paths.iterator();
                    while (iter.hasNext()) {
                        prefix = (IPath)iter.next();
                        if (!prefix.isPrefixOf(type.getPath())) continue;
                        return type.getPath().removeFirstSegments(prefix.segmentCount()).removeFileExtension();
                    }
                    break;
                }
            }
        }
        return null;
    }

    public String toString() {
        return "Builder for project: [" + this.fCurrentProject.getName() + "]";
    }

    public static BuildState getLastBuiltState(IProject project) throws CoreException {
        if (!Util.isApiProject(project)) {
            return null;
        }
        return ApiAnalysisBuilder.readState(project);
    }

    protected static BuildState readState(IProject project) throws CoreException {
        File file = ApiAnalysisBuilder.getSerializationFile(project);
        if (file != null && file.exists()) {
            BuildState buildState;
            DataInputStream in;
            block10: {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    buildState = BuildState.read(in);
                    if (!DEBUG) break block10;
                    System.out.println("Saved state thinks last build failed for " + project.getName());
                }
                catch (Throwable throwable) {
                    try {
                        if (DEBUG) {
                            System.out.println("Saved state thinks last build failed for " + project.getName());
                        }
                        in.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
                    }
                }
            }
            in.close();
            return buildState;
        }
        if (DEBUG) {
            if (file == null) {
                System.out.println("Project does not exist: " + project);
            } else {
                System.out.println("Build state file " + file.getPath() + " does not exist");
            }
        }
        return null;
    }

    public static void setLastBuiltState(IProject project, BuildState state) throws CoreException {
        if (Util.isApiProject(project)) {
            if (state != null) {
                ApiAnalysisBuilder.saveBuiltState(project, state);
            } else {
                try {
                    File file = ApiAnalysisBuilder.getSerializationFile(project);
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                }
                catch (SecurityException securityException) {}
            }
        }
    }

    private static File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.pde.api.tools");
        return workingLocation.append("state.dat").toFile();
    }

    private static void saveBuiltState(IProject project, BuildState state) throws CoreException {
        File file;
        if (DEBUG) {
            System.out.println("Saving build state for project: " + project.getName());
        }
        if ((file = ApiAnalysisBuilder.getSerializationFile(project)) == null) {
            return;
        }
        long t = 0L;
        if (DEBUG) {
            t = System.currentTimeMillis();
        }
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                BuildState.write(state, out);
            }
            finally {
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 2, NLS.bind((String)BuilderMessages.build_cannotSaveState, (Object)project.getName()), (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", 2, NLS.bind((String)BuilderMessages.build_cannotSaveState, (Object)project.getName()), (Throwable)e));
        }
        if (DEBUG) {
            t = System.currentTimeMillis() - t;
            System.out.println(NLS.bind((String)BuilderMessages.build_saveStateComplete, (Object)String.valueOf(t)));
        }
    }

    private void clearLastState() throws CoreException {
        ApiAnalysisBuilder.setLastBuiltState(this.fCurrentProject, null);
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean fRequireFullBuild = false;

        private ResourceDeltaVisitor() {
        }

        boolean shouldRunFullBuild() {
            return this.fRequireFullBuild;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getResource().getType()) {
                case 4: 
                case 8: {
                    return !this.fRequireFullBuild;
                }
                case 2: {
                    return !this.fRequireFullBuild;
                }
                case 1: {
                    if (delta.getResource().getProjectRelativePath().equals((Object)MANIFEST_PATH)) {
                        this.fRequireFullBuild = true;
                        break;
                    }
                    IResource resource = delta.getResource();
                    String fileName = resource.getName();
                    if (Util.isClassFile(fileName)) {
                        ApiAnalysisBuilder.this.findAffectedSourceFiles(delta);
                        break;
                    }
                    if (Util.isJavaFileName(fileName) && ApiAnalysisBuilder.this.fCurrentProject.equals((Object)resource.getProject())) {
                        ApiAnalysisBuilder.this.fChangedTypes.add(resource);
                        ApiAnalysisBuilder.this.fTypesToCheck.add(resource);
                        break;
                    }
                    if (this.fRequireFullBuild || !".api_filters".equals(fileName)) break;
                    switch (delta.getKind()) {
                        case 2: 
                        case 262144: {
                            this.fRequireFullBuild = true;
                        }
                    }
                }
            }
            return false;
        }
    }
}

