/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.api.tools.internal.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchCriteria;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchEngine;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchResult;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchScope;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.provisional.search.IReference;
import org.eclipse.pde.api.tools.internal.search.MethodSearchCriteria;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiUseAnalyzer {
    private static final IApiProblem[] EMPTY = new IApiProblem[0];
    private static final boolean DEBUG = Util.DEBUG;

    public IApiProblem[] findIllegalApiUse(IApiComponent component, IApiSearchScope scope, IProgressMonitor monitor) throws CoreException {
        IApiSearchCriteria[] conditions = this.buildSearchConditions(component);
        ArrayList<IApiProblem> problems = new ArrayList<IApiProblem>();
        if (conditions.length > 0) {
            IApiSearchEngine engine = Factory.newSearchEngine();
            IApiSearchResult[] results = engine.search(scope, conditions, monitor);
            IApiProblem problem = null;
            IReference[] references = null;
            ProblemDescriptor desc = null;
            int i = 0;
            while (i < results.length) {
                references = results[i].getReferences();
                desc = (ProblemDescriptor)results[i].getSearchCriteria().getUserData();
                int j = 0;
                while (j < references.length) {
                    problem = this.createProblem(desc.getKind(), desc.getElementType(), desc.getFlags(), references[j]);
                    if (problem != null) {
                        problems.add(problem);
                    }
                    ++j;
                }
                ++i;
            }
            return problems.toArray(new IApiProblem[problems.size()]);
        }
        return EMPTY;
    }

    private IApiProblem createProblem(int kind, int elementType, int flags, IReference reference) {
        IApiComponent component = reference.getSourceLocation().getApiComponent();
        if (component instanceof PluginProjectApiComponent) {
            PluginProjectApiComponent ppac = (PluginProjectApiComponent)component;
            IJavaProject project = ppac.getJavaProject();
            return this.createUsageProblem(kind, elementType, flags, reference, project);
        }
        return this.createUsageProblem(kind, elementType, flags, reference);
    }

    private IApiSearchCriteria[] buildSearchConditions(IApiComponent component) {
        long start = System.currentTimeMillis();
        IApiComponent[] components = component.getProfile().getPrerequisiteComponents(new IApiComponent[]{component});
        UsageVisitor visitor = new UsageVisitor();
        int i = 0;
        while (i < components.length) {
            IApiComponent prereq = components[i];
            if (!prereq.equals(component)) {
                visitor.setOwningComponentId(prereq.getId());
                try {
                    prereq.getApiDescription().accept(visitor);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e.getStatus());
                }
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("Time to build search conditions: " + (end - start) + "ms");
        }
        List conditions = visitor.getConditions();
        conditions.add(this.createLeakCondition(1, 6, 2, 1, 65535, 5));
        conditions.add(this.createLeakCondition(2, 6, 2, 2, 65535, 5));
        conditions.add(this.createLeakCondition(4, 6, 5, 3, 63487, 5));
        MethodSearchCriteria criteria = new MethodSearchCriteria(8, new ProblemDescriptor(6, 6, 4));
        conditions.add(criteria);
        criteria = new MethodSearchCriteria(16, new ProblemDescriptor(6, 6, 5));
        conditions.add(criteria);
        return conditions.toArray(new IApiSearchCriteria[conditions.size()]);
    }

    private IApiSearchCriteria createLeakCondition(int refKind, int problemKind, int elementType, int flags, int restrictions, int sourcevis) {
        IApiSearchCriteria criteria = Factory.newSearchCriteria();
        criteria.setReferenceKinds(refKind);
        criteria.setReferencedRestrictions(2, 65535);
        criteria.setSourceRestrictions(1, restrictions);
        criteria.setSourceModifiers(sourcevis);
        criteria.setUserData(new ProblemDescriptor(problemKind, elementType, flags));
        return criteria;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IApiProblem createUsageProblem(int kind, int elementType, int flags, IReference reference, IJavaProject project) {
        try {
            int resolvedflags;
            String[] messageargs;
            String prefKey;
            int charEnd;
            int charStart;
            int lineNumber;
            IResource resource;
            ICompilationUnit compilationUnit;
            IType type;
            block53: {
                ILocation location = reference.getSourceLocation();
                IReferenceTypeDescriptor refType = location.getType();
                String lookupName = null;
                lookupName = refType.getEnclosingType() == null ? refType.getQualifiedName() : refType.getQualifiedName().replace('$', '.');
                type = project.findType(lookupName, (IProgressMonitor)new NullProgressMonitor());
                if (type == null) {
                    return null;
                }
                compilationUnit = type.getCompilationUnit();
                if (compilationUnit == null) {
                    return null;
                }
                resource = compilationUnit.getCorrespondingResource();
                if (resource == null) {
                    return null;
                }
                IDocument document = Util.getDocument(compilationUnit);
                lineNumber = location.getLineNumber();
                charStart = -1;
                charEnd = -1;
                prefKey = null;
                ILocation resolvedLocation = reference.getResolvedLocation();
                String typename = resolvedLocation.getType().getName();
                IMemberDescriptor member = resolvedLocation.getMember();
                messageargs = null;
                resolvedflags = flags;
                try {
                    block2 : switch (kind) {
                        case 4: {
                            prefKey = "ILLEGAL_IMPLEMENT";
                            messageargs = new String[]{typename, type.getElementName()};
                            ISourceRange range = type.getNameRange();
                            charStart = range.getOffset();
                            charEnd = charStart + range.getLength();
                            lineNumber = document.getLineOfOffset(charStart);
                            break;
                        }
                        case 1: {
                            prefKey = "ILLEGAL_EXTEND";
                            messageargs = new String[]{typename, type.getElementName()};
                            ISourceRange range = type.getNameRange();
                            charStart = range.getOffset();
                            charEnd = charStart + range.getLength();
                            lineNumber = document.getLineOfOffset(charStart);
                            break;
                        }
                        case 2: {
                            prefKey = "ILLEGAL_INSTANTIATE";
                            messageargs = new String[]{typename, type.getElementName()};
                            int linenumber = lineNumber == 0 ? 0 : lineNumber - 1;
                            IReferenceTypeDescriptor typeDesc = (IReferenceTypeDescriptor)member;
                            int offset = document.getLineOffset(linenumber);
                            String line = document.get(offset, document.getLineLength(linenumber));
                            String qname = typeDesc.getQualifiedName();
                            int first = this.findMethodNameStart(qname, line, 0);
                            if (first < 0) {
                                qname = typeDesc.getName();
                                first = this.findMethodNameStart(qname, line, 0);
                            }
                            if (first < 0) {
                                qname = "super";
                                first = line.indexOf(qname);
                            }
                            if (first > -1) {
                                charStart = offset + first;
                                charEnd = charStart + qname.length();
                            }
                            break;
                        }
                        case 5: {
                            IMethodDescriptor method = (IMethodDescriptor)member;
                            prefKey = "ILLEGAL_OVERRIDE";
                            String sig = Signature.toString((String)method.getSignature(), (String)method.getName(), null, (boolean)false, (boolean)false);
                            messageargs = new String[]{method.getEnclosingType().getName(), type.getElementName(), sig};
                            String[] parameterTypes = Signature.getParameterTypes((String)method.getSignature());
                            int i = 0;
                            while (i < parameterTypes.length) {
                                parameterTypes[i] = parameterTypes[i].replace('/', '.');
                                ++i;
                            }
                            IMethod Qmethod = type.getMethod(method.getName(), parameterTypes);
                            IMethod[] methods = type.getMethods();
                            IMethod match = null;
                            int i2 = 0;
                            while (i2 < methods.length) {
                                IMethod m = methods[i2];
                                if (m.isSimilar(Qmethod)) {
                                    match = m;
                                    break;
                                }
                                ++i2;
                            }
                            if (match != null) {
                                ISourceRange range = match.getNameRange();
                                charStart = range.getOffset();
                                charEnd = charStart + range.getLength();
                                lineNumber = document.getLineOfOffset(charStart);
                            }
                            break;
                        }
                        case 3: {
                            prefKey = "ILLEGAL_REFERENCE";
                            switch (elementType) {
                                case 6: {
                                    int first;
                                    IMethodDescriptor method = (IMethodDescriptor)member;
                                    messageargs = new String[]{method.getEnclosingType().getName(), type.getElementName(), Signature.toString((String)method.getSignature(), (String)method.getName(), null, (boolean)false, (boolean)false)};
                                    resolvedflags = 8;
                                    int linenumber = lineNumber == 0 ? 0 : lineNumber - 1;
                                    int offset = document.getLineOffset(linenumber);
                                    String line = document.get(offset, document.getLineLength(linenumber));
                                    String name = method.getName();
                                    if (method.isConstructor()) {
                                        name = method.getEnclosingType().getName();
                                        resolvedflags = 7;
                                        messageargs = new String[]{Signature.toString((String)method.getSignature(), (String)method.getEnclosingType().getName(), null, (boolean)false, (boolean)false), type.getElementName()};
                                    }
                                    if ((first = this.findMethodNameStart(name, line, 0)) < 0) {
                                        name = "super";
                                    }
                                    if ((first = this.findMethodNameStart(name, line, 0)) > -1) {
                                        charStart = offset + first;
                                        charEnd = charStart + name.length();
                                        break;
                                    }
                                    break block53;
                                }
                                case 5: {
                                    IFieldDescriptor field = (IFieldDescriptor)member;
                                    messageargs = new String[]{field.getEnclosingType().getName(), type.getElementName(), field.getName()};
                                    resolvedflags = 9;
                                    String name = field.getName();
                                    int linenumber = lineNumber == 0 ? 0 : lineNumber - 1;
                                    int offset = document.getLineOffset(linenumber);
                                    String line = document.get(offset, document.getLineLength(linenumber));
                                    IReferenceTypeDescriptor parent = field.getEnclosingType();
                                    String qname = String.valueOf(parent.getQualifiedName()) + "." + name;
                                    int first = line.indexOf(qname);
                                    if (first < 0) {
                                        qname = String.valueOf(parent.getName()) + "." + name;
                                        first = line.indexOf(qname);
                                    }
                                    if (first < 0) {
                                        qname = "super." + name;
                                        first = line.indexOf(qname);
                                    }
                                    if (first < 0) {
                                        qname = "this." + name;
                                        first = line.indexOf(qname);
                                    }
                                    if (first < 0) {
                                        int idx = line.indexOf(name);
                                        while (idx > -1) {
                                            if (line.charAt(idx - 1) == '.') {
                                                first = idx;
                                                qname = name;
                                                break;
                                            }
                                            idx = line.indexOf(name, idx + 1);
                                        }
                                    }
                                    if (first > -1) {
                                        charStart = offset + first;
                                        charEnd = charStart + qname.length();
                                        break;
                                    }
                                    charStart = offset;
                                    charEnd = offset + line.length();
                                }
                            }
                            break;
                        }
                        case 6: {
                            switch (flags) {
                                case 1: 
                                case 2: {
                                    prefKey = flags == 1 ? "LEAK_EXTEND" : "LEAK_IMPLEMENT";
                                    ISourceRange range = type.getNameRange();
                                    charStart = range.getOffset();
                                    charEnd = charStart + range.getLength();
                                    lineNumber = document.getLineOfOffset(charStart);
                                    messageargs = new String[]{typename, type.getElementName()};
                                    break block2;
                                }
                                case 3: {
                                    IField javaField;
                                    prefKey = "LEAK_FIELD_DECL";
                                    IFieldDescriptor field = (IFieldDescriptor)reference.getSourceLocation().getMember();
                                    if ((4 & field.getModifiers()) > 0) {
                                        IApiDescription description = reference.getSourceLocation().getApiComponent().getApiDescription();
                                        IApiAnnotations annotations = description.resolveAnnotations(field.getEnclosingType());
                                        if (annotations == null) {
                                            return null;
                                        }
                                        if (RestrictionModifiers.isExtendRestriction(annotations.getRestrictions())) {
                                            return null;
                                        }
                                    }
                                    if ((javaField = type.getField(field.getName())).exists()) {
                                        ISourceRange range = javaField.getNameRange();
                                        charStart = range.getOffset();
                                        charEnd = charStart + range.getLength();
                                        lineNumber = document.getLineOfOffset(charStart);
                                    }
                                    messageargs = new String[]{typename, type.getElementName(), field.getName()};
                                    break block2;
                                }
                                case 4: 
                                case 5: {
                                    IApiDescription description;
                                    IApiAnnotations annotations;
                                    prefKey = flags == 4 ? "LEAK_METHOD_RETURN_TYPE" : "LEAK_METHOD_PARAM";
                                    IMethodDescriptor method = (IMethodDescriptor)reference.getSourceLocation().getMember();
                                    if ((4 & method.getModifiers()) > 0 && ((annotations = (description = reference.getSourceLocation().getApiComponent().getApiDescription()).resolveAnnotations(method.getEnclosingType())) == null || RestrictionModifiers.isExtendRestriction(annotations.getRestrictions()))) {
                                        return null;
                                    }
                                    String[] parameterTypes = Signature.getParameterTypes((String)method.getSignature());
                                    int i = 0;
                                    while (i < parameterTypes.length) {
                                        parameterTypes[i] = parameterTypes[i].replace('/', '.');
                                        ++i;
                                    }
                                    String methodname = method.getName();
                                    if (method.isConstructor()) {
                                        methodname = method.getEnclosingType().getName();
                                        resolvedflags = 6;
                                    }
                                    IMethod Qmethod = type.getMethod(methodname, parameterTypes);
                                    IMethod[] methods = type.getMethods();
                                    IMethod match = null;
                                    int i3 = 0;
                                    while (i3 < methods.length) {
                                        IMethod m = methods[i3];
                                        if (m.isSimilar(Qmethod)) {
                                            match = m;
                                            break;
                                        }
                                        ++i3;
                                    }
                                    if (match != null) {
                                        ISourceRange range = match.getNameRange();
                                        charStart = range.getOffset();
                                        charEnd = charStart + range.getLength();
                                        lineNumber = document.getLineOfOffset(charStart);
                                    }
                                    messageargs = new String[]{typename, type.getElementName(), Signature.toString((String)method.getSignature(), (String)methodname, null, (boolean)false, (boolean)false)};
                                }
                            }
                        }
                    }
                }
                catch (BadLocationException e) {
                    ApiPlugin.log(e);
                }
            }
            if (ApiPlugin.getDefault().getSeverityLevel(prefKey, project.getProject()) == 0) {
                return null;
            }
            ICompilationUnit element = compilationUnit;
            if (charStart > -1) {
                element = compilationUnit.getElementAt(charStart);
            }
            return ApiProblemFactory.newApiUsageProblem(resource.getProjectRelativePath().toPortableString(), type.getFullyQualifiedName(), messageargs, new String[]{"org.eclipse.jdt.internal.core.JavaModelManager.handleId", "apiMarkerID"}, new Object[]{element == null ? compilationUnit.getHandleIdentifier() : element.getHandleIdentifier(), new Integer(3)}, lineNumber, charStart, charEnd, elementType, kind, resolvedflags);
        }
        catch (CoreException e) {
            ApiPlugin.log(e);
            return null;
        }
    }

    private int findMethodNameStart(String namepart, String line, int index) {
        int start = line.indexOf(namepart, index);
        if (start < 0) {
            return -1;
        }
        int offset = start + namepart.length();
        while (line.charAt(offset) == ' ') {
            ++offset;
        }
        if (line.charAt(offset) == '(') {
            return start;
        }
        return this.findMethodNameStart(namepart, line, offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IApiProblem createUsageProblem(int kind, int elementType, int flags, IReference reference) {
        ILocation location = reference.getSourceLocation();
        IReferenceTypeDescriptor refType = location.getType();
        int lineNumber = location.getLineNumber();
        ILocation resolvedLocation = reference.getResolvedLocation();
        String typename = resolvedLocation.getType().getQualifiedName();
        String ltypename = location.getType().getQualifiedName();
        IMemberDescriptor member = resolvedLocation.getMember();
        String[] messageargs = null;
        int resolvedflags = flags;
        switch (kind) {
            case 4: {
                messageargs = new String[]{typename, ltypename};
                return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
            }
            case 1: {
                messageargs = new String[]{typename, ltypename};
                return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
            }
            case 2: {
                messageargs = new String[]{typename, ltypename};
                return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
            }
            case 5: {
                IMethodDescriptor method = (IMethodDescriptor)member;
                messageargs = new String[]{method.getEnclosingType().getQualifiedName(), ltypename, Signature.toString((String)method.getSignature(), (String)method.getName(), null, (boolean)false, (boolean)false)};
                return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
            }
            case 3: {
                switch (elementType) {
                    case 6: {
                        IMethodDescriptor method = (IMethodDescriptor)member;
                        String methodname = method.getName();
                        resolvedflags = 8;
                        if (method.isConstructor()) {
                            methodname = method.getEnclosingType().getName();
                            resolvedflags = 7;
                        }
                        messageargs = new String[]{method.getEnclosingType().getQualifiedName(), ltypename, Signature.toString((String)method.getSignature(), (String)methodname, null, (boolean)false, (boolean)false)};
                        return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
                    }
                    case 5: {
                        IFieldDescriptor field = (IFieldDescriptor)member;
                        messageargs = new String[]{field.getEnclosingType().getQualifiedName(), ltypename, field.getName()};
                        resolvedflags = 9;
                        return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
                    }
                }
                return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
            }
            case 6: {
                try {
                    switch (flags) {
                        case 1: 
                        case 2: {
                            messageargs = new String[]{typename, ltypename};
                            return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
                        }
                        case 3: {
                            IApiDescription description;
                            IApiAnnotations annotations;
                            IFieldDescriptor field = (IFieldDescriptor)reference.getSourceLocation().getMember();
                            if ((4 & field.getModifiers()) > 0 && ((annotations = (description = reference.getSourceLocation().getApiComponent().getApiDescription()).resolveAnnotations(field.getEnclosingType())) == null || RestrictionModifiers.isExtendRestriction(annotations.getRestrictions()))) {
                                return null;
                            }
                            messageargs = new String[]{typename, ltypename, field.getName()};
                            return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
                        }
                        case 4: 
                        case 5: {
                            IApiDescription description;
                            IApiAnnotations annotations;
                            IMethodDescriptor method = (IMethodDescriptor)reference.getSourceLocation().getMember();
                            if ((4 & method.getModifiers()) > 0 && ((annotations = (description = reference.getSourceLocation().getApiComponent().getApiDescription()).resolveAnnotations(method.getEnclosingType())) == null || RestrictionModifiers.isOverrideRestriction(annotations.getRestrictions()))) {
                                return null;
                            }
                            String name = method.getName();
                            if (method.isConstructor()) {
                                name = method.getEnclosingType().getName();
                                resolvedflags = 6;
                            }
                            messageargs = new String[]{typename, ltypename, Signature.toString((String)method.getSignature(), (String)name, null, (boolean)false, (boolean)false)};
                            return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
                        }
                    }
                    return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e.getStatus());
                }
                return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
            }
        }
        return ApiProblemFactory.newApiUsageProblem(null, refType.getQualifiedName(), messageargs, new String[]{"apiMarkerID"}, new Object[]{new Integer(3)}, lineNumber, -1, -1, elementType, kind, resolvedflags);
    }

    class ProblemDescriptor {
        private int fKind;
        private int fElementType;
        private int fFlags;

        ProblemDescriptor(int kind, int elementType) {
            this(kind, elementType, 0);
        }

        ProblemDescriptor(int kind, int elementType, int flags) {
            this.fKind = kind;
            this.fElementType = elementType;
            this.fFlags = flags;
        }

        public int getKind() {
            return this.fKind;
        }

        public int getElementType() {
            return this.fElementType;
        }

        public int getFlags() {
            return this.fFlags;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Problem Descriptor[");
            buffer.append(Util.getProblemKind(0x20000000, this.fKind)).append(", ");
            buffer.append(Util.getProblemElementKind(0x20000000, this.fElementType)).append(", ");
            buffer.append(Util.getProblemFlagsName(0x20000000, this.fFlags));
            buffer.append("]\n");
            return buffer.toString();
        }
    }

    class UsageVisitor
    extends ApiDescriptionVisitor {
        private List fConditions = new ArrayList();
        private String fOwningComponentId;

        UsageVisitor() {
        }

        void setOwningComponentId(String id) {
            this.fOwningComponentId = id;
        }

        public boolean visitElement(IElementDescriptor element, IApiAnnotations description) {
            int mask = description.getRestrictions();
            if (!RestrictionModifiers.isUnrestricted(mask)) {
                IElementDescriptor[] elements = new IElementDescriptor[]{element};
                if (RestrictionModifiers.isOverrideRestriction(mask)) {
                    this.addCriteria(0x10000000, 4096, elements, 5, 6);
                }
                if (RestrictionModifiers.isExtendRestriction(mask)) {
                    this.addCriteria(1, 512, elements, 1, 2);
                }
                if (RestrictionModifiers.isImplementRestriction(mask)) {
                    this.addCriteria(2, 256, elements, 4, 2);
                    this.addCriteria(1, 256, elements, 4, 2);
                }
                if (RestrictionModifiers.isInstantiateRestriction(mask)) {
                    this.addCriteria(0x8000000, 1024, elements, 2, 2);
                }
                if (RestrictionModifiers.isReferenceRestriction(mask)) {
                    if (element.getElementType() == 6) {
                        this.addCriteria(1049536, 2048, elements, 3, 6);
                    } else if (element.getElementType() == 5) {
                        this.addCriteria(30720, 2048, elements, 3, 5);
                    }
                }
            }
            return true;
        }

        private void addCriteria(int refKind, int restriction, IElementDescriptor[] elements, int problemKind, int elemenType) {
            IApiSearchCriteria condition = Factory.newSearchCriteria();
            condition.addReferencedElementRestriction(this.fOwningComponentId, elements);
            condition.setReferenceKinds(refKind);
            condition.setReferencedRestrictions(65535, restriction);
            condition.setUserData(new ProblemDescriptor(problemKind, elemenType));
            this.fConditions.add(condition);
        }

        List getConditions() {
            return this.fConditions;
        }
    }
}

