/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Signature;
import org.eclipse.pde.api.tools.internal.comparator.ComparatorMessages;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.comparator.ElementDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.FieldDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.MemberTypeDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.MethodDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.SignatureDecoder;
import org.eclipse.pde.api.tools.internal.comparator.SignatureDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.TypeDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.TypeParameterDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassFileComparator {
    private static boolean DEBUG = Util.DEBUG;
    private IApiProfile apiProfile = null;
    private IApiProfile apiProfile2 = null;
    private IClassFile classFile = null;
    private IApiComponent component = null;
    private IApiComponent component2 = null;
    private Delta delta = null;
    private TypeDescriptor descriptor1 = null;
    private TypeDescriptor descriptor2 = null;
    private int visibilityModifiers;
    private int currentDescriptorRestrictions;
    private int initialDescriptorRestrictions;
    private MultiStatus status = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCheckedException(IApiProfile profile, IApiComponent apiComponent, String exceptionName) {
        if (profile == null) {
            return true;
        }
        try {
            String packageName = Util.getPackageName(exceptionName);
            IClassFile classFile = Util.getClassFile(profile.resolvePackage(apiComponent, packageName), exceptionName);
            if (classFile == null) return true;
            byte[] contents = classFile.getContents();
            TypeDescriptor typeDescriptor = new TypeDescriptor(contents);
            do {
                if (Util.isJavaLangObject(typeDescriptor.name)) {
                    return true;
                }
                String superName = typeDescriptor.superName;
                packageName = Util.getPackageName(superName);
                classFile = Util.getClassFile(profile.resolvePackage(apiComponent, packageName), superName);
                if (classFile == null) {
                    if (!DEBUG) return true;
                    System.err.println("CHECKED EXCEPTION LOOKUP: Could not find " + superName + " in profile " + profile.getName() + " from component " + apiComponent.getId());
                    return true;
                }
                typeDescriptor = new TypeDescriptor(classFile.getContents());
            } while (!Util.isJavaLangRuntimeException(typeDescriptor.name));
            return false;
        }
        catch (CoreException e) {
            this.reportStatus((Exception)((Object)e));
        }
        return true;
    }

    public ClassFileComparator(IClassFile classFile, IClassFile classFile2, IApiComponent component, IApiComponent component2, IApiProfile apiState, IApiProfile apiState2, int visibilityModifiers) throws CoreException {
        this.component = component;
        this.component2 = component2;
        this.descriptor1 = new TypeDescriptor(classFile.getContents());
        this.descriptor2 = new TypeDescriptor(classFile2.getContents());
        this.apiProfile = apiState;
        this.apiProfile2 = apiState2;
        this.classFile = classFile;
        this.visibilityModifiers = visibilityModifiers;
    }

    public ClassFileComparator(TypeDescriptor typeDescriptor, IClassFile classFile2, IApiComponent component, IApiComponent component2, IApiProfile apiState, IApiProfile apiState2, int visibilityModifiers) throws CoreException {
        this.component = component;
        this.component2 = component2;
        this.descriptor1 = typeDescriptor;
        this.descriptor2 = new TypeDescriptor(classFile2.getContents());
        this.apiProfile = apiState;
        this.apiProfile2 = apiState2;
        this.classFile = typeDescriptor.classFile;
        this.visibilityModifiers = visibilityModifiers;
    }

    private void addDelta(IDelta delta) {
        this.delta.add(delta);
    }

    private void addDelta(int elementType, int kind, int flags, int restrictions, int modifiers, IClassFile classFile, String key, String data) {
        this.addDelta(new Delta(Util.getDeltaComponentID(this.component2), elementType, kind, flags, restrictions, modifiers, classFile.getTypeName(), key, data));
    }

    private void addDelta(int elementType, int kind, int flags, int restrictions, int modifiers, IClassFile classFile, String key, String[] datas) {
        this.addDelta(new Delta(Util.getDeltaComponentID(this.component2), elementType, kind, flags, restrictions, modifiers, classFile.getTypeName(), key, datas));
    }

    private void checkSuperclass() throws CoreException {
        List superclassList1 = this.getSuperclassList(this.descriptor1, this.component, this.apiProfile);
        if (!this.isStatusOk()) {
            return;
        }
        List superclassList2 = this.getSuperclassList(this.descriptor2, this.component2, this.apiProfile2);
        if (!this.isStatusOk()) {
            return;
        }
        if (superclassList1 == null) {
            if (superclassList2 != null) {
                this.addDelta(this.descriptor1.getElementType(), 1, 39, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
        } else if (superclassList2 == null) {
            this.addDelta(this.descriptor1.getElementType(), 3, 39, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
        }
        if (superclassList1 != null && superclassList2 != null) {
            TypeDescriptor superclassTypeDescriptor2 = (TypeDescriptor)superclassList2.get(0);
            TypeDescriptor superclassTypeDescriptor = (TypeDescriptor)superclassList1.get(0);
            if (!superclassTypeDescriptor.name.equals(superclassTypeDescriptor2.name)) {
                if (!superclassList2.contains(superclassTypeDescriptor)) {
                    this.addDelta(this.descriptor1.getElementType(), 3, 39, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                } else {
                    this.addDelta(this.descriptor1.getElementType(), 1, 39, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                }
            }
        }
        if (this.visibilityModifiers == 1) {
            int currentTypeVisibility = 0;
            String superTypeName = this.descriptor1.superName;
            String superTypeName2 = this.descriptor2.superName;
            if (!superTypeName.equals(superTypeName2)) {
                return;
            }
            LookupResult pair = this.getType(superTypeName, this.component, this.apiProfile);
            if (pair == null) {
                return;
            }
            IClassFile superclassType1 = pair.classFile;
            IApiDescription apiDescription = pair.apiComponent.getApiDescription();
            TypeDescriptor superTypeDescriptor = new TypeDescriptor(superclassType1.getContents());
            IApiAnnotations superclassAnnotations = apiDescription.resolveAnnotations(superTypeDescriptor.handle);
            if (superclassAnnotations != null && !VisibilityModifiers.isAPI(currentTypeVisibility = superclassAnnotations.getVisibility())) {
                ClassFileComparator comparator;
                IDelta delta2;
                final boolean ignoreProtected = RestrictionModifiers.isExtendRestriction(this.currentDescriptorRestrictions) || Util.isFinal(this.descriptor1.access);
                IClassFile superclassType2 = this.component2.findClassFile(superTypeName);
                if (superclassType2 != null && (delta2 = (comparator = new ClassFileComparator(superclassType1, superclassType2, this.component, this.component2, this.apiProfile, this.apiProfile2, this.visibilityModifiers)).getDelta()) != null && delta2 != ApiComparator.NO_DELTA) {
                    delta2.accept(new DeltaVisitor(){

                        public boolean visit(IDelta delta) {
                            IDelta[] children = delta.getChildren();
                            if (children.length == 0) {
                                int modifiers = delta.getModifiers();
                                if (Util.isProtected(modifiers)) {
                                    if (!ignoreProtected) {
                                        switch (delta.getElementType()) {
                                            case 4: 
                                            case 5: 
                                            case 6: 
                                            case 7: 
                                            case 9: {
                                                break;
                                            }
                                            default: {
                                                ClassFileComparator.this.addDelta(delta);
                                                break;
                                            }
                                        }
                                    }
                                } else if (Util.isPublic(modifiers)) {
                                    block3 : switch (delta.getElementType()) {
                                        case 4: 
                                        case 6: 
                                        case 7: 
                                        case 9: {
                                            switch (delta.getFlags()) {
                                                case 8: {
                                                    break block3;
                                                }
                                            }
                                            ClassFileComparator.this.addDelta(delta);
                                        }
                                    }
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }
        }
    }

    protected void reportStatus(IStatus newstatus) {
        if (this.status == null) {
            String msg = MessageFormat.format((String)ComparatorMessages.ClassFileComparator_0, (Object[])new String[]{this.descriptor1.name});
            this.status = new MultiStatus("org.eclipse.pde.api.tools", 4, msg, null);
        }
        this.status.add(newstatus);
    }

    private void reportStatus(Exception e) {
        this.reportStatus(e);
    }

    private boolean isStatusOk() {
        return this.status == null;
    }

    public IStatus getStatus() {
        return this.status;
    }

    private void checkSuperInterfaces() {
        Set superinterfacesSet1 = this.getInterfacesSet(this.descriptor1, this.component, this.apiProfile);
        if (!this.isStatusOk()) {
            return;
        }
        Set superinterfacesSet2 = this.getInterfacesSet(this.descriptor2, this.component2, this.apiProfile2);
        if (!this.isStatusOk()) {
            return;
        }
        if (superinterfacesSet1 == null) {
            if (superinterfacesSet2 != null) {
                this.addDelta(this.descriptor1.getElementType(), 2, 15, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
        } else if (superinterfacesSet2 == null) {
            this.addDelta(this.descriptor1.getElementType(), 2, 10, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
        } else {
            Iterator iterator = superinterfacesSet1.iterator();
            while (iterator.hasNext()) {
                TypeDescriptor superInterfaceTypeDescriptor = (TypeDescriptor)iterator.next();
                if (superinterfacesSet2.contains(superInterfaceTypeDescriptor)) continue;
                this.addDelta(this.descriptor1.getElementType(), 2, 10, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                return;
            }
            if (superinterfacesSet1.size() < superinterfacesSet2.size()) {
                this.addDelta(this.descriptor1.getElementType(), 2, 15, this.currentDescriptorRestrictions, this.descriptor1.access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
        }
    }

    private void checkTypeMembers() {
        List typeMembers = this.descriptor1.typeMembers;
        List typeMembers2 = this.descriptor2.typeMembers;
        if (typeMembers != null) {
            String typeMemberName;
            MemberTypeDescriptor typeMember;
            if (typeMembers2 == null) {
                Iterator iterator = typeMembers.iterator();
                while (iterator.hasNext()) {
                    try {
                        MemberTypeDescriptor typeMember2 = (MemberTypeDescriptor)iterator.next();
                        String typeMemberName2 = ((IReferenceTypeDescriptor)typeMember2.handle).getQualifiedName();
                        IApiDescription apiDescription = this.component.getApiDescription();
                        IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(Factory.typeDescriptor(typeMemberName2));
                        int memberTypeVisibility = 0;
                        if (memberTypeElementDescription != null) {
                            memberTypeVisibility = memberTypeElementDescription.getVisibility();
                        }
                        if ((memberTypeVisibility & this.visibilityModifiers) == 0 || this.visibilityModifiers == 1 && (Util.isDefault(typeMember2.access) || Util.isPrivate(typeMember2.access))) continue;
                        this.addDelta(this.descriptor1.getElementType(), 3, 48, this.currentDescriptorRestrictions, typeMember2.access, this.classFile, typeMember2.name, new String[]{typeMemberName2.replace('$', '.'), Util.getDeltaComponentID(this.component2)});
                    }
                    catch (CoreException e) {
                        this.reportStatus((Exception)((Object)e));
                    }
                }
                return;
            }
            ArrayList<MemberTypeDescriptor> removedTypeMembers = new ArrayList<MemberTypeDescriptor>();
            Iterator iterator = typeMembers.iterator();
            while (iterator.hasNext()) {
                typeMember = (MemberTypeDescriptor)iterator.next();
                typeMemberName = ((IReferenceTypeDescriptor)typeMember.handle).getQualifiedName();
                MemberTypeDescriptor typeMember2 = this.retrieveTypeMember(typeMembers2, typeMember.name);
                if (typeMember2 == null) {
                    removedTypeMembers.add(typeMember);
                    continue;
                }
                typeMembers2.remove(typeMember2);
                try {
                    IClassFile memberType2;
                    ClassFileComparator comparator;
                    IDelta delta2;
                    int restrictions;
                    IClassFile memberType1 = this.component.findClassFile(typeMemberName);
                    IApiDescription apiDescription = this.component.getApiDescription();
                    IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(Factory.typeDescriptor(typeMemberName));
                    int memberTypeVisibility = 0;
                    if (memberTypeElementDescription != null) {
                        memberTypeVisibility = memberTypeElementDescription.getVisibility();
                    }
                    if ((memberTypeVisibility & this.visibilityModifiers) == 0) continue;
                    IApiDescription apiDescription2 = this.component2.getApiDescription();
                    IApiAnnotations memberTypeElementDescription2 = apiDescription2.resolveAnnotations(Factory.typeDescriptor(typeMemberName));
                    int memberTypeVisibility2 = 0;
                    if (memberTypeElementDescription2 != null) {
                        memberTypeVisibility2 = memberTypeElementDescription2.getVisibility();
                    }
                    String deltaComponentID = Util.getDeltaComponentID(this.component2);
                    int n = restrictions = memberTypeElementDescription2 != null ? memberTypeElementDescription2.getRestrictions() : 0;
                    if (Util.isFinal(this.descriptor2.access)) {
                        restrictions |= 0x200;
                    }
                    if (ClassFileComparator.isAPI(memberTypeVisibility, typeMember) && !ClassFileComparator.isAPI(memberTypeVisibility2, typeMember2)) {
                        this.addDelta(new Delta(deltaComponentID, typeMember.getElementType(), 2, 11, restrictions | this.currentDescriptorRestrictions, typeMember.access, typeMemberName, typeMemberName, new String[]{typeMemberName.replace('$', '.')}));
                        continue;
                    }
                    if ((memberTypeVisibility2 & this.visibilityModifiers) == 0) {
                        this.addDelta(new Delta(deltaComponentID, typeMember.getElementType(), 2, 52, restrictions | this.currentDescriptorRestrictions, typeMember2.access, typeMemberName, typeMemberName, new String[]{typeMemberName.replace('$', '.')}));
                    }
                    if (this.visibilityModifiers == 1 && (Util.isDefault(typeMember2.access) || Util.isPrivate(typeMember2.access)) || (delta2 = (comparator = new ClassFileComparator(memberType1, memberType2 = this.component2.findClassFile(typeMemberName), this.component, this.component2, this.apiProfile, this.apiProfile2, this.visibilityModifiers)).getDelta()) == null || delta2 == ApiComparator.NO_DELTA) continue;
                    this.addDelta(delta2);
                }
                catch (CoreException e) {
                    this.reportStatus((Exception)((Object)e));
                }
            }
            iterator = removedTypeMembers.iterator();
            while (iterator.hasNext()) {
                try {
                    typeMember = (MemberTypeDescriptor)iterator.next();
                    typeMemberName = ((IReferenceTypeDescriptor)typeMember.handle).getQualifiedName();
                    IApiDescription apiDescription = this.component.getApiDescription();
                    IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(Factory.typeDescriptor(typeMemberName));
                    int memberTypeVisibility = 0;
                    if (memberTypeElementDescription != null) {
                        memberTypeVisibility = memberTypeElementDescription.getVisibility();
                    }
                    if ((memberTypeVisibility & this.visibilityModifiers) == 0 || this.visibilityModifiers == 1 && (Util.isDefault(typeMember.access) || Util.isPrivate(typeMember.access))) continue;
                    this.addDelta(this.descriptor1.getElementType(), 3, 48, memberTypeElementDescription != null ? memberTypeElementDescription.getRestrictions() : 0, typeMember.access, this.classFile, typeMember.name, new String[]{typeMemberName.replace('$', '.'), Util.getDeltaComponentID(this.component2)});
                }
                catch (CoreException e) {
                    this.reportStatus((Exception)((Object)e));
                }
            }
        }
        if (typeMembers2 == null) {
            return;
        }
        Iterator iterator = typeMembers2.iterator();
        while (iterator.hasNext()) {
            try {
                MemberTypeDescriptor typeMember = (MemberTypeDescriptor)iterator.next();
                String typeMemberName = ((IReferenceTypeDescriptor)typeMember.handle).getQualifiedName();
                IApiDescription apiDescription2 = this.component2.getApiDescription();
                IApiAnnotations memberTypeElementDescription2 = apiDescription2.resolveAnnotations(Factory.typeDescriptor(typeMemberName));
                int memberTypeVisibility2 = 0;
                if (memberTypeElementDescription2 != null) {
                    memberTypeVisibility2 = memberTypeElementDescription2.getVisibility();
                }
                if ((memberTypeVisibility2 & this.visibilityModifiers) == 0 || this.visibilityModifiers == 1 && (Util.isDefault(typeMember.access) || Util.isPrivate(typeMember.access))) continue;
                this.addDelta(this.descriptor1.getElementType(), 1, 48, this.currentDescriptorRestrictions, typeMember.access, this.classFile, typeMember.name, typeMember.name.replace('$', '.'));
            }
            catch (CoreException e) {
                this.reportStatus((Exception)((Object)e));
            }
        }
    }

    private void checkGenericSignature(String signature1, String signature2, ElementDescriptor elementDescriptor1, ElementDescriptor elementDescriptor2) {
        block32: {
            block34: {
                int length;
                SignatureDescriptor signatureDescriptor;
                block35: {
                    block31: {
                        SignatureDescriptor signatureDescriptor2;
                        block33: {
                            if (signature1 != null) break block31;
                            if (signature2 == null) break block32;
                            signatureDescriptor2 = this.getSignatureDescritor(signature2);
                            TypeParameterDescriptor[] typeParameterDescriptors = signatureDescriptor2.getTypeParameterDescriptors();
                            if (typeParameterDescriptors.length == 0) break block33;
                            this.addDelta(elementDescriptor1.getElementType(), 1, 51, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                            break block32;
                        }
                        if (signatureDescriptor2.getTypeArguments().length == 0) break block32;
                        this.addDelta(elementDescriptor1.getElementType(), 1, 47, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1)});
                        break block32;
                    }
                    if (signature2 != null) break block34;
                    signatureDescriptor = this.getSignatureDescritor(signature1);
                    TypeParameterDescriptor[] typeParameterDescriptors = signatureDescriptor.getTypeParameterDescriptors();
                    length = typeParameterDescriptors.length;
                    if (length == 0) break block35;
                    int i = 0;
                    while (i < length) {
                        TypeParameterDescriptor typeParameterDescriptor = typeParameterDescriptors[i];
                        this.addDelta(elementDescriptor1.getElementType(), 3, 49, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), typeParameterDescriptor.name});
                        ++i;
                    }
                    break block32;
                }
                String[] typeArguments = signatureDescriptor.getTypeArguments();
                length = typeArguments.length;
                if (length == 0) break block32;
                int i = 0;
                while (i < length) {
                    String typeArgument = typeArguments[i];
                    this.addDelta(elementDescriptor1.getElementType(), 3, 68, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), typeArgument});
                    ++i;
                }
                break block32;
            }
            SignatureDescriptor signatureDescriptor = this.getSignatureDescritor(signature1);
            SignatureDescriptor signatureDescriptor2 = this.getSignatureDescritor(signature2);
            TypeParameterDescriptor[] typeParameterDescriptors1 = signatureDescriptor.getTypeParameterDescriptors();
            TypeParameterDescriptor[] typeParameterDescriptors2 = signatureDescriptor2.getTypeParameterDescriptors();
            int length = typeParameterDescriptors1.length;
            int length2 = typeParameterDescriptors2.length;
            int min = length;
            int max = length2;
            if (length > length2) {
                min = length2;
                max = length;
            }
            int i = 0;
            while (i < min) {
                TypeParameterDescriptor parameterDescriptor1 = typeParameterDescriptors1[i];
                TypeParameterDescriptor parameterDescriptor2 = typeParameterDescriptors2[i];
                String name = parameterDescriptor1.name;
                if (!name.equals(parameterDescriptor2.name)) {
                    this.addDelta(10, 2, 50, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                }
                if (parameterDescriptor1.classBound == null) {
                    if (parameterDescriptor2.classBound != null) {
                        this.addDelta(10, 1, 6, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                    }
                } else if (parameterDescriptor2.classBound == null) {
                    this.addDelta(10, 3, 6, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                } else if (!parameterDescriptor1.classBound.equals(parameterDescriptor2.classBound)) {
                    this.addDelta(10, 2, 6, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name});
                }
                List interfaceBounds1 = parameterDescriptor1.interfaceBounds;
                List interfaceBounds2 = parameterDescriptor2.interfaceBounds;
                if (interfaceBounds1 == null) {
                    if (interfaceBounds2 != null) {
                        Iterator iterator = interfaceBounds2.iterator();
                        while (iterator.hasNext()) {
                            this.addDelta(10, 1, 23, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name, (String)iterator.next()});
                        }
                    }
                } else if (interfaceBounds2 == null) {
                    Iterator iterator = interfaceBounds1.iterator();
                    while (iterator.hasNext()) {
                        this.addDelta(10, 3, 23, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name, (String)iterator.next()});
                    }
                } else {
                    int size1 = interfaceBounds1.size();
                    int size2 = interfaceBounds2.size();
                    int boundsMin = size1;
                    int boundsMax = size2;
                    if (size1 > size2) {
                        boundsMin = size2;
                        boundsMax = size1;
                    }
                    int index = 0;
                    while (index < boundsMin) {
                        String currentInterfaceBound = (String)interfaceBounds1.get(index);
                        if (!currentInterfaceBound.equals(interfaceBounds2.get(index))) {
                            this.addDelta(10, 2, 23, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name, currentInterfaceBound});
                        }
                        ++index;
                    }
                    if (boundsMin != boundsMax) {
                        boolean added = boundsMax == size2;
                        while (index < boundsMax) {
                            String currentInterfaceBound = added ? (String)interfaceBounds2.get(index) : (String)interfaceBounds1.get(index);
                            this.addDelta(10, added ? 1 : 3, 23, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), name, currentInterfaceBound});
                            ++index;
                        }
                    }
                }
                ++i;
            }
            if (min != max) {
                boolean added = max == length2;
                while (i < max) {
                    TypeParameterDescriptor currentTypeParameter = added ? typeParameterDescriptors2[i] : typeParameterDescriptors1[i];
                    this.addDelta(elementDescriptor1.getElementType(), added ? 1 : 3, 49, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), currentTypeParameter.name});
                    ++i;
                }
            }
            if (length2 > 0 || length > 0) {
                return;
            }
            String[] typeArguments = signatureDescriptor.getTypeArguments();
            String[] typeArguments2 = signatureDescriptor2.getTypeArguments();
            length = typeArguments.length;
            length2 = typeArguments2.length;
            min = length;
            max = length2;
            if (length > length2) {
                min = length2;
                max = length;
            }
            i = 0;
            while (i < min) {
                String currentTypeArgument = typeArguments[i];
                String newTypeArgument = typeArguments2[i];
                if (!currentTypeArgument.equals(newTypeArgument)) {
                    this.addDelta(elementDescriptor1.getElementType(), 2, 68, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), currentTypeArgument, newTypeArgument});
                }
                ++i;
            }
            if (min != max) {
                boolean added = max == length2;
                while (i < max) {
                    String currentTypeArgument = added ? typeArguments2[i] : typeArguments[i];
                    this.addDelta(elementDescriptor1.getElementType(), added ? 1 : 3, 68, this.currentDescriptorRestrictions, elementDescriptor1.access, this.classFile, elementDescriptor1.name, new String[]{this.getDataFor(elementDescriptor1, this.descriptor1), currentTypeArgument});
                    ++i;
                }
            }
        }
    }

    private void collectAllInterfaces(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile, Set set) {
        Set interfaces = typeDescriptor.interfaces;
        try {
            String superclassName;
            IApiComponent sourceComponent = apiComponent;
            IApiDescription apiDescription = sourceComponent.getApiDescription();
            HashMap<String, IApiDescription> apiDescriptions = new HashMap<String, IApiDescription>(3);
            apiDescriptions.put(sourceComponent.getId(), apiDescription);
            if (interfaces != null) {
                Iterator iterator = interfaces.iterator();
                while (iterator.hasNext()) {
                    String interfaceName = (String)iterator.next();
                    LookupResult pair = this.getType(interfaceName, sourceComponent, profile);
                    if (pair == null) {
                        return;
                    }
                    IClassFile superinterface = pair.classFile;
                    TypeDescriptor typeDescriptor2 = new TypeDescriptor(superinterface.getContents());
                    int visibility = 2;
                    IApiComponent apiComponent2 = pair.apiComponent;
                    if (apiComponent2.hasApiDescription()) {
                        IApiAnnotations elementDescription;
                        apiDescription = (IApiDescription)apiDescriptions.get(apiComponent2.getId());
                        if (apiDescription == null) {
                            apiDescription = apiComponent2.getApiDescription();
                            apiDescriptions.put(apiComponent2.getId(), apiDescription);
                        }
                        if ((elementDescription = apiDescription.resolveAnnotations(typeDescriptor2.handle)) != null) {
                            visibility = elementDescription.getVisibility();
                        }
                    } else if (Util.isPublic(typeDescriptor2.access) || Util.isProtected(typeDescriptor2.access)) {
                        visibility = 1;
                    }
                    if ((visibility & this.visibilityModifiers) != 0) {
                        set.add(typeDescriptor2);
                    }
                    this.collectAllInterfaces(typeDescriptor2, apiComponent, profile, set);
                }
            }
            if ((superclassName = typeDescriptor.superName) != null && !Util.isJavaLangObject(superclassName)) {
                LookupResult pair = this.getType(superclassName, apiComponent, profile);
                if (pair == null) {
                    return;
                }
                IClassFile superclass = pair.classFile;
                TypeDescriptor typeDescriptor2 = new TypeDescriptor(superclass.getContents());
                this.collectAllInterfaces(typeDescriptor2, apiComponent, profile, set);
            }
        }
        catch (CoreException e) {
            this.reportStatus((Exception)((Object)e));
        }
    }

    private String getDataFor(ElementDescriptor descriptor, TypeDescriptor typeDescriptor) {
        switch (descriptor.getElementType()) {
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                if (descriptor.isMemberType()) {
                    return descriptor.name.replace('$', '.');
                }
                return descriptor.name;
            }
            case 5: 
            case 9: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(typeDescriptor.name).append('.').append(this.getMethodDisplayName((MethodDescriptor)descriptor, typeDescriptor));
                return String.valueOf(buffer);
            }
            case 7: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(typeDescriptor.name).append('.').append(descriptor.name);
                return String.valueOf(buffer);
            }
        }
        return null;
    }

    private Delta createDelta() {
        return new Delta();
    }

    public IDelta getDelta() {
        try {
            Iterator iterator2;
            Object object;
            FieldDescriptor fieldDescriptor;
            this.delta = this.createDelta();
            int typeAccess = this.descriptor1.access;
            int typeAccess2 = this.descriptor2.access;
            IApiDescription component2ApiDescription = this.component2.getApiDescription();
            IApiAnnotations elementDescription2 = component2ApiDescription.resolveAnnotations(this.descriptor2.handle);
            this.initialDescriptorRestrictions = 0;
            this.currentDescriptorRestrictions = 0;
            if (elementDescription2 != null) {
                int restrictions2 = elementDescription2.getRestrictions();
                IApiDescription apiDescription = this.component.getApiDescription();
                if (this.component.hasApiDescription()) {
                    int restrictions = 0;
                    IApiAnnotations componentApiDescription = apiDescription.resolveAnnotations(this.descriptor1.handle);
                    if (componentApiDescription != null) {
                        this.initialDescriptorRestrictions = restrictions = componentApiDescription.getRestrictions();
                    }
                    if (restrictions2 != restrictions) {
                        if (this.descriptor1.isInterface()) {
                            if (RestrictionModifiers.isImplementRestriction(restrictions2) && !RestrictionModifiers.isImplementRestriction(restrictions)) {
                                this.addDelta(this.descriptor1.getElementType(), 2, 37, restrictions2, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                            }
                        } else {
                            boolean reportChangedRestrictions = false;
                            if (!Util.isFinal(typeAccess2) && !Util.isFinal(typeAccess) && RestrictionModifiers.isExtendRestriction(restrictions2) && !RestrictionModifiers.isExtendRestriction(restrictions)) {
                                reportChangedRestrictions = true;
                                this.addDelta(this.descriptor1.getElementType(), 2, 37, restrictions2, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                            }
                            if (!(reportChangedRestrictions || Util.isAbstract(typeAccess2) || Util.isAbstract(typeAccess) || !RestrictionModifiers.isInstantiateRestriction(restrictions2) || RestrictionModifiers.isInstantiateRestriction(restrictions))) {
                                this.addDelta(this.descriptor1.getElementType(), 2, 37, restrictions2, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                            }
                        }
                    }
                }
                this.currentDescriptorRestrictions = restrictions2;
            }
            if (Util.isFinal(typeAccess2)) {
                this.currentDescriptorRestrictions |= 0x200;
            }
            if (Util.isFinal(typeAccess)) {
                this.initialDescriptorRestrictions |= 0x200;
            }
            if (Util.isProtected(typeAccess)) {
                if (Util.isPrivate(typeAccess2) || Util.isDefault(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 11, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
                if (Util.isPublic(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 22, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
            } else {
                if (Util.isPublic(typeAccess) && (Util.isProtected(typeAccess2) || Util.isPrivate(typeAccess2) || Util.isDefault(typeAccess2))) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 11, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
                if (Util.isDefault(typeAccess) && (Util.isPublic(typeAccess2) || Util.isProtected(typeAccess2))) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 22, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
                if (Util.isPrivate(typeAccess) && (Util.isDefault(typeAccess2) || Util.isPublic(typeAccess2) || Util.isProtected(typeAccess2))) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 22, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                    return this.delta;
                }
            }
            if (Util.isAnnotation(typeAccess)) {
                if (!Util.isAnnotation(typeAccess2)) {
                    if (Util.isInterface(typeAccess2)) {
                        this.addDelta(1, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(1), Integer.toString(8)});
                    } else if (Util.isEnum(typeAccess2)) {
                        this.addDelta(1, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(1), Integer.toString(6)});
                    } else {
                        this.addDelta(1, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(1), Integer.toString(4)});
                    }
                    return this.delta;
                }
            } else if (Util.isInterface(typeAccess)) {
                if (Util.isAnnotation(typeAccess2)) {
                    this.addDelta(8, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(8), Integer.toString(1)});
                    return this.delta;
                }
                if (!Util.isInterface(typeAccess2)) {
                    if (Util.isEnum(typeAccess2)) {
                        this.addDelta(8, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(8), Integer.toString(6)});
                    } else {
                        this.addDelta(8, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(8), Integer.toString(4)});
                    }
                    return this.delta;
                }
            } else if (Util.isEnum(typeAccess)) {
                if (!Util.isEnum(typeAccess2)) {
                    if (Util.isAnnotation(typeAccess2)) {
                        this.addDelta(6, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(6), Integer.toString(1)});
                    } else if (Util.isInterface(typeAccess2)) {
                        this.addDelta(6, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(6), Integer.toString(8)});
                    } else {
                        this.addDelta(6, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(6), Integer.toString(4)});
                    }
                    return this.delta;
                }
            } else if (!Util.isClass(typeAccess2)) {
                if (Util.isAnnotation(typeAccess2)) {
                    this.addDelta(4, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(4), Integer.toString(1)});
                } else if (Util.isInterface(typeAccess2)) {
                    this.addDelta(4, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(4), Integer.toString(8)});
                } else {
                    this.addDelta(4, 2, 41, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), Integer.toString(4), Integer.toString(6)});
                }
                return this.delta;
            }
            if (Util.isStatic(typeAccess)) {
                if (!Util.isStatic(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 38, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                }
            } else if (Util.isStatic(typeAccess2)) {
                this.addDelta(this.descriptor1.getElementType(), 2, 33, this.currentDescriptorRestrictions, typeAccess2, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
            this.checkSuperclass();
            this.checkSuperInterfaces();
            Iterator iterator = this.descriptor1.fields.values().iterator();
            while (iterator.hasNext()) {
                fieldDescriptor = (FieldDescriptor)iterator.next();
                this.getDeltaForFieldDescriptor(fieldDescriptor);
            }
            iterator = this.descriptor2.fields.values().iterator();
            while (iterator.hasNext()) {
                fieldDescriptor = (FieldDescriptor)iterator.next();
                this.reportFieldAddition(fieldDescriptor, this.descriptor2);
            }
            iterator = this.descriptor1.methods.values().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object instanceof List) {
                    List list = (List)object;
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        MethodDescriptor methodDescriptor = (MethodDescriptor)iterator2.next();
                        this.getDeltaForMethodDescriptor(methodDescriptor);
                    }
                    continue;
                }
                MethodDescriptor methodDescriptor = (MethodDescriptor)object;
                this.getDeltaForMethodDescriptor(methodDescriptor);
            }
            iterator = this.descriptor2.methods.values().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object instanceof List) {
                    List list = (List)object;
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        MethodDescriptor methodDescriptor = (MethodDescriptor)iterator2.next();
                        this.reportMethodAddition(methodDescriptor, this.descriptor1);
                    }
                    continue;
                }
                MethodDescriptor methodDescriptor = (MethodDescriptor)object;
                this.reportMethodAddition(methodDescriptor, this.descriptor1);
            }
            if (Util.isAbstract(typeAccess)) {
                if (!Util.isAbstract(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 1, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                }
            } else if (Util.isAbstract(typeAccess2)) {
                this.addDelta(this.descriptor1.getElementType(), 2, 30, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
            if (Util.isFinal(typeAccess)) {
                if (!Util.isFinal(typeAccess2)) {
                    this.addDelta(this.descriptor1.getElementType(), 2, 18, this.currentDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                }
            } else if (Util.isFinal(typeAccess2)) {
                this.addDelta(this.descriptor1.getElementType(), 2, 31, this.initialDescriptorRestrictions, typeAccess, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
            }
            String signature1 = this.descriptor1.signature;
            String signature2 = this.descriptor2.signature;
            this.checkGenericSignature(signature1, signature2, this.descriptor1, this.descriptor2);
            this.checkTypeMembers();
            return this.delta.isEmpty() ? ApiComparator.NO_DELTA : this.delta;
        }
        catch (CoreException e) {
            this.reportStatus((Exception)((Object)e));
            return null;
        }
    }

    private void getDeltaForFieldDescriptor(FieldDescriptor fieldDescriptor) {
        IApiDescription apiDescription;
        int access = fieldDescriptor.access;
        if (Util.isSynthetic(access)) {
            return;
        }
        String name = fieldDescriptor.name;
        FieldDescriptor fieldDescriptor2 = this.getFieldDescriptor(this.descriptor2, name);
        if (fieldDescriptor2 == null) {
            if (Util.isPrivate(access) || Util.isDefault(access)) {
                this.addDelta(this.descriptor1.getElementType(), 3, 16, this.currentDescriptorRestrictions, access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            } else {
                boolean found = false;
                if (this.component2 != null) {
                    TypeDescriptor superTypeDescriptor;
                    Iterator iterator;
                    if (this.descriptor1.isInterface()) {
                        Set interfacesSet = this.getInterfacesSet(this.descriptor2, this.component2, this.apiProfile2);
                        if (interfacesSet != null) {
                            iterator = interfacesSet.iterator();
                            while (iterator.hasNext()) {
                                superTypeDescriptor = (TypeDescriptor)iterator.next();
                                FieldDescriptor fieldDescriptor3 = this.getFieldDescriptor(superTypeDescriptor, name);
                                if (fieldDescriptor3 == null) continue;
                                this.addDelta(this.descriptor1.getElementType(), 3, 17, this.currentDescriptorRestrictions, fieldDescriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                                found = true;
                                break;
                            }
                        }
                    } else {
                        List superclassList = this.getSuperclassList(this.descriptor2, this.component2, this.apiProfile2);
                        if (superclassList != null && this.isStatusOk()) {
                            iterator = superclassList.iterator();
                            while (iterator.hasNext()) {
                                int access3;
                                superTypeDescriptor = (TypeDescriptor)iterator.next();
                                FieldDescriptor fieldDescriptor3 = this.getFieldDescriptor(superTypeDescriptor, name);
                                if (fieldDescriptor3 == null || !Util.isPublic(access3 = fieldDescriptor3.access) && !Util.isProtected(access3)) continue;
                                this.addDelta(this.descriptor1.getElementType(), 3, 17, this.currentDescriptorRestrictions, fieldDescriptor3.access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                                found = true;
                                break;
                            }
                        }
                    }
                }
                if (!found) {
                    if (this.visibilityModifiers == 1 && this.component.hasApiDescription()) {
                        int restrictions;
                        IApiAnnotations apiAnnotations;
                        IApiDescription apiDescription2 = null;
                        try {
                            apiDescription2 = this.component.getApiDescription();
                        }
                        catch (CoreException e) {
                            this.reportStatus((Exception)((Object)e));
                        }
                        if (apiDescription2 != null && (apiAnnotations = apiDescription2.resolveAnnotations(fieldDescriptor.handle)) != null && RestrictionModifiers.isReferenceRestriction(restrictions = apiAnnotations.getRestrictions())) {
                            return;
                        }
                    }
                    if (fieldDescriptor.isEnum()) {
                        this.addDelta(this.descriptor1.getElementType(), 3, 12, this.currentDescriptorRestrictions, this.descriptor2.access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                        return;
                    }
                    this.addDelta(this.descriptor1.getElementType(), 3, 16, this.currentDescriptorRestrictions, fieldDescriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                }
            }
            return;
        }
        int restrictions = 0;
        int referenceRestrictions = 0;
        int access2 = fieldDescriptor2.access;
        if (this.component2.hasApiDescription()) {
            try {
                apiDescription = this.component2.getApiDescription();
                IApiAnnotations resolvedAPIDescription = apiDescription.resolveAnnotations(fieldDescriptor2.handle);
                if (resolvedAPIDescription != null) {
                    restrictions = resolvedAPIDescription.getRestrictions();
                }
            }
            catch (CoreException coreException) {}
        }
        if (this.visibilityModifiers == 1 && this.component.hasApiDescription()) {
            IApiAnnotations apiAnnotations;
            apiDescription = null;
            try {
                apiDescription = this.component.getApiDescription();
            }
            catch (CoreException e) {
                this.reportStatus((Exception)((Object)e));
            }
            if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(fieldDescriptor.handle)) != null) {
                referenceRestrictions = apiAnnotations.getRestrictions();
            }
            if (RestrictionModifiers.isReferenceRestriction(referenceRestrictions)) {
                if (!RestrictionModifiers.isReferenceRestriction(restrictions)) {
                    if (fieldDescriptor2.isEnum()) {
                        this.addDelta(this.descriptor2.getElementType(), 1, 12, this.currentDescriptorRestrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor2), name});
                    } else {
                        this.addDelta(this.descriptor2.getElementType(), 1, 16, this.currentDescriptorRestrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor2), name});
                    }
                    return;
                }
            } else if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
                if ((Util.isPublic(access2) || Util.isProtected(access2)) && (Util.isPublic(access) || Util.isProtected(access)) && this.visibilityModifiers == 1) {
                    this.addDelta(this.descriptor2.getElementType(), 3, fieldDescriptor2.isEnum() ? 64 : 61, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor2), name});
                }
                return;
            }
        }
        restrictions |= this.currentDescriptorRestrictions;
        if (!fieldDescriptor.descriptor.equals(fieldDescriptor2.descriptor)) {
            this.addDelta(fieldDescriptor.getElementType(), 2, 46, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        } else {
            String signature1 = fieldDescriptor.signature;
            String signature2 = fieldDescriptor2.signature;
            this.checkGenericSignature(signature1, signature2, fieldDescriptor, fieldDescriptor2);
        }
        boolean changeFinalToNonFinal = false;
        if (Util.isProtected(access)) {
            if (Util.isPrivate(access2) || Util.isDefault(access2)) {
                this.addDelta(7, 2, 11, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            } else if (Util.isPublic(access2)) {
                this.addDelta(7, 2, 22, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            }
        } else if (Util.isPublic(access) && (Util.isProtected(access2) || Util.isPrivate(access2) || Util.isDefault(access2))) {
            this.addDelta(7, 2, 11, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        } else if (Util.isPrivate(access) && (Util.isProtected(access2) || Util.isDefault(access2) || Util.isPublic(access2))) {
            this.addDelta(7, 2, 22, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        } else if (Util.isDefault(access) && (Util.isProtected(access2) || Util.isPublic(access2))) {
            this.addDelta(7, 2, 22, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
        if (Util.isFinal(access)) {
            if (!Util.isFinal(access2)) {
                if (!Util.isStatic(access2)) {
                    this.addDelta(7, 2, 19, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                } else if (fieldDescriptor.value != null) {
                    changeFinalToNonFinal = true;
                    this.addDelta(7, 2, 20, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                } else {
                    this.addDelta(7, 2, 21, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
                }
            }
        } else if (Util.isFinal(access2)) {
            this.addDelta(7, 2, 31, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
        if (Util.isStatic(access)) {
            if (!Util.isStatic(access2)) {
                this.addDelta(7, 2, 38, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            }
        } else if (Util.isStatic(access2)) {
            this.addDelta(7, 2, 33, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
        if (Util.isTransient(access)) {
            if (!Util.isTransient(access2)) {
                this.addDelta(7, 2, 45, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            }
        } else if (Util.isTransient(access2)) {
            this.addDelta(7, 2, 35, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
        if (Util.isVolatile(access)) {
            if (!Util.isVolatile(access2)) {
                this.addDelta(7, 2, 58, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
            }
        } else if (Util.isVolatile(access2)) {
            this.addDelta(7, 2, 57, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name});
        }
        if (fieldDescriptor.value != null) {
            if (fieldDescriptor2.value == null) {
                if (!changeFinalToNonFinal) {
                    this.addDelta(7, 3, 54, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name, String.valueOf(fieldDescriptor.value)});
                }
            } else if (!fieldDescriptor.value.equals(fieldDescriptor2.value)) {
                this.addDelta(7, 2, 54, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name, String.valueOf(fieldDescriptor.value)});
            }
        } else if (fieldDescriptor2.value != null) {
            this.addDelta(7, 1, 54, restrictions, access2, this.classFile, name, new String[]{Util.getDescriptorName(this.descriptor1), name, String.valueOf(fieldDescriptor2.value)});
        }
    }

    private void getDeltaForMethodDescriptor(MethodDescriptor methodDescriptor) {
        String exceptionName;
        Iterator iterator;
        int access = methodDescriptor.access;
        if (Util.isSynthetic(access)) {
            return;
        }
        String name = methodDescriptor.name;
        String descriptor = methodDescriptor.descriptor;
        String key = this.getKeyForMethod(methodDescriptor, this.descriptor1);
        MethodDescriptor methodDescriptor2 = this.getMethodDescriptor(this.descriptor2, name, descriptor);
        String methodDisplayName = this.getMethodDisplayName(methodDescriptor, this.descriptor1);
        if (methodDescriptor2 == null) {
            if (methodDescriptor.isClinit()) {
                this.addDelta(this.descriptor1.getElementType(), 3, 7, this.currentDescriptorRestrictions, access, this.classFile, this.descriptor1.name, Util.getDescriptorName(this.descriptor1));
                return;
            }
            if (Util.isPrivate(access) || Util.isDefault(access)) {
                this.addDelta(this.descriptor1.getElementType(), 3, methodDescriptor.isConstructor() ? 8 : 25, Util.isAbstract(this.descriptor2.access) ? this.currentDescriptorRestrictions | 0x400 : this.currentDescriptorRestrictions, access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                return;
            }
            TypeDescriptor typeDescriptor = this.descriptor2;
            boolean found = false;
            if (this.component2 != null && !methodDescriptor.isConstructor()) {
                TypeDescriptor superTypeDescriptor;
                Iterator iterator2;
                if (this.descriptor1.isInterface()) {
                    Set interfacesSet = this.getInterfacesSet(typeDescriptor, this.component2, this.apiProfile2);
                    if (interfacesSet != null && this.isStatusOk()) {
                        iterator2 = interfacesSet.iterator();
                        while (iterator2.hasNext()) {
                            superTypeDescriptor = (TypeDescriptor)iterator2.next();
                            MethodDescriptor methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                            if (methodDescriptor3 == null) continue;
                            this.addDelta(this.descriptor1.getElementType(), 3, 26, this.currentDescriptorRestrictions, access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                            found = true;
                            break;
                        }
                    }
                } else {
                    List superclassList = this.getSuperclassList(typeDescriptor, this.component2, this.apiProfile2, true);
                    if (superclassList != null && this.isStatusOk()) {
                        iterator2 = superclassList.iterator();
                        while (iterator2.hasNext()) {
                            int access3;
                            superTypeDescriptor = (TypeDescriptor)iterator2.next();
                            MethodDescriptor methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                            if (methodDescriptor3 == null || !Util.isPublic(access3 = methodDescriptor3.access) && !Util.isProtected(access3)) continue;
                            this.addDelta(this.descriptor1.getElementType(), 3, 26, this.currentDescriptorRestrictions, access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                            found = true;
                            break;
                        }
                    }
                }
            }
            if (!found) {
                if (this.visibilityModifiers == 1 && this.component.hasApiDescription()) {
                    int restrictions;
                    IApiAnnotations apiAnnotations;
                    IApiDescription apiDescription = null;
                    try {
                        apiDescription = this.component.getApiDescription();
                    }
                    catch (CoreException e) {
                        this.reportStatus((Exception)((Object)e));
                    }
                    if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(methodDescriptor.handle)) != null && RestrictionModifiers.isReferenceRestriction(restrictions = apiAnnotations.getRestrictions())) {
                        return;
                    }
                }
                if (this.descriptor1.isAnnotation()) {
                    this.addDelta(this.descriptor1.getElementType(), 3, methodDescriptor.defaultValue != null ? 27 : 28, this.currentDescriptorRestrictions, methodDescriptor.access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                } else {
                    this.addDelta(this.descriptor1.getElementType(), 3, methodDescriptor.isConstructor() ? 8 : 25, Util.isAbstract(this.descriptor2.access) ? this.currentDescriptorRestrictions | 0x400 : this.currentDescriptorRestrictions, methodDescriptor.access, this.classFile, this.descriptor1.name, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
                }
            }
            return;
        }
        int restrictions = this.currentDescriptorRestrictions;
        if (this.component2.hasApiDescription()) {
            try {
                IApiDescription apiDescription = this.component2.getApiDescription();
                IApiAnnotations resolvedAPIDescription = apiDescription.resolveAnnotations(methodDescriptor2.handle);
                if (resolvedAPIDescription != null) {
                    restrictions |= resolvedAPIDescription.getRestrictions();
                }
            }
            catch (CoreException coreException) {}
        }
        int referenceRestrictions = this.initialDescriptorRestrictions;
        int access2 = methodDescriptor2.access;
        if (this.component.hasApiDescription()) {
            IApiAnnotations apiAnnotations;
            IApiDescription apiDescription = null;
            try {
                apiDescription = this.component.getApiDescription();
            }
            catch (CoreException e) {
                this.reportStatus((Exception)((Object)e));
            }
            if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(methodDescriptor.handle)) != null) {
                referenceRestrictions |= apiAnnotations.getRestrictions();
            }
        }
        if (this.visibilityModifiers == 1) {
            if (RestrictionModifiers.isReferenceRestriction(referenceRestrictions)) {
                if (!RestrictionModifiers.isReferenceRestriction(restrictions)) {
                    if (methodDescriptor.isConstructor()) {
                        this.addDelta(this.descriptor2.getElementType(), 1, 8, this.currentDescriptorRestrictions, access2, this.classFile, this.getKeyForMethod(methodDescriptor, this.descriptor2), new String[]{Util.getDescriptorName(this.descriptor2), methodDisplayName});
                    } else if (this.descriptor2.isAnnotation()) {
                        if (methodDescriptor.defaultValue != null) {
                            this.addDelta(this.descriptor2.getElementType(), 1, 27, this.currentDescriptorRestrictions, access2, this.classFile, this.getKeyForMethod(methodDescriptor, this.descriptor2), new String[]{Util.getDescriptorName(this.descriptor2), methodDisplayName});
                        } else {
                            this.addDelta(this.descriptor2.getElementType(), 1, 28, this.currentDescriptorRestrictions, access2, this.classFile, this.getKeyForMethod(methodDescriptor, this.descriptor2), new String[]{Util.getDescriptorName(this.descriptor2), methodDisplayName});
                        }
                    } else {
                        TypeDescriptor typeDescriptor2 = this.descriptor2;
                        boolean found = false;
                        if (this.component2 != null) {
                            if (this.descriptor1.isInterface()) {
                                Set interfacesSet = this.getInterfacesSet(typeDescriptor2, this.component2, this.apiProfile2);
                                if (interfacesSet != null && this.isStatusOk()) {
                                    Iterator iterator3 = interfacesSet.iterator();
                                    while (iterator3.hasNext()) {
                                        TypeDescriptor superTypeDescriptor = (TypeDescriptor)iterator3.next();
                                        MethodDescriptor methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                                        if (methodDescriptor3 == null) continue;
                                        found = true;
                                        break;
                                    }
                                }
                            } else {
                                List superclassList = this.getSuperclassList(typeDescriptor2, this.component2, this.apiProfile2, true);
                                if (superclassList != null) {
                                    Iterator iterator4 = superclassList.iterator();
                                    while (iterator4.hasNext()) {
                                        int access3;
                                        TypeDescriptor superTypeDescriptor = (TypeDescriptor)iterator4.next();
                                        MethodDescriptor methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                                        if (methodDescriptor3 == null || !Util.isPublic(access3 = methodDescriptor3.access) && !Util.isProtected(access3)) continue;
                                        found = true;
                                        break;
                                    }
                                }
                            }
                        }
                        this.addDelta(this.descriptor2.getElementType(), 1, found ? 36 : 25, this.currentDescriptorRestrictions, access2, this.classFile, this.getKeyForMethod(methodDescriptor, this.descriptor2), new String[]{Util.getDescriptorName(this.descriptor2), methodDisplayName});
                    }
                    return;
                }
            } else if (RestrictionModifiers.isReferenceRestriction(restrictions) && (Util.isPublic(access2) || Util.isProtected(access2))) {
                if (this.descriptor2.isAnnotation()) {
                    this.addDelta(this.descriptor2.getElementType(), 3, methodDescriptor.defaultValue != null ? 65 : 66, this.currentDescriptorRestrictions, access2, this.classFile, this.getKeyForMethod(methodDescriptor2, this.descriptor2), new String[]{Util.getDescriptorName(this.descriptor2), methodDisplayName});
                } else if (Util.isPublic(access) || Util.isProtected(access)) {
                    this.addDelta(this.descriptor2.getElementType(), 3, methodDescriptor.isConstructor() ? 63 : 62, Util.isAbstract(this.descriptor2.access) ? this.currentDescriptorRestrictions | 0x400 : this.currentDescriptorRestrictions, access2, this.classFile, this.getKeyForMethod(methodDescriptor2, this.descriptor2), new String[]{Util.getDescriptorName(this.descriptor2), methodDisplayName});
                }
                return;
            }
        }
        if (!(!this.component.hasApiDescription() || methodDescriptor.isConstructor() || methodDescriptor.isClinit() || this.descriptor1.isInterface() || this.descriptor1.isAnnotation() || restrictions == referenceRestrictions || Util.isFinal(access2) || !RestrictionModifiers.isOverrideRestriction(restrictions) || RestrictionModifiers.isOverrideRestriction(referenceRestrictions))) {
            this.addDelta(methodDescriptor.getElementType(), 2, 37, restrictions, access2, this.classFile, this.getKeyForMethod(methodDescriptor2, this.descriptor2), new String[]{Util.getDescriptorName(this.descriptor2), methodDisplayName});
        }
        if (methodDescriptor.exceptions != null) {
            if (methodDescriptor2.exceptions == null) {
                iterator = methodDescriptor.exceptions.iterator();
                while (iterator.hasNext()) {
                    exceptionName = ((String)iterator.next()).replace('/', '.');
                    if (this.isCheckedException(this.apiProfile, this.component, exceptionName)) {
                        this.addDelta(methodDescriptor.getElementType(), 3, 5, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName});
                        break;
                    }
                    this.addDelta(methodDescriptor.getElementType(), 3, 53, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName});
                }
            } else {
                String exceptionName2;
                ArrayList<String> removedExceptions = new ArrayList<String>();
                Iterator iterator5 = methodDescriptor.exceptions.iterator();
                while (iterator5.hasNext()) {
                    exceptionName2 = ((String)iterator5.next()).replace('/', '.');
                    if (methodDescriptor2.exceptions.remove(exceptionName2)) continue;
                    removedExceptions.add(exceptionName2);
                }
                if (removedExceptions.size() != 0) {
                    iterator5 = removedExceptions.iterator();
                    while (iterator5.hasNext()) {
                        exceptionName2 = ((String)iterator5.next()).replace('/', '.');
                        if (this.isCheckedException(this.apiProfile, this.component, exceptionName2)) {
                            this.addDelta(methodDescriptor.getElementType(), 3, 5, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName2});
                            break;
                        }
                        this.addDelta(methodDescriptor.getElementType(), 3, 53, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName2});
                    }
                }
                iterator5 = methodDescriptor2.exceptions.iterator();
                while (iterator5.hasNext()) {
                    exceptionName2 = ((String)iterator5.next()).replace('/', '.');
                    if (this.isCheckedException(this.apiProfile2, this.component2, exceptionName2)) {
                        this.addDelta(methodDescriptor.getElementType(), 1, 5, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName2});
                        break;
                    }
                    this.addDelta(methodDescriptor.getElementType(), 1, 53, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName2});
                }
            }
        } else if (methodDescriptor2.exceptions != null) {
            iterator = methodDescriptor2.exceptions.iterator();
            while (iterator.hasNext()) {
                exceptionName = ((String)iterator.next()).replace('/', '.');
                if (this.isCheckedException(this.apiProfile2, this.component2, exceptionName)) {
                    this.addDelta(methodDescriptor.getElementType(), 1, 5, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName});
                    break;
                }
                this.addDelta(methodDescriptor.getElementType(), 1, 53, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName, exceptionName});
            }
        }
        if (Util.isVarargs(access)) {
            if (!Util.isVarargs(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 55, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isVarargs(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 4, restrictions, methodDescriptor2.access, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isProtected(access)) {
            if (Util.isPrivate(access2) || Util.isDefault(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 11, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            } else if (Util.isPublic(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 22, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isPublic(access) && (Util.isProtected(access2) || Util.isPrivate(access2) || Util.isDefault(access2))) {
            this.addDelta(methodDescriptor.getElementType(), 2, 11, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        } else if (Util.isDefault(access) && (Util.isPublic(access2) || Util.isProtected(access2))) {
            this.addDelta(methodDescriptor.getElementType(), 2, 22, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        } else if (Util.isPrivate(access) && (Util.isDefault(access2) || Util.isPublic(access2) || Util.isProtected(access2))) {
            this.addDelta(methodDescriptor.getElementType(), 2, 22, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isAbstract(access)) {
            if (!Util.isAbstract(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 1, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isAbstract(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 30, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isFinal(access)) {
            if (!Util.isFinal(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 18, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isFinal(access2)) {
            int res = restrictions;
            if (!RestrictionModifiers.isOverrideRestriction(res)) {
                if (RestrictionModifiers.isExtendRestriction(this.currentDescriptorRestrictions)) {
                    res = this.currentDescriptorRestrictions;
                } else if (RestrictionModifiers.isExtendRestriction(this.initialDescriptorRestrictions)) {
                    res = this.initialDescriptorRestrictions;
                }
                if (RestrictionModifiers.isOverrideRestriction(referenceRestrictions)) {
                    res = referenceRestrictions;
                }
            }
            this.addDelta(methodDescriptor2.getElementType(), 2, 31, res, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor2), this.getMethodDisplayName(methodDescriptor2, this.descriptor2)});
        }
        if (Util.isStatic(access)) {
            if (!Util.isStatic(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 38, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isStatic(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 33, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isNative(access)) {
            if (!Util.isNative(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 29, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isNative(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 32, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        if (Util.isSynchronized(access)) {
            if (!Util.isSynchronized(access2)) {
                this.addDelta(methodDescriptor.getElementType(), 2, 40, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (Util.isSynchronized(access2)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 34, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
        String signature1 = methodDescriptor.signature;
        String signature2 = methodDescriptor2.signature;
        this.checkGenericSignature(signature1, signature2, methodDescriptor, methodDescriptor2);
        if (methodDescriptor.defaultValue == null) {
            if (methodDescriptor2.defaultValue != null) {
                this.addDelta(methodDescriptor.getElementType(), 1, 2, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
            }
        } else if (methodDescriptor2.defaultValue == null) {
            this.addDelta(methodDescriptor.getElementType(), 3, 2, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        } else if (!methodDescriptor.defaultValue.equals(methodDescriptor2.defaultValue)) {
            this.addDelta(methodDescriptor.getElementType(), 2, 2, restrictions, access2, this.classFile, key, new String[]{Util.getDescriptorName(this.descriptor1), methodDisplayName});
        }
    }

    FieldDescriptor getFieldDescriptor(TypeDescriptor typeDescriptor, String name) {
        Object object = typeDescriptor.fields.get(name);
        if (object == null) {
            return null;
        }
        FieldDescriptor fieldDescriptor = (FieldDescriptor)object;
        typeDescriptor.fields.remove(name);
        return fieldDescriptor;
    }

    private Set getInterfacesSet(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile) {
        HashSet set = new HashSet();
        this.status = null;
        this.collectAllInterfaces(typeDescriptor, apiComponent, profile, set);
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    MethodDescriptor getMethodDescriptor(TypeDescriptor typeDescriptor, String name, String descriptor) {
        Object object = typeDescriptor.methods.get(name);
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MethodDescriptor methodDescriptor = (MethodDescriptor)iterator.next();
                if (!methodDescriptor.name.equals(name) || !methodDescriptor.descriptor.equals(descriptor)) continue;
                list.remove(methodDescriptor);
                if (list.size() == 0) {
                    typeDescriptor.methods.remove(name);
                }
                return methodDescriptor;
            }
            return null;
        }
        MethodDescriptor methodDescriptor = (MethodDescriptor)object;
        if (methodDescriptor.name.equals(name) && methodDescriptor.descriptor.equals(descriptor)) {
            typeDescriptor.methods.remove(name);
            return methodDescriptor;
        }
        return null;
    }

    private String getMethodDisplayName(MethodDescriptor methodDescriptor, TypeDescriptor typeDescriptor) {
        String methodName = methodDescriptor.name;
        if (methodDescriptor.isConstructor()) {
            int index2;
            String typeName = typeDescriptor.name;
            int index = typeName.lastIndexOf(46);
            methodName = index == -1 ? typeName : ((index2 = typeName.lastIndexOf(36)) > index ? typeName.substring(index2 + 1) : typeName.substring(index + 1));
        }
        return Signature.toString((String)methodDescriptor.descriptor, (String)methodName, null, (boolean)false, (boolean)false);
    }

    private SignatureDescriptor getSignatureDescritor(String signature) {
        SignatureDescriptor signatureDescriptor = new SignatureDescriptor();
        SignatureReader signatureReader = new SignatureReader(signature);
        signatureReader.accept((SignatureVisitor)new SignatureDecoder(signatureDescriptor));
        return signatureDescriptor;
    }

    private List getSuperclassList(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile) {
        return this.getSuperclassList(typeDescriptor, apiComponent, profile, false);
    }

    private List getSuperclassList(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile, boolean includeObject) {
        return this.getSuperclassList(typeDescriptor, apiComponent, profile, includeObject, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getSuperclassList(TypeDescriptor typeDescriptor, IApiComponent apiComponent, IApiProfile profile, boolean includeObject, boolean includePrivate) {
        TypeDescriptor descriptor = typeDescriptor;
        this.status = null;
        String superName = descriptor.superName;
        if (Util.isJavaLangObject(superName) && !includeObject) {
            return null;
        }
        ArrayList<TypeDescriptor> list = new ArrayList<TypeDescriptor>();
        IApiComponent sourceComponent = apiComponent;
        try {
            IApiDescription apiDescription = sourceComponent.getApiDescription();
            HashMap<String, IApiDescription> apiDescriptions = new HashMap<String, IApiDescription>(3);
            apiDescriptions.put(sourceComponent.getId(), apiDescription);
            while (superName != null && (!Util.isJavaLangObject(superName) || includeObject)) {
                LookupResult pair = this.getType(superName, sourceComponent, profile);
                if (pair == null) {
                    return null;
                }
                IClassFile classFile = pair.classFile;
                descriptor = new TypeDescriptor(classFile.getContents());
                int visibility = 2;
                IApiComponent pairComponent = pair.apiComponent;
                if (pairComponent.hasApiDescription()) {
                    IApiAnnotations elementDescription;
                    String id = pairComponent.getId();
                    apiDescription = (IApiDescription)apiDescriptions.get(id);
                    if (apiDescription == null) {
                        apiDescription = pairComponent.getApiDescription();
                        apiDescriptions.put(id, apiDescription);
                    }
                    if ((elementDescription = apiDescription.resolveAnnotations(descriptor.handle)) != null) {
                        visibility = elementDescription.getVisibility();
                    }
                } else if (Util.isPublic(descriptor.access) || Util.isProtected(descriptor.access)) {
                    visibility = 1;
                }
                if (includePrivate || (visibility & this.visibilityModifiers) != 0) {
                    list.add(descriptor);
                }
                superName = descriptor.superName;
            }
        }
        catch (CoreException e) {
            this.reportStatus((Exception)((Object)e));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private void reportFieldAddition(FieldDescriptor fieldDescriptor, TypeDescriptor descriptor) {
        int access = fieldDescriptor.access;
        String name = fieldDescriptor.name;
        if (Util.isSynthetic(access)) {
            return;
        }
        if (this.visibilityModifiers == 1 && this.component2.hasApiDescription()) {
            int restrictions;
            IApiAnnotations apiAnnotations;
            IApiDescription apiDescription = null;
            try {
                apiDescription = this.component2.getApiDescription();
            }
            catch (CoreException e) {
                this.reportStatus((Exception)((Object)e));
            }
            if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(fieldDescriptor.handle)) != null && RestrictionModifiers.isReferenceRestriction(restrictions = apiAnnotations.getRestrictions())) {
                return;
            }
        }
        if (fieldDescriptor.isEnum()) {
            this.addDelta(descriptor.getElementType(), 1, 12, this.currentDescriptorRestrictions, descriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(descriptor), name});
        } else {
            this.addDelta(descriptor.getElementType(), 1, 16, this.currentDescriptorRestrictions, fieldDescriptor.access, this.classFile, name, new String[]{Util.getDescriptorName(descriptor), name});
        }
    }

    private void reportMethodAddition(MethodDescriptor methodDescriptor, TypeDescriptor typeDescriptor) {
        if (methodDescriptor.isClinit()) {
            this.addDelta(typeDescriptor.getElementType(), 1, 7, this.currentDescriptorRestrictions, methodDescriptor.access, this.classFile, typeDescriptor.name, Util.getDescriptorName(this.descriptor1));
            return;
        }
        int access = methodDescriptor.access;
        if (Util.isSynthetic(access)) {
            return;
        }
        if (this.visibilityModifiers == 1 && this.component2.hasApiDescription()) {
            IApiAnnotations apiAnnotations;
            IApiDescription apiDescription = null;
            int restrictions = 0;
            try {
                apiDescription = this.component2.getApiDescription();
            }
            catch (CoreException e) {
                this.reportStatus((Exception)((Object)e));
            }
            if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(methodDescriptor.handle)) != null) {
                restrictions = apiAnnotations.getRestrictions();
            }
            if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
                return;
            }
        }
        String methodDisplayName = this.getMethodDisplayName(methodDescriptor, typeDescriptor);
        int restrictionsForMethodAddition = this.currentDescriptorRestrictions;
        if (Util.isFinal(this.descriptor2.access)) {
            restrictionsForMethodAddition |= 0x200;
        }
        if (Util.isPublic(access) || Util.isProtected(access)) {
            if (methodDescriptor.isConstructor()) {
                this.addDelta(typeDescriptor.getElementType(), 1, 8, restrictionsForMethodAddition, access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
            } else if (typeDescriptor.isAnnotation()) {
                if (methodDescriptor.defaultValue != null) {
                    this.addDelta(typeDescriptor.getElementType(), 1, 27, restrictionsForMethodAddition, access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
                } else {
                    this.addDelta(typeDescriptor.getElementType(), 1, 28, restrictionsForMethodAddition, typeDescriptor.access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
                }
            } else {
                int access3;
                List superclassList;
                MethodDescriptor methodDescriptor3;
                TypeDescriptor superTypeDescriptor;
                Iterator iterator;
                Set interfacesSet;
                String descriptor;
                String name;
                TypeDescriptor typeDescriptor2 = this.descriptor2;
                boolean found = false;
                if (this.component2 != null) {
                    name = methodDescriptor.name;
                    descriptor = methodDescriptor.descriptor;
                    if (this.descriptor1.isInterface()) {
                        interfacesSet = this.getInterfacesSet(typeDescriptor2, this.component2, this.apiProfile2);
                        if (interfacesSet != null && this.isStatusOk()) {
                            iterator = interfacesSet.iterator();
                            while (iterator.hasNext()) {
                                superTypeDescriptor = (TypeDescriptor)iterator.next();
                                methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                                if (methodDescriptor3 == null) continue;
                                found = true;
                                break;
                            }
                        }
                    } else {
                        superclassList = this.getSuperclassList(typeDescriptor2, this.component2, this.apiProfile2, true);
                        if (superclassList != null && this.isStatusOk()) {
                            iterator = superclassList.iterator();
                            while (iterator.hasNext()) {
                                superTypeDescriptor = (TypeDescriptor)iterator.next();
                                methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                                if (methodDescriptor3 == null || !Util.isPublic(access3 = methodDescriptor3.access) && !Util.isProtected(access3)) continue;
                                found = true;
                                break;
                            }
                        }
                    }
                }
                if (!found) {
                    if (this.component != null) {
                        name = methodDescriptor.name;
                        descriptor = methodDescriptor.descriptor;
                        if (this.descriptor1.isInterface()) {
                            interfacesSet = this.getInterfacesSet(typeDescriptor, this.component, this.apiProfile);
                            if (interfacesSet != null && this.isStatusOk()) {
                                iterator = interfacesSet.iterator();
                                while (iterator.hasNext()) {
                                    superTypeDescriptor = (TypeDescriptor)iterator.next();
                                    methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                                    if (methodDescriptor3 == null) continue;
                                    found = true;
                                    break;
                                }
                            }
                        } else {
                            superclassList = this.getSuperclassList(typeDescriptor, this.component, this.apiProfile, true);
                            if (superclassList != null && this.isStatusOk()) {
                                iterator = superclassList.iterator();
                                while (iterator.hasNext()) {
                                    superTypeDescriptor = (TypeDescriptor)iterator.next();
                                    methodDescriptor3 = this.getMethodDescriptor(superTypeDescriptor, name, descriptor);
                                    if (methodDescriptor3 == null || !Util.isPublic(access3 = methodDescriptor3.access) && !Util.isProtected(access3)) continue;
                                    found = true;
                                    break;
                                }
                            }
                        }
                    }
                    this.addDelta(typeDescriptor.getElementType(), 1, found ? 67 : 25, restrictionsForMethodAddition, methodDescriptor.access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
                } else {
                    this.addDelta(typeDescriptor.getElementType(), 1, found ? 36 : 25, restrictionsForMethodAddition, methodDescriptor.access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
                }
            }
        } else {
            this.addDelta(typeDescriptor.getElementType(), 1, methodDescriptor.isConstructor() ? 8 : 25, restrictionsForMethodAddition, methodDescriptor.access, this.classFile, this.getKeyForMethod(methodDescriptor, typeDescriptor), new String[]{Util.getDescriptorName(typeDescriptor), methodDisplayName});
        }
    }

    private String getKeyForMethod(MethodDescriptor methodDescriptor, TypeDescriptor typeDescriptor) {
        StringBuffer buffer = new StringBuffer();
        if (methodDescriptor.isConstructor()) {
            String name = typeDescriptor.name;
            int index = name.lastIndexOf(46);
            int dollarIndex = name.lastIndexOf(36);
            if (dollarIndex != -1 && typeDescriptor.isNestedType()) {
                buffer.append(typeDescriptor.name.substring(dollarIndex + 1));
            } else {
                buffer.append(typeDescriptor.name.substring(index + 1));
            }
        } else {
            buffer.append(methodDescriptor.name);
        }
        buffer.append(methodDescriptor.descriptor);
        return String.valueOf(buffer);
    }

    private static boolean isAPI(int visibility, MemberTypeDescriptor memberTypeDescriptor) {
        int access = memberTypeDescriptor.access;
        return (visibility & 1) != 0 && (Util.isPublic(access) || Util.isProtected(access));
    }

    private MemberTypeDescriptor retrieveTypeMember(List typeMembers, String typeName) {
        Iterator iterator = typeMembers.iterator();
        while (iterator.hasNext()) {
            MemberTypeDescriptor typeMember = (MemberTypeDescriptor)iterator.next();
            if (!typeMember.name.equals(typeName)) continue;
            return typeMember;
        }
        return null;
    }

    private LookupResult getType(String typeName, IApiComponent component, IApiProfile profile) throws CoreException {
        IApiComponent sourceComponent = component;
        String packageName = Util.getPackageName(typeName);
        IApiComponent[] components = profile.resolvePackage(component, packageName);
        if (components == null) {
            String msg = MessageFormat.format((String)ComparatorMessages.ClassFileComparator_1, (Object[])new String[]{packageName, profile.getName(), component.getId()});
            if (DEBUG) {
                System.err.println("TYPE LOOKUP: " + msg);
            }
            this.reportStatus((IStatus)new Status(4, component.getId(), msg));
            return null;
        }
        sourceComponent = Util.getComponent(components, typeName);
        if (sourceComponent == null) {
            String msg = MessageFormat.format((String)ComparatorMessages.ClassFileComparator_1, (Object[])new String[]{packageName, profile.getName(), component.getId()});
            if (DEBUG) {
                System.err.println("TYPE LOOKUP: " + msg);
            }
            this.reportStatus((IStatus)new Status(4, component.getId(), msg));
            return null;
        }
        IClassFile classfile = sourceComponent.findClassFile(typeName);
        if (classfile == null) {
            String msg = MessageFormat.format((String)ComparatorMessages.ClassFileComparator_2, (Object[])new String[]{typeName, profile.getName(), component.getId()});
            if (DEBUG) {
                System.err.println("TYPE LOOKUP: " + msg);
            }
            this.reportStatus((IStatus)new Status(4, component.getId(), msg));
            return null;
        }
        return new LookupResult(classfile, sourceComponent);
    }

    private static class LookupResult {
        IClassFile classFile;
        IApiComponent apiComponent;

        LookupResult(IClassFile classFile, IApiComponent apiComponent) {
            this.classFile = classFile;
            this.apiComponent = apiComponent;
        }
    }
}

