/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.pde.api.tools.internal.comparator.ElementDescriptor;
import org.eclipse.pde.api.tools.internal.util.Util;

public class MethodDescriptor
extends ElementDescriptor {
    private static final String INIT = "<init>";
    private static final String CLINIT = "<clinit>";
    Object defaultValue;
    String descriptor;
    Set exceptions;
    String signature;

    public MethodDescriptor(int access, String name, String desc, String signature, String[] exceptions) {
        super(access, name);
        this.descriptor = desc;
        this.signature = signature;
        if (exceptions != null) {
            this.exceptions = new HashSet();
            int i = 0;
            int max = exceptions.length;
            while (i < max) {
                this.exceptions.add(exceptions[i].replace('/', '.'));
                ++i;
            }
        }
    }

    public boolean isClinit() {
        return this.name.equals(CLINIT);
    }

    public boolean isConstructor() {
        return this.name.equals(INIT);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Method : access(").append(this.access).append(") ").append(this.descriptor).append(' ').append(this.name);
        if (this.exceptions != null) {
            buffer.append(" throws ");
            int i = 0;
            Iterator iterator = this.exceptions.iterator();
            while (iterator.hasNext()) {
                if (i > 0) {
                    buffer.append(',');
                }
                ++i;
                buffer.append(iterator.next());
            }
        }
        buffer.append(';').append(Util.LINE_DELIMITER);
        if (this.signature != null) {
            buffer.append(" Signature : ").append(this.signature).append(Util.LINE_DELIMITER);
        }
        return String.valueOf(buffer);
    }

    int getElementType() {
        return this.isConstructor() ? 5 : 9;
    }
}

